/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BEnum;

public class EventNotificationParameters {
    public static final int PROCESS_ID_TAG = 0;
    public static final int INITIATING_DEVICE_ID_TAG = 1;
    public static final int EVENT_OBJECT_ID_TAG = 2;
    public static final int TIMESTAMP_TAG = 3;
    public static final int NOTIFICATION_CLASS_TAG = 4;
    public static final int PRIORITY_TAG = 5;
    public static final int EVENT_TYPE_TAG = 6;
    public static final int MESSAGE_TEXT_TAG = 7;
    public static final int NOTIFY_TYPE_TAG = 8;
    public static final int ACK_REQUIRED_TAG = 9;
    public static final int FROM_STATE_TAG = 10;
    public static final int TO_STATE_TAG = 11;
    public static final int EVENT_VALUES_TAG = 12;
    private long processId;
    private BBacnetObjectIdentifier initiatingDeviceId;
    private BBacnetObjectIdentifier eventObjectId;
    private BBacnetTimeStamp timeStamp;
    private long notificationClass;
    private int priority;
    private BEnum eventType;
    private String messageText;
    private BBacnetNotifyType notifyType;
    private boolean ackRequired;
    private BEnum fromState;
    private BEnum toState;
    private BacnetNotificationParameters eventValues;
    private byte[] rawEventValues;
    private BCharacterSetEncoding encoding;

    public long getProcessId() {
        return this.processId;
    }

    public BBacnetObjectIdentifier getInitiatingDeviceId() {
        return this.initiatingDeviceId;
    }

    public BBacnetObjectIdentifier getEventObjectId() {
        return this.eventObjectId;
    }

    public BBacnetTimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    public long getNotificationClass() {
        return this.notificationClass;
    }

    public int getPriority() {
        return this.priority;
    }

    public BEnum getEventType() {
        return this.eventType;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public BBacnetNotifyType getNotifyType() {
        return this.notifyType;
    }

    public boolean getAckRequired() {
        return this.ackRequired;
    }

    public BEnum getFromState() {
        return this.fromState;
    }

    public BEnum getToState() {
        return this.toState;
    }

    public BacnetNotificationParameters getEventValues() {
        return this.eventValues;
    }

    public byte[] getRawEventValues() {
        return this.rawEventValues;
    }

    public BCharacterSetEncoding getEncoding() {
        return this.encoding;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        boolean bl;
        asnOutputStream.writeUnsignedInteger(0, this.processId);
        asnOutputStream.writeObjectIdentifier(1, this.initiatingDeviceId);
        asnOutputStream.writeObjectIdentifier(2, this.eventObjectId);
        asnOutputStream.writeOpeningTag(3);
        this.timeStamp.writeAsn(asnOutputStream);
        asnOutputStream.writeClosingTag(3);
        asnOutputStream.writeUnsignedInteger(4, this.notificationClass);
        asnOutputStream.writeUnsignedInteger(5, this.priority);
        asnOutputStream.writeEnumerated(6, this.eventType.getOrdinal());
        if (this.messageText != null) {
            asnOutputStream.writeCharacterString(7, this.messageText, this.encoding);
        }
        asnOutputStream.writeEnumerated(8, this.notifyType.getOrdinal());
        boolean bl2 = false;
        if (this.notifyType.getOrdinal() == 2) {
            bl2 = true;
        }
        if (!(bl = bl2)) {
            asnOutputStream.writeBoolean(9, this.ackRequired);
        }
        if (!bl && this.fromState != null) {
            asnOutputStream.writeEnumerated(10, this.fromState.getOrdinal());
        }
        asnOutputStream.writeEnumerated(11, this.toState.getOrdinal());
        if (!bl) {
            if (this.rawEventValues != null) {
                asnOutputStream.writeEncodedValue(12, this.rawEventValues);
            } else if (this.eventValues != null) {
                asnOutputStream.writeOpeningTag(12);
                this.eventValues.writeEncoded(asnOutputStream);
                asnOutputStream.writeClosingTag(12);
            }
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        int n;
        this.processId = asnInputStream.readUnsignedInteger(0);
        this.initiatingDeviceId = asnInputStream.readObjectIdentifier(1);
        this.eventObjectId = asnInputStream.readObjectIdentifier(2);
        BBacnetDevice bBacnetDevice = BBacnetNetwork.bacnet().doLookupDeviceById(this.initiatingDeviceId);
        BExtensibleEnumList bExtensibleEnumList = BBacnetNetwork.localDevice().getEnumerationList();
        if (bBacnetDevice != null) {
            bExtensibleEnumList = bBacnetDevice.getEnumerationList();
        }
        asnInputStream.skipTag();
        this.timeStamp = new BBacnetTimeStamp();
        this.timeStamp.readAsn(asnInputStream);
        asnInputStream.skipTag();
        this.notificationClass = asnInputStream.readUnsignedInteger(4);
        this.priority = asnInputStream.readUnsignedInt(5);
        int n2 = asnInputStream.readEnumerated(6);
        this.eventType = bExtensibleEnumList.getEventType().getRange().get(n2);
        asnInputStream.peekTag();
        if (asnInputStream.isValueTag(7)) {
            this.encoding = asnInputStream.peekEncoding(7);
            this.messageText = asnInputStream.readCharacterString(7);
        } else {
            this.messageText = null;
        }
        this.notifyType = BBacnetNotifyType.make(asnInputStream.readEnumerated(8));
        asnInputStream.peekTag();
        if (asnInputStream.isValueTag(9)) {
            this.ackRequired = asnInputStream.readBoolean(9);
            asnInputStream.peekTag();
        } else {
            this.ackRequired = false;
        }
        if (asnInputStream.isValueTag(10)) {
            n = asnInputStream.readEnumerated(10);
            this.fromState = bExtensibleEnumList.getEventState().getRange().get(n);
            asnInputStream.peekTag();
        } else {
            this.fromState = null;
        }
        if (asnInputStream.isValueTag(11)) {
            n = asnInputStream.readEnumerated(11);
            this.toState = bExtensibleEnumList.getEventState().getRange().get(n);
            asnInputStream.peekTag();
        } else {
            this.toState = BBacnetEventState.normal;
        }
        if (asnInputStream.isOpeningTag(12)) {
            asnInputStream.mark(0);
            this.rawEventValues = asnInputStream.readEncodedValue(12);
            asnInputStream.reset();
            asnInputStream.skipTag();
            this.eventValues = BacnetNotificationParameters.parseEncoded(this.initiatingDeviceId, asnInputStream);
            asnInputStream.skipTag();
        } else {
            this.eventValues = null;
            this.rawEventValues = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("\n  processId:         " + this.processId);
        stringBuffer.append("\n  initiatingDeviceId:" + (Object)((Object)this.initiatingDeviceId));
        stringBuffer.append("\n  eventObjectId:     " + (Object)((Object)this.eventObjectId));
        stringBuffer.append("\n  timeStamp:         " + this.timeStamp);
        stringBuffer.append("\n  notificationClass: " + this.notificationClass);
        stringBuffer.append("\n  priority:          " + this.priority);
        stringBuffer.append("\n  eventType:         " + this.eventType);
        stringBuffer.append("\n  messageText:       " + this.messageText);
        stringBuffer.append("\n  notifyType:        " + (Object)((Object)this.notifyType));
        stringBuffer.append("\n  ackRequired:       " + this.ackRequired);
        stringBuffer.append("\n  fromState:         " + this.fromState);
        stringBuffer.append("\n  toState:           " + this.toState);
        stringBuffer.append("\n  eventValues:       " + this.eventValues);
        stringBuffer.append("\n  encoding:          " + (Object)((Object)this.encoding));
        return stringBuffer.toString();
    }

    public EventNotificationParameters() {
    }

    public EventNotificationParameters(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, BBacnetTimeStamp bBacnetTimeStamp, long l2, int n, BEnum bEnum, String string, BBacnetNotifyType bBacnetNotifyType, boolean bl, BEnum bEnum2, BEnum bEnum3, BacnetNotificationParameters bacnetNotificationParameters, BCharacterSetEncoding bCharacterSetEncoding) {
        this.processId = l;
        this.initiatingDeviceId = bBacnetObjectIdentifier;
        this.eventObjectId = bBacnetObjectIdentifier2;
        this.timeStamp = bBacnetTimeStamp;
        this.notificationClass = l2;
        this.priority = n;
        this.eventType = bEnum;
        this.messageText = string;
        this.notifyType = bBacnetNotifyType;
        this.ackRequired = bl;
        this.fromState = bEnum2;
        this.toState = bEnum3;
        this.eventValues = bacnetNotificationParameters;
        this.encoding = bCharacterSetEncoding;
    }

    public EventNotificationParameters(EventNotificationParameters eventNotificationParameters) {
        this.processId = eventNotificationParameters.processId;
        this.initiatingDeviceId = eventNotificationParameters.initiatingDeviceId;
        this.eventObjectId = eventNotificationParameters.eventObjectId;
        this.timeStamp = (BBacnetTimeStamp)eventNotificationParameters.timeStamp.newCopy();
        this.notificationClass = eventNotificationParameters.notificationClass;
        this.priority = eventNotificationParameters.priority;
        this.eventType = eventNotificationParameters.eventType;
        this.messageText = eventNotificationParameters.messageText;
        this.notifyType = eventNotificationParameters.notifyType;
        this.ackRequired = eventNotificationParameters.ackRequired;
        this.fromState = eventNotificationParameters.fromState;
        this.toState = eventNotificationParameters.toState;
        this.eventValues = BacnetNotificationParameters.make(eventNotificationParameters.eventValues);
        this.encoding = eventNotificationParameters.encoding;
    }
}

