/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.notificationParameters.BufferReady;
import com.tridium.bacnet.asn.notificationParameters.ChangeOfBitstring;
import com.tridium.bacnet.asn.notificationParameters.ChangeOfLifeSafety;
import com.tridium.bacnet.asn.notificationParameters.ChangeOfState;
import com.tridium.bacnet.asn.notificationParameters.ChangeOfValue;
import com.tridium.bacnet.asn.notificationParameters.CommandFailure;
import com.tridium.bacnet.asn.notificationParameters.ComplexEventType;
import com.tridium.bacnet.asn.notificationParameters.Extended;
import com.tridium.bacnet.asn.notificationParameters.FloatingLimit;
import com.tridium.bacnet.asn.notificationParameters.OutOfRange;
import com.tridium.bacnet.asn.notificationParameters.UnsignedRange;
import java.util.HashMap;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.Context;

public abstract class BacnetNotificationParameters
implements AsnConst,
BacnetAlarmConst {
    public static final int CHANGE_OF_BITSTRING_TAG = 0;
    public static final int CHANGE_OF_STATE_TAG = 1;
    public static final int CHANGE_OF_VALUE_TAG = 2;
    public static final int COMMAND_FAILURE_TAG = 3;
    public static final int FLOATING_LIMIT_TAG = 4;
    public static final int OUT_OF_RANGE_TAG = 5;
    public static final int COMPLEX_EVENT_TYPE_TAG = 6;
    public static final int CHANGE_OF_LIFE_SAFETY_TAG = 8;
    public static final int EXTENDED_TAG = 9;
    public static final int BUFFER_READY_TAG = 10;
    public static final int UNSIGNED_RANGE_TAG = 11;
    int choiceType;

    public static BacnetNotificationParameters make(BacnetNotificationParameters bacnetNotificationParameters) {
        if (bacnetNotificationParameters == null) {
            return null;
        }
        switch (bacnetNotificationParameters.getChoiceType()) {
            case 0: {
                ChangeOfBitstring changeOfBitstring = (ChangeOfBitstring)bacnetNotificationParameters;
                return new ChangeOfBitstring(changeOfBitstring.getReferencedBitstring(), changeOfBitstring.getStatusFlags());
            }
            case 1: {
                ChangeOfState changeOfState = (ChangeOfState)bacnetNotificationParameters;
                return new ChangeOfState(changeOfState.getNewState(), changeOfState.getStatusFlags());
            }
            case 2: {
                ChangeOfValue changeOfValue = (ChangeOfValue)bacnetNotificationParameters;
                if (changeOfValue.isValue()) {
                    return new ChangeOfValue(changeOfValue.getChangedValue(), changeOfValue.getStatusFlags());
                }
                return new ChangeOfValue(changeOfValue.getChangedBits(), changeOfValue.getStatusFlags());
            }
            case 3: {
                CommandFailure commandFailure = (CommandFailure)bacnetNotificationParameters;
                return new CommandFailure(commandFailure.getCommandValue(), commandFailure.getStatusFlags(), commandFailure.getFeedbackValue());
            }
            case 4: {
                FloatingLimit floatingLimit = (FloatingLimit)bacnetNotificationParameters;
                return new FloatingLimit(floatingLimit.getReferenceValue(), floatingLimit.getStatusFlags(), floatingLimit.getSetpointValue(), floatingLimit.getErrorLimit());
            }
            case 5: {
                OutOfRange outOfRange = (OutOfRange)bacnetNotificationParameters;
                return new OutOfRange(outOfRange.getExceedingValue(), outOfRange.getStatusFlags(), outOfRange.getDeadband(), outOfRange.getExceededLimit());
            }
            case 6: {
                ComplexEventType complexEventType = (ComplexEventType)bacnetNotificationParameters;
                return new ComplexEventType(complexEventType.getListOfPropertyValues());
            }
            case 8: {
                ChangeOfLifeSafety changeOfLifeSafety = (ChangeOfLifeSafety)bacnetNotificationParameters;
                return new ChangeOfLifeSafety(changeOfLifeSafety.getNewState(), changeOfLifeSafety.getNewMode(), changeOfLifeSafety.getStatusFlags(), changeOfLifeSafety.getOperationExpected());
            }
            case 9: {
                Extended extended = (Extended)bacnetNotificationParameters;
                return new Extended(extended.getVendorId(), extended.getExtendedEventType(), extended.getParameters());
            }
            case 10: {
                BufferReady bufferReady = (BufferReady)bacnetNotificationParameters;
                return new BufferReady((BBacnetDeviceObjectPropertyReference)bufferReady.getBufferProperty().newCopy(), bufferReady.getPreviousNotification(), bufferReady.getCurrentNotification());
            }
            case 11: {
                UnsignedRange unsignedRange = (UnsignedRange)bacnetNotificationParameters;
                return new UnsignedRange(unsignedRange.getTimeDelay(), unsignedRange.getLowLimit(), unsignedRange.getHighLimit());
            }
        }
        return null;
    }

    public static final BacnetNotificationParameters parseEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        BacnetNotificationParameters bacnetNotificationParameters = null;
        asnInputStream.peekTag();
        if (asnInputStream.isOpeningTag(0)) {
            bacnetNotificationParameters = new ChangeOfBitstring();
        } else if (asnInputStream.isOpeningTag(1)) {
            bacnetNotificationParameters = new ChangeOfState();
        } else if (asnInputStream.isOpeningTag(2)) {
            bacnetNotificationParameters = new ChangeOfValue();
        } else if (asnInputStream.isOpeningTag(3)) {
            bacnetNotificationParameters = new CommandFailure();
        } else if (asnInputStream.isOpeningTag(4)) {
            bacnetNotificationParameters = new FloatingLimit();
        } else if (asnInputStream.isOpeningTag(5)) {
            bacnetNotificationParameters = new OutOfRange();
        } else if (asnInputStream.isOpeningTag(6)) {
            bacnetNotificationParameters = new ComplexEventType();
        } else if (asnInputStream.isOpeningTag(8)) {
            bacnetNotificationParameters = new ChangeOfLifeSafety();
        } else if (asnInputStream.isOpeningTag(9)) {
            bacnetNotificationParameters = new Extended();
        } else if (asnInputStream.isOpeningTag(10)) {
            bacnetNotificationParameters = new BufferReady();
        } else if (asnInputStream.isOpeningTag(11)) {
            bacnetNotificationParameters = new UnsignedRange();
        }
        if (bacnetNotificationParameters != null) {
            ((BacnetNotificationParameters)bacnetNotificationParameters).readEncoded(bBacnetObjectIdentifier, asnInputStream);
        }
        return bacnetNotificationParameters;
    }

    public abstract int getChoiceType();

    public abstract String toFacetString();

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public abstract void addAlarmData(HashMap var1);

    public abstract void writeEncoded(AsnOutputStream var1);

    public abstract void readEncoded(BBacnetObjectIdentifier var1, AsnInputStream var2) throws AsnException;

    public abstract void readEncoded(AsnInputStream var1) throws AsnException;

    protected BacnetNotificationParameters() {
    }
}

