/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AsnOutputStream
extends ByteArrayOutputStream
implements AsnOutput,
AsnConst {
    private static final int DEFAULT_BUFFER_CAPACITY = 16;
    private static final int STREAM_POOL_SIZE = 20;
    private static int cnt = 0;
    private static AsnOutputStream[] pool = new AsnOutputStream[20];
    private static Object poolLock = new Object();
    private boolean freeBuf;

    public void writeNull() {
        this.writePrimitiveApplicationTag(0, 0);
    }

    public void writeNull(int n) {
        this.writePrimitiveContextTag(n, 0);
    }

    public void writeBoolean(boolean bl) {
        if (bl) {
            this.writePrimitiveApplicationTag(1, 1);
        } else {
            this.writePrimitiveApplicationTag(1, 0);
        }
    }

    public void writeBoolean(int n, boolean bl) {
        this.writePrimitiveContextTag(n, 1);
        if (bl) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeBoolean(BBoolean bBoolean) {
        this.writeBoolean(bBoolean.getBoolean());
    }

    public void writeBoolean(int n, BBoolean bBoolean) {
        this.writeBoolean(n, bBoolean.getBoolean());
    }

    public void writeUnsignedInteger(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Unsigned integer values must be >= 0.");
        }
        int n = this.findIntegerLength(l);
        this.writePrimitiveApplicationTag(2, n);
        this.writeIntegerData(l, n);
    }

    public void writeUnsignedInteger(int n, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Unsigned integer values must be >= 0.");
        }
        int n2 = this.findIntegerLength(l);
        this.writePrimitiveContextTag(n, n2);
        this.writeIntegerData(l, n2);
    }

    public void writeUnsigned(BBacnetUnsigned bBacnetUnsigned) {
        this.writeUnsignedInteger(bBacnetUnsigned.getUnsigned());
    }

    public void writeUnsigned(int n, BBacnetUnsigned bBacnetUnsigned) {
        this.writeUnsignedInteger(n, bBacnetUnsigned.getUnsigned());
    }

    public void writeSignedInteger(int n) {
        int n2;
        int n3 = this.findIntegerLength(n);
        if (n > 0 && (n & (n2 = 1 << 8 * n3 - 1)) != 0) {
            ++n3;
        }
        this.writePrimitiveApplicationTag(3, n3);
        this.writeIntegerData(n, n3);
    }

    public void writeSignedInteger(int n, int n2) {
        int n3;
        int n4 = this.findIntegerLength(n2);
        if (n2 > 0 && (n2 & (n3 = 1 << 8 * n4 - 1)) != 0) {
            ++n4;
        }
        this.writePrimitiveContextTag(n, n4);
        this.writeIntegerData(n2, n4);
    }

    private final int findIntegerLength(long l) {
        if (l == 0L) {
            return 1;
        }
        if (l > 0L) {
            if (l > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("Number too big for Asn conversion: " + Long.toHexString(l));
            }
            if ((l & 0xFFFFFFFFFF000000L) != 0L) {
                return 4;
            }
            if ((l & 0xFF0000L) != 0L) {
                return 3;
            }
            if ((l & 0xFF00L) != 0L) {
                return 2;
            }
            return 1;
        }
        if (l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Number too big for Asn conversion: " + Long.toHexString(l));
        }
        if ((l & 0xFFFFFFFFFF000000L) != -16777216L) {
            return 4;
        }
        if ((l & 0x800000L) == 0L) {
            return 4;
        }
        if ((l & 0xFF0000L) != 0xFF0000L) {
            return 3;
        }
        if ((l & 0x8000L) == 0L) {
            return 3;
        }
        if ((l & 0xFF00L) != 65280L) {
            return 2;
        }
        if ((l & 0x80L) == 0L) {
            return 2;
        }
        return 1;
    }

    private final void writeIntegerData(long l, int n) {
        int n2 = 1;
        while (n2 <= n) {
            int n3 = (n - n2) * 8;
            this.write((int)(l >> n3));
            ++n2;
        }
    }

    public void writeSignedInteger(BInteger bInteger) {
        this.writeSignedInteger(bInteger.getInt());
    }

    public void writeSignedInteger(int n, BInteger bInteger) {
        this.writeSignedInteger(n, bInteger.getInt());
    }

    public void writeReal(double d) {
        this.writePrimitiveApplicationTag(4, 4);
        this.encodeReal((float)d);
    }

    public void writeReal(int n, double d) {
        this.writePrimitiveContextTag(n, 4);
        this.encodeReal((float)d);
    }

    private final void encodeReal(float f) {
        int n = Float.floatToIntBits(f);
        int n2 = 24;
        int n3 = 0;
        while (n3 < 4) {
            this.write(n >> n2);
            n2 -= 8;
            ++n3;
        }
    }

    public void writeReal(BNumber bNumber) {
        this.writeReal(bNumber.getFloat());
    }

    public void writeReal(int n, BNumber bNumber) {
        this.writeReal(n, bNumber.getFloat());
    }

    public void writeDouble(double d) {
        this.writePrimitiveApplicationTag(5, 8);
        this.encodeDouble(d);
    }

    public void writeDouble(int n, double d) {
        this.writePrimitiveContextTag(n, 8);
        this.encodeDouble(d);
    }

    private final void encodeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        long l2 = 64L;
        int n = 0;
        while (n < 8) {
            this.write((int)(l >> (int)(l2 -= 8L)));
            ++n;
        }
    }

    public void writeDouble(BNumber bNumber) {
        this.writeDouble(bNumber.getDouble());
    }

    public void writeDouble(int n, BNumber bNumber) {
        this.writeDouble(n, bNumber.getDouble());
    }

    public void writeOctetString(byte[] byArray) {
        this.writePrimitiveApplicationTag(6, byArray.length);
        this.writeOctetStringData(byArray);
    }

    public void writeOctetString(int n, byte[] byArray) {
        this.writePrimitiveContextTag(n, byArray.length);
        this.writeOctetStringData(byArray);
    }

    public void writeOctetString(BBacnetOctetString bBacnetOctetString) {
        this.writePrimitiveApplicationTag(6, bBacnetOctetString.length());
        this.writeOctetStringData(bBacnetOctetString.getBytes());
    }

    public void writeOctetString(int n, BBacnetOctetString bBacnetOctetString) {
        this.writePrimitiveContextTag(n, bBacnetOctetString.length());
        this.writeOctetStringData(bBacnetOctetString.getBytes());
    }

    private final void writeOctetStringData(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            this.write(byArray[n]);
            ++n;
        }
    }

    public void writeCharacterString(String string) {
        this.writeCharacterString(string, BBacnetNetwork.localDevice().getCharacterSet());
    }

    public void writeCharacterString(String string, BCharacterSetEncoding bCharacterSetEncoding) {
        if (bCharacterSetEncoding == null) {
            bCharacterSetEncoding = BBacnetNetwork.localDevice().getCharacterSet();
        }
        try {
            byte[] byArray = string.getBytes(bCharacterSetEncoding.getEncodingName());
            this.writePrimitiveApplicationTag(7, byArray.length + 1);
            this.write(bCharacterSetEncoding.getOrdinal());
            this.write(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unsupported Encoding:" + bCharacterSetEncoding.getTag());
        }
    }

    public void writeCharacterString(int n, String string) {
        this.writeCharacterString(n, string, BBacnetNetwork.localDevice().getCharacterSet());
    }

    public void writeCharacterString(int n, String string, BCharacterSetEncoding bCharacterSetEncoding) {
        if (bCharacterSetEncoding == null) {
            bCharacterSetEncoding = BBacnetNetwork.localDevice().getCharacterSet();
        }
        try {
            byte[] byArray = string.getBytes(bCharacterSetEncoding.getEncodingName());
            this.writePrimitiveContextTag(n, byArray.length + 1);
            this.write(bCharacterSetEncoding.getOrdinal());
            this.write(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unsupported Encoding:" + bCharacterSetEncoding.getTag());
        }
    }

    public void writeCharacterString(BString bString) {
        this.writeCharacterString(bString.getString());
    }

    public void writeCharacterString(BString bString, BCharacterSetEncoding bCharacterSetEncoding) {
        this.writeCharacterString(bString.getString(), bCharacterSetEncoding);
    }

    public void writeCharacterString(int n, BString bString) {
        this.writeCharacterString(n, bString.getString());
    }

    public void writeCharacterString(int n, BString bString, BCharacterSetEncoding bCharacterSetEncoding) {
        this.writeCharacterString(n, bString.getString(), bCharacterSetEncoding);
    }

    public void writeBitString(boolean[] blArray) {
        this.writePrimitiveApplicationTag(8, this.getBitStringDataLength(blArray.length));
        this.writeBitStringData(blArray);
    }

    public void writeBitString(int n, boolean[] blArray) {
        this.writePrimitiveContextTag(n, this.getBitStringDataLength(blArray.length));
        this.writeBitStringData(blArray);
    }

    public void writeBitString(BBacnetBitString bBacnetBitString) {
        this.writeBitString(bBacnetBitString.getBits());
    }

    public void writeBitString(int n, BBacnetBitString bBacnetBitString) {
        this.writeBitString(n, bBacnetBitString.getBits());
    }

    private final int getBitStringDataLength(int n) {
        int n2 = n / 8 + 1;
        if (n % 8 != 0) {
            ++n2;
        }
        return n2;
    }

    private final void writeBitStringData(boolean[] blArray) {
        int n = blArray.length;
        int n2 = 8 - n % 8;
        int n3 = n / 8;
        if (n2 == 8) {
            n2 = 0;
        } else {
            ++n3;
        }
        this.write(n2);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            int n7 = 128;
            int n8 = 0;
            while (n8 < 8) {
                if (n4 < n && blArray[n4]) {
                    n6 |= n7;
                }
                n7 >>= 1;
                ++n4;
                ++n8;
            }
            this.write(n6);
            ++n5;
        }
    }

    public void writeStatusFlags(BStatus bStatus) {
        this.writePrimitiveApplicationTag(8, this.getBitStringDataLength(4));
        this.writeBitStringData(new boolean[]{bStatus.isAlarm(), bStatus.isFault(), bStatus.isOverridden(), bStatus.isDisabled()});
    }

    public void writeStatusFlags(int n, BStatus bStatus) {
        this.writePrimitiveContextTag(n, this.getBitStringDataLength(4));
        this.writeBitStringData(new boolean[]{bStatus.isAlarm(), bStatus.isFault(), bStatus.isOverridden(), bStatus.isDisabled()});
    }

    public void writeEnumerated(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Enumerated values must be greater than zero.");
        }
        int n2 = this.findIntegerLength(n);
        this.writePrimitiveApplicationTag(9, n2);
        this.writeIntegerData(n, n2);
    }

    public void writeEnumerated(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Enumerated values must be nonnegative.");
        }
        int n3 = this.findIntegerLength(n2);
        this.writePrimitiveContextTag(n, n3);
        this.writeIntegerData(n2, n3);
    }

    public void writeEnumerated(BEnum bEnum) {
        this.writeEnumerated(bEnum.getOrdinal());
    }

    public void writeEnumerated(int n, BEnum bEnum) {
        this.writeEnumerated(n, bEnum.getOrdinal());
    }

    public void writeDate(int n, int n2, int n3, int n4) {
        this.writePrimitiveApplicationTag(10, 4);
        this.writeDateData(n, n2, n3, n4);
    }

    public void writeDate(int n, int n2, int n3, int n4, int n5) {
        this.writePrimitiveContextTag(n, 4);
        this.writeDateData(n2, n3, n4, n5);
    }

    public void writeDate(BBacnetDate bBacnetDate) {
        this.writePrimitiveApplicationTag(10, 4);
        this.writeDateData(bBacnetDate.getRawYear(), bBacnetDate.getMonth(), bBacnetDate.getDayOfMonth(), bBacnetDate.getDayOfWeek());
    }

    public void writeDate(int n, BBacnetDate bBacnetDate) {
        this.writePrimitiveContextTag(n, 4);
        this.writeDateData(bBacnetDate.getRawYear(), bBacnetDate.getMonth(), bBacnetDate.getDayOfMonth(), bBacnetDate.getDayOfWeek());
    }

    public void writeDate(BAbsTime bAbsTime) {
        this.writePrimitiveApplicationTag(10, 4);
        if (bAbsTime.isNull()) {
            this.writeDateData(-1, -1, -1, -1);
        } else {
            this.writeDateData(bAbsTime.getYear() - 1900, bAbsTime.getMonth().getOrdinal() + 1, bAbsTime.getDay(), bAbsTime.getWeekday().getOrdinal() == 0 ? 7 : bAbsTime.getWeekday().getOrdinal());
        }
    }

    public void writeDate(int n, BAbsTime bAbsTime) {
        this.writePrimitiveContextTag(n, 4);
        if (bAbsTime.isNull()) {
            this.writeDateData(-1, -1, -1, -1);
        } else {
            this.writeDateData(bAbsTime.getYear() - 1900, bAbsTime.getMonth().getOrdinal() + 1, bAbsTime.getDay(), bAbsTime.getWeekday().getOrdinal() == 0 ? 7 : bAbsTime.getWeekday().getOrdinal());
        }
    }

    private final void writeDateData(int n, int n2, int n3, int n4) {
        this.write(n);
        this.write(n2);
        this.write(n3);
        this.write(n4);
    }

    public void writeTime(int n, int n2, int n3, int n4) {
        this.writePrimitiveApplicationTag(11, 4);
        this.writeTimeData(n, n2, n3, n4);
    }

    public void writeTime(int n, int n2, int n3, int n4, int n5) {
        this.writePrimitiveContextTag(n, 4);
        this.writeTimeData(n2, n3, n4, n5);
    }

    public void writeTime(BBacnetTime bBacnetTime) {
        this.writePrimitiveApplicationTag(11, 4);
        this.writeTimeData(bBacnetTime.getHour(), bBacnetTime.getMinute(), bBacnetTime.getSecond(), bBacnetTime.getHundredth());
    }

    public void writeTime(int n, BBacnetTime bBacnetTime) {
        this.writePrimitiveContextTag(n, 4);
        this.writeTimeData(bBacnetTime.getHour(), bBacnetTime.getMinute(), bBacnetTime.getSecond(), bBacnetTime.getHundredth());
    }

    public void writeTime(BTime bTime) {
        this.writePrimitiveApplicationTag(11, 4);
        this.writeTimeData(bTime.getHour(), bTime.getMinute(), bTime.getSecond(), bTime.getMillisecond() / 10);
    }

    public void writeTime(int n, BTime bTime) {
        this.writePrimitiveContextTag(n, 4);
        this.writeTimeData(bTime.getHour(), bTime.getMinute(), bTime.getSecond(), bTime.getMillisecond() / 10);
    }

    public void writeTime(BAbsTime bAbsTime) {
        this.writePrimitiveApplicationTag(11, 4);
        if (bAbsTime.isNull()) {
            this.writeTimeData(-1, -1, -1, -1);
        } else {
            this.writeTimeData(bAbsTime.getHour(), bAbsTime.getMinute(), bAbsTime.getSecond(), bAbsTime.getMillisecond() / 10);
        }
    }

    public void writeTime(int n, BAbsTime bAbsTime) {
        this.writePrimitiveContextTag(n, 4);
        if (bAbsTime.isNull()) {
            this.writeTimeData(-1, -1, -1, -1);
        } else {
            this.writeTimeData(bAbsTime.getHour(), bAbsTime.getMinute(), bAbsTime.getSecond(), bAbsTime.getMillisecond() / 10);
        }
    }

    private final void writeTimeData(int n, int n2, int n3, int n4) {
        this.write(n);
        this.write(n2);
        this.write(n3);
        this.write(n4);
    }

    public void writeObjectIdentifier(int n, int n2) {
        this.writePrimitiveApplicationTag(12, 4);
        int n3 = n << 22 & 0xFFC00000 | n2 & 0x3FFFFF;
        this.writeIntegerData(n3, 4);
    }

    public void writeObjectIdentifier(int n, int n2, int n3) {
        this.writePrimitiveContextTag(n, 4);
        int n4 = n2 << 22 & 0xFFC00000 | n3 & 0x3FFFFF;
        this.writeIntegerData(n4, 4);
    }

    public void writeObjectIdentifier(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.writeObjectIdentifier(bBacnetObjectIdentifier.getObjectType(), bBacnetObjectIdentifier.getInstanceNumber());
    }

    public void writeObjectIdentifier(int n, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.writeObjectIdentifier(n, bBacnetObjectIdentifier.getObjectType(), bBacnetObjectIdentifier.getInstanceNumber());
    }

    public void writeEncodedValue(byte[] byArray) {
        if (byArray != null) {
            this.write(byArray, 0, byArray.length);
        }
    }

    public void writeEncodedValue(int n, byte[] byArray) {
        this.writeOpeningTag(n);
        if (byArray != null) {
            this.write(byArray);
        }
        this.writeClosingTag(n);
    }

    public void writeOpeningTag(int n) {
        this.writeTag(n, 8, 6);
    }

    public void writeClosingTag(int n) {
        this.writeTag(n, 8, 7);
    }

    private final void writePrimitiveApplicationTag(int n, int n2) {
        this.writePrimitiveTag(n, 0, n2);
    }

    private final void writePrimitiveContextTag(int n, int n2) {
        this.writePrimitiveTag(n, 8, n2);
    }

    private final void writePrimitiveTag(int n, int n2, int n3) {
        int n4 = n3 <= 4 ? n3 : 5;
        this.writeTag(n, n2, n4);
        if (n4 == 5) {
            this.writeExtendedLength(n3);
        }
    }

    private final void writeTag(int n, int n2, int n3) {
        if (n <= 14) {
            this.write((n <<= 4) | n2 | n3);
        } else if (n <= 254) {
            this.write(0xF0 | n2 | n3);
            this.write(n);
        } else {
            throw new IllegalArgumentException("Tag number > 254 not permitted !");
        }
    }

    void writeExtendedLength(int n) {
        if (n <= 4) {
            throw new IllegalArgumentException("Length too small to be extended");
        }
        if (n <= 253) {
            this.write(n);
        } else if (n <= (char)-1) {
            int n2 = (n & 0xFF00) >> 8;
            int n3 = n & 0xFF;
            this.write(254);
            this.write(n2);
            this.write(n3);
        } else {
            int n4 = (n & 0xFF000000) >> 24;
            int n5 = (n & 0xFF0000) >> 16;
            int n6 = (n & 0xFF00) >> 8;
            int n7 = n & 0xFF;
            this.write(255);
            this.write(n4);
            this.write(n5);
            this.write(n6);
            this.write(n7);
        }
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setPoolSize(int n) {
        Object object = poolLock;
        synchronized (object) {
            AsnOutputStream[] asnOutputStreamArray = new AsnOutputStream[n];
            System.arraycopy(pool, 0, asnOutputStreamArray, 0, Math.min(pool.length, asnOutputStreamArray.length));
            pool = asnOutputStreamArray;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AsnOutputStream make() {
        Object object = poolLock;
        synchronized (object) {
            AsnOutputStream asnOutputStream;
            block4: {
                block3: {
                    if (cnt <= 0 || cnt > pool.length) break block3;
                    asnOutputStream = pool[--cnt];
                    asnOutputStream.reset();
                    break block4;
                }
                asnOutputStream = new AsnOutputStream();
            }
            asnOutputStream.freeBuf = false;
            return asnOutputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        Object object = poolLock;
        synchronized (object) {
            if (this.freeBuf) {
                return;
            }
            if (cnt < pool.length) {
                AsnOutputStream.pool[AsnOutputStream.cnt++] = this;
            }
            this.freeBuf = true;
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.freeBuf = false;
    }

    public AsnOutputStream() {
        super(16);
        this.this();
    }

    public AsnOutputStream(int n) {
        super(n);
        this.this();
    }
}

