/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet;

import com.tridium.bacnet.asn.NBacnetPropertyReference;
import java.io.InputStream;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectTypeList {
    private static ObjectTypeList INSTANCE = null;
    private static Vector BASIC_PROP_LIST = new Vector();
    private static int[] BASIC_PROPS;
    private IntHashMap objectMap;
    private IntHashMap reqPropsMap;

    public static ObjectTypeList make(BOrd bOrd) {
        return new ObjectTypeList(bOrd);
    }

    private final void load(BOrd bOrd) {
        try {
            if (bOrd == null || bOrd.equals((Object)BOrd.NULL)) {
                return;
            }
            Log.getLog((String)"bacnet").trace("Loading object type info from " + bOrd);
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse();
            XElem[] xElemArray = xElem.elems("object");
            int n = 0;
            while (n < xElemArray.length) {
                int n2;
                IntHashMap intHashMap = new IntHashMap();
                Vector<Integer> vector = new Vector<Integer>();
                int n3 = xElemArray[n].geti("t");
                XElem[] xElemArray2 = xElemArray[n].elems("property");
                int n4 = 0;
                while (n4 < xElemArray2.length) {
                    n2 = xElemArray2[n4].geti("i");
                    PropertyInfo propertyInfo = new PropertyInfo(xElemArray2[n4]);
                    intHashMap.put(n2, (Object)propertyInfo);
                    boolean bl = xElemArray2[n4].getb("r", false);
                    if (bl) {
                        vector.add(new Integer(n2));
                    }
                    ++n4;
                }
                int[] nArray = new int[vector.size()];
                n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n2] = (Integer)vector.get(n2);
                    ++n2;
                }
                this.objectMap.put(n3, (Object)intHashMap);
                this.reqPropsMap.put(n3, (Object)nArray);
                ++n;
            }
        }
        catch (Exception exception) {
            Log.getLog((String)"bacnet").warning("Unable to load Bacnet Object Types from " + bOrd + ':' + exception);
            throw new BajaRuntimeException("Error loading object types!", (Throwable)exception);
        }
    }

    public PropertyInfo getPropertyInfo(int n, int n2) {
        IntHashMap intHashMap = (IntHashMap)this.objectMap.get(n);
        if (intHashMap == null) {
            return null;
        }
        return (PropertyInfo)intHashMap.get(n2);
    }

    public boolean isObjectTypeKnown(int n) {
        boolean bl = false;
        if (this.objectMap.get(n) != null) {
            bl = true;
        }
        return bl;
    }

    public int[] getPossibleProperties(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        if (bBacnetObjectIdentifier == null) {
            return BASIC_PROPS;
        }
        IntHashMap intHashMap = (IntHashMap)this.objectMap.get(bBacnetObjectIdentifier.getObjectType());
        if (intHashMap == null) {
            return BASIC_PROPS;
        }
        int[] nArray = new int[intHashMap.size()];
        IntHashMap.Iterator iterator = intHashMap.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            nArray[n++] = iterator.key();
        }
        return nArray;
    }

    public int[] getRequiredProperties(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        if (bBacnetObjectIdentifier == null) {
            return BASIC_PROPS;
        }
        int[] nArray = (int[])this.reqPropsMap.get(bBacnetObjectIdentifier.getObjectType());
        return nArray != null ? nArray : BASIC_PROPS;
    }

    public String toString() {
        return "ObjectTypeList:size=" + this.size();
    }

    public static ObjectTypeList getInstance() {
        return INSTANCE;
    }

    private final int size() {
        return this.objectMap.size();
    }

    private final /* synthetic */ void this() {
        this.objectMap = new IntHashMap(25);
        this.reqPropsMap = new IntHashMap(25);
    }

    private ObjectTypeList(BOrd bOrd) {
        this.this();
        this.load(bOrd);
    }

    static {
        try {
            INSTANCE = new ObjectTypeList(BOrd.make((String)"file:!lib/bacnetObjectTypes.xml"));
        }
        catch (Exception exception) {
            try {
                INSTANCE = new ObjectTypeList(BOrd.make((String)"module://bacnet/com/tridium/bacnet/objectTypes.xml"));
            }
            catch (Exception exception2) {
                System.out.println("Cannot load BACnet object type data from XML file!");
            }
        }
        BASIC_PROP_LIST.add(new NBacnetPropertyReference(75));
        BASIC_PROP_LIST.add(new NBacnetPropertyReference(77));
        BASIC_PROP_LIST.add(new NBacnetPropertyReference(79));
        BASIC_PROPS = new int[]{75, 77, 79};
    }
}

