/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet;

import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BacnetVendorUtil {
    private static BacnetVendorUtil list = new BacnetVendorUtil(BOrd.make((String)"module://bacnet/com/tridium/bacnet/vendors.xml"));
    private IntHashMap namesById;

    private final void load(BOrd bOrd) {
        try {
            if (bOrd == null || bOrd.equals((Object)BOrd.NULL)) {
                return;
            }
            Log.getLog((String)"bacnet").trace("Loading vendor id/name info from " + bOrd);
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse();
            XElem[] xElemArray = xElem.elems("vendor");
            int n = 0;
            while (n < xElemArray.length) {
                int n2 = xElemArray[n].geti("id");
                String string = xElemArray[n].get("n");
                this.namesById.put(n2, (Object)string);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BajaRuntimeException("Error loading vendor file!", (Throwable)exception);
        }
    }

    public static String getVendorName(int n) {
        return list.nameById(n);
    }

    private final String nameById(int n) {
        String string = (String)this.namesById.get(n);
        return string != null ? string : "";
    }

    private final void dump() {
        int n = 0;
        while (n < this.namesById.size()) {
            System.out.println("" + n + ':' + this.nameById(n));
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("BACnet Vendor List:");
        list.dump();
    }

    private final /* synthetic */ void this() {
        this.namesById = new IntHashMap(180);
    }

    private BacnetVendorUtil(BOrd bOrd) {
        this.this();
        this.load(bOrd);
    }
}

