/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet;

import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BacnetQuery
implements OrdQuery {
    private final String body;
    private String device;
    private String domain;
    private String object;
    private String property;
    private String index;
    private boolean hasDomain;
    private boolean hasObject;
    private boolean hasProperty;
    private boolean hasIndex;

    public String getScheme() {
        return "bac";
    }

    public String getBody() {
        return this.body;
    }

    public boolean isHost() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public void normalize(OrdQueryList ordQueryList, int n) {
        if (ordQueryList.isSameScheme(n, n + 1)) {
            ordQueryList.remove(n);
        }
    }

    public String toString() {
        return "bac:" + this.body;
    }

    private final void parse() {
        if (this.body == null) {
            return;
        }
        int n = this.body.indexOf(";");
        int n2 = this.body.indexOf("/");
        int n3 = this.body.indexOf("[");
        int n4 = this.body.indexOf("]");
        int n5 = this.body.indexOf("{");
        int n6 = this.body.indexOf("}");
        if (n5 < 0) {
            this.hasDomain = false;
            this.domain = null;
        } else {
            this.hasDomain = true;
            this.domain = this.body.substring(n5 + 1, n6);
        }
        if (n < 0) {
            this.hasObject = false;
            this.hasProperty = false;
            this.hasIndex = false;
            this.device = this.hasDomain ? this.body.substring(0, n5) : this.body;
            this.object = null;
            this.property = null;
            this.index = null;
        } else {
            this.hasObject = true;
            this.device = this.body.substring(0, n);
            if (n2 < 0) {
                this.hasProperty = false;
                this.hasIndex = false;
                this.object = this.hasDomain ? this.body.substring(n + 1, n5) : this.body.substring(n + 1);
                this.property = null;
                this.index = null;
            } else {
                this.hasProperty = true;
                this.object = this.body.substring(n + 1, n2);
                if (n3 >= 0 && n4 >= 0 && n4 > n3) {
                    this.hasIndex = true;
                    this.property = this.body.substring(n2 + 1, n3);
                    this.index = this.body.substring(n3 + 1, n4);
                } else {
                    this.hasIndex = false;
                    this.property = this.hasDomain ? this.body.substring(n2 + 1, n5) : this.body.substring(n2 + 1);
                    this.index = null;
                }
            }
        }
    }

    public boolean hasDomain() {
        return this.hasDomain;
    }

    public boolean hasObject() {
        return this.hasObject;
    }

    public boolean hasProperty() {
        return this.hasProperty;
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public String getDevice() {
        return this.device;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getObject() {
        return this.object;
    }

    public String getProperty() {
        return this.property;
    }

    public String getIndex() {
        return this.index;
    }

    public void dump() {
        System.out.println("body:" + this.body);
        System.out.println("  device=" + this.device);
        System.out.println("  object=" + this.object);
        System.out.println("  property=" + this.property);
        System.out.println("  index=" + this.index);
        System.out.println("  domain=" + this.domain);
    }

    private final /* synthetic */ void this() {
        this.device = null;
        this.domain = null;
        this.object = null;
        this.property = null;
        this.index = null;
        this.hasDomain = false;
        this.hasObject = false;
        this.hasProperty = false;
        this.hasIndex = false;
    }

    BacnetQuery(String string) {
        this.this();
        this.body = string;
        this.parse();
    }
}

