/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.station;

import com.tridium.platDaemon.ui.widget.BCreateFileDialog;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.provisioning.station.BStationProxy;
import com.tridium.provisioning.ui.station.BStationProxyOutputDialog;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.baja.file.FilePath;
import javax.baja.platform.BStationStatus;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;

public class StreamOutputCommand
extends Command {
    private BStationProxy station;
    private static Lexicon lex = Lexicon.make((String)"provisioning");

    public StreamOutputCommand(BWidget bWidget) {
        super(bWidget, lex, "ProvisioningStationDirector.command.streamOutput");
        this.setEnabled(false);
    }

    public void loadStation(BStationProxy bStationProxy) {
        this.station = bStationProxy;
        this.checkEnabled();
    }

    public void checkEnabled() {
        this.setEnabled(this.station.getStationStatus() != BStationStatus.unknown);
    }

    public CommandArtifact doInvoke() {
        try {
            FilePath filePath = BCreateFileDialog.getPath((BWidget)this.getOwner(), null, (String)lex.getText("ProvisioningStationDirector.command.streamOutput.saveAs.dlgTitle"), (String)lex.getText("ProvisioningStationDirector.command.streamOutput.saveAs.dlgMessage"), null, (String)"txt");
            if (filePath != null) {
                new BStationProxyOutputDialog(this.getOwner(), this.station, filePath).open();
            }
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
        return null;
    }

    public static class Worker
    extends Thread {
        private BDialog dialog = null;
        private InputStream in;
        private OutputStream out;
        private BWidget owner;
        private String fileName;
        private boolean stopped = true;
        private BLabel label;

        public Worker(BWidget bWidget, BLabel bLabel, String string, InputStream inputStream, OutputStream outputStream) {
            this.owner = bWidget;
            this.fileName = string;
            this.label = bLabel;
            this.in = inputStream;
            this.out = outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.stopped = false;
            byte[] byArray = new byte[1024];
            int n = 0;
            boolean bl = false;
            long l = 0L;
            this.label.setText(lex.getText("ProvisioningStationDirector.command.streamOutput.saving.dlgMessage", new Object[]{this.fileName, DaemonFileUtil.fileSize((long)l)}));
            try {
                while (!this.stopped) {
                    try {
                        n = this.in.read(byArray, 0, 1024);
                        if (n > 0) {
                            l += (long)n;
                        }
                        this.label.setText(lex.getText("ProvisioningStationDirector.command.streamOutput.saving.dlgMessage", new Object[]{this.fileName, DaemonFileUtil.fileSize((long)l)}));
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new IOException();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    if (this.stopped || n < 0) continue;
                    this.out.write(byArray, 0, n);
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                if (!this.stopped) {
                    iOException.printStackTrace(System.out);
                }
            }
            finally {
                this.stopWorker();
            }
        }

        public void stopWorker() {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            try {
                this.in.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this.out.flush();
                this.out.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.dialog != null) {
                this.dialog.close();
            }
        }

        public void setDialog(BDialog bDialog) {
            this.dialog = bDialog;
        }
    }

    public static class CloseCommand
    extends DialogCommand {
        private Worker worker;

        public CloseCommand(BWidget bWidget, Worker worker) {
            super(bWidget, 16, Lexicon.make((String)"platform").getText("dialog.close"));
            this.worker = worker;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.worker.stopWorker();
            return null;
        }
    }
}

