/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.station;

import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioning.station.BStationProxy;
import javax.baja.gx.BImage;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class RebootCommand
extends AsyncCommand {
    private BStationProxy station;
    private static final Lexicon lex = Lexicon.make((String)"provisioning");

    public RebootCommand(BWidget bWidget) {
        super(bWidget, lex, "ProvisioningStationDirector.command.reboot");
    }

    public void loadStation(BStationProxy bStationProxy) {
        this.station = bStationProxy;
        this.checkEnabled();
    }

    public void checkEnabled() {
        this.setEnabled(this.station.getIsRebootEnabled());
    }

    public void doInvokeAsync() {
        try {
            String string = lex.getText("ProvisioningStationDirector.command.reboot.dlgTitle");
            String string2 = lex.getText("ProvisioningStationDirector.command.reboot.dlgMessage");
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)this.getOwner());
            if (BDialog.open((BWidget)this.getOwner(), (String)string, (Object)string2, (int)12, (BImage)BDialog.WARNING_ICON, (String)null) == 4) {
                this.station.rebootHost();
                BDialog.message((BWidget)bWbShell, (String)lex.getText("ProvisioningStationDirector.command.reboot.notifyTitle", new Object[]{this.station.getStationName()}), (Object)lex.getText("ProvisioningStationDirector.command.reboot.notifyMessage", new Object[]{this.station.getNiagaraStation().getRemoteHost()}));
            }
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
    }
}

