/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.station;

import com.tridium.platform.ui.util.BInputStreamPane;
import com.tridium.provisioning.station.BStationProxy;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStationProxyOutputPane
extends BInputStreamPane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$ui$station$BStationProxyOutputPane == null ? (class$com$tridium$provisioning$ui$station$BStationProxyOutputPane = BStationProxyOutputPane.class$("com.tridium.provisioning.ui.station.BStationProxyOutputPane")) : class$com$tridium$provisioning$ui$station$BStationProxyOutputPane));
    private BStationProxy station = null;
    private boolean updatesOnly = false;
    private FilePath capturePath = null;
    private Writer captureWriter = null;
    static /* synthetic */ Class class$com$tridium$provisioning$ui$station$BStationProxyOutputPane;

    public Type getType() {
        return TYPE;
    }

    public BStationProxyOutputPane() {
        this.setBufferTime(-1);
    }

    public BStationProxyOutputPane(int n, int n2) {
        super(n, n2);
        this.setBufferTime(-1);
    }

    public BStationProxyOutputPane(int n, int n2, boolean bl) {
        super(n, n2);
        this.setBufferTime(-1);
        this.updatesOnly = bl;
    }

    protected InputStream getInputStream() {
        try {
            return this.station.getStationOutput(true, this.updatesOnly);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void loadStation(BStationProxy bStationProxy) {
        BStationProxy bStationProxy2 = this.station;
        this.station = bStationProxy;
        if (bStationProxy2 != this.station) {
            this.load();
        }
    }

    public void setCapturePath(FilePath filePath) {
        this.capturePath = filePath;
    }

    protected synchronized void startUpdates(BInputStreamPane.OutputWatcher outputWatcher) {
        if (this.capturePath != null) {
            try {
                this.captureWriter = new BufferedWriter(new OutputStreamWriter(BFileSystem.INSTANCE.makeFile(this.capturePath).getOutputStream()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.startUpdates(outputWatcher);
    }

    public void append(String string) {
        super.append(string);
        if (this.captureWriter != null) {
            try {
                this.captureWriter.write(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    this.captureWriter.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.captureWriter = null;
            }
        }
    }

    public synchronized void stopUpdates() {
        super.stopUpdates();
        try {
            Thread.sleep(600L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.captureWriter != null) {
            try {
                this.captureWriter.flush();
                this.captureWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.captureWriter = null;
        }
    }

    public BStationProxy getStation() {
        return this.station;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

