/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.software;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BModuleStatus;
import com.tridium.install.part.BPart;
import com.tridium.platform.ui.util.SortableTableUtil;
import com.tridium.provisioning.ui.software.SoftwareTableModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;

public class SoftwareTableRow
implements SortableTableUtil.SortableRow {
    private Array forwardDeps = new Array(class$com$tridium$install$BDependency == null ? (class$com$tridium$install$BDependency = SoftwareTableRow.class$("com.tridium.install.BDependency")) : class$com$tridium$install$BDependency);
    private HashMap reverseDepsByName = new HashMap();
    private BPart currentPart = null;
    private long installablePartSize = Long.MIN_VALUE;
    private BInstallable installable;
    private SoftwareTableModel model;
    private int installStatus = 0;
    private int action = 0;
    private static Lexicon lex = Lexicon.make((String)"provisioning");
    public static final int ACTION_MASK = 255;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_INSTALL = 511;
    public static final int ACTION_UNINSTALL = 767;
    public static final int ACTION_UPGRADE = 1279;
    public static final int ACTION_REINSTALL = 2303;
    public static final int ACTION_DOWNGRADE = 4351;
    public static final int ACTION_ANY_INSTALL = 7679;
    public static final int STATUS_NONE = 0;
    public static final int STATUS_LATER = 2;
    public static final int STATUS_SAME = 4;
    public static final int STATUS_EARLIER = 8;
    public static final int STATUS_DIFFERENT = 16;
    public static final int STATUS_EQUIVALENT = 18;
    public static final int STATUS_NOT_INSTALLED = 20;
    public static final int STATUS_BAD_INSTALLABLE = 24;
    public static final int STATUS_BAD_TARGET = 32;
    public static final int STATUS_BOTH_BAD = 34;
    public static final int STATUS_NO_DETAILS = 36;
    public static final int STATUS_NO_LOCAL = 40;
    public static final int STATUS_INSTALL = 511;
    public static final int STATUS_UNINSTALL = 767;
    public static final int STATUS_UPGRADE = 1279;
    public static final int STATUS_REINSTALL = 2303;
    public static final int STATUS_DOWNGRADE = 4351;
    public static final int NAME_COL = 0;
    public static final int TYPE_COL = 1;
    public static final int CURRENT_VER_COL = 2;
    public static final int AVAIL_VER_COL = 3;
    public static final int FILE_NAME_COL = 4;
    public static final int COMMENT_COL = 5;
    static /* synthetic */ Class class$com$tridium$install$part$BPart;
    static /* synthetic */ Class class$com$tridium$install$BDependency;

    public SoftwareTableRow(SoftwareTableModel softwareTableModel) {
        this.model = softwareTableModel;
    }

    public int compareComment(SoftwareTableRow softwareTableRow) {
        int n;
        int n2 = SoftwareTableRow.getStatusRank(this.getStatus());
        if (n2 < (n = SoftwareTableRow.getStatusRank(softwareTableRow.getStatus()))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return TextUtil.toLowerCase((String)this.getComment()).compareTo(TextUtil.toLowerCase((String)softwareTableRow.getComment()));
    }

    public Object getRowId() {
        return this.getPartName();
    }

    public int compareToRowForColumn(SortableTableUtil.SortableRow sortableRow, int n) {
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)sortableRow;
        switch (n) {
            case 0: {
                return TextUtil.toLowerCase((String)this.getPartName()).compareTo(TextUtil.toLowerCase((String)softwareTableRow.getPartName()));
            }
            case 1: {
                return TextUtil.toLowerCase((String)this.getType()).compareTo(TextUtil.toLowerCase((String)softwareTableRow.getType()));
            }
            case 5: {
                return this.compareComment(softwareTableRow);
            }
            case 4: {
                if (this.getInstallableName() == null) {
                    if (softwareTableRow.getInstallableName() == null) {
                        return 0;
                    }
                    return 1;
                }
                if (softwareTableRow.getInstallableName() == null) {
                    return -1;
                }
                return TextUtil.toLowerCase((String)this.getInstallableName()).compareTo(TextUtil.toLowerCase((String)softwareTableRow.getInstallableName()));
            }
            case 2: {
                if (this.getCurrentPart() == null) {
                    if (softwareTableRow.getCurrentPart() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (softwareTableRow.getCurrentPart() == null) {
                    return 1;
                }
                return this.getCurrentPart().getVersion().compareTo((Object)softwareTableRow.getCurrentPart().getVersion());
            }
            case 3: {
                if (this.getInstallable() == null) {
                    if (softwareTableRow.getInstallable() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (softwareTableRow.getInstallable() == null) {
                    return 1;
                }
                return this.getInstallable().getVersion().compareTo((Object)softwareTableRow.getInstallable().getVersion());
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getAction() {
        return this.action;
    }

    public static String statusToComment(int n) {
        switch (n) {
            case 20: {
                return lex.getText("StationSoftwareView.status.notInstalled");
            }
            case 8: 
            case 16: {
                return lex.getText("StationSoftwareView.status.outOfDate");
            }
            case 2: 
            case 4: 
            case 18: {
                return lex.getText("StationSoftwareView.status.upToDate");
            }
            case 24: {
                return lex.getText("StationSoftwareView.status.badInstallable");
            }
            case 32: 
            case 34: {
                return lex.getText("StationSoftwareView.status.badTarget");
            }
            case 36: 
            case 40: {
                return lex.getText("StationSoftwareView.status.noLocal");
            }
        }
        return "";
    }

    public String getComment() {
        switch (this.getStatus()) {
            case 511: {
                return lex.getText("StationSoftwareView.status.install", new Object[]{this.installable.getVersion()});
            }
            case 767: {
                return lex.getText("StationSoftwareView.status.uninstall", new Object[]{this.currentPart.getVersion()});
            }
            case 1279: {
                return lex.getText("StationSoftwareView.status.upgrade", new Object[]{this.installable.getVersion()});
            }
            case 4351: {
                return lex.getText("StationSoftwareView.status.downgrade", new Object[]{this.installable.getVersion()});
            }
            case 2303: {
                return lex.getText("StationSoftwareView.status.reinstall", new Object[]{this.installable.getVersion()});
            }
        }
        return SoftwareTableRow.statusToComment(this.getStatus());
    }

    public BPart getCurrentPart() {
        return this.currentPart;
    }

    public BImage getPartIcon() {
        if (this.getCurrentPart() == null) {
            if (this.getInstallablePart() == null) {
                return BImage.make((BIcon)this.getInstallable().getIcon());
            }
            return BImage.make((BIcon)this.getInstallablePart().getIcon());
        }
        return BImage.make((BIcon)this.getCurrentPart().getIcon());
    }

    public BImage getFileIcon() {
        return this.installable == null ? null : BImage.make((BIcon)this.installable.getIcon());
    }

    public BVersion getCurrentVersion() {
        return this.currentPart == null ? null : this.currentPart.getVersion();
    }

    public String getInstallableName() {
        return this.installable == null ? null : this.installable.getInstallableName();
    }

    public BPart getInstallablePart() {
        return this.installable == null ? null : this.installable.getPart();
    }

    public long getInstallablePartSize() {
        if (this.installable == null) {
            return 0L;
        }
        if (this.installablePartSize == Long.MIN_VALUE) {
            this.installablePartSize = this.installable instanceof BModuleInstallable ? ((BModulePart)this.getInstallablePart()).getFilteredFileSize(this.model.getTargetPlatform().getModuleContent(), this.model.getTargetPlatform().getStripLineNumbers()) : this.installable.getInstallableFileSize();
        }
        return this.installablePartSize;
    }

    public BVersion getInstallableVersion() {
        return this.installable == null ? null : this.installable.getVersion();
    }

    public String getPartName() {
        return this.installable == null ? this.currentPart.getPartName() : this.installable.getInstallableName();
    }

    public long getSizeDeltaOnCommit() {
        if (this.action == 511) {
            return this.getInstallablePartSize();
        }
        if (this.action == 767) {
            BInstallable bInstallable = this.currentPart.getInstallable();
            if (bInstallable != null) {
                return -1L * bInstallable.getInstallableFileSize();
            }
        } else if (this.action == 1279 || this.action == 4351 || this.action == 2303) {
            if (this.currentPart.getInstallable() == null) {
                return 0L;
            }
            return this.getInstallablePartSize() - this.currentPart.getInstallable().getInstallableFileSize();
        }
        return 0L;
    }

    public int getStatus() {
        return this.installStatus | this.action;
    }

    public String getType() {
        if (this.currentPart == null) {
            if (this.installable.getPart() == null) {
                return this.installable.getDisplayName(null);
            }
            return BPart.getPartTypeShortName((Type)this.installable.getPart().getType());
        }
        return BPart.getPartTypeShortName((Type)this.currentPart.getType());
    }

    public int hashCode() {
        return this.getPartName().hashCode();
    }

    public boolean isModule() {
        BPart bPart = this.currentPart == null ? this.getInstallablePart() : this.currentPart;
        return bPart instanceof BModulePart;
    }

    public void setCurrentPart(BPart bPart) {
        this.currentPart = bPart;
        this.updateRow();
    }

    public void setInstallable(BInstallable bInstallable) {
        if (this.installable != bInstallable) {
            this.installable = bInstallable;
            this.installablePartSize = Long.MIN_VALUE;
            this.updateRow();
        }
    }

    public BInstallable getInstallable() {
        return this.installable;
    }

    public String toString() {
        return this.getPartName();
    }

    public void setForwardDeps(Array array) {
        this.forwardDeps = array;
    }

    public Array getForwardDeps() {
        return this.forwardDeps;
    }

    public Array getDependentParts() {
        Array array = new Array(class$com$tridium$install$part$BPart == null ? (class$com$tridium$install$part$BPart = SoftwareTableRow.class$("com.tridium.install.part.BPart")) : class$com$tridium$install$part$BPart);
        Iterator iterator = this.reverseDepsByName.keySet().iterator();
        while (iterator.hasNext()) {
            SoftwareTableRow softwareTableRow = this.model.getRow((String)iterator.next());
            if (softwareTableRow.getInstallablePart() == null) {
                array.add((Object)softwareTableRow.getCurrentPart());
                continue;
            }
            array.add((Object)softwareTableRow.getInstallablePart());
        }
        return array;
    }

    public Map getReverseDeps() {
        return this.reverseDepsByName;
    }

    public void addReverseDep(SoftwareTableRow softwareTableRow, BDependency bDependency) {
        this.reverseDepsByName.put(softwareTableRow.getPartName(), bDependency);
    }

    public void clearDeps() {
        this.forwardDeps.clear();
        this.reverseDepsByName.clear();
    }

    public synchronized void setAction(int n) {
        this.action = n;
    }

    public static int getStatus(BInstallable bInstallable, BPart bPart) {
        if (bPart == null) {
            if (bInstallable == null) {
                return 0;
            }
            if (bInstallable instanceof BModuleInstallable && ((BModulePart)bInstallable.getPart()).getStatus() != BModuleStatus.ok) {
                return 24;
            }
            return 20;
        }
        if (bInstallable == null) {
            if (bPart instanceof BModulePart) {
                BModuleStatus bModuleStatus = ((BModulePart)bPart).getStatus();
                if (bModuleStatus == BModuleStatus.nomanifest) {
                    return 36;
                }
                if (bModuleStatus == BModuleStatus.ok) {
                    return 40;
                }
                return 32;
            }
            return 40;
        }
        BVersion bVersion = bPart.getVersion();
        BVersion bVersion2 = bInstallable.getPart().getVersion();
        if (bInstallable instanceof BModuleInstallable && !((BModulePart)bInstallable.getPart()).getStatus().equals((Object)BModuleStatus.ok)) {
            if (bPart instanceof BModulePart && !((BModulePart)bPart).getStatus().equals((Object)BModuleStatus.ok)) {
                return 34;
            }
            return 24;
        }
        if (bPart instanceof BModulePart && !((BModulePart)bPart).getStatus().equals((Object)BModuleStatus.ok)) {
            return 32;
        }
        switch (bVersion.checkVersionRequirement(bVersion2)) {
            case 2: {
                if (bPart instanceof BModulePart) {
                    BModulePart bModulePart = (BModulePart)bPart;
                    BModulePart bModulePart2 = (BModulePart)bInstallable.getPart();
                    if (bModulePart.getBuildAbsTime() != null && bModulePart2.getBuildAbsTime() != null) {
                        int n = bModulePart2.getBuildAbsTime().compareTo((Object)bModulePart.getBuildAbsTime());
                        if (n > 0) {
                            return 8;
                        }
                        if (n < 0) {
                            return 2;
                        }
                        return 4;
                    }
                    return 4;
                }
                return 4;
            }
            case 16: {
                return 18;
            }
            case 8: {
                return 16;
            }
            case 4: {
                return 8;
            }
        }
        return 2;
    }

    public void updateRow() {
        this.installStatus = SoftwareTableRow.getStatus(this.installable, this.currentPart);
    }

    public static int getStatusRank(int n) {
        switch (n) {
            case 24: 
            case 32: 
            case 34: {
                return 0;
            }
            case 8: 
            case 16: {
                return 1;
            }
            case 20: {
                return 2;
            }
            case 2: 
            case 4: 
            case 18: {
                return 4;
            }
            case 0: 
            case 36: 
            case 40: {
                return 5;
            }
        }
        return 3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

