/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.software;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.SortableTableUtil;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.software.BSoftwareStationExt;
import com.tridium.provisioning.software.ProvisioningRegistry;
import com.tridium.provisioning.ui.software.BStationSoftwareFilter;
import com.tridium.provisioning.ui.software.SoftwareTableRow;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.util.IFilter;
import javax.baja.util.Lexicon;

public class SoftwareTableModel
extends TableModel
implements SortableTableUtil.Model {
    private long elapsed = 0L;
    private static int[] cols = new int[]{0, 1, 2, 3, 4, 5};
    private int sortColumn = 5;
    private boolean sortAscending = true;
    private boolean needsSort = true;
    private TreeMap rowsByPartName;
    protected Array rows;
    private BSoftwareStationExt stationExt;
    private BStationSoftwareFilter filter = null;
    private DaemonSessionTaskListener taskListener;
    private Lexicon lex = Lexicon.make((String)"provisioning");
    static /* synthetic */ Class class$com$tridium$provisioning$ui$software$SoftwareTableRow;
    static /* synthetic */ Class class$com$tridium$install$BDependency;
    static /* synthetic */ Class class$com$tridium$install$part$BPart;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$install$installable$BInstallable;

    public SoftwareTableModel() {
        this.rowsByPartName = new TreeMap();
        this.rows = new Array(class$com$tridium$provisioning$ui$software$SoftwareTableRow == null ? (class$com$tridium$provisioning$ui$software$SoftwareTableRow = SoftwareTableModel.class$("com.tridium.provisioning.ui.software.SoftwareTableRow")) : class$com$tridium$provisioning$ui$software$SoftwareTableRow);
    }

    public void cancelAction(String string) {
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)this.rowsByPartName.get(string);
        if (softwareTableRow != null) {
            softwareTableRow.setAction(0);
            this.updateTable(false);
        }
    }

    public void cancelAction(Array array) {
        for (int i = 0; i < array.size(); ++i) {
            this.cancelAction((String)array.get(i));
        }
        this.updateTable(false);
    }

    public int getActionAt(int n) {
        return this.getRow(n).getAction();
    }

    public int getActionFor(String string) {
        SoftwareTableRow softwareTableRow = this.getRow(string);
        if (softwareTableRow == null) {
            return 0;
        }
        return softwareTableRow.getAction();
    }

    public void setActionAt(int n, int n2) {
        this.getRow(n).setAction(n2);
        this.updateTable(false);
    }

    public synchronized void reset() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.getRow(i).setAction(0);
        }
        this.updateTable(false);
    }

    public BImage getCellIcon(int n, int n2) {
        SoftwareTableRow softwareTableRow = this.getRow(n);
        if (cols[n2] == 0) {
            return softwareTableRow.getPartIcon();
        }
        if (cols[n2] == 4) {
            return softwareTableRow.getFileIcon();
        }
        return null;
    }

    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int n) {
        switch (cols[n]) {
            case 0: {
                return this.lex.getText("StationSoftwareView.column.partName");
            }
            case 1: {
                return this.lex.getText("StationSoftwareView.column.partType");
            }
            case 2: {
                return this.lex.getText("StationSoftwareView.column.currentVersion");
            }
            case 4: {
                return this.lex.getText("StationSoftwareView.column.installableFile");
            }
            case 3: {
                return this.lex.getText("StationSoftwareView.column.availableVersion");
            }
            case 5: {
                return "";
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public BPart getCurrentPartFor(String string) {
        SoftwareTableRow softwareTableRow = this.getRow(string);
        return softwareTableRow == null ? null : softwareTableRow.getCurrentPart();
    }

    public BPart getCurrentPartAt(int n) {
        return this.getRow(n).getCurrentPart();
    }

    public BVersion getCurrentVersionAt(int n) {
        return this.getRow(n).getCurrentVersion();
    }

    public BVersion getCurrentVersionFor(String string) {
        SoftwareTableRow softwareTableRow = this.getRow(string);
        return softwareTableRow == null ? null : softwareTableRow.getCurrentVersion();
    }

    public Array getForwardDependenciesAt(int n) {
        return this.getRow(n).getForwardDeps();
    }

    public Array getForwardDependenciesFor(String string) {
        SoftwareTableRow softwareTableRow = this.getRow(string);
        return softwareTableRow == null ? new Array(class$com$tridium$install$BDependency == null ? (class$com$tridium$install$BDependency = SoftwareTableModel.class$("com.tridium.install.BDependency")) : class$com$tridium$install$BDependency) : softwareTableRow.getForwardDeps();
    }

    public BInstallable getInstallableAt(int n) {
        return this.getRow(n).getInstallable();
    }

    public BInstallable getInstallableFor(String string) {
        SoftwareTableRow softwareTableRow = this.getRow(string);
        return softwareTableRow == null ? null : softwareTableRow.getInstallable();
    }

    public BPart getInstallablePartAt(int n) {
        return this.getRow(n).getInstallablePart();
    }

    public BPart getInstallablePartFor(String string) {
        SoftwareTableRow softwareTableRow = this.getRow(string);
        return softwareTableRow == null ? null : softwareTableRow.getInstallablePart();
    }

    public BVersion getInstallableVersionAt(int n) {
        return this.getRow(n).getInstallableVersion();
    }

    public BVersion getInstallableVersionFor(String string) {
        SoftwareTableRow softwareTableRow = this.getRow(string);
        return softwareTableRow == null ? null : softwareTableRow.getInstallableVersion();
    }

    public String getNameAt(int n) {
        return this.getRow(n).getPartName();
    }

    public Array getDependentPartsFor(String string) {
        SoftwareTableRow softwareTableRow = this.getRow(string);
        if (softwareTableRow == null) {
            return new Array(class$com$tridium$install$part$BPart == null ? (class$com$tridium$install$part$BPart = SoftwareTableModel.class$("com.tridium.install.part.BPart")) : class$com$tridium$install$part$BPart);
        }
        return softwareTableRow.getDependentParts();
    }

    public Array getDependentPartsAt(int n) {
        return this.getRow(n).getDependentParts();
    }

    public SortableTableUtil.SortableRow getSortableRow(int n) {
        return this.getRow(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public BImage getRowIcon(int n) {
        return this.getCellIcon(n, 0);
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public int getStatusAt(int n) {
        return this.getRow(n).getStatus();
    }

    public int getStatusFor(String string) {
        SoftwareTableRow softwareTableRow = this.getRow(string);
        if (softwareTableRow == null) {
            return 0;
        }
        return softwareTableRow.getStatus();
    }

    public String getTypeAt(int n) {
        return this.getRow(n).getType();
    }

    public DaemonSessionTaskListener getTaskListener() {
        return this.taskListener;
    }

    public synchronized String[] getToUninstall() {
        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = SoftwareTableModel.class$("java.lang.String")) : class$java$lang$String);
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getActionAt(i) != 767) continue;
            array.add((Object)this.getNameAt(i));
        }
        return (String[])array.trim();
    }

    public synchronized BInstallable[] getToInstall() {
        Array array = new Array(class$com$tridium$install$installable$BInstallable == null ? (class$com$tridium$install$installable$BInstallable = SoftwareTableModel.class$("com.tridium.install.installable.BInstallable")) : class$com$tridium$install$installable$BInstallable);
        for (int i = 0; i < this.getRowCount(); ++i) {
            int n = this.getActionAt(i);
            if (n != 511 && n != 1279 && n != 2303 && n != 4351) continue;
            array.add((Object)this.getInstallableAt(i));
        }
        return (BInstallable[])array.trim();
    }

    public InstallScenario getScenario(DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        return InstallScenario.solve((BDaemonPlatform)this.getTargetPlatform(), (DaemonSessionTaskListener)daemonSessionTaskListener, (String[])this.getToUninstall(), null, (BInstallable[])this.getToInstall(), (InstallableRegistry)this.getInstallableRegistry());
    }

    public Object getValueAt(int n, int n2) {
        switch (cols[n2]) {
            case 0: {
                return this.getRow(n).getPartName();
            }
            case 1: {
                return this.getRow(n).getType();
            }
            case 2: {
                return SoftwareTableModel.nvl(this.getRow(n).getCurrentVersion(), "-");
            }
            case 4: {
                return SoftwareTableModel.nvl(this.getRow(n).getInstallableName(), "-");
            }
            case 3: {
                return SoftwareTableModel.nvl(this.getRow(n).getInstallableVersion(), "-");
            }
            case 5: {
                return this.getRow(n).getComment();
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public BSoftwareStationExt getStationExt() {
        return this.stationExt;
    }

    public BDaemonPlatform getTargetPlatform() {
        return this.stationExt.getPlatformSnapshot();
    }

    public ProvisioningRegistry getInstallableRegistry() {
        BProvisioningService bProvisioningService = (BProvisioningService)BOrd.make((String)"service:provisioning:ProvisioningService").get((BObject)this.stationExt);
        return bProvisioningService.getInstallableRegistry();
    }

    public void init(BSoftwareStationExt bSoftwareStationExt, DaemonSessionTaskListener daemonSessionTaskListener, boolean bl) throws AuthenticationException {
        this.taskListener = daemonSessionTaskListener;
        this.stationExt = bSoftwareStationExt;
        this.rebuild(bl);
    }

    public void install(BInstallable[] bInstallableArray) {
        for (int i = 0; i < bInstallableArray.length; ++i) {
            this.install(bInstallableArray[i]);
        }
    }

    public void install(BInstallable bInstallable) {
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)this.rowsByPartName.get(bInstallable.getPart().getPartName());
        if (softwareTableRow != null) {
            switch (softwareTableRow.getStatus()) {
                case 0: 
                case 20: 
                case 32: 
                case 36: 
                case 40: {
                    softwareTableRow.setAction(511);
                    break;
                }
                case 8: 
                case 16: {
                    softwareTableRow.setAction(1279);
                    break;
                }
                case 2: {
                    softwareTableRow.setAction(4351);
                    break;
                }
                case 4: 
                case 18: {
                    softwareTableRow.setAction(2303);
                }
            }
            this.updateTable(false);
        }
    }

    public boolean isColumnSortable(int n) {
        return true;
    }

    public boolean isModule(int n) {
        return this.getRow(n).isModule();
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void rebuild() throws AuthenticationException {
        this.rebuild(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(boolean bl) throws AuthenticationException {
        SortableTableUtil.OriginalOrderComparator originalOrderComparator = new SortableTableUtil.OriginalOrderComparator((SortableTableUtil.Model)this);
        this.rowsByPartName = new TreeMap();
        BDaemonPlatform bDaemonPlatform = this.stationExt.getPlatformSnapshot();
        DaemonSessionTask daemonSessionTask = new DaemonSessionTask(this.lex, "StationSoftwareView.rebuilding", "StationSoftwareView.rebuilding");
        try {
            Object object;
            Object object2;
            if (this.taskListener != null) {
                this.taskListener.taskStarted(daemonSessionTask);
            }
            BDaemonSessionView.log.trace("model rebuild: fetched platform " + this.getElapsed());
            this.addCurrentPart((BPart)bDaemonPlatform.getArchPart());
            this.addCurrentPart((BPart)bDaemonPlatform.getOsPart());
            this.addCurrentPart((BPart)bDaemonPlatform.getNrePart());
            this.addCurrentPart((BPart)bDaemonPlatform.getModelPart());
            this.addCurrentPart((BPart)bDaemonPlatform.getVmPart());
            this.addCurrentPart((BPart)bDaemonPlatform.getBrandPart());
            Property[] propertyArray = bDaemonPlatform.getOtherParts().getPropertiesArray();
            for (int i = 0; i < propertyArray.length; ++i) {
                this.addCurrentPart((BPart)bDaemonPlatform.getOtherParts().get(propertyArray[i]));
            }
            Object object3 = bDaemonPlatform.getModuleList().getModules().getProperties();
            while (object3.next()) {
                this.addCurrentPart((BPart)((BModuleInstallable)object3.get()).getModulePart());
            }
            BDaemonSessionView.log.trace("model rebuild: added remote modules " + this.getElapsed());
            object3 = (BProvisioningService)BOrd.make((String)"service:provisioning:ProvisioningService").get((BObject)this.stationExt);
            ProvisioningRegistry provisioningRegistry = ((BProvisioningService)((Object)object3)).getInstallableRegistry();
            try {
                object2 = provisioningRegistry.getInstallables(true, this.taskListener, null, "nre-config*.dist;backup*.dist");
                while (object2.next()) {
                    object = (BInstallable)object2.get();
                    if (object.getPart() == null || object.getUnmetPlatformDependencies(bDaemonPlatform).size() != 0) continue;
                    this.addInstallable((BInstallable)object);
                }
            }
            catch (AuthenticationException authenticationException) {
                throw authenticationException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            BDaemonSessionView.log.trace("model rebuild: added local modules " + this.getElapsed());
            object2 = this.rowsByPartName.values().iterator();
            while (object2.hasNext()) {
                object = (SoftwareTableRow)object2.next();
                TreeMap treeMap = new TreeMap();
                Array array = new Array();
                this.checkDependencies(((SoftwareTableRow)object).getPartName(), treeMap, array);
                ((SoftwareTableRow)object).setForwardDeps(new Array(treeMap.values()));
            }
            if (bl) {
                this.sortValues((Comparator)originalOrderComparator);
            }
        }
        finally {
            if (this.taskListener != null) {
                this.taskListener.taskFinished(daemonSessionTask);
            }
        }
    }

    public void reload() throws Exception {
        this.getTable().getSelection().deselectAll();
        this.rebuild();
    }

    public long getSizeDeltaOnCommit() {
        long l = 0L;
        for (int i = 0; i < this.getRowCount(); ++i) {
            l += this.getRow(i).getSizeDeltaOnCommit();
        }
        return l;
    }

    public void sortByColumn(int n, boolean bl) {
        if (!this.needsSort && n == this.sortColumn && bl == this.sortAscending) {
            return;
        }
        this.sortColumn = n;
        this.sortAscending = bl;
        this.sortValues(null);
    }

    public void setFilter(BStationSoftwareFilter bStationSoftwareFilter) {
        this.filter = bStationSoftwareFilter;
        if (this.filter != null) {
            this.sortValues(null);
        }
    }

    public BStationSoftwareFilter getFilter() {
        return this.filter;
    }

    public void uninstall(String string) {
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)this.rowsByPartName.get(string);
        if (softwareTableRow != null) {
            softwareTableRow.setAction(767);
        }
        this.updateTable(false);
    }

    public void uninstall(Array array) {
        for (int i = 0; i < array.size(); ++i) {
            this.uninstall((String)array.get(i));
        }
    }

    private void addCurrentPart(BPart bPart) {
        if (bPart == null || bPart.isNull()) {
            return;
        }
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)this.rowsByPartName.get(bPart.getPartName());
        if (softwareTableRow == null) {
            softwareTableRow = this.makeRow();
            this.rowsByPartName.put(bPart.getPartName(), softwareTableRow);
        }
        softwareTableRow.setCurrentPart(bPart);
    }

    protected SoftwareTableRow makeRow() {
        return new SoftwareTableRow(this);
    }

    private void checkDependencies(String string, Map map, Array array) {
        Object object;
        BDependency bDependency;
        if (array.contains((Object)string)) {
            return;
        }
        array.add((Object)string);
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)this.rowsByPartName.get(string);
        if (softwareTableRow == null) {
            return;
        }
        BPart bPart = softwareTableRow.getInstallablePart() == null ? softwareTableRow.getCurrentPart() : softwareTableRow.getInstallablePart();
        BDependency[] bDependencyArray = bPart.getDependencyArray();
        for (int i = 0; i < bDependencyArray.length; ++i) {
            bDependency = (BDependency)map.get(bDependencyArray[i].getPartName());
            if (bDependency == null) {
                map.put(bDependencyArray[i].getPartName(), bDependencyArray[i]);
                this.checkDependencies(bDependencyArray[i].getPartName(), map, array);
            } else if (bDependencyArray[i].supersedes(bDependency)) {
                map.put(bDependencyArray[i].getPartName(), bDependencyArray[i]);
            }
            object = (SoftwareTableRow)this.rowsByPartName.get(bDependencyArray[i].getPartName());
            if (object == null) continue;
            ((SoftwareTableRow)object).addReverseDep(softwareTableRow, bDependencyArray[i]);
        }
        BInstallable bInstallable = softwareTableRow.getInstallable();
        if (bInstallable != null) {
            bDependency = bInstallable.getDependencies().getProperties();
            while (bDependency.next(class$com$tridium$install$BDependency == null ? SoftwareTableModel.class$("com.tridium.install.BDependency") : class$com$tridium$install$BDependency)) {
                SoftwareTableRow softwareTableRow2;
                object = (BDependency)bDependency.get();
                BDependency bDependency2 = (BDependency)map.get(object.getPartName());
                if (bDependency2 == null) {
                    map.put(object.getPartName(), object);
                    this.checkDependencies(object.getPartName(), map, array);
                } else if (object.supersedes(bDependency2)) {
                    map.put(object.getPartName(), object);
                }
                if ((softwareTableRow2 = (SoftwareTableRow)this.rowsByPartName.get(object.getPartName())) == null) continue;
                softwareTableRow2.addReverseDep(softwareTableRow, (BDependency)object);
            }
        }
    }

    private void addInstallable(BInstallable bInstallable) {
        BInstallable bInstallable2;
        if (bInstallable == null) {
            return;
        }
        SoftwareTableRow softwareTableRow = (SoftwareTableRow)this.rowsByPartName.get(bInstallable.getPart().getPartName());
        if (softwareTableRow == null) {
            softwareTableRow = this.makeRow();
            this.rowsByPartName.put(bInstallable.getPart().getPartName(), softwareTableRow);
        }
        if (this.isUpgrade(bInstallable, bInstallable2 = softwareTableRow.getInstallable())) {
            softwareTableRow.setInstallable(bInstallable);
        }
    }

    private boolean isUpgrade(BInstallable bInstallable, BInstallable bInstallable2) {
        if (bInstallable == null) {
            return false;
        }
        if (bInstallable2 == null) {
            return true;
        }
        switch (bInstallable2.getVersion().checkVersionRequirement(bInstallable.getVersion())) {
            case 2: {
                if (bInstallable2 instanceof BModuleInstallable) {
                    BModulePart bModulePart = (BModulePart)bInstallable.getPart();
                    BModulePart bModulePart2 = (BModulePart)bInstallable2.getPart();
                    if (bModulePart.getBuildAbsTime() != null && bModulePart2.getBuildAbsTime() != null) {
                        int n = bModulePart.getBuildAbsTime().compareTo((Object)bModulePart2.getBuildAbsTime());
                        if (n > 0) {
                            return true;
                        }
                        if (n < 0) {
                            return false;
                        }
                    }
                }
                return false;
            }
            case 8: 
            case 16: {
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    protected SoftwareTableRow getRow(int n) {
        return (SoftwareTableRow)this.rows.get(n);
    }

    protected SoftwareTableRow getRow(String string) {
        return (SoftwareTableRow)this.rowsByPartName.get(string);
    }

    private static String nvl(Object object, String string) {
        return object == null ? string : object.toString();
    }

    protected void sortValues(Comparator comparator) {
        this.needsSort = false;
        this.rows = new Array(this.rowsByPartName.values()).sort((Comparator)new SortableTableUtil.RowComparator((SortableTableUtil.Model)this, comparator));
        if (this.filter != null && this.filter.getIsEnabled()) {
            this.rows = this.rows.filter((IFilter)this.filter);
        }
        this.getTable().getSelection().deselectAll();
        this.updateTable(true);
    }

    private String getElapsed() {
        long l = this.elapsed;
        this.elapsed = Clock.ticks();
        return l == 0L ? "" : this.elapsed - l + " ms";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

