/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.software;

import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.part.BModulePart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.softwaremanager.BPartDetailsPane;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.software.BInstallBySpecStep;
import com.tridium.provisioning.software.BSoftwareContainer;
import com.tridium.provisioning.software.BSoftwareStationExt;
import com.tridium.provisioning.software.BUninstallModuleStep;
import com.tridium.provisioning.station.BStationProxy;
import com.tridium.provisioning.ui.software.BStationSoftwareFilter;
import com.tridium.provisioning.ui.software.CancelInstallCommand;
import com.tridium.provisioning.ui.software.CancelUninstallCommand;
import com.tridium.provisioning.ui.software.InstallCommand;
import com.tridium.provisioning.ui.software.ResetCommand;
import com.tridium.provisioning.ui.software.SoftwareCellRenderer;
import com.tridium.provisioning.ui.software.SoftwareTableModel;
import com.tridium.provisioning.ui.software.UninstallCommand;
import com.tridium.provisioning.ui.software.UpgradeOutOfDateCommand;
import com.tridium.ui.theme.Theme;
import javax.baja.file.FilePath;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.IInsets;
import javax.baja.gx.Insets;
import javax.baja.naming.BOrd;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BStationSoftwareView
extends BWbComponentView {
    public static final Action handleTableModified = BStationSoftwareView.newAction((int)0, null);
    public static final Action handleSelectionModified = BStationSoftwareView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$ui$software$BStationSoftwareView == null ? (class$com$tridium$provisioning$ui$software$BStationSoftwareView = BStationSoftwareView.class$("com.tridium.provisioning.ui.software.BStationSoftwareView")) : class$com$tridium$provisioning$ui$software$BStationSoftwareView));
    private SoftwareTableModel tableModel;
    private DaemonSessionTaskListener taskListener;
    private BButton leftButton;
    private BButton rightButton;
    private BButton resetButton;
    private BButton commitButton;
    private BLabel currentSpaceLabel;
    private BLabel spaceDeltaLabel;
    private BLabel afterSpaceLabel;
    private long currentFreeSpace = 0L;
    boolean trapSelectionModified = true;
    private AsyncCommand cancelInstallCommand;
    private AsyncCommand cancelUninstallCommand;
    private AsyncCommand cancelUpgradeCommand;
    private AsyncCommand cancelReinstallCommand;
    private AsyncCommand cancelDowngradeCommand;
    private AsyncCommand commitCommand;
    private AsyncCommand installCommand;
    private AsyncCommand resetCommand;
    private AsyncCommand uninstallCommand;
    private AsyncCommand upgradeCommand;
    private AsyncCommand reinstallCommand;
    private AsyncCommand downgradeCommand;
    private AsyncCommand upgradeOODCommand;
    private BWidget loadedContent;
    private Command[] leftButtonCommands;
    private Command[] rightButtonCommands;
    static /* synthetic */ Class class$com$tridium$provisioning$ui$software$BStationSoftwareView;

    public void handleTableModified() {
        this.invoke(handleTableModified, null, null);
    }

    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BStationSoftwareView() {
        this.autoRegisterForComponentEvents = false;
        this.taskListener = new DaemonSessionTaskHandler((BWidget)this);
        BGridPane bGridPane = new BGridPane(7);
        BLabel bLabel = new BLabel(DaemonFileUtil.kbFormat.format(88888888L));
        bLabel.computePreferredSize();
        BLabel bLabel2 = new BLabel(DaemonFileUtil.kbFormat.format(88888L));
        bLabel2.computePreferredSize();
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel.getPreferredWidth() + 5), 0.0));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel2.getPreferredWidth() + 5), 0.0));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel.getPreferredWidth() + 5), 0.0));
        bGridPane.setHalign(BHalign.left);
        BButton bButton = new BButton((Command)new EditFilterCommand(), false, true);
        bGridPane.add("editFilter", (BValue)bButton);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.currentSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"StationSoftwareView.currentSpaceLabel"), (BWidget)this.currentSpaceLabel);
        this.spaceDeltaLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"StationSoftwareView.spaceDeltaLabel"), (BWidget)this.spaceDeltaLabel);
        this.afterSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"StationSoftwareView.afterSpaceLabel"), (BWidget)this.afterSpaceLabel);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setHalign(BHalign.left);
        bGridPane2.add(null, (BValue)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 4.0, 0.0));
        this.tableModel = new SoftwareTableModel();
        BTable bTable = new BTable((TableModel)this.tableModel);
        this.tableModel.setFilter(this.loadFilter());
        bTable.setCellRenderer((TableCellRenderer)new SoftwareCellRenderer());
        bTable.setController((TableController)new SoftwareTableController());
        AsyncCommand.Group group = new AsyncCommand.Group();
        this.cancelInstallCommand = CancelInstallCommand.makeCancelInstall((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.cancelInstallCommand);
        this.cancelUninstallCommand = new CancelUninstallCommand((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.cancelUninstallCommand);
        this.cancelUpgradeCommand = CancelInstallCommand.makeCancelUpgrade((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.cancelUpgradeCommand);
        this.cancelReinstallCommand = CancelInstallCommand.makeCancelReinstall((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.cancelReinstallCommand);
        this.cancelDowngradeCommand = CancelInstallCommand.makeCancelDowngrade((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.cancelDowngradeCommand);
        this.commitCommand = new CommitCommand();
        group.add((AsyncGroup.AsyncGroupMember)this.commitCommand);
        this.installCommand = InstallCommand.makeInstall((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.installCommand);
        this.resetCommand = new ResetCommand((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.resetCommand);
        this.uninstallCommand = new UninstallCommand((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.uninstallCommand);
        this.upgradeCommand = InstallCommand.makeUpgrade((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.upgradeCommand);
        this.reinstallCommand = InstallCommand.makeReinstall((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.reinstallCommand);
        this.downgradeCommand = InstallCommand.makeDowngrade((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.downgradeCommand);
        this.upgradeOODCommand = new UpgradeOutOfDateCommand((BWidget)this, this.tableModel);
        group.add((AsyncGroup.AsyncGroupMember)this.upgradeOODCommand);
        this.resetCommand.setEnabled(false);
        this.installCommand.setEnabled(false);
        this.uninstallCommand.setEnabled(false);
        this.commitCommand.setEnabled(false);
        this.upgradeOODCommand.setEnabled(false);
        this.leftButtonCommands = new Command[]{this.installCommand, this.reinstallCommand, this.upgradeCommand, this.downgradeCommand, this.cancelInstallCommand, this.cancelUpgradeCommand, this.cancelUpgradeCommand, this.cancelDowngradeCommand};
        this.rightButtonCommands = new Command[]{this.uninstallCommand, this.cancelUninstallCommand};
        this.linkTo((BComponent)bTable, (Slot)BTable.selectionModified, (Slot)handleSelectionModified);
        this.linkTo((BComponent)bTable, (Slot)BTable.tableModified, (Slot)handleTableModified);
        Insets insets = new Insets(4.0, 3.0, 4.0, 3.0);
        BFlowPane bFlowPane = new BFlowPane(BHalign.center);
        bButton = new BButton((Command)this.upgradeOODCommand, true, false);
        bFlowPane.add("upgradeOOD", (BValue)bButton);
        bButton.setPadding(BInsets.make((IInsets)insets));
        bFlowPane.add("spacer1", (BValue)new BBox(3.0, 0.0));
        this.leftButton = new BButton((Command)this.installCommand, true, false);
        bFlowPane.add("leftButton", (BValue)this.leftButton);
        this.leftButton.setPadding(BInsets.make((IInsets)insets));
        this.rightButton = new BButton((Command)this.uninstallCommand, true, false);
        bFlowPane.add("rightButton", (BValue)this.rightButton);
        this.rightButton.setPadding(BInsets.make((IInsets)insets));
        this.resetButton = new BButton((Command)this.resetCommand, true, false);
        bFlowPane.add("resetButton", (BValue)this.resetButton);
        this.resetButton.setPadding(BInsets.make((IInsets)insets));
        this.commitButton = new BButton((Command)this.commitCommand, true, false);
        bFlowPane.add("commitButton", (BValue)this.commitButton);
        this.commitButton.setPadding(BInsets.make((IInsets)insets));
        this.loadedContent = new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane2, 0.0, 0.0, 0.0, 4.0), (BWidget)new BBorderPane((BWidget)bFlowPane, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)bTable, BBorder.inset, BInsets.DEFAULT), 0.0, 4.0, 0.0, 0.0));
        this.setContent(this.loadedContent);
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BSoftwareStationExt bSoftwareStationExt = (BSoftwareStationExt)bObject;
        bSoftwareStationExt.lease();
        if (bSoftwareStationExt.getStatus().isFault()) {
            this.setContent((BWidget)new BLabel(this.getLexicon().getText("StationSoftwareView.fault", new Object[]{bSoftwareStationExt.getFaultCause()})));
            return;
        }
        BProvisioningService bProvisioningService = (BProvisioningService)BOrd.make((String)"service:provisioning:ProvisioningService").get((BObject)bSoftwareStationExt);
        bProvisioningService.lease();
        BSoftwareContainer bSoftwareContainer = bProvisioningService.getSoftware();
        bSoftwareContainer.lease();
        if (bSoftwareContainer.getLoaded()) {
            new Loader(bSoftwareStationExt).start();
        } else {
            this.setContent((BWidget)new BLabel(this.getLexicon().getText("StationSoftwareView.loading")));
            this.registerForComponentEvents(bSoftwareContainer, 1);
        }
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BSoftwareContainer && bComponentEvent.getId() == 0 && bComponentEvent.getSlot() == BSoftwareContainer.loaded) {
            new Loader((BSoftwareStationExt)this.getCurrentValue()).start();
        }
    }

    public void doHandleTableModified() {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            int n;
            if (this.tableModel.getActionAt(i) != 0) {
                bl = true;
            }
            if ((n = this.tableModel.getStatusAt(i)) == 8 || n == 16) {
                bl2 = true;
            }
            if (bl && bl2) break;
        }
        this.commitCommand.setEnabled(bl);
        this.upgradeOODCommand.setEnabled(bl2);
        long l = (int)(this.tableModel.getSizeDeltaOnCommit() / 1024L);
        this.spaceDeltaLabel.setText(DaemonFileUtil.kbFormat.format(l));
        long l2 = this.currentFreeSpace - l;
        this.afterSpaceLabel.setText(DaemonFileUtil.kbFormat.format(l2));
        this.handleSelectionModified();
    }

    public void doHandleSelectionModified() {
        boolean bl;
        if (!this.trapSelectionModified) {
            return;
        }
        this.resetCommand.setEnabled(true);
        int[] nArray = this.tableModel.getSelection().getRows();
        if (nArray.length == 0) {
            this.setLeftButtonCommand((Command)this.installCommand, false);
            this.setRightButtonCommand((Command)this.uninstallCommand, false);
            return;
        }
        if (nArray.length > 1) {
            int n = this.tableModel.getActionAt(nArray[0]);
            for (bl = true; bl < nArray.length; bl += 1) {
                if (this.tableModel.getActionAt(nArray[bl]) == n) continue;
                this.setLeftButtonCommand((Command)this.installCommand, false);
                this.setRightButtonCommand((Command)this.uninstallCommand, false);
                return;
            }
        }
        if (this.tableModel.getActionAt(nArray[0]) == 0) {
            AsyncCommand asyncCommand = null;
            bl = true;
            boolean bl2 = true;
            boolean bl3 = false;
            for (int i = 0; i < nArray.length; ++i) {
                int n = this.tableModel.getStatusAt(nArray[i]);
                if (this.tableModel.getInstallableVersionAt(nArray[i]) != null) {
                    switch (n) {
                        case 24: 
                        case 34: {
                            asyncCommand = this.installCommand;
                            bl = false;
                            break;
                        }
                        case 0: 
                        case 20: {
                            asyncCommand = this.installCommand;
                            break;
                        }
                        case 4: 
                        case 16: 
                        case 18: 
                        case 32: {
                            if (asyncCommand != null) break;
                            asyncCommand = this.reinstallCommand;
                            break;
                        }
                        case 8: {
                            if (asyncCommand != null) break;
                            asyncCommand = this.upgradeCommand;
                            break;
                        }
                        default: {
                            if (asyncCommand != null) break;
                            asyncCommand = this.downgradeCommand;
                        }
                    }
                }
                if (n == 0 || n == 20) {
                    bl2 = false;
                    continue;
                }
                if (!bl2) continue;
                bl3 = true;
                if (this.tableModel.isModule(nArray[i])) {
                    BModulePart bModulePart = (BModulePart)this.tableModel.getCurrentPartAt(nArray[i]);
                    if (bModulePart != null && !bModulePart.getPartName().equals("wbapplet") && !bModulePart.getPartName().equals("build")) continue;
                    bl2 = false;
                    continue;
                }
                bl2 = false;
            }
            if (asyncCommand == null) {
                this.setLeftButtonCommand((Command)this.installCommand, false);
            } else {
                this.setLeftButtonCommand((Command)asyncCommand, bl);
            }
            this.setRightButtonCommand((Command)this.uninstallCommand, bl2 && bl3);
        } else {
            switch (this.tableModel.getActionAt(nArray[0])) {
                case 511: {
                    this.setLeftButtonCommand((Command)this.cancelInstallCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 1279: {
                    this.setLeftButtonCommand((Command)this.cancelUpgradeCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 4351: {
                    this.setLeftButtonCommand((Command)this.cancelDowngradeCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 2303: {
                    this.setLeftButtonCommand((Command)this.cancelReinstallCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 767: {
                    this.setLeftButtonCommand((Command)this.installCommand, false);
                    this.setRightButtonCommand((Command)this.cancelUninstallCommand, true);
                    return;
                }
            }
            BDaemonSessionView.log.warning("unrecognized action " + this.tableModel.getActionAt(nArray[0]));
        }
    }

    protected BStationSoftwareFilter loadFilter() {
        BStationSoftwareFilter bStationSoftwareFilter;
        try {
            BOptions bOptions = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            bStationSoftwareFilter = (BStationSoftwareFilter)bOptions.get("filter");
            if (bStationSoftwareFilter == null) {
                bStationSoftwareFilter = new BStationSoftwareFilter();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bStationSoftwareFilter = new BStationSoftwareFilter();
        }
        return bStationSoftwareFilter;
    }

    protected void saveFilter(BStationSoftwareFilter bStationSoftwareFilter) {
        try {
            BOptions bOptions = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            if (bOptions.get("filter") == null) {
                bOptions.add("filter", bStationSoftwareFilter.newCopy());
            } else {
                bOptions.set("filter", bStationSoftwareFilter.newCopy());
            }
            bOptions.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setLeftButtonCommand(Command command, boolean bl) {
        for (int i = 0; i < this.leftButtonCommands.length; ++i) {
            this.leftButtonCommands[i].setEnabled(this.leftButtonCommands[i] == command ? bl : false);
        }
        if (command != this.leftButton.getCommand()) {
            this.leftButton.setCommand(command, true, false);
            this.leftButton.relayout();
            this.relayout();
        }
    }

    private void setRightButtonCommand(Command command, boolean bl) {
        for (int i = 0; i < this.rightButtonCommands.length; ++i) {
            this.rightButtonCommands[i].setEnabled(this.rightButtonCommands[i] == command ? bl : false);
        }
        if (command != this.rightButton.getCommand()) {
            this.rightButton.setCommand(command, true, false);
            this.rightButton.relayout();
            this.relayout();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EditFilterCommand
    extends Command {
        public EditFilterCommand() {
            super((BWidget)BStationSoftwareView.this, TYPE.getModule(), "StationSoftwareView.command.editFilter");
        }

        public CommandArtifact doInvoke() {
            try {
                BStationSoftwareFilter bStationSoftwareFilter = BStationSoftwareFilter.getFilter((BWidget)BStationSoftwareView.this, BStationSoftwareView.this.tableModel.getFilter());
                if (bStationSoftwareFilter != null) {
                    BStationSoftwareView.this.tableModel.setFilter(bStationSoftwareFilter);
                    BStationSoftwareView.this.saveFilter(bStationSoftwareFilter);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class CommitCommand
    extends AsyncCommand {
        public CommitCommand() {
            super((BWidget)BStationSoftwareView.this, TYPE.getModule(), "StationSoftwareView.command.installNow");
        }

        public void doInvokeAsync() {
            try {
                BSoftwareStationExt bSoftwareStationExt = (BSoftwareStationExt)BStationSoftwareView.this.getCurrentValue();
                BProvisioningJob bProvisioningJob = new BProvisioningJob(bSoftwareStationExt.getNiagaraStation().getStationName());
                BInstallable[] bInstallableArray = BStationSoftwareView.this.tableModel.getToInstall();
                for (int i = 0; i < bInstallableArray.length; ++i) {
                    bProvisioningJob.addStep(new BInstallBySpecStep(BInstallableSpec.make((BInstallable)bInstallableArray[i])));
                }
                String[] stringArray = BStationSoftwareView.this.tableModel.getToUninstall();
                for (int i = 0; i < stringArray.length; ++i) {
                    bProvisioningJob.addStep(new BUninstallModuleStep(stringArray[i]));
                }
                BProvisioningService bProvisioningService = (BProvisioningService)BOrd.make((String)"service:provisioning:ProvisioningService").get(BStationSoftwareView.this.getCurrentValue());
                BComponentSpace bComponentSpace = (BComponentSpace)bProvisioningService.getSpace();
                BOrd bOrd = bProvisioningService.submitJob(bProvisioningJob, null);
                bComponentSpace.sync();
                bProvisioningJob = (BProvisioningJob)bOrd.get((BObject)bComponentSpace);
                BWbShell bWbShell = BWbShell.getWbShell((BWidget)BStationSoftwareView.this);
                if (bWbShell != null) {
                    bWbShell.hyperlink(bProvisioningJob.getNavOrd());
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    private class DetailCommand
    extends Command {
        private int row;

        public DetailCommand(int n) {
            super((BWidget)BStationSoftwareView.this, TYPE.getModule(), "StationSoftwareView.command.details");
            this.row = n;
        }

        public CommandArtifact doInvoke() {
            try {
                BPartDetailsPane bPartDetailsPane = new BPartDetailsPane();
                bPartDetailsPane.loadValue(BStationSoftwareView.this.tableModel.getCurrentPartAt(this.row), BStationSoftwareView.this.tableModel.getInstallablePartAt(this.row), BStationSoftwareView.this.tableModel.getTypeAt(this.row), BStationSoftwareView.this.tableModel.getForwardDependenciesAt(this.row), BStationSoftwareView.this.tableModel.getDependentPartsAt(this.row));
                BBrush bBrush = Theme.scrollPane().getControlBackground();
                BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bPartDetailsPane, 10.0, 10.0, 5.0, 10.0));
                bScrollPane.setViewportBackground(bBrush);
                bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
                bConstrainedPane.setFixedSize(500.0, 350.0);
                BDialog.message((BWidget)BStationSoftwareView.this, (String)BStationSoftwareView.this.getLexicon().getText("StationSoftwareView.command.details.dlgTitle"), (Object)bConstrainedPane);
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class SoftwareTableController
    extends TableController {
        private SoftwareTableController() {
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            if (bMouseEvent.isPopupTrigger()) {
                super.cellPressed(bMouseEvent, n, n2);
                return;
            }
            if (n2 != 0 || bMouseEvent.getX() > 14.0) {
                if (bMouseEvent.getClickCount() > 1) {
                    new DetailCommand(n).invoke();
                } else {
                    super.cellPressed(bMouseEvent, n, n2);
                }
                return;
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (BValue)new BActionMenuItem((Command)new DetailCommand(n)), null);
            bMenu.add(null, (BValue)new BActionMenuItem(BStationSoftwareView.this.leftButton.getCommand()), null);
            bMenu.add(null, (BValue)new BActionMenuItem(BStationSoftwareView.this.rightButton.getCommand()), null);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BStationSoftwareView.this.upgradeOODCommand), null);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BStationSoftwareView.this.commitCommand), null);
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BStationSoftwareView.this.resetCommand), null);
            bMenu.open((BWidget)BStationSoftwareView.this.tableModel.getTable(), bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    private class Loader
    extends Thread {
        private BSoftwareStationExt stationExt;

        public Loader(BSoftwareStationExt bSoftwareStationExt) {
            this.stationExt = bSoftwareStationExt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.stationExt.getNiagaraStation().lease();
                BStationProxy bStationProxy = (BStationProxy)this.stationExt.getNiagaraStation().getMixIn(BStationProxy.TYPE);
                DaemonSessionTask daemonSessionTask = new DaemonSessionTask(BStationSoftwareView.this.getLexicon(), "StationSoftwareView.loading.title", "StationSoftwareView.freeSpace.message");
                BStationSoftwareView.this.taskListener.taskStarted(daemonSessionTask);
                try {
                    BStationSoftwareView.this.currentFreeSpace = bStationProxy.getFilesystemAttributes(new FilePath("!")).getFreeSpace();
                    BStationSoftwareView.this.currentSpaceLabel.setText(DaemonFileUtil.kbFormat.format(BStationSoftwareView.this.currentFreeSpace));
                    BStationSoftwareView.this.spaceDeltaLabel.setText(DaemonFileUtil.kbFormat.format(0L));
                    BStationSoftwareView.this.afterSpaceLabel.setText(DaemonFileUtil.kbFormat.format(BStationSoftwareView.this.currentFreeSpace));
                    if (BStationSoftwareView.this.loadedContent.getParent() == null) {
                        BStationSoftwareView.this.setContent(BStationSoftwareView.this.loadedContent);
                    }
                    BStationSoftwareView.this.registerForComponentEvents((BComponent)this.stationExt, Integer.MAX_VALUE);
                    daemonSessionTask.setMessage(BStationSoftwareView.this.getLexicon().getText("StationSoftwareView.updateSnapshot.message"));
                    BStationSoftwareView.this.taskListener.taskUpdated(daemonSessionTask);
                    BComponentSpace bComponentSpace = (BComponentSpace)this.stationExt.getSpace();
                    this.stationExt.takeSnapshotSync();
                    bComponentSpace.sync();
                }
                finally {
                    BStationSoftwareView.this.taskListener.taskFinished(daemonSessionTask);
                }
                BStationSoftwareView.this.tableModel.init(this.stationExt, BStationSoftwareView.this.taskListener, true);
                BStationSoftwareView.this.registerForComponentEvents((BComponent)bStationProxy, Integer.MAX_VALUE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

