/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.job;

import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.BProvisioningStationExt;
import com.tridium.provisioning.software.BSoftwareStationExt;
import com.tridium.provisioning.ui.job.BProvisioningJobBuilder;
import com.tridium.ui.theme.Theme;
import java.util.HashMap;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.space.BSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

public class BStationList
extends BList
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$ui$job$BStationList == null ? (class$com$tridium$provisioning$ui$job$BStationList = BStationList.class$("com.tridium.provisioning.ui.job.BStationList")) : class$com$tridium$provisioning$ui$job$BStationList));
    private BObject target = null;
    private BProvisioningJobBuilder builder;
    private BWidget container;
    private Model model;
    private AddStation addStation;
    private MoveStationUp moveStationUp;
    private MoveStationDown moveStationDown;
    private RemoveStation removeStation;
    private PasteFromClipboard pasteFromClipboard;
    public static final Lexicon lex = Lexicon.make((String)"provisioning");
    static /* synthetic */ Class class$com$tridium$provisioning$ui$job$BStationList;
    static /* synthetic */ Class class$com$tridium$nd$BNiagaraStation;

    public Type getType() {
        return TYPE;
    }

    public BStationList(BProvisioningJobBuilder bProvisioningJobBuilder) {
        this.builder = bProvisioningJobBuilder;
        CommandBindings commandBindings = new CommandBindings();
        commandBindings.setSupport((CommandBindings.Support)this);
        this.addStation = new AddStation();
        commandBindings.addCommand((Command)this.addStation, BCommandEnablePolicy.always);
        this.pasteFromClipboard = new PasteFromClipboard();
        commandBindings.addCommand((Command)this.pasteFromClipboard, BCommandEnablePolicy.always);
        this.moveStationUp = new MoveStationUp();
        commandBindings.addCommand((Command)this.moveStationUp, BCommandEnablePolicy.singleSelection);
        this.moveStationDown = new MoveStationDown();
        commandBindings.addCommand((Command)this.moveStationDown, BCommandEnablePolicy.singleSelection);
        this.removeStation = new RemoveStation();
        commandBindings.addCommand((Command)this.removeStation, BCommandEnablePolicy.anySelection);
        this.setController((ListController)new Controller(commandBindings));
        this.setSelection((ListSelection)new CommandBindings.ListSelection(commandBindings));
        this.model = new Model();
        this.setModel(this.model);
        BBorderPane bBorderPane = new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BButtonPane(BButtonStyle.toolBar, new Command[]{this.addStation, this.moveStationUp, this.moveStationDown, this.removeStation}, false, true), null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this, BBorder.inset, BInsets.DEFAULT), 4.0, 0.0, 4.0, 0.0)));
        bBorderPane.setBorder(BBorder.solid);
        bBorderPane.setLabel((BWidget)new BLabel(lex.getText("ProvisioningJobBuilder.stationList.header")));
        bBorderPane.setPadding(BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0));
        this.container = bBorderPane;
    }

    public BWidget getContainer() {
        return this.container;
    }

    public void setTarget(BObject bObject) {
        this.target = bObject;
    }

    public BObject getTarget() {
        return this.target;
    }

    public String[] getStationNames() {
        String[] stringArray = new String[this.model.getItemCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.model.getStation(i).getStationName();
        }
        return stringArray;
    }

    public int dragOver(TransferContext transferContext) {
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            for (int i = 0; i < bObjectArray.length; ++i) {
                if (!(bObjectArray[i] instanceof BNiagaraStation)) continue;
                return 16;
            }
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            int n = this.getItemIndexAt(transferContext.getX(), transferContext.getY());
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            for (int i = 0; i < bObjectArray.length; ++i) {
                if (!(bObjectArray[i] instanceof BNiagaraStation)) continue;
                if (n < 0) {
                    this.model.addItem(null, bObjectArray[i]);
                    continue;
                }
                this.model.insertItem(n, null, bObjectArray[i]);
            }
        }
        return null;
    }

    public void addStations(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addStation(stringArray[i]);
        }
    }

    public void addStation(String string) {
        BSpace bSpace = BOrd.toSpace((BObject)this.getTarget());
        BIDataTable bIDataTable = (BIDataTable)BOrd.make((String)("bql: select slotPath from niagaraDriver:NiagaraStation where name = '" + string + "'")).get((BObject)bSpace);
        TableCursor tableCursor = (TableCursor)bIDataTable.cursor();
        Column column = bIDataTable.getColumns().get(0);
        if (tableCursor.next()) {
            this.addStation((BNiagaraStation)BOrd.make((String)tableCursor.getString(column)).get((BObject)bSpace));
        }
    }

    public void addStations(BNiagaraStation[] bNiagaraStationArray) {
        for (int i = 0; i < bNiagaraStationArray.length; ++i) {
            this.addStation(bNiagaraStationArray[i]);
        }
    }

    public void addStation(BNiagaraStation bNiagaraStation) {
        bNiagaraStation.lease(4);
        boolean bl = false;
        Type[] typeArray = BProvisioningStationExt.getStationExtTypes();
        for (int i = 0; i < typeArray.length; ++i) {
            BProvisioningStationExt bProvisioningStationExt = (BProvisioningStationExt)bNiagaraStation.getMixIn(typeArray[i]);
            if (bProvisioningStationExt == null || !bProvisioningStationExt.getEnabled()) continue;
            this.model.addItem(null, bNiagaraStation);
            return;
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (command instanceof StationListCommand) {
            ((StationListCommand)command).checkEnabled(bl);
        } else {
            command.setEnabled(bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Controller
    extends CommandBindings.ListController {
        public Controller(CommandBindings commandBindings) {
            super(commandBindings);
        }

        public void focusGained(BFocusEvent bFocusEvent) {
            BStationList.this.builder.transferWidgetFocusGained((BTransferWidget)this.getList());
        }
    }

    private class Model
    extends ListModel {
        private Array stations = new Array(class$com$tridium$nd$BNiagaraStation == null ? (class$com$tridium$nd$BNiagaraStation = BStationList.class$("com.tridium.nd.BNiagaraStation")) : class$com$tridium$nd$BNiagaraStation);
        private HashMap stationByName = new HashMap();

        private Model() {
        }

        public BNiagaraStation[] getAvailableStations(BObject bObject) {
            Array array = new Array(class$com$tridium$nd$BNiagaraStation == null ? (class$com$tridium$nd$BNiagaraStation = BStationList.class$("com.tridium.nd.BNiagaraStation")) : class$com$tridium$nd$BNiagaraStation);
            try {
                BSpace bSpace = BOrd.toSpace((BObject)bObject);
                BIDataTable bIDataTable = (BIDataTable)BOrd.make((String)"bql:select slotPath from provisioning:SoftwareStationExt").get((BObject)bSpace);
                Column column = bIDataTable.getColumns().get(0);
                TableCursor tableCursor = (TableCursor)bIDataTable.cursor();
                while (tableCursor.next()) {
                    BNiagaraStation bNiagaraStation;
                    BSoftwareStationExt bSoftwareStationExt = (BSoftwareStationExt)BOrd.make((String)tableCursor.getString(column)).get((BObject)bSpace);
                    bSoftwareStationExt.lease(1);
                    if (!bSoftwareStationExt.getEnabled() || this.stationByName.containsKey((bNiagaraStation = (BNiagaraStation)bSoftwareStationExt.getParent()).getName())) continue;
                    array.add((Object)bNiagaraStation);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return (BNiagaraStation[])array.trim();
        }

        public synchronized void swapItems(int n, int n2) {
            this.stations.swap(n, n2);
            this.updateList();
        }

        public synchronized void addItem(BImage bImage, Object object) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)object;
            if (!this.stationByName.containsKey(bNiagaraStation.getStationName())) {
                this.stationByName.put(bNiagaraStation.getStationName(), bNiagaraStation);
                this.stations.add((Object)bNiagaraStation);
                this.updateList();
            }
        }

        public synchronized void insertItem(int n, BImage bImage, Object object) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)object;
            if (!this.stationByName.containsKey(bNiagaraStation.getStationName())) {
                this.stations.add(n, (Object)bNiagaraStation);
                this.stationByName.put(bNiagaraStation.getStationName(), bNiagaraStation);
                this.updateList();
            }
        }

        public synchronized void removeItem(Object object) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)object;
            this.stations.remove((Object)bNiagaraStation);
            this.stationByName.remove(bNiagaraStation.getStationName());
            this.updateList();
        }

        public void removeItem(int n) {
            this.removeItem(this.getStation(n));
        }

        public synchronized void removeAllItems() {
            this.stationByName.clear();
            this.stations.clear();
            this.updateList();
        }

        public int getItemCount() {
            return this.stations.size();
        }

        public BImage getItemIcon(int n) {
            return BImage.make((BIcon)this.getStation(n).getIcon());
        }

        public Object getItem(int n) {
            return this.getStation(n).getStationName();
        }

        public BNiagaraStation getStation(int n) {
            return (BNiagaraStation)this.stations.get(n);
        }

        public void updateList() {
            super.updateList();
            BStationList.this.builder.listUpdated(this.getList());
        }
    }

    private class PasteFromClipboard
    extends Command {
        public PasteFromClipboard() {
            super((BWidget)BStationList.this, (Lexicon)UiLexicon.bajaui, "commands.paste");
        }

        public synchronized boolean isEnabled() {
            TransferEnvelope transferEnvelope = Clipboard.getDefault().getContents();
            if (transferEnvelope != null && transferEnvelope.supports(TransferFormat.mark)) {
                Mark mark = (Mark)transferEnvelope.getData(TransferFormat.mark);
                BObject[] bObjectArray = mark.getValues();
                for (int i = 0; i < bObjectArray.length; ++i) {
                    if (!(bObjectArray[i] instanceof BNiagaraStation)) continue;
                    return true;
                }
            }
            return false;
        }

        public CommandArtifact doInvoke() {
            TransferEnvelope transferEnvelope = Clipboard.getDefault().getContents();
            if (transferEnvelope != null && transferEnvelope.supports(TransferFormat.mark)) {
                Mark mark = (Mark)transferEnvelope.getData(TransferFormat.mark);
                BObject[] bObjectArray = mark.getValues();
                for (int i = 0; i < bObjectArray.length; ++i) {
                    if (!(bObjectArray[i] instanceof BNiagaraStation)) continue;
                    BStationList.this.model.addItem(null, bObjectArray[i]);
                }
            }
            return null;
        }
    }

    private class RemoveStation
    extends StationListCommand {
        public RemoveStation() {
            super("ProvisioningJobBuilder.stationList.remove");
        }

        public CommandArtifact doInvoke() {
            int[] nArray = BStationList.this.model.getSelection().getItems();
            for (int i = nArray.length; i > 0; --i) {
                BStationList.this.model.removeItem(nArray[i - 1]);
            }
            return null;
        }
    }

    private class MoveStationDown
    extends StationListCommand {
        public MoveStationDown() {
            super("ProvisioningJobBuilder.stationList.moveDown");
        }

        public CommandArtifact doInvoke() {
            int n = BStationList.this.model.getSelection().getItems()[0];
            BStationList.this.model.swapItems(n, n + 1);
            BStationList.this.model.getSelection().select(n + 1, true);
            return null;
        }

        public void checkEnabled(boolean bl) {
            if (bl) {
                int n = BStationList.this.model.getSelection().getItems()[0];
                if (n == BStationList.this.model.getModel().getItemCount() - 1) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(bl);
                }
            } else {
                this.setEnabled(bl);
            }
        }
    }

    private class MoveStationUp
    extends StationListCommand {
        public MoveStationUp() {
            super("ProvisioningJobBuilder.stationList.moveUp");
        }

        public CommandArtifact doInvoke() {
            int n = BStationList.this.model.getSelection().getItems()[0];
            BStationList.this.model.swapItems(n, n - 1);
            BStationList.this.model.getSelection().select(n - 1, true);
            return null;
        }

        public void checkEnabled(boolean bl) {
            if (bl) {
                int n = BStationList.this.model.getSelection().getItems()[0];
                if (n == 0) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(bl);
                }
            } else {
                this.setEnabled(bl);
            }
        }
    }

    private static class StationItem {
        private BNiagaraStation station;

        public StationItem(BNiagaraStation bNiagaraStation) {
            this.station = bNiagaraStation;
        }

        public BNiagaraStation getStation() {
            return this.station;
        }

        public String toString() {
            return this.station.getStationName();
        }
    }

    private class CheckAllCommand
    extends DialogCommand {
        private BCheckList checkList;

        public CheckAllCommand(BCheckList bCheckList) {
            super((BWidget)BStationList.this, -1, lex, "ProvisioningJobBuilder.stationList.add.checkAll");
            this.checkList = bCheckList;
        }

        public CommandArtifact doInvoke() {
            try {
                this.checkList.getSelection().selectAll();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class AddStation
    extends StationListCommand {
        public AddStation() {
            super("ProvisioningJobBuilder.stationList.add");
        }

        public CommandArtifact doInvoke() {
            try {
                DefaultListModel defaultListModel = new DefaultListModel();
                BProvisioningService bProvisioningService = (BProvisioningService)BStationList.this.getTarget();
                bProvisioningService.lease();
                BNiagaraStation[] bNiagaraStationArray = BStationList.this.model.getAvailableStations((BObject)bProvisioningService);
                if (bNiagaraStationArray.length == 0) {
                    if (BStationList.this.model.getItemCount() > 0) {
                        BDialog.message((BWidget)BStationList.this, (String)lex.getText("ProvisioningJobBuilder.stationList.add.noMoreStations.dlgTitle"), (Object)lex.getText("ProvisioningJobBuilder.stationList.add.noMoreStations.dlgMessage"));
                    } else {
                        BDialog.message((BWidget)BStationList.this, (String)lex.getText("ProvisioningJobBuilder.stationList.add.noStations.dlgTitle"), (Object)lex.getText("ProvisioningJobBuilder.stationList.add.noStations.dlgMessage"));
                    }
                    return null;
                }
                for (int i = 0; i < bNiagaraStationArray.length; ++i) {
                    defaultListModel.addItem(BImage.make((BIcon)bNiagaraStationArray[i].getIcon()), (Object)new StationItem(bNiagaraStationArray[i]));
                }
                BCheckList bCheckList = new BCheckList();
                bCheckList.setModel((ListModel)defaultListModel);
                if (bNiagaraStationArray.length == 1) {
                    bCheckList.getSelection().select(0, true);
                }
                BBrush bBrush = Theme.scrollPane().getControlBackground();
                BScrollPane bScrollPane = new BScrollPane((BWidget)bCheckList);
                bScrollPane.setViewportBackground(bBrush);
                bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BFlowPane bFlowPane = new BFlowPane(BHalign.left);
                bFlowPane.add("label", (BValue)new BLabel(lex.getText("ProvisioningJobBuilder.stationList.add.dlgMessage")));
                if (1 == BCommandDialog.open((BWidget)BStationList.this, (String)lex.getText("ProvisioningJobBuilder.stationList.add.dlgTitle"), (Object)new BBorderPane((BWidget)new BEdgePane((BWidget)bFlowPane, (BWidget)new BBox(250.0, 0.0), (BWidget)new BBox(0.0, 300.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT), 10.0, 0.0, 4.0, 0.0)), 4.0, 10.0, 4.0, 10.0), (DialogCommand[])new DialogCommand[]{new CheckAllCommand(bCheckList), DialogCommand.makeOk((BWidget)BStationList.this), DialogCommand.makeCancel((BWidget)BStationList.this)})) {
                    int[] nArray = bCheckList.getSelection().getItems();
                    for (int i = 0; i < nArray.length; ++i) {
                        BStationList.this.model.addItem(null, ((StationItem)bCheckList.getModel().getItem(nArray[i])).getStation());
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private abstract class StationListCommand
    extends Command {
        public StationListCommand(String string) {
            super((BWidget)BStationList.this, lex, string);
        }

        public void checkEnabled(boolean bl) {
            this.setEnabled(bl);
        }
    }
}

