/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.job;

import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.job.BJobLogFile;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BStationStepLogFile;
import com.tridium.provisioning.job.BStationStepRecord;
import com.tridium.provisioning.ui.job.JobTable;
import java.util.HashSet;
import java.util.Set;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

public class BProvisioningJobView
extends BWbComponentView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$ui$job$BProvisioningJobView == null ? (class$com$tridium$provisioning$ui$job$BProvisioningJobView = BProvisioningJobView.class$("com.tridium.provisioning.ui.job.BProvisioningJobView")) : class$com$tridium$provisioning$ui$job$BProvisioningJobView));
    private BLabel userLabel;
    private BLabel startedLabel;
    private BLabel endedLabel;
    private BLabel stateLabel;
    private Model model;
    private BProvisioningJob job = null;
    private ViewLogCommand viewLogCommand;
    private JobListCommand jobListCommand;
    private CancelJobCommand cancelJobCommand;
    private CancelStationCommand cancelStationCommand;
    private DisposeCommand disposeCommand;
    private OpenCommand openCommand;
    public static final int COL_STATION = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_START = 2;
    public static final int COL_END = 3;
    public static final int COL_BUTTONS = 4;
    static /* synthetic */ Class class$com$tridium$provisioning$ui$job$BProvisioningJobView;
    static /* synthetic */ Class class$com$tridium$provisioning$job$BStationStepRecord;

    public Type getType() {
        return TYPE;
    }

    public BProvisioningJobView() {
        this.autoRegisterForComponentEvents = false;
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setHalign(BHalign.left);
        this.userLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"ProvisioningJobView.user"), (BWidget)this.userLabel);
        this.startedLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"ProvisioningJobView.started"), (BWidget)this.startedLabel);
        this.endedLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"ProvisioningJobView.ended"), (BWidget)this.endedLabel);
        this.stateLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"ProvisioningJobView.state"), (BWidget)this.stateLabel);
        CommandBindings commandBindings = new CommandBindings();
        this.openCommand = new OpenCommand();
        commandBindings.addCommand((Command)this.openCommand, BCommandEnablePolicy.singleSelection);
        this.cancelStationCommand = new CancelStationCommand();
        commandBindings.addCommand((Command)this.cancelStationCommand, BCommandEnablePolicy.singleSelection);
        commandBindings.setSupport((CommandBindings.Support)this);
        this.model = new Model();
        BCommandBoundTable bCommandBoundTable = JobTable.makeListTable(this.model, commandBindings, 4, this.openCommand, null);
        BButtonPane bButtonPane = new BButtonPane();
        this.viewLogCommand = new ViewLogCommand();
        bButtonPane.add((Command)this.viewLogCommand);
        this.jobListCommand = new JobListCommand();
        bButtonPane.add((Command)this.jobListCommand);
        this.cancelJobCommand = new CancelJobCommand();
        bButtonPane.add((Command)this.cancelJobCommand);
        bButtonPane.add((Command)this.cancelStationCommand);
        this.disposeCommand = new DisposeCommand();
        bButtonPane.add((Command)this.disposeCommand);
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBorderPane((BWidget)bButtonPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)bCommandBoundTable), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        if (bObject instanceof BProvisioningJob) {
            this.job = (BProvisioningJob)bObject;
            this.job.lease(Integer.MAX_VALUE);
        } else {
            this.job = ((BJobLogFile)bObject).getJob();
        }
        this.userLabel.setText(this.job.getSubmitUser());
        this.startedLabel.setText(this.job.getStartTime().toString());
        this.endedLabel.setText(this.job.getEndTime().toString());
        this.stateLabel.setText(this.job.getJobState().toString());
        this.model.load(this.job);
        this.cancelJobCommand.checkEnabled();
        this.disposeCommand.checkEnabled();
        if (bObject instanceof BProvisioningJob) {
            this.registerForComponentEvents((BComponent)this.job, Integer.MAX_VALUE);
        }
    }

    public BProvisioningJob getProvisioningJob() throws Exception {
        BObject bObject = this.getCurrentValue();
        if (bObject instanceof BProvisioningJob) {
            return (BProvisioningJob)bObject;
        }
        return ((BJobLogFile)bObject).getJob();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BProvisioningJob && bComponentEvent.getSlot().isProperty()) {
            Property property = (Property)bComponentEvent.getSlot();
            String string = bComponentEvent.getValue().toString();
            if (property == BProvisioningJob.submitUser) {
                this.userLabel.setText(string);
            } else if (property == BProvisioningJob.startTime) {
                this.startedLabel.setText(string);
            } else if (property == BProvisioningJob.endTime) {
                this.endedLabel.setText(string);
            } else if (property == BProvisioningJob.jobState) {
                this.stateLabel.setText(string);
                this.cancelJobCommand.checkEnabled();
                this.disposeCommand.checkEnabled();
            }
        } else if (bComponentEvent.getSourceComponent() instanceof BStationStepRecord) {
            this.model.updateRecord((BStationStepRecord)bComponentEvent.getSourceComponent());
        } else if (bComponentEvent.getId() == 1 && bComponentEvent.getValue() instanceof BStationStepRecord) {
            this.model.updateRecord((BStationStepRecord)bComponentEvent.getValue());
            this.registerForComponentEvents((BStationStepRecord)bComponentEvent.getValue(), Integer.MAX_VALUE);
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        BStationStepRecord bStationStepRecord;
        BJobState bJobState;
        if (command == this.cancelStationCommand && bl && ((bJobState = this.job.getStationState((bStationStepRecord = this.model.record(this.model.getTable().getSelection().getRow())).getStationName())).isComplete() || bJobState == BJobState.canceling)) {
            command.setEnabled(false);
            return;
        }
        command.setEnabled(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DisposeCommand
    extends Command {
        public DisposeCommand() {
            super((BWidget)BProvisioningJobView.this, BProvisioningJobView.this.getLexicon(), "ProvisioningJobView.disposeCommand");
            this.setEnabled(false);
        }

        public void checkEnabled() {
            this.setEnabled(!(BProvisioningJobView.this.getCurrentValue() instanceof BProvisioningJob) || ((BProvisioningJob)BProvisioningJobView.this.getCurrentValue()).getJobState().isComplete());
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BProvisioningJobView.this.model.getTable(), (String)BProvisioningJobView.this.getLexicon().getText("ProvisioningJobView.disposeCommand.dlgTitle"), (Object)BProvisioningJobView.this.getLexicon().getText("ProvisioningJobView.disposeCommand.dlgMessage"))) {
                    BProvisioningService bProvisioningService = (BProvisioningService)BOrd.make((String)"service:provisioning:ProvisioningService").get(BProvisioningJobView.this.getCurrentValue());
                    BOrd bOrd = BOrd.make((BOrd)bProvisioningService.getAbsoluteOrd(), (String)"view:provisioning:ProvisioningJobList");
                    BProvisioningJobView.this.getWbShell().hyperlink(bOrd);
                    bProvisioningService.disposeJob(BProvisioningJobView.this.job.getStartTime());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class CancelStationCommand
    extends Command {
        public CancelStationCommand() {
            super((BWidget)BProvisioningJobView.this, BProvisioningJobView.this.getLexicon(), "ProvisioningJobView.cancelStationCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BProvisioningJobView.this.model.record(BProvisioningJobView.this.model.getSelection().getRow()).cancel();
                BProvisioningJobView.this.model.getSelection().deselectAll();
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class CancelJobCommand
    extends Command {
        public CancelJobCommand() {
            super((BWidget)BProvisioningJobView.this, BProvisioningJobView.this.getLexicon(), "ProvisioningJobView.cancelJobCommand");
            this.setEnabled(false);
        }

        public void checkEnabled() {
            try {
                this.setEnabled(BProvisioningJobView.this.getProvisioningJob().getJobState() == BJobState.running);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public CommandArtifact doInvoke() {
            try {
                BProvisioningJobView.this.job.cancel();
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class JobListCommand
    extends Command {
        public JobListCommand() {
            super((BWidget)BProvisioningJobView.this, BProvisioningJobView.this.getLexicon(), "ProvisioningJobView.jobListCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd bOrd = BOrd.make((BOrd)BOrd.toSpace((BObject)BProvisioningJobView.this.getCurrentValue()).getAbsoluteOrd(), (String)"service:provisioning:ProvisioningService|view:provisioning:ProvisioningJobList");
                BProvisioningJobView.this.getWbShell().hyperlink(bOrd);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class ViewLogCommand
    extends Command {
        public ViewLogCommand() {
            super((BWidget)BProvisioningJobView.this, BProvisioningJobView.this.getLexicon(), "ProvisioningJobView.viewLogCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                JobTable.showLogDialog((BWidget)BProvisioningJobView.this.model.getTable(), BProvisioningJobView.this.job);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class OpenCommand
    extends Command {
        public OpenCommand() {
            super((BWidget)BProvisioningJobView.this, BProvisioningJobView.this.getLexicon(), "ProvisioningJobView.openCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BStationStepRecord bStationStepRecord = BProvisioningJobView.this.model.record(BProvisioningJobView.this.model.getTable().getSelection().getRow());
                if (bStationStepRecord.getState().isComplete()) {
                    BStationStepLogFile bStationStepLogFile = BStationStepLogFile.find(bStationStepRecord, BProvisioningJobView.this.getCurrentValue());
                    BOrd bOrd = BOrd.make((BOrd)((BINavNode)BProvisioningJobView.this.getCurrentValue()).getNavOrd(), (BOrd)bStationStepLogFile.getOrdInSession());
                    BProvisioningJobView.this.getWbShell().hyperlink(bOrd);
                } else {
                    BProvisioningJobView.this.getWbShell().hyperlink(bStationStepRecord.getNavOrd());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class Model
    extends TableModel {
        private Array rows = new Array(class$com$tridium$provisioning$job$BStationStepRecord == null ? (class$com$tridium$provisioning$job$BStationStepRecord = BProvisioningJobView.class$("com.tridium.provisioning.job.BStationStepRecord")) : class$com$tridium$provisioning$job$BStationStepRecord);
        private Set startTimes = new HashSet();

        private Model() {
        }

        public synchronized void updateRecord(BStationStepRecord bStationStepRecord) {
            if (!this.startTimes.contains(bStationStepRecord.getStartTime())) {
                this.rows.add((Object)bStationStepRecord);
                this.startTimes.add(bStationStepRecord.getStartTime());
            }
            this.updateTable(true);
        }

        public synchronized void load(BProvisioningJob bProvisioningJob) throws Exception {
            BStationStepRecord[] bStationStepRecordArray = bProvisioningJob.getStepRecords();
            HashSet<BAbsTime> hashSet = new HashSet<BAbsTime>();
            for (int i = 0; i < bStationStepRecordArray.length; ++i) {
                hashSet.add(bStationStepRecordArray[i].getStartTime());
            }
            this.rows = new Array((Object[])bStationStepRecordArray);
            this.startTimes = hashSet;
            this.updateTable(true);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BProvisioningJobView.this.getLexicon().getText("ProvisioningJobView.col.station");
                }
                case 1: {
                    return BProvisioningJobView.this.getLexicon().getText("ProvisioningJobView.col.type");
                }
                case 2: {
                    return BProvisioningJobView.this.getLexicon().getText("ProvisioningJobView.col.start");
                }
                case 3: {
                    return BProvisioningJobView.this.getLexicon().getText("ProvisioningJobView.col.end");
                }
                case 4: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.record(n).getStationName();
                }
                case 1: {
                    return this.record(n).getStepDescription();
                }
                case 2: {
                    return this.record(n).getStartTime().toString();
                }
                case 3: {
                    return this.record(n).getEndTime() == null ? "" : this.record(n).getEndTime().toString();
                }
                case 4: {
                    return this.record(n).getState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BStationStepRecord record(int n) {
            return (BStationStepRecord)((Object)this.rows.get(n));
        }

        public BImage getRowIcon(int n) {
            return JobTable.stateToIcon(this.record(n).getState());
        }
    }
}

