/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.ui.job;

import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BProvisioningJobStep;
import com.tridium.provisioning.ui.job.BStationList;
import com.tridium.provisioning.ui.job.BStepList;
import com.tridium.provisioning.ui.job.ViewQueryParameter;
import com.tridium.workbench.fieldeditors.BDateFE;
import com.tridium.workbench.fieldeditors.BTimeFE;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.util.TextUtil;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BProvisioningJobBuilder
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$ui$job$BProvisioningJobBuilder == null ? (class$com$tridium$provisioning$ui$job$BProvisioningJobBuilder = BProvisioningJobBuilder.class$("com.tridium.provisioning.ui.job.BProvisioningJobBuilder")) : class$com$tridium$provisioning$ui$job$BProvisioningJobBuilder));
    private BStationList stations;
    private BStepList steps;
    private BButtonPane buttons;
    private Later later;
    private Now now;
    private BCheckBox alertOnStepFailureCheckBox;
    private BCheckBox alertOnJobSuccessCheckBox;
    public static final Lexicon lex = Lexicon.make((String)"provisioning");
    private static final BIcon icon = BIcon.std((String)"gears.png");
    static /* synthetic */ Class class$com$tridium$provisioning$ui$job$BProvisioningJobBuilder;

    public Type getType() {
        return TYPE;
    }

    public BProvisioningJobBuilder() {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        this.alertOnStepFailureCheckBox = new BCheckBox(this.getLexicon().getText("ProvisioningJobBuilder.alertOnStepFailure"));
        bGridPane.add(null, (BValue)this.alertOnStepFailureCheckBox);
        this.alertOnStepFailureCheckBox.setSelected(((BBoolean)BProvisioningJob.alertOnStepFailure.getDefaultValue()).getBoolean());
        this.alertOnJobSuccessCheckBox = new BCheckBox(this.getLexicon().getText("ProvisioningJobBuilder.alertOnJobSuccess"));
        bGridPane.add(null, (BValue)this.alertOnJobSuccessCheckBox);
        this.alertOnJobSuccessCheckBox.setSelected(((BBoolean)BProvisioningJob.alertOnJobSuccess.getDefaultValue()).getBoolean());
        this.stations = new BStationList(this);
        this.steps = new BStepList(this);
        BSplitPane bSplitPane = new BSplitPane(this.steps.getContainer(), this.stations.getContainer());
        bSplitPane.setOrientation(BOrientation.vertical);
        Command[] commandArray = new Command[2];
        this.later = new Later();
        commandArray[0] = this.later;
        this.now = new Now();
        commandArray[1] = this.now;
        this.buttons = new BButtonPane(commandArray, true, true);
        this.setContent((BWidget)new BEdgePane((BWidget)bGridPane, (BWidget)this.buttons, null, null, (BWidget)new BBorderPane((BWidget)bSplitPane, 4.0, 0.0, 4.0, 0.0)));
    }

    public void doLoadValue(BObject bObject, Context context) throws Exception {
        BProvisioningService bProvisioningService = (BProvisioningService)bObject;
        bProvisioningService.lease();
        this.stations.setTarget((BObject)bProvisioningService);
        this.steps.setTarget((BObject)bProvisioningService);
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)this);
        if (bWbShell != null) {
            OrdQuery[] ordQueryArray = bWbShell.getActiveOrd().parse();
            if (ordQueryArray[ordQueryArray.length - 1] instanceof ViewQuery) {
                String string;
                ViewQuery viewQuery = (ViewQuery)ordQueryArray[ordQueryArray.length - 1];
                String string2 = viewQuery.getParameter("stations", null);
                if (string2 != null) {
                    this.stations.addStations(TextUtil.split((String)string2, (char)','));
                }
                if ((string = viewQuery.getParameter("steps", null)) != null) {
                    String[] stringArray = TextUtil.split((String)string, (char)',');
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.steps.addStep((BProvisioningJobStep)ViewQueryParameter.decode(stringArray[i]));
                    }
                }
            }
            this.buttons.add(bWbShell.getRefreshCommand(), true, true);
        }
    }

    protected BProvisioningJob makeJob() throws Exception {
        BProvisioningJob bProvisioningJob = new BProvisioningJob(this.stations.getStationNames());
        bProvisioningJob.setAlertOnStepFailure(this.alertOnStepFailureCheckBox.isSelected());
        bProvisioningJob.setAlertOnJobSuccess(this.alertOnJobSuccessCheckBox.isSelected());
        BProvisioningJobStep[] bProvisioningJobStepArray = this.steps.getJobSteps();
        for (int i = 0; i < bProvisioningJobStepArray.length; ++i) {
            bProvisioningJob.addStep(bProvisioningJobStepArray[i]);
        }
        return bProvisioningJob;
    }

    void transferWidgetFocusGained(BTransferWidget bTransferWidget) {
        this.setTransferWidget(bTransferWidget);
        if (bTransferWidget != this.stations) {
            this.stations.getSelection().deselectAll();
        }
        if (bTransferWidget != this.steps) {
            this.steps.getSelection().deselectAll();
        }
    }

    void listUpdated(BList bList) {
        boolean bl = this.stations.getModel().getItemCount() > 0 && this.steps.getModel().getItemCount() > 0;
        this.later.setEnabled(bl);
        this.now.setEnabled(bl);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Now
    extends Command {
        public Now() {
            super((BWidget)BProvisioningJobBuilder.this, lex, "ProvisioningJobBuilder.now");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                BProvisioningService bProvisioningService = (BProvisioningService)BProvisioningJobBuilder.this.getCurrentValue();
                bProvisioningService.lease();
                BComponentSpace bComponentSpace = (BComponentSpace)bProvisioningService.getSpace();
                BOrd bOrd = bProvisioningService.submitJob(BProvisioningJobBuilder.this.makeJob(), null);
                bComponentSpace.sync();
                BProvisioningJob bProvisioningJob = (BProvisioningJob)bOrd.get((BObject)bComponentSpace);
                BWbShell bWbShell = BWbShell.getWbShell((BWidget)BProvisioningJobBuilder.this);
                if (bWbShell != null) {
                    bWbShell.hyperlink(bProvisioningJob.getNavOrd());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class Later
    extends Command {
        public Later() {
            super((BWidget)BProvisioningJobBuilder.this, lex, "ProvisioningJobBuilder.later");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                BGridPane bGridPane = new BGridPane(2);
                BAbsTime bAbsTime = BAbsTime.now().add(BRelTime.make((long)30000L));
                BDateFE bDateFE = new BDateFE(bAbsTime);
                BTimeFE bTimeFE = new BTimeFE(BTime.make((BAbsTime)bAbsTime));
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"ProvisioningJobBuilder.later.dateLabel"), (BWidget)bDateFE);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"provisioning", (String)"ProvisioningJobBuilder.later.timeLabel"), (BWidget)bTimeFE);
                if (1 == BCommandDialog.open((BWidget)BProvisioningJobBuilder.this, (String)lex.getText("ProvisioningJobBuilder.later.dlgTitle"), (Object)new BBorderPane((BWidget)bGridPane, 14.0, 10.0, 8.0, 10.0), (DialogCommand[])new DialogCommand[]{DialogCommand.makeOk((BWidget)BProvisioningJobBuilder.this), DialogCommand.makeCancel((BWidget)BProvisioningJobBuilder.this)})) {
                    BProvisioningService bProvisioningService = (BProvisioningService)BProvisioningJobBuilder.this.getCurrentValue();
                    bProvisioningService.lease();
                    BComponentSpace bComponentSpace = (BComponentSpace)bProvisioningService.getSpace();
                    BAbsTime bAbsTime2 = (BAbsTime)bDateFE.saveValue();
                    BTime bTime = (BTime)bTimeFE.saveValue();
                    BAbsTime bAbsTime3 = BAbsTime.make((BAbsTime)bAbsTime2, (BTime)bTime);
                    if (bAbsTime3.isBefore(BAbsTime.now())) {
                        throw new LocalizableRuntimeException("provisioning", "ProvisioningJobBuilder.later.futureDateRequired");
                    }
                    BOrd bOrd = bProvisioningService.scheduleJob(BProvisioningJobBuilder.this.makeJob(), bAbsTime3);
                    bComponentSpace.sync();
                    BWbShell bWbShell = BWbShell.getWbShell((BWidget)BProvisioningJobBuilder.this);
                    if (bWbShell != null) {
                        bWbShell.hyperlink(bOrd);
                    }
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }
}

