/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.station;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioning.BProvisioningChannel;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.BProvisioningStationExt;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.platform.BStationStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

public class BStationProxy
extends BProvisioningStationExt
implements BIMixIn,
BIPollable {
    public static final Property pollFrequency = BStationProxy.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property isRestartEnabled = BStationProxy.newProperty((int)3, (boolean)false, null);
    public static final Property isRebootEnabled = BStationProxy.newProperty((int)3, (boolean)false, null);
    public static final Property isAutoStart = BStationProxy.newProperty((int)3, (boolean)false, null);
    public static final Property isAutoRestart = BStationProxy.newProperty((int)3, (boolean)false, null);
    public static final Property stationStatus = BStationProxy.newProperty((int)3, (BValue)BStationStatus.unknown, null);
    public static final Property isAcceptingMessages = BStationProxy.newProperty((int)3, (boolean)false, null);
    public static final Property logBufferSize = BStationProxy.newProperty((int)3, (int)Short.MAX_VALUE, null);
    public static final Property logBufferFileSize = BStationProxy.newProperty((int)3, (int)Short.MAX_VALUE, null);
    public static final Property numCpus = BStationProxy.newProperty((int)3, (int)1, null);
    public static final Property currentCpuUsage = BStationProxy.newProperty((int)3, (int)-1, null);
    public static final Property overallCpuUsage = BStationProxy.newProperty((int)3, (int)-1, null);
    public static final Property totalPhysicalMemory = BStationProxy.newProperty((int)3, (int)-1, null);
    public static final Property freePhysicalMemory = BStationProxy.newProperty((int)3, (int)-1, null);
    public static final Property filesystemAttributes = BStationProxy.newProperty((int)3, (BValue)new BVector(), null);
    public static final Action poll = BStationProxy.newAction((int)0, null);
    public static final Action dumpThreads = BStationProxy.newAction((int)16, null);
    public static final Action saveStation = BStationProxy.newAction((int)16, null);
    public static final Action stopStation = BStationProxy.newAction((int)144, null);
    public static final Action startStation = BStationProxy.newAction((int)0, null);
    public static final Action killStation = BStationProxy.newAction((int)144, null);
    public static final Action restartStation = BStationProxy.newAction((int)144, null);
    public static final Action rebootHost = BStationProxy.newAction((int)144, null);
    public static final Action updateLogBufferSize = BStationProxy.newAction((int)20, null);
    public static final Action updateStartSettings = BStationProxy.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$station$BStationProxy == null ? (class$com$tridium$provisioning$station$BStationProxy = BStationProxy.class$("com.tridium.provisioning.station.BStationProxy")) : class$com$tridium$provisioning$station$BStationProxy));
    private boolean allowStartUpdate = true;
    private boolean startUpdated = false;
    public static BIcon ICON = BIcon.std((String)"computer.png");
    static /* synthetic */ Class class$com$tridium$provisioning$station$BStationProxy;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$platform$BFilesystemAttributes;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public boolean getIsRestartEnabled() {
        return this.getBoolean(isRestartEnabled);
    }

    public void setIsRestartEnabled(boolean bl) {
        this.setBoolean(isRestartEnabled, bl, null);
    }

    public boolean getIsRebootEnabled() {
        return this.getBoolean(isRebootEnabled);
    }

    public void setIsRebootEnabled(boolean bl) {
        this.setBoolean(isRebootEnabled, bl, null);
    }

    public boolean getIsAutoStart() {
        return this.getBoolean(isAutoStart);
    }

    public void setIsAutoStart(boolean bl) {
        this.setBoolean(isAutoStart, bl, null);
    }

    public boolean getIsAutoRestart() {
        return this.getBoolean(isAutoRestart);
    }

    public void setIsAutoRestart(boolean bl) {
        this.setBoolean(isAutoRestart, bl, null);
    }

    public BStationStatus getStationStatus() {
        return (BStationStatus)this.get(stationStatus);
    }

    public void setStationStatus(BStationStatus bStationStatus) {
        this.set(stationStatus, (BValue)bStationStatus, null);
    }

    public boolean getIsAcceptingMessages() {
        return this.getBoolean(isAcceptingMessages);
    }

    public void setIsAcceptingMessages(boolean bl) {
        this.setBoolean(isAcceptingMessages, bl, null);
    }

    public int getLogBufferSize() {
        return this.getInt(logBufferSize);
    }

    public void setLogBufferSize(int n) {
        this.setInt(logBufferSize, n, null);
    }

    public int getLogBufferFileSize() {
        return this.getInt(logBufferFileSize);
    }

    public void setLogBufferFileSize(int n) {
        this.setInt(logBufferFileSize, n, null);
    }

    public int getNumCpus() {
        return this.getInt(numCpus);
    }

    public void setNumCpus(int n) {
        this.setInt(numCpus, n, null);
    }

    public int getCurrentCpuUsage() {
        return this.getInt(currentCpuUsage);
    }

    public void setCurrentCpuUsage(int n) {
        this.setInt(currentCpuUsage, n, null);
    }

    public int getOverallCpuUsage() {
        return this.getInt(overallCpuUsage);
    }

    public void setOverallCpuUsage(int n) {
        this.setInt(overallCpuUsage, n, null);
    }

    public int getTotalPhysicalMemory() {
        return this.getInt(totalPhysicalMemory);
    }

    public void setTotalPhysicalMemory(int n) {
        this.setInt(totalPhysicalMemory, n, null);
    }

    public int getFreePhysicalMemory() {
        return this.getInt(freePhysicalMemory);
    }

    public void setFreePhysicalMemory(int n) {
        this.setInt(freePhysicalMemory, n, null);
    }

    public BVector getFilesystemAttributes() {
        return (BVector)this.get(filesystemAttributes);
    }

    public void setFilesystemAttributes(BVector bVector) {
        this.set(filesystemAttributes, (BValue)bVector, null);
    }

    public void poll() {
        this.invoke(poll, null, null);
    }

    public void dumpThreads() {
        this.invoke(dumpThreads, null, null);
    }

    public void saveStation() {
        this.invoke(saveStation, null, null);
    }

    public void stopStation() {
        this.invoke(stopStation, null, null);
    }

    public void startStation() {
        this.invoke(startStation, null, null);
    }

    public void killStation() {
        this.invoke(killStation, null, null);
    }

    public void restartStation() {
        this.invoke(restartStation, null, null);
    }

    public void rebootHost() {
        this.invoke(rebootHost, null, null);
    }

    public void updateLogBufferSize() {
        this.invoke(updateLogBufferSize, null, null);
    }

    public void updateStartSettings() {
        this.invoke(updateStartSettings, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context context) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("StationProxy");
    }

    public void subscribed() {
        try {
            BProvisioningService bProvisioningService = (BProvisioningService)Sys.getService((Type)BProvisioningService.TYPE);
            bProvisioningService.getPollScheduler().subscribe(this);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public void unsubscribed() {
        try {
            BProvisioningService bProvisioningService = (BProvisioningService)Sys.getService((Type)BProvisioningService.TYPE);
            bProvisioningService.getPollScheduler().unsubscribe(this);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.allowStartUpdate && (property == isAutoStart || property == isAutoRestart)) {
            this.startUpdated = true;
        }
    }

    public BFilesystemAttributes getFilesystemAttributes(FilePath filePath) throws Exception {
        if (this.isUnoperational()) {
            return null;
        }
        if (this.isRunning()) {
            return DaemonFileUtil.getFilesystemAttributes((BDaemonSession)this.getDaemonSession(), (FilePath)filePath);
        }
        return this.channel().getFilesystemAttributes(this.getStationName(), filePath);
    }

    public String getStationName() {
        return this.getNiagaraStation().getStationName();
    }

    public InputStream getStationOutput(boolean bl, boolean bl2) throws Exception {
        if (this.isUnoperational()) {
            return null;
        }
        if (this.isRunning()) {
            return this.getStationSurrogate().getStationOutput(bl, bl2);
        }
        return this.channel().getStationOutput(this.getStationName(), bl, bl2);
    }

    public void startStation(DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().startStation(null, daemonSessionTaskListener);
        } else {
            this.channel().startStation(this.getStationName(), daemonSessionTaskListener);
        }
    }

    public void stopStation(DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().stopStation(null, daemonSessionTaskListener);
        } else {
            this.channel().stopStation(this.getStationName(), daemonSessionTaskListener);
        }
    }

    public void saveStation(DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().saveStation(null, daemonSessionTaskListener);
        } else {
            this.channel().saveStation(this.getStationName(), daemonSessionTaskListener);
        }
    }

    public void killStation(DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().killStation(null, daemonSessionTaskListener);
        } else {
            this.channel().killStation(this.getStationName(), daemonSessionTaskListener);
        }
    }

    public synchronized void doPoll() throws Exception {
        if (this.isUnoperational()) {
            this.reset();
            this.clearDown();
            return;
        }
        try {
            BDaemonSession bDaemonSession = this.getDaemonSession();
            if (bDaemonSession == null) {
                this.reset();
                this.setDown();
                return;
            }
            BHostProperties bHostProperties = bDaemonSession.updateHostProperties();
            this.setNumCpus(bHostProperties.getNumCpus());
            this.setCurrentCpuUsage(bHostProperties.getCurrentCpuUsage());
            this.setOverallCpuUsage(bHostProperties.getOverallCpuUsage());
            this.setTotalPhysicalMemory(bHostProperties.getTotalPhysicalMemory());
            this.setFreePhysicalMemory(bHostProperties.getFreePhysicalMemory());
            Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BStationProxy.class$("java.lang.String")) : class$java$lang$String);
            SlotCursor slotCursor = this.getFilesystemAttributes().getProperties();
            while (slotCursor.next(class$com$tridium$platform$BFilesystemAttributes == null ? BStationProxy.class$("com.tridium.platform.BFilesystemAttributes") : class$com$tridium$platform$BFilesystemAttributes)) {
                array.add((Object)slotCursor.slot().getName());
            }
            slotCursor = bHostProperties.getFilesystemAttributes().getProperties();
            while (slotCursor.next(class$com$tridium$platform$BFilesystemAttributes == null ? BStationProxy.class$("com.tridium.platform.BFilesystemAttributes") : class$com$tridium$platform$BFilesystemAttributes)) {
                String string = slotCursor.slot().getName();
                array.remove((Object)string);
                BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)slotCursor.get();
                Property property = this.getFilesystemAttributes().getProperty(string);
                if (property == null) {
                    this.getFilesystemAttributes().add(string, bFilesystemAttributes.newCopy());
                    continue;
                }
                BFilesystemAttributes bFilesystemAttributes2 = (BFilesystemAttributes)this.getFilesystemAttributes().get(property);
                SlotCursor slotCursor2 = bFilesystemAttributes.getProperties();
                while (slotCursor2.next()) {
                    BValue bValue = (BValue)slotCursor2.get();
                    if (bValue instanceof BComplex) {
                        bFilesystemAttributes2.set(slotCursor2.property(), (BValue)((BComplex)((BComplex)bValue).newCopy()));
                        continue;
                    }
                    bFilesystemAttributes2.set(slotCursor2.property(), bValue);
                }
            }
            for (int i = 0; i < array.size(); ++i) {
                this.getFilesystemAttributes().remove((String)array.get(i));
            }
            BStationSurrogate bStationSurrogate = this.getStationSurrogate();
            if (bStationSurrogate == null) {
                this.clearDown();
                return;
            }
            if (!this.startUpdated) {
                this.allowStartUpdate = false;
                if (bStationSurrogate.getIsAutoStart() != this.getIsAutoStart()) {
                    this.setIsAutoStart(bStationSurrogate.getIsAutoStart());
                }
                if (bStationSurrogate.getIsAutoRestart() != this.getIsAutoRestart()) {
                    this.setIsAutoRestart(bStationSurrogate.getIsAutoRestart());
                }
                this.allowStartUpdate = true;
            }
            this.setStationStatus(bStationSurrogate.getStationStatus());
            this.setIsAcceptingMessages(bStationSurrogate.getIsAcceptingMessages());
            this.setLogBufferFileSize(bStationSurrogate.getLogBufferFileSize());
            this.setLogBufferSize(bStationSurrogate.getLogBufferSize());
            this.setIsRestartEnabled(bStationSurrogate.isRestartEnabled());
            this.setIsRebootEnabled(this.getDaemonSession().getHostProperties().supportsServlet("reboot") && !this.getDaemonSession().getHostProperties().getHostId().equals(Nre.getHostId()));
            this.clearDown();
        }
        catch (IOException iOException) {
            this.setDown();
            this.reset();
        }
    }

    public void reset() {
        this.setStationStatus(BStationStatus.unknown);
        this.setIsAcceptingMessages(false);
        this.setIsRestartEnabled(false);
        this.setIsRebootEnabled(false);
    }

    public void doStopStation() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.setStationStatus(BStationStatus.stopping);
        this.getStationSurrogate().stopStationAsync();
    }

    public void doStartStation() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.setStationStatus(BStationStatus.starting);
        this.getStationSurrogate().startStationAsync();
    }

    public void doKillStation() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().killStationAsync();
    }

    public void doRestartStation() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (!this.getIsRestartEnabled()) {
            throw new IllegalStateException("Restart not permitted");
        }
        this.setStationStatus(BStationStatus.stopping);
        this.getStationSurrogate().restartStationAsync();
    }

    public void doRebootHost() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (!this.getIsRebootEnabled()) {
            throw new IllegalStateException("Reboot not permitted");
        }
        this.getDaemonSession().sendRebootRequest(false);
        this.reset();
    }

    public void doDumpThreads() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().dumpThreads();
    }

    public void doSaveStation() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().saveStationAsync();
    }

    public void doUpdateLogBufferSize() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().updateLogBufferSize(this.getLogBufferSize(), this.getLogBufferFileSize());
    }

    public void doUpdateStartSettings() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().updateSettings(this.getIsAutoStart(), this.getIsAutoRestart());
        this.startUpdated = false;
    }

    protected BStationSurrogate getStationSurrogate() throws Exception {
        BDaemonSession bDaemonSession = this.getDaemonSession();
        return bDaemonSession == null ? null : BStationSurrogate.make((BDaemonSession)bDaemonSession, (String)this.getStationName());
    }

    protected BProvisioningChannel channel() throws Exception {
        BFoxSession bFoxSession = (BFoxSession)BOrd.toSession((BObject)this);
        return (BProvisioningChannel)bFoxSession.getConnection().getChannels().get("provisioning", BProvisioningChannel.TYPE);
    }

    public boolean isUnoperational() {
        return this.isDisabled() || this.isFault();
    }

    protected void setDown() {
        if (!this.getStatus().isDown()) {
            int n = this.getStatus().getBits();
            this.setStatus(BStatus.make((int)(n |= 4)));
        }
    }

    protected void clearDown() {
        if (this.getStatus().isDown()) {
            int n = this.getStatus().getBits();
            this.setStatus(BStatus.make((int)(n &= 0xFFFFFFFB)));
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

