/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.software;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.ClosableCursor;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.provisioning.BProvisioningChannel;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.software.BInstallableSummary;
import java.util.Comparator;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

public class BSoftwareContainer
extends BComponent
implements LocalInstallableRegistry.RegistryListener {
    public static final Property loaded = BSoftwareContainer.newProperty((int)7, (boolean)false, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$software$BSoftwareContainer == null ? (class$com$tridium$provisioning$software$BSoftwareContainer = BSoftwareContainer.class$("com.tridium.provisioning.software.BSoftwareContainer")) : class$com$tridium$provisioning$software$BSoftwareContainer));
    private static final BIcon icon = BIcon.make((String)"module://provisioning/icons/software.png");
    static /* synthetic */ Class class$com$tridium$provisioning$software$BSoftwareContainer;

    public boolean getLoaded() {
        return this.getBoolean(loaded);
    }

    public void setLoaded(boolean bl) {
        this.setBoolean(loaded, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public synchronized void installableRegistered(BInstallable bInstallable) {
        try {
            BInstallableSummary bInstallableSummary = this.getInstallableSummary(bInstallable.getInstallableName());
            if (bInstallableSummary == null) {
                bInstallableSummary = new BInstallableSummary(bInstallable);
                this.add(SlotPath.escape((String)bInstallable.getInstallableName()), (BValue)bInstallableSummary, 3);
            } else {
                bInstallableSummary.addInstallable(bInstallable);
            }
        }
        catch (RuntimeException runtimeException) {
            Log.getLog((String)"provisioning").error("Installable registration failed for " + bInstallable.getLocalInstallableFile(), (Throwable)runtimeException);
        }
    }

    public BProvisioningService getProvisioningService() {
        return (BProvisioningService)this.getParent();
    }

    public BInstallableSummary getInstallableSummary(String string) {
        return (BInstallableSummary)this.get(SlotPath.escape((String)string));
    }

    public BInstallableSpec getInstallableSpec(String string, BVersion bVersion) {
        BInstallableSummary bInstallableSummary = this.getInstallableSummary(string);
        return bInstallableSummary == null ? null : bInstallableSummary.getInstallableSpec(bVersion);
    }

    public BInstallable getInstallable(BIFile bIFile) throws Exception {
        if (bIFile == null) {
            return null;
        }
        if (bIFile.getStore() instanceof BLocalFileStore) {
            return BInstallable.make((BIFile)bIFile);
        }
        if (bIFile.getFileSpace().getSession().equals(this.getSession())) {
            BFoxSession bFoxSession = (BFoxSession)this.getSession();
            BProvisioningChannel bProvisioningChannel = (BProvisioningChannel)bFoxSession.getConnection().getChannels().get("provisioning", BProvisioningChannel.TYPE);
            return bProvisioningChannel.getInstallableByPath(bIFile.getFilePath());
        }
        return null;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent.getType().is(BProvisioningService.TYPE);
    }

    public boolean isChildLegal(BComponent bComponent) {
        return bComponent.getType().is(BInstallableSummary.TYPE);
    }

    public void serviceStarted() {
        new Import().start();
    }

    public BINavNode[] getNavChildren() {
        Array array = new Array((Object[])super.getNavChildren());
        array = array.sort(new Comparator(){

            public int compare(Object object, Object object2) {
                BINavNode bINavNode = (BINavNode)object;
                BINavNode bINavNode2 = (BINavNode)object2;
                return bINavNode.getNavName().compareTo(bINavNode2.getNavName());
            }
        });
        return (BINavNode[])array.trim();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Import
    extends Thread {
        private Import() {
        }

        public void run() {
            try {
                BSoftwareContainer.this.removeAll();
                ClosableCursor closableCursor = LocalInstallableRegistry.getInstance().getInstallables(false, null);
                try {
                    while (closableCursor.next()) {
                        BSoftwareContainer.this.installableRegistered((BInstallable)closableCursor.get());
                    }
                }
                finally {
                    closableCursor.close();
                }
                BSoftwareContainer.this.setLoaded(true);
                LocalInstallableRegistry.getInstance().addListener((LocalInstallableRegistry.RegistryListener)BSoftwareContainer.this);
            }
            catch (Exception exception) {
                Log.getLog((String)"provisioning").error("Software registry scan failed", (Throwable)exception);
            }
        }
    }
}

