/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.software;

import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.job.BStationStepRecord;
import com.tridium.provisioning.software.BAbstractSoftwareStep;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

public class BFileCopyStep
extends BAbstractSoftwareStep {
    public static final Property sourceFileOrd = BFileCopyStep.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property destinationFileName = BFileCopyStep.newProperty((int)1, (String)"", null);
    public static final Property destinationDirPathBody = BFileCopyStep.newProperty((int)1, (String)"!", null);
    public static final Property shouldCleanUp = BFileCopyStep.newProperty((int)5, (boolean)false, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$software$BFileCopyStep == null ? (class$com$tridium$provisioning$software$BFileCopyStep = BFileCopyStep.class$("com.tridium.provisioning.software.BFileCopyStep")) : class$com$tridium$provisioning$software$BFileCopyStep));
    private BISession fileSession = null;
    public static final Lexicon lex = Lexicon.make((String)"provisioning");
    private static final BIcon icon = BIcon.std((String)"file.png");
    static /* synthetic */ Class class$com$tridium$provisioning$software$BFileCopyStep;

    public BOrd getSourceFileOrd() {
        return (BOrd)this.get(sourceFileOrd);
    }

    public void setSourceFileOrd(BOrd bOrd) {
        this.set(sourceFileOrd, (BValue)bOrd, null);
    }

    public String getDestinationFileName() {
        return this.getString(destinationFileName);
    }

    public void setDestinationFileName(String string) {
        this.setString(destinationFileName, string, null);
    }

    public String getDestinationDirPathBody() {
        return this.getString(destinationDirPathBody);
    }

    public void setDestinationDirPathBody(String string) {
        this.setString(destinationDirPathBody, string, null);
    }

    public boolean getShouldCleanUp() {
        return this.getBoolean(shouldCleanUp);
    }

    public void setShouldCleanUp(boolean bl) {
        this.setBoolean(shouldCleanUp, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFileCopyStep() {
    }

    public BFileCopyStep(BIFile bIFile, FilePath filePath) {
        this.setSourceFileOrd(bIFile.getOrdInSession());
        this.setDestinationFileName(bIFile.getFileName());
        this.setDestinationDirPathBody(filePath.getBody());
        this.fileSession = bIFile.getFileSpace().getSession();
    }

    public void prepareStep(BObject bObject) throws Exception {
        BISession bISession;
        if (this.fileSession != null && !(bISession = BOrd.toSession((BObject)bObject)).equals(this.fileSession)) {
            BIFile bIFile = (BIFile)this.getSourceFileOrd().get((BObject)this.fileSession);
            BProvisioningService bProvisioningService = (BProvisioningService)BOrd.make((String)"service:provisioning:ProvisioningService").get(bObject);
            BIFile bIFile2 = bProvisioningService.makeTempFile(bIFile.getExtension());
            FileUtil.pipe((BIFile)bIFile, (BIFile)bIFile2);
            this.setSourceFileOrd(bIFile2.getOrdInSession());
            this.setShouldCleanUp(true);
        }
    }

    public InstallScenario updateInstallScenario(BStationStepRecord bStationStepRecord, DaemonSessionTaskListener daemonSessionTaskListener, InstallScenario installScenario) throws Exception {
        Array array;
        BIFile bIFile = (BIFile)this.getSourceFileOrd().get();
        FilePath filePath = new FilePath(this.getDestinationDirPathBody());
        if (filePath.isStationHomeAbsolute()) {
            array = new FilePath("!stations").merge(bStationStepRecord.getStationName());
            for (int i = 0; i < filePath.depth(); ++i) {
                array = array.merge(filePath.nameAt(i));
            }
            filePath = array;
        }
        array = new Array((Object[])installScenario.getToInstall());
        array.add((Object)new BFileInstallable(bIFile, this.getDestinationFileName(), filePath));
        return new InstallScenario(installScenario.getTargetPlatform(), daemonSessionTaskListener, installScenario.getModulesToUninstall(), installScenario.getUnmetDependencies(), (BInstallable[])array.trim(), (InstallableRegistry)LocalInstallableRegistry.getInstance());
    }

    public void jobComplete() {
        if (this.getShouldCleanUp()) {
            BIFile bIFile = (BIFile)this.getSourceFileOrd().get();
            try {
                bIFile.delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.jobComplete();
    }

    public BIcon getIcon() {
        try {
            String string = FileUtil.getExtension((String)this.getDestinationFileName());
            if (string != null && string.length() > 0) {
                TypeInfo typeInfo = Sys.getRegistry().getFileTypeForExtension(string);
                BObject bObject = typeInfo.getInstance();
                return bObject.getIcon();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    public String toString(Context context) {
        return lex.getText("FileCopyStep.display", new Object[]{this.getDestinationFileName(), this.getDestinationDirPathBody()});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

