/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning.software;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DaemonPlatformUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioning.BPlatformConnection;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.job.BProvisioningJobStep;
import com.tridium.provisioning.job.BStationStepRecord;
import com.tridium.provisioning.software.BSoftwareStationExt;
import com.tridium.provisioning.software.BUpgradeOutOfDateStep;
import java.net.SocketException;
import javax.baja.job.BJobState;
import javax.baja.naming.BHost;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

public abstract class BAbstractSoftwareStep
extends BProvisioningJobStep {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$software$BAbstractSoftwareStep == null ? (class$com$tridium$provisioning$software$BAbstractSoftwareStep = BAbstractSoftwareStep.class$("com.tridium.provisioning.software.BAbstractSoftwareStep")) : class$com$tridium$provisioning$software$BAbstractSoftwareStep));
    protected Array combinedSteps = new Array(class$com$tridium$provisioning$software$BAbstractSoftwareStep == null ? (class$com$tridium$provisioning$software$BAbstractSoftwareStep = BAbstractSoftwareStep.class$("com.tridium.provisioning.software.BAbstractSoftwareStep")) : class$com$tridium$provisioning$software$BAbstractSoftwareStep);
    static /* synthetic */ Class class$com$tridium$provisioning$software$BAbstractSoftwareStep;

    public Type getType() {
        return TYPE;
    }

    public boolean canCombine(BProvisioningJobStep bProvisioningJobStep) {
        return bProvisioningJobStep instanceof BAbstractSoftwareStep;
    }

    public void combine(BProvisioningJobStep bProvisioningJobStep) {
        this.combinedSteps.add((Object)bProvisioningJobStep);
    }

    public void jobComplete() {
        for (int i = 0; i < this.combinedSteps.size(); ++i) {
            ((BAbstractSoftwareStep)((Object)this.combinedSteps.get(i))).jobComplete();
        }
    }

    protected void doRun(BProvisioningService bProvisioningService, BStationStepRecord bStationStepRecord, BNiagaraStation bNiagaraStation, Context context) throws Exception {
        this.checkCanceled(bNiagaraStation);
        BPlatformConnection bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
        BDaemonSession bDaemonSession = bPlatformConnection.getDaemonSession();
        BSoftwareStationExt bSoftwareStationExt = (BSoftwareStationExt)bNiagaraStation.getMixIn(BSoftwareStationExt.TYPE);
        if (bSoftwareStationExt.isUnoperational()) {
            bStationStepRecord.failed("Software extension for " + bNiagaraStation.getStationName() + " status is " + bSoftwareStationExt.getStatus());
            bStationStepRecord.complete(BJobState.failed);
            return;
        }
        if (bPlatformConnection.isUnoperational()) {
            bStationStepRecord.failed("Platform connection for " + bNiagaraStation.getStationName() + " status is " + bSoftwareStationExt.getStatus());
            bStationStepRecord.complete(BJobState.failed);
            return;
        }
        if (bDaemonSession == null) {
            bStationStepRecord.failed("Platform connection for " + bNiagaraStation.getStationName() + " is unavailable");
            bStationStepRecord.complete(BJobState.failed);
            return;
        }
        Listener listener = new Listener(bStationStepRecord);
        BRemoteDaemonPlatform bRemoteDaemonPlatform = BRemoteDaemonPlatform.make((BDaemonSession)bDaemonSession, (DaemonSessionTaskListener)listener, (boolean)false);
        InstallScenario installScenario = new InstallScenario((BDaemonPlatform)bRemoteDaemonPlatform, (DaemonSessionTaskListener)listener, new String[0], new BDependency[0], new BInstallable[0], (InstallableRegistry)LocalInstallableRegistry.getInstance());
        BAbstractSoftwareStep[] bAbstractSoftwareStepArray = new BAbstractSoftwareStep[this.combinedSteps.size() + 1];
        bAbstractSoftwareStepArray[0] = this;
        System.arraycopy(this.combinedSteps.trim(), 0, bAbstractSoftwareStepArray, 1, this.combinedSteps.size());
        BUpgradeOutOfDateStep bUpgradeOutOfDateStep = null;
        if (bStationStepRecord.getState().isRunning()) {
            for (int i = 0; i < bAbstractSoftwareStepArray.length; ++i) {
                if (bAbstractSoftwareStepArray[i] instanceof BUpgradeOutOfDateStep) {
                    bUpgradeOutOfDateStep = (BUpgradeOutOfDateStep)bAbstractSoftwareStepArray[i];
                } else {
                    installScenario = bAbstractSoftwareStepArray[i].updateInstallScenario(bStationStepRecord, listener, installScenario);
                }
                if (bStationStepRecord.getState().isRunning()) continue;
                return;
            }
            if (bUpgradeOutOfDateStep != null) {
                installScenario = bUpgradeOutOfDateStep.updateInstallScenario(bStationStepRecord, listener, installScenario);
            }
            this.commitScenario(bStationStepRecord, installScenario, (BDaemonPlatform)bRemoteDaemonPlatform, bPlatformConnection, bSoftwareStationExt, context);
        }
    }

    public abstract InstallScenario updateInstallScenario(BStationStepRecord var1, DaemonSessionTaskListener var2, InstallScenario var3) throws Exception;

    protected final void commitScenario(BStationStepRecord bStationStepRecord, InstallScenario installScenario, BDaemonPlatform bDaemonPlatform, BPlatformConnection bPlatformConnection, BSoftwareStationExt bSoftwareStationExt, Context context) throws Exception {
        Listener listener = new Listener(bStationStepRecord);
        BDaemonSession bDaemonSession = bPlatformConnection.getDaemonSession();
        if (bDaemonSession == null) {
            bStationStepRecord.failed("Platform connection unavailable");
            bStationStepRecord.complete(BJobState.failed);
            return;
        }
        String string = bDaemonSession.getHostProperties().getSessionTimestamp();
        BDependency[] bDependencyArray = (installScenario = installScenario.solve()).getUnmetDependencies();
        if (bDependencyArray.length > 0) {
            for (int i = 0; i < bDependencyArray.length; ++i) {
                bStationStepRecord.message("Can't find software to meet dependency: " + bDependencyArray[i]);
            }
            bStationStepRecord.failed("Unmet dependencies exist");
            bStationStepRecord.complete(BJobState.failed);
            return;
        }
        BInstallable[] bInstallableArray = installScenario.getToInstall();
        for (int i = 0; i < bInstallableArray.length; ++i) {
            bStationStepRecord.message("Installing " + bInstallableArray[i]);
        }
        String[] stringArray = installScenario.getModulesToUninstall();
        for (int i = 0; i < stringArray.length; ++i) {
            bStationStepRecord.message("Uninstalling module " + stringArray[i]);
        }
        long l = installScenario.getProcessingFlags();
        boolean bl = (l & 0x10000L) > 0L;
        BAppSurrogate[] bAppSurrogateArray = new BAppSurrogate[]{};
        if ((l & 1L) > 0L || (l & 2L) > 0L) {
            bStationStepRecord.message("Stopping running applications on " + bDaemonPlatform.getNavDescription(context));
            bAppSurrogateArray = BAppSurrogate.stopAllApps((BDaemonSession)bPlatformConnection.getDaemonSession(), (Type)((l & 1L) > 0L ? null : BStationSurrogate.TYPE), (ICancelHint)this, (DaemonSessionTaskListener)listener);
            BStationSurrogate[] bStationSurrogateArray = BStationSurrogate.makeAll((BDaemonSession)bPlatformConnection.getDaemonSession());
            block7: for (int i = 0; i < bStationSurrogateArray.length; ++i) {
                if (bStationSurrogateArray[i].getStationStatus() == BStationStatus.idle) continue;
                BInstallable[] bInstallableArray2 = installScenario.getToInstall();
                for (int j = 0; j < bInstallableArray2.length; ++j) {
                    BPart bPart = bInstallableArray2[j].getPart();
                    if (bPart == null || !(bPart instanceof BNrePart)) continue;
                    DaemonPlatformUtil.doExtraStationShutdownTasks((BDaemonPlatform)bDaemonPlatform, (DaemonSessionTaskListener)listener, (ICancelHint)this);
                    string = bDaemonSession.getHostProperties().getSessionTimestamp();
                    break block7;
                }
                break;
            }
            if (bAppSurrogateArray.length > 0 && !bDaemonPlatform.getDaemonSession().getHostProperties().getAllowStationRestart()) {
                bl = true;
            }
        }
        this.checkCanceled(bStationStepRecord.getStation());
        installScenario.commit((DaemonSessionTaskListener)listener, null, (ICancelHint)this);
        this.checkCanceled(bStationStepRecord.getStation());
        if ((l & 0x20000L) > 0L) {
            bStationStepRecord.start("Installing OS image on " + bDaemonPlatform.getNavDescription(context));
            bPlatformConnection.getDaemonSession().sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 60000);
            bStationStepRecord.endSuccess();
            bl = true;
        }
        if ((l & 0x80000L) > 0L) {
            bStationStepRecord.message("TCP/IP changes ignored");
        }
        boolean bl2 = bl;
        BHost bHost = bPlatformConnection.getDaemonSession().getHost();
        if (bl) {
            bStationStepRecord.start("Rebooting " + bHost);
            bPlatformConnection.getDaemonSession().sendRebootRequest();
            bPlatformConnection.reset();
            bStationStepRecord.endSuccess();
        } else if ((l & 0x40000L) > 0L) {
            bStationStepRecord.start("Restarting platform daemon on " + bDaemonPlatform.getNavDescription(context));
            try {
                bPlatformConnection.getDaemonSession().sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            bPlatformConnection.reset();
            bStationStepRecord.endSuccess();
            bl2 = true;
        } else if (bAppSurrogateArray.length > 0) {
            for (int i = 0; i < bAppSurrogateArray.length; ++i) {
                this.checkCanceled(bStationStepRecord.getStation());
                bStationStepRecord.start("Starting " + bAppSurrogateArray[i].toString(context));
                bAppSurrogateArray[i].startAppAsync();
                bStationStepRecord.endSuccess();
            }
        }
        if (bl2) {
            bStationStepRecord.start("Reconnecting to " + bHost);
            while (!this.isCanceled()) {
                try {
                    bPlatformConnection.getDaemonSession().reloadHostProperties(15000);
                    if (bPlatformConnection.getDaemonSession().getHostProperties().getSessionTimestamp().equals(string)) continue;
                    bStationStepRecord.endSuccess();
                    break;
                }
                catch (SocketException socketException) {
                }
            }
        }
        bSoftwareStationExt.takeSnapshot();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class Listener
    implements DaemonSessionTaskListener {
        private BStationStepRecord record;
        private String lastTaskMessage = null;

        public Listener(BStationStepRecord bStationStepRecord) {
            this.record = bStationStepRecord;
        }

        public void taskStarted(DaemonSessionTask daemonSessionTask) {
            this.taskUpdated(daemonSessionTask);
        }

        public void taskUpdated(DaemonSessionTask daemonSessionTask) {
            if (!daemonSessionTask.getMessage().equals(this.lastTaskMessage)) {
                this.record.message(daemonSessionTask.getMessage());
                this.lastTaskMessage = daemonSessionTask.getMessage();
            }
        }

        public void taskFinished(DaemonSessionTask daemonSessionTask) {
            this.taskUpdated(daemonSessionTask);
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

