/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioning.BPlatformConnection;
import com.tridium.provisioning.BProvisioningService;
import javax.baja.driver.BDeviceExt;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BProvisioningStationExt
extends BDeviceExt
implements BIMixIn,
BIStatus {
    public static final Property enabled = BProvisioningStationExt.newProperty((int)0, (boolean)true, null);
    public static final Property status = BProvisioningStationExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BProvisioningStationExt.newProperty((int)3, (String)"", null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$BProvisioningStationExt == null ? (class$com$tridium$provisioning$BProvisioningStationExt = BProvisioningStationExt.class$("com.tridium.provisioning.BProvisioningStationExt")) : class$com$tridium$provisioning$BProvisioningStationExt));
    static final int FATAL_FAULT = 1;
    private static Type[] TYPES;
    private int flags = 0;
    private int oldStatus = -1;
    static /* synthetic */ Class class$com$tridium$provisioning$BProvisioningStationExt;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public boolean isUnoperational() {
        return this.isDown() || this.isDisabled() || this.isFault();
    }

    protected boolean propagateDeviceDownStatus() {
        return false;
    }

    protected boolean propagatePlatformConnectionStatus() {
        return true;
    }

    public void updateStatus() {
        int n = this.getStatus().getBits();
        BNiagaraStation bNiagaraStation = this.getNiagaraStation();
        if (bNiagaraStation == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
        }
        BStatus bStatus = bNiagaraStation == null ? BStatus.ok : bNiagaraStation.getStatus();
        BProvisioningService bProvisioningService = null;
        try {
            bProvisioningService = (BProvisioningService)Sys.getService((Type)BProvisioningService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        BStatus bStatus2 = bProvisioningService == null ? BStatus.ok : bProvisioningService.getStatus();
        BStatus bStatus3 = BStatus.ok;
        BPlatformConnection bPlatformConnection = null;
        if (bNiagaraStation != null) {
            bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
            bStatus3 = bPlatformConnection.getStatus();
        }
        n = !this.getEnabled() || bStatus.isDisabled() || bStatus2.isDisabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        if (this.propagateDeviceDownStatus()) {
            n = bStatus.isDown() ? (n |= 4) : (n &= 0xFFFFFFFB);
        }
        if (this.fatalFault()) {
            n |= 2;
        } else if (bProvisioningService == null) {
            n |= 2;
            this.setFaultCause("No provisioning service");
        } else if (bStatus.isFault()) {
            n |= 2;
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
        } else if (this.propagatePlatformConnectionStatus() && bStatus3.isFault()) {
            n |= 2;
            this.setFaultCause("Platform connection fault: " + bPlatformConnection.getFaultCause());
        } else {
            n &= 0xFFFFFFFD;
            this.setFaultCause("");
        }
        if (this.oldStatus == n) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
    }

    public final boolean isFatalFault() {
        return this.fatalFault();
    }

    private void checkFatalFault() {
        if (this.fatalFault()) {
            return;
        }
        try {
            BProvisioningService bProvisioningService = (BProvisioningService)Sys.getService((Type)BProvisioningService.TYPE);
            if (bProvisioningService.isFatalFault()) {
                this.fatalFault(true);
                this.setFaultCause("Provisioning service fault: " + bProvisioningService.getFaultCause());
                return;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.fatalFault(true);
            this.setFaultCause("No provisioning service");
            return;
        }
        if (this.getNiagaraStation() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
            return;
        }
        if (this.getNiagaraStation().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
            return;
        }
        if (this.getNiagaraNetwork() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraNetwork");
            return;
        }
        if (this.getNiagaraNetwork().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Network fault: " + this.getNiagaraNetwork().getFaultCause());
            return;
        }
        this.setFaultCause("");
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNiagaraStation;
    }

    public void started() throws Exception {
        this.checkFatalFault();
        this.updateStatus();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        }
    }

    public BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getDevice();
    }

    public BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getNetwork();
    }

    public BPlatformConnection getPlatformConnection() {
        return (BPlatformConnection)this.getNiagaraStation().getMixIn(BPlatformConnection.TYPE);
    }

    public BDaemonSession getDaemonSession() throws Exception {
        BPlatformConnection bPlatformConnection = this.getPlatformConnection();
        if (bPlatformConnection == null || bPlatformConnection.getStatus().isFault()) {
            return null;
        }
        return bPlatformConnection.getDaemonSession();
    }

    public static Type[] getStationExtTypes() {
        if (TYPES == null) {
            TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo());
            Type[] typeArray = new Type[typeInfoArray.length];
            for (int i = 0; i < typeInfoArray.length; ++i) {
                typeArray[i] = typeInfoArray[i].getTypeSpec().getResolvedType();
            }
            TYPES = typeArray;
        }
        return TYPES;
    }

    private boolean fatalFault() {
        return (this.flags & 1) != 0;
    }

    private void fatalFault(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

