/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxObject;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.ClosableCursor;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.ConsoleInputStream;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioning.BPlatformConnection;
import com.tridium.provisioning.job.BJobLogFile;
import com.tridium.provisioning.job.BJobStepSummary;
import com.tridium.provisioning.job.BProvisioningJob;
import com.tridium.provisioning.job.BProvisioningJobSummary;
import com.tridium.provisioning.job.BStationStepLogFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.baja.driver.BDevice;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;

public class BProvisioningChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$BProvisioningChannel == null ? (class$com$tridium$provisioning$BProvisioningChannel = BProvisioningChannel.class$("com.tridium.provisioning.BProvisioningChannel")) : class$com$tridium$provisioning$BProvisioningChannel));
    static /* synthetic */ Class class$com$tridium$provisioning$BProvisioningChannel;
    static /* synthetic */ Class class$com$tridium$install$installable$BInstallable;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BProvisioningChannel() {
        super("provisioning");
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (string == "getFilesystemAttributes") {
            return this.getFilesystemAttributes(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Exception {
        String string = foxCircuit.command;
        if (string == "findInstallable") {
            this.findInstallable(foxCircuit);
            return;
        }
        if (string == "getInstallableByPath") {
            this.getInstallableByPath(foxCircuit);
            return;
        }
        if (string == "findInstallables") {
            this.findInstallables(foxCircuit);
            return;
        }
        if (string == "getInstallables") {
            this.getInstallables(foxCircuit);
            return;
        }
        if (string == "registerInstallable") {
            this.registerInstallable(foxCircuit);
            return;
        }
        if (string == "registerStationInstallable") {
            this.registerStationInstallable(foxCircuit);
            return;
        }
        if (string == "getJobSummaries") {
            this.getJobSummaries(foxCircuit);
            return;
        }
        if (string == "getJobStepSummaries") {
            this.getJobStepSummaries(foxCircuit);
            return;
        }
        if (string == "getStationOutput") {
            this.getStationOutput(foxCircuit);
            return;
        }
        if (string == "startStation") {
            this.startStation(foxCircuit);
            return;
        }
        if (string == "stopStation") {
            this.stopStation(foxCircuit);
            return;
        }
        if (string == "killStation") {
            this.killStation(foxCircuit);
            return;
        }
        if (string == "saveStation") {
            this.saveStation(foxCircuit);
            return;
        }
        throw new InvalidCommandException(string);
    }

    public BFilesystemAttributes getFilesystemAttributes(String string, FilePath filePath) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getFilesystemAttributes");
        }
        FoxRequest foxRequest = this.makeRequest("getFilesystemAttributes");
        foxRequest.add("stationName", string);
        foxRequest.add("path", filePath.getBody());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        FoxObject foxObject = (FoxObject)foxResponse.getOptional("attributes");
        if (foxObject == null) {
            return null;
        }
        return (BFilesystemAttributes)DecoderFactory.decode((FoxObject)foxObject, null);
    }

    public FoxResponse getFilesystemAttributes(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        FilePath filePath = new FilePath(foxRequest.getString("path"));
        BNiagaraStation bNiagaraStation = this.getStation((FoxMessage)foxRequest);
        if (bNiagaraStation != null) {
            BPlatformConnection bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
            BogCodec.add((FoxMessage)foxResponse, (String)"attributes", (BValue)DaemonFileUtil.getFilesystemAttributes((BDaemonSession)bPlatformConnection.getDaemonSession(), (FilePath)filePath), null);
        }
        return foxResponse;
    }

    public void startStation(String string, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:startStation");
        }
        this.stationControl("startStation", string, daemonSessionTaskListener);
    }

    public void startStation(FoxCircuit foxCircuit) throws Exception {
        BStationSurrogate bStationSurrogate;
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:startStation");
        }
        if ((bStationSurrogate = this.getStationSurrogate(foxMessage)) != null) {
            bStationSurrogate.startStation(null, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        }
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("type", "end");
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public void saveStation(String string, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:saveStation");
        }
        this.stationControl("saveStation", string, daemonSessionTaskListener);
    }

    public void saveStation(FoxCircuit foxCircuit) throws Exception {
        BStationSurrogate bStationSurrogate;
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:saveStation");
        }
        if ((bStationSurrogate = this.getStationSurrogate(foxMessage)) != null) {
            bStationSurrogate.saveStation(null, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        }
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("type", "end");
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public void stopStation(String string, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:stopStation");
        }
        this.stationControl("stopStation", string, daemonSessionTaskListener);
    }

    public void stopStation(FoxCircuit foxCircuit) throws Exception {
        BStationSurrogate bStationSurrogate;
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:stopStation");
        }
        if ((bStationSurrogate = this.getStationSurrogate(foxMessage)) != null) {
            bStationSurrogate.stopStation(null, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        }
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("type", "end");
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public void killStation(String string, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:killStation");
        }
        this.stationControl("killStation", string, daemonSessionTaskListener);
    }

    public void killStation(FoxCircuit foxCircuit) throws Exception {
        BStationSurrogate bStationSurrogate;
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:killStation");
        }
        if ((bStationSurrogate = this.getStationSurrogate(foxMessage)) != null) {
            bStationSurrogate.killStation(null, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        }
        FoxMessage foxMessage2 = new FoxMessage();
        foxMessage2.add("type", "end");
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public InputStream getStationOutput(String string, boolean bl, boolean bl2) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getStationOutput");
        }
        FoxCircuit foxCircuit = this.openCircuit("getStationOutput");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("stationName", string);
        foxMessage.add("follow", bl);
        foxMessage.add("updatesOnly", bl2);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        return ConsoleInputStream.make((InputStream)foxCircuit.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getStationOutput(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:getStationOutput");
        }
        boolean bl = foxMessage.getBoolean("follow");
        boolean bl2 = foxMessage.getBoolean("updatesOnly");
        BStationSurrogate bStationSurrogate = this.getStationSurrogate(foxMessage);
        if (bStationSurrogate == null) return;
        InputStream inputStream = bStationSurrogate.getStationOutput(bl, bl2);
        OutputStream outputStream = foxCircuit.getOutputStream();
        try {
            int n = 4096;
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[]{0, 0, 0, 0};
            long l = Clock.ticks();
            while (true) {
                long l2;
                int n2;
                block26: {
                    n2 = inputStream.read(byArray, 0, n);
                    if (n2 >= 0) break block26;
                    return;
                }
                try {
                    if (n2 == 0) {
                        l2 = Clock.ticks();
                        if (l2 - l > 500L) {
                            outputStream.write(byArray2, 0, 4);
                            l = l2;
                        }
                    } else {
                        outputStream.write(n2 >>> 24 & 0xFF);
                        outputStream.write(n2 >>> 16 & 0xFF);
                        outputStream.write(n2 >>> 8 & 0xFF);
                        outputStream.write(n2 >>> 0 & 0xFF);
                        outputStream.write(byArray, 0, n2);
                        l = Clock.ticks();
                    }
                    outputStream.flush();
                    foxCircuit.flush();
                }
                catch (InterruptedIOException interruptedIOException) {
                    l2 = Clock.ticks();
                    if (l2 - l <= 500L) continue;
                    outputStream.write(byArray2, 0, 4);
                    outputStream.flush();
                    foxCircuit.flush();
                    l = l2;
                }
                continue;
                break;
            }
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private void stationControl(String string, String string2, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        FoxCircuit foxCircuit = this.openCircuit(string);
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("stationName", string2);
        TaskListenerClient taskListenerClient = new TaskListenerClient(daemonSessionTaskListener);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        try {
            while (true) {
                FoxMessage foxMessage2;
                if (taskListenerClient.handleMessage(foxMessage2 = foxCircuit.readMessage()) || !foxMessage2.getString("type").equals("end")) continue;
                return;
            }
        }
        finally {
            taskListenerClient.close();
        }
    }

    private BNiagaraStation getStation(FoxMessage foxMessage) throws Exception {
        String string = foxMessage.getString("stationName");
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] bDeviceArray = bNiagaraNetwork.getDevices();
        for (int i = 0; i < bDeviceArray.length; ++i) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDeviceArray[i];
            if (!bNiagaraStation.getStationName().equals(string)) continue;
            return bNiagaraStation;
        }
        return null;
    }

    private BStationSurrogate getStationSurrogate(FoxMessage foxMessage) throws Exception {
        BNiagaraStation bNiagaraStation = this.getStation(foxMessage);
        if (bNiagaraStation == null) {
            return null;
        }
        BPlatformConnection bPlatformConnection = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
        return BStationSurrogate.make((BDaemonSession)bPlatformConnection.getDaemonSession(), (String)bNiagaraStation.getStationName());
    }

    public ClosableCursor getJobStepSummaries(String string, Type type) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getJobStepSummaries");
        }
        FoxCircuit foxCircuit = this.openCircuit("getJobStepSummaries");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("stationName", string);
        if (type != null) {
            BogCodec.add((FoxMessage)foxMessage, (String)"type", (BValue)type.getTypeSpec(), null);
        }
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        return new ValueCursor(foxCircuit);
    }

    public void getJobStepSummaries(FoxCircuit foxCircuit) throws Exception {
        BTypeSpec bTypeSpec;
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:getJobStepSummaries");
        }
        String string = foxMessage.getString("stationName");
        FoxObject foxObject = (FoxObject)foxMessage.getOptional("type");
        FilePath filePath = new FilePath("^provisioning/stationLog");
        filePath = filePath.merge(string);
        if (foxObject == null) {
            bTypeSpec = BStationStepLogFile.list(string);
            for (int i = 0; i < ((BTypeSpec)bTypeSpec).length; ++i) {
                this.sendJobStepSummary(foxCircuit, (BStationStepLogFile)bTypeSpec[i]);
            }
        } else {
            bTypeSpec = (BTypeSpec)DecoderFactory.decode((FoxObject)foxObject, null);
            BStationStepLogFile[] bStationStepLogFileArray = BStationStepLogFile.list(string, bTypeSpec);
            for (int i = 0; i < bStationStepLogFileArray.length; ++i) {
                this.sendJobStepSummary(foxCircuit, bStationStepLogFileArray[i]);
            }
        }
        bTypeSpec = new FoxMessage();
        bTypeSpec.add("type", "end");
        foxCircuit.writeMessage((FoxMessage)bTypeSpec);
    }

    protected void sendJobStepSummary(FoxCircuit foxCircuit, BStationStepLogFile bStationStepLogFile) {
        try {
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("type", "item");
            BogCodec.add((FoxMessage)foxMessage, (String)"payload", (BValue)new BJobStepSummary(bStationStepLogFile.getRecord(), bStationStepLogFile.getStepType(), bStationStepLogFile.getJobStartTime()), null);
            foxCircuit.writeMessage(foxMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ClosableCursor getJobSummaries() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getJobSummaries");
        }
        FoxCircuit foxCircuit = this.openCircuit("getJobSummaries");
        FoxMessage foxMessage = new FoxMessage();
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        return new ValueCursor(foxCircuit);
    }

    public void getJobSummaries(FoxCircuit foxCircuit) throws Exception {
        foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:getJobSummaries");
        }
        BJobLogFile[] bJobLogFileArray = BJobLogFile.list();
        for (int i = 0; i < bJobLogFileArray.length; ++i) {
            BProvisioningJob bProvisioningJob = bJobLogFileArray[i].getJob();
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("type", "item");
            BogCodec.add((FoxMessage)foxMessage, (String)"payload", (BValue)new BProvisioningJobSummary(bProvisioningJob), null);
            foxCircuit.writeMessage(foxMessage);
        }
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("type", "end");
        foxCircuit.writeMessage(foxMessage);
    }

    public BInstallable getInstallableByPath(FilePath filePath) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getInstallableByPath");
        }
        FoxCircuit foxCircuit = this.openCircuit("getInstallableByPath");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("pathString", filePath.getBody());
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if ("notFound".equals(foxMessage2.getString("status"))) {
            return null;
        }
        return (BInstallable)DecoderFactory.decode((FoxMessage)foxMessage2, (String)"payload", null);
    }

    public void getInstallableByPath(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:getInstallableByPath");
        }
        BIFile bIFile = BFileSystem.INSTANCE.findFile(new FilePath(foxMessage.getString("pathString")));
        BInstallable bInstallable = null;
        if (bIFile != null) {
            bInstallable = BInstallable.make((BIFile)bIFile);
        }
        FoxMessage foxMessage2 = new FoxMessage();
        if (bInstallable == null) {
            foxMessage2.add("status", "notFound");
        } else {
            foxMessage2.add("status", "ok");
            BogCodec.add((FoxMessage)foxMessage2, (String)"payload", (BValue)bInstallable, null);
        }
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
    }

    public void registerStationInstallable(BInstallable bInstallable, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:registerInstallable");
        }
        if (bInstallable.getInstallableFileOrd().isNull()) {
            throw new IllegalArgumentException("Installable has no associated file");
        }
        FoxCircuit foxCircuit = this.openCircuit("registerInstallable");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("name", bInstallable.getInstallableName());
        foxMessage.add("fileName", bInstallable.getInstallableFileName());
        BogCodec.add((FoxMessage)foxMessage, (String)"version", (BValue)bInstallable.getVersion(), null);
        BogCodec.add((FoxMessage)foxMessage, (String)"typeSpec", (BValue)bInstallable.getType().getTypeSpec(), null);
        BogCodec.add((FoxMessage)foxMessage, (String)"fileOrd", (BValue)bInstallable.getInstallableFileOrd(), null);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        TaskListenerClient taskListenerClient = new TaskListenerClient(daemonSessionTaskListener);
        try {
            while (true) {
                FoxMessage foxMessage2;
                if ("status".equals((foxMessage2 = foxCircuit.readMessage()).getString("type"))) {
                    return;
                }
                taskListenerClient.handleMessage(foxMessage2);
            }
        }
        finally {
            taskListenerClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStationInstallable(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:registerStationInstallable");
        }
        try {
            BIFile bIFile;
            BInstallable bInstallable;
            String string = foxMessage.getString("name");
            BVersion bVersion = (BVersion)DecoderFactory.decode((FoxMessage)foxMessage, (String)"version", null);
            BTypeSpec bTypeSpec = (BTypeSpec)DecoderFactory.decode((FoxMessage)foxMessage, (String)"typeSpec", null);
            BOrd bOrd = (BOrd)DecoderFactory.decode((FoxMessage)foxMessage, (String)"fileOrd", null);
            BInstallable bInstallable2 = LocalInstallableRegistry.getInstance().findInstallable(string, bVersion.getVendorVersion(), bTypeSpec.getResolvedType(), (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
            FoxMessage foxMessage2 = new FoxMessage();
            if (bInstallable2 == null && (bInstallable = BInstallable.make((BIFile)(bIFile = (BIFile)bOrd.get()))) != null) {
                LocalInstallableRegistry.getInstance().register(bInstallable, null);
            }
            foxMessage2.add("type", "status");
            foxMessage2.add("status", "ok");
            foxCircuit.writeMessage(foxMessage2);
            foxCircuit.flush();
        }
        finally {
            foxCircuit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstallable(BInstallable bInstallable, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:registerInstallable");
        }
        if (bInstallable.getInstallableFileOrd().isNull()) {
            throw new IllegalArgumentException("Installable has no associated file");
        }
        BIFile bIFile = (BIFile)bInstallable.getInstallableFileOrd().get();
        if (bIFile != null && bIFile.getStore() instanceof BLocalFileStore) {
            FoxCircuit foxCircuit = this.openCircuit("registerInstallable");
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("name", bInstallable.getInstallableName());
            foxMessage.add("fileName", bInstallable.getInstallableFileName());
            BogCodec.add((FoxMessage)foxMessage, (String)"version", (BValue)bInstallable.getVersion(), null);
            BogCodec.add((FoxMessage)foxMessage, (String)"typeSpec", (BValue)bInstallable.getType().getTypeSpec(), null);
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            TaskListenerClient taskListenerClient = new TaskListenerClient(daemonSessionTaskListener);
            try {
                while (true) {
                    FoxMessage foxMessage2;
                    if ("status".equals((foxMessage2 = foxCircuit.readMessage()).getString("type"))) {
                        if ("continue".equals(foxMessage2.getString("status"))) {
                            ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(foxCircuit);
                            InputStream inputStream = bIFile.getInputStream();
                            try {
                                FileUtil.pipe((InputStream)inputStream, (long)bIFile.getSize(), (OutputStream)chunkedOutputStream);
                            }
                            finally {
                                try {
                                    inputStream.close();
                                }
                                catch (Exception exception) {}
                                try {
                                    ((OutputStream)chunkedOutputStream).close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        return;
                    }
                    taskListenerClient.handleMessage(foxMessage2);
                }
            }
            finally {
                taskListenerClient.close();
            }
        }
        throw new IllegalArgumentException("Installable is not a local file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstallable(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:registerInstallable");
        }
        try {
            String string = foxMessage.getString("name");
            String string2 = foxMessage.getString("fileName");
            BVersion bVersion = (BVersion)DecoderFactory.decode((FoxMessage)foxMessage, (String)"version", null);
            BTypeSpec bTypeSpec = (BTypeSpec)DecoderFactory.decode((FoxMessage)foxMessage, (String)"typeSpec", null);
            BInstallable bInstallable = LocalInstallableRegistry.getInstance().findInstallable(string, bVersion.getVendorVersion(), bTypeSpec.getResolvedType(), (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
            FoxMessage foxMessage2 = new FoxMessage();
            if (bInstallable == null) {
                foxMessage2.add("type", "status");
                foxMessage2.add("status", "continue");
                foxCircuit.writeMessage(foxMessage2);
                foxCircuit.flush();
                LocalInstallableRegistry.getInstance().register(string, string2, bVersion, (InputStream)new ChunkedInputStream(foxCircuit), null);
            } else {
                foxMessage2.add("type", "status");
                foxMessage2.add("status", "duplicate");
                foxCircuit.writeMessage(foxMessage2);
                foxCircuit.flush();
            }
        }
        finally {
            foxCircuit.close();
        }
    }

    public ClosableCursor getInstallables(boolean bl, boolean bl2, DaemonSessionTaskListener daemonSessionTaskListener, String string, String string2) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getInstallables");
        }
        FoxCircuit foxCircuit = this.openCircuit("getInstallables");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("latestOnly", bl);
        foxMessage.add("sendSpec", bl2);
        if (string != null) {
            foxMessage.add("includes", string);
        }
        if (string2 != null) {
            foxMessage.add("excludes", string2);
        }
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        return new GetInstallablesCursor(foxCircuit, daemonSessionTaskListener);
    }

    public ClosableCursor getInstallables(BDependency bDependency, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getInstallables");
        }
        FoxCircuit foxCircuit = this.openCircuit("getInstallables");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("latestOnly", false);
        foxMessage.add("sendSpec", false);
        BogCodec.add((FoxMessage)foxMessage, (String)"depend", (BValue)bDependency, null);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        return new GetInstallablesCursor(foxCircuit, daemonSessionTaskListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInstallables(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:getInstallables");
        }
        boolean bl = foxMessage.getBoolean("latestOnly", false);
        boolean bl2 = foxMessage.getBoolean("sendSpec", false);
        String string = foxMessage.getString("includes", null);
        String string2 = foxMessage.getString("excludes", null);
        FoxObject foxObject = (FoxObject)foxMessage.getOptional("depend");
        try {
            ClosableCursor closableCursor = foxObject == null ? LocalInstallableRegistry.getInstance().getInstallables(bl, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit), string, string2) : LocalInstallableRegistry.getInstance().getInstallables((BDependency)DecoderFactory.decode((FoxObject)foxObject, null), (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
            try {
                BInstallable bInstallable;
                while (closableCursor.next(class$com$tridium$install$installable$BInstallable == null ? BProvisioningChannel.class$("com.tridium.install.installable.BInstallable") : class$com$tridium$install$installable$BInstallable)) {
                    bInstallable = (BInstallable)closableCursor.get();
                    FoxMessage foxMessage2 = new FoxMessage();
                    if (bl2) {
                        foxMessage2.add("type", "spec");
                        BogCodec.add((FoxMessage)foxMessage2, (String)"payload", (BValue)BInstallableSpec.make((BInstallable)bInstallable), null);
                    } else {
                        foxMessage2.add("type", "installable");
                        BogCodec.add((FoxMessage)foxMessage2, (String)"payload", (BValue)bInstallable, null);
                    }
                    foxCircuit.writeMessage(foxMessage2);
                    foxCircuit.flush();
                }
                bInstallable = new FoxMessage();
                bInstallable.add("type", "end");
                foxCircuit.writeMessage((FoxMessage)bInstallable);
                foxCircuit.flush();
            }
            finally {
                closableCursor.close();
            }
        }
        finally {
            foxCircuit.close();
        }
    }

    public BInstallable[] findInstallables(BDependency bDependency, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:findInstallable");
        }
        FoxCircuit foxCircuit = this.openCircuit("findInstallables");
        FoxMessage foxMessage = new FoxMessage();
        BogCodec.add((FoxMessage)foxMessage, (String)"depend", (BValue)bDependency, null);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        TaskListenerClient taskListenerClient = new TaskListenerClient(daemonSessionTaskListener);
        Array array = new Array(class$com$tridium$install$installable$BInstallable == null ? (class$com$tridium$install$installable$BInstallable = BProvisioningChannel.class$("com.tridium.install.installable.BInstallable")) : class$com$tridium$install$installable$BInstallable);
        try {
            while (true) {
                FoxMessage foxMessage2;
                if (taskListenerClient.handleMessage(foxMessage2 = foxCircuit.readMessage())) continue;
                String string = foxMessage2.getString("type");
                if (string.equals("result")) {
                    array.add(DecoderFactory.decode((FoxMessage)foxMessage2, (String)"payload", null));
                    continue;
                }
                if (!string.equals("end")) continue;
                BInstallable[] bInstallableArray = (BInstallable[])array.trim();
                return bInstallableArray;
            }
        }
        finally {
            taskListenerClient.close();
            foxCircuit.close();
        }
    }

    public void findInstallables(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage;
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:findInstallables");
        }
        BDependency bDependency = (BDependency)DecoderFactory.decode((FoxMessage)foxMessage2, (String)"depend", null);
        BInstallable[] bInstallableArray = LocalInstallableRegistry.getInstance().findInstallables(bDependency, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        for (int i = 0; i < bInstallableArray.length; ++i) {
            foxMessage = new FoxMessage();
            foxMessage.add("type", "result");
            BogCodec.add((FoxMessage)foxMessage, (String)"payload", (BValue)bInstallableArray[i], null);
            foxCircuit.writeMessage(foxMessage);
        }
        foxMessage = new FoxMessage();
        foxMessage.add("type", "end");
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        foxCircuit.close();
    }

    public BInstallable findInstallable(BDependency bDependency, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:findInstallable");
        }
        FoxCircuit foxCircuit = this.openCircuit("findInstallable");
        FoxMessage foxMessage = new FoxMessage();
        BogCodec.add((FoxMessage)foxMessage, (String)"depend", (BValue)bDependency, null);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        TaskListenerClient taskListenerClient = new TaskListenerClient(daemonSessionTaskListener);
        try {
            while (true) {
                FoxMessage foxMessage2;
                if (taskListenerClient.handleMessage(foxMessage2 = foxCircuit.readMessage())) continue;
                String string = foxMessage2.getString("type");
                if (string.equals("result")) {
                    BInstallable bInstallable = (BInstallable)DecoderFactory.decode((FoxMessage)foxMessage2, (String)"payload", null);
                    return bInstallable;
                }
                if (!string.equals("notFound")) continue;
                BInstallable bInstallable = null;
                return bInstallable;
            }
        }
        finally {
            taskListenerClient.close();
            foxCircuit.close();
        }
    }

    public void findInstallable(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:findInstallable");
        }
        BDependency bDependency = (BDependency)DecoderFactory.decode((FoxMessage)foxMessage, (String)"depend", null);
        BInstallable bInstallable = LocalInstallableRegistry.getInstance().findInstallable(bDependency, (DaemonSessionTaskListener)new TaskDispatcher(foxCircuit));
        FoxMessage foxMessage2 = new FoxMessage();
        if (bInstallable == null) {
            foxMessage2.add("type", "notFound");
        } else {
            foxMessage2.add("type", "result");
            BogCodec.add((FoxMessage)foxMessage2, (String)"payload", (BValue)bInstallable, null);
        }
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
        foxCircuit.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ChunkedOutputStream
    extends OutputStream {
        private FoxCircuit circuit;
        private byte[] buf = new byte[Fox.circuitChunkSize - 256];
        private int n;

        public ChunkedOutputStream(FoxCircuit foxCircuit) {
            this.circuit = foxCircuit;
        }

        public void write(int n) throws IOException {
            this.buf[this.n++] = (byte)(0xFF & n);
            if (this.n >= this.buf.length) {
                this.flush();
            }
        }

        public void flush() throws IOException {
            if (this.n > 0) {
                FoxMessage foxMessage = new FoxMessage();
                foxMessage.add("type", "chunk");
                foxMessage.add("chunk", this.buf, this.n);
                this.writeMessage(foxMessage);
                this.n = 0;
            }
        }

        public void close() throws IOException {
            this.flush();
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("type", "chunk");
            foxMessage.add("chunk", this.buf, 0);
            this.writeMessage(foxMessage);
            FoxMessage foxMessage2 = this.readMessage();
            this.circuit.close();
            String string = foxMessage2.getString("error", null);
            if (string != null) {
                throw new IOException(string);
            }
        }

        private FoxMessage readMessage() throws IOException {
            try {
                return this.circuit.readMessage();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }

        private void writeMessage(FoxMessage foxMessage) throws IOException {
            try {
                this.circuit.writeMessage(foxMessage);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
    }

    private static class ChunkedInputStream
    extends InputStream {
        private FoxCircuit circuit;
        private byte[] chunk = null;
        private int nextRead = -1;
        private MessageClient[] messageClients;

        public ChunkedInputStream(FoxCircuit foxCircuit) {
            this(foxCircuit, new MessageClient[0]);
        }

        public ChunkedInputStream(FoxCircuit foxCircuit, MessageClient[] messageClientArray) {
            this.circuit = foxCircuit;
            this.messageClients = messageClientArray;
        }

        public int read() throws IOException {
            int n = this.available();
            if (n <= 0) {
                return -1;
            }
            byte by = this.chunk[this.nextRead];
            ++this.nextRead;
            return by;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.available();
            if (n3 <= 0) {
                return -1;
            }
            int n4 = n2 > n3 ? n3 : n2;
            System.arraycopy(this.chunk, this.nextRead, byArray, n, n4);
            this.nextRead += n4;
            return n4;
        }

        public int available() throws IOException {
            try {
                if (this.chunk == null || this.nextRead >= this.chunk.length) {
                    boolean bl = true;
                    FoxMessage foxMessage = null;
                    block4: while (bl) {
                        bl = false;
                        foxMessage = this.circuit.readMessage();
                        for (int i = 0; i < this.messageClients.length; ++i) {
                            if (!this.messageClients[i].handleMessage(foxMessage)) continue;
                            bl = true;
                            continue block4;
                        }
                    }
                    this.chunk = foxMessage.getBlob("chunk");
                    this.nextRead = 0;
                }
                return this.chunk.length - this.nextRead;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public void close() throws IOException {
            try {
                this.circuit.writeMessage(new FoxMessage());
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    private static class ValueCursor
    implements ClosableCursor {
        private FoxCircuit circuit;
        private BValue currentValue;
        private MessageClient[] messageClients;

        public ValueCursor(FoxCircuit foxCircuit) {
            this(foxCircuit, new MessageClient[0]);
        }

        public ValueCursor(FoxCircuit foxCircuit, MessageClient[] messageClientArray) {
            this.circuit = foxCircuit;
            this.messageClients = messageClientArray;
        }

        public Context getContext() {
            return null;
        }

        public boolean next() {
            String string;
            if (this.circuit == null) {
                return false;
            }
            FoxMessage foxMessage = null;
            try {
                boolean bl = true;
                block6: while (bl) {
                    bl = false;
                    foxMessage = this.circuit.readMessage();
                    for (int i = 0; i < this.messageClients.length; ++i) {
                        if (!this.messageClients[i].handleMessage(foxMessage)) continue;
                        bl = true;
                        continue block6;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            try {
                string = foxMessage.getString("type");
                if (string.equals("end")) {
                    return false;
                }
                if (string.equals("item")) {
                    this.currentValue = (BValue)DecoderFactory.decode((FoxMessage)foxMessage, (String)"payload", null);
                    return true;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            throw new IllegalStateException("bad response type: " + string);
        }

        public boolean nextComponent() {
            return this.next(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BProvisioningChannel.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        }

        public boolean next(Class clazz) {
            while (this.next()) {
                if (!clazz.isAssignableFrom(this.currentValue.getClass())) continue;
                return true;
            }
            return false;
        }

        public BObject get() {
            return this.currentValue;
        }

        public void close() {
            if (this.circuit != null) {
                this.circuit.close();
                this.circuit = null;
            }
            for (int i = 0; i < this.messageClients.length; ++i) {
                this.messageClients[i].close();
            }
        }
    }

    public static class TaskDispatcher
    implements DaemonSessionTaskListener {
        private FoxCircuit circuit;

        public TaskDispatcher(FoxCircuit foxCircuit) {
            this.circuit = foxCircuit;
        }

        public void taskStarted(DaemonSessionTask daemonSessionTask) {
            try {
                FoxMessage foxMessage = new FoxMessage();
                foxMessage.add("type", "taskStatus");
                foxMessage.add("id", "started");
                foxMessage.add("title", daemonSessionTask.getTitle());
                foxMessage.add("message", daemonSessionTask.getMessage());
                foxMessage.add("total", daemonSessionTask.getTotal());
                foxMessage.add("immediate", daemonSessionTask.isImmediate());
                this.circuit.writeMessage(foxMessage);
                this.circuit.flush();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public synchronized void taskUpdated(DaemonSessionTask daemonSessionTask) {
            try {
                FoxMessage foxMessage = new FoxMessage();
                foxMessage.add("type", "taskStatus");
                foxMessage.add("id", "updated");
                foxMessage.add("immediate", daemonSessionTask.isImmediate());
                foxMessage.add("progress", daemonSessionTask.getProgress());
                foxMessage.add("message", daemonSessionTask.getMessage());
                this.circuit.writeMessage(foxMessage);
                this.circuit.flush();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public void taskFinished(DaemonSessionTask daemonSessionTask) {
            try {
                FoxMessage foxMessage = new FoxMessage();
                foxMessage.add("type", "taskStatus");
                foxMessage.add("id", "updated");
                foxMessage.add("immediate", daemonSessionTask.isImmediate());
                foxMessage.add("progress", daemonSessionTask.getProgress());
                foxMessage.add("message", daemonSessionTask.getMessage());
                this.circuit.writeMessage(foxMessage);
                this.circuit.flush();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }

    private static class GetInstallablesCursor
    implements ClosableCursor {
        private FoxCircuit circuit;
        private MessageClient[] messageClients;
        private BObject current = null;

        public GetInstallablesCursor(FoxCircuit foxCircuit, DaemonSessionTaskListener daemonSessionTaskListener) {
            this(foxCircuit, new MessageClient[]{new TaskListenerClient(daemonSessionTaskListener)});
        }

        public GetInstallablesCursor(FoxCircuit foxCircuit, MessageClient[] messageClientArray) {
            this.messageClients = messageClientArray;
            this.circuit = foxCircuit;
        }

        public Context getContext() {
            return null;
        }

        public boolean next() {
            try {
                FoxMessage foxMessage;
                String string;
                do {
                    foxMessage = null;
                    boolean bl = true;
                    block4: while (bl) {
                        bl = false;
                        foxMessage = this.circuit.readMessage();
                        for (int i = 0; i < this.messageClients.length; ++i) {
                            if (!this.messageClients[i].handleMessage(foxMessage)) continue;
                            bl = true;
                            continue block4;
                        }
                    }
                    string = foxMessage.getString("type");
                    if (!string.equals("end")) continue;
                    this.close();
                    return false;
                } while (!string.equals("installable") && !string.equals("spec"));
                this.current = (BObject)DecoderFactory.decode((FoxMessage)foxMessage, (String)"payload", null);
                return true;
            }
            catch (RuntimeException runtimeException) {
                this.close();
                throw runtimeException;
            }
            catch (Exception exception) {
                this.close();
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public boolean nextComponent() {
            return this.next(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BProvisioningChannel.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        }

        public boolean next(Class clazz) {
            while (this.next()) {
                if (!clazz.isAssignableFrom(this.current.getClass())) continue;
                return true;
            }
            this.close();
            return false;
        }

        public BObject get() {
            return this.current;
        }

        public void close() {
            this.circuit.close();
            for (int i = 0; i < this.messageClients.length; ++i) {
                this.messageClients[i].close();
            }
        }
    }

    private static class TaskListenerClient
    implements MessageClient {
        public DaemonSessionTask task = null;
        public DaemonSessionTaskListener listener;

        public TaskListenerClient(DaemonSessionTaskListener daemonSessionTaskListener) {
            this.listener = daemonSessionTaskListener == null ? DaemonSessionTaskListener.NULL_TASK_LISTENER : daemonSessionTaskListener;
        }

        public boolean handleMessage(FoxMessage foxMessage) throws Exception {
            String string = foxMessage.getString("type");
            if (string.equals("taskStatus")) {
                String string2 = foxMessage.getString("id");
                if (string2.equals("started")) {
                    this.task = new DaemonSessionTask(foxMessage.getString("title"), foxMessage.getString("message"), foxMessage.getInt("total"));
                    this.task.setImmediate(foxMessage.getBoolean("immediate"));
                    this.listener.taskStarted(this.task);
                } else if (string2.equals("updated")) {
                    if (this.task != null) {
                        this.task.setImmediate(foxMessage.getBoolean("immediate"));
                        this.task.setProgress(foxMessage.getInt("progress"));
                        this.task.setMessage(foxMessage.getString("message"));
                        this.listener.taskUpdated(this.task);
                    }
                } else if (string2.equals("finished") && this.task != null) {
                    this.listener.taskFinished(this.task);
                    this.task = null;
                }
                return true;
            }
            return false;
        }

        public void close() {
            if (this.task != null) {
                this.listener.taskFinished(this.task);
            }
        }
    }

    private static interface MessageClient {
        public boolean handleMessage(FoxMessage var1) throws Exception;

        public void close();
    }
}

