/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioning;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonSessionListener;
import com.tridium.platform.daemon.NiagaraPlatformDaemon;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.provisioning.BPlatformWorker;
import com.tridium.provisioning.BProvisioningService;
import com.tridium.provisioning.BProvisioningStationExt;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.naming.BHost;
import javax.baja.platform.PlatformDaemon;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public class BPlatformConnection
extends BDeviceExt
implements BIMixIn,
BIPingable,
DaemonSessionListener {
    public static final Property status = BPlatformConnection.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property faultCause = BPlatformConnection.newProperty((int)3, (String)"", null);
    public static final Property port = BPlatformConnection.newProperty((int)0, (int)3011, null);
    public static final Property credentials = BPlatformConnection.newProperty((int)0, (BValue)new BUsernameAndPassword("", ""), null);
    public static final Property health = BPlatformConnection.newProperty((int)65, (BValue)new BPingHealth(), null);
    public static final Property alarmSourceInfo = BPlatformConnection.newProperty((int)0, (BValue)BPlatformConnection.initAlarmSourceInfo(), null);
    public static final Property worker = BPlatformConnection.newProperty((int)4, (BValue)new BPlatformWorker(), null);
    public static final Action ping = BPlatformConnection.newAction((int)16, null);
    public static final Action ackAlarm = BPlatformConnection.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$provisioning$BPlatformConnection == null ? (class$com$tridium$provisioning$BPlatformConnection = BPlatformConnection.class$("com.tridium.provisioning.BPlatformConnection")) : class$com$tridium$provisioning$BPlatformConnection));
    private static final BIcon icon = BIcon.std((String)"connection.png");
    static final int FATAL_FAULT = 1;
    private BDaemonSession daemonSession = null;
    private Object sessionMonitor = new Byte(0);
    private int flags = 0;
    private int oldStatus = -1;
    private boolean pingActive = false;
    static /* synthetic */ Class class$com$tridium$provisioning$BPlatformConnection;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public BUsernameAndPassword getCredentials() {
        return (BUsernameAndPassword)this.get(credentials);
    }

    public void setCredentials(BUsernameAndPassword bUsernameAndPassword) {
        this.set(credentials, (BValue)bUsernameAndPassword, null);
    }

    public BPingHealth getHealth() {
        return (BPingHealth)this.get(health);
    }

    public void setHealth(BPingHealth bPingHealth) {
        this.set(health, (BValue)bPingHealth, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo bAlarmSourceInfo) {
        this.set(alarmSourceInfo, (BValue)bAlarmSourceInfo, null);
    }

    public BPlatformWorker getWorker() {
        return (BPlatformWorker)this.get(worker);
    }

    public void setWorker(BPlatformWorker bPlatformWorker) {
        this.set(worker, (BValue)bPlatformWorker, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context context) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("PlatformConnection");
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNiagaraStation;
    }

    public void started() throws Exception {
        Slot slot = this.getSlot("pingTrigger");
        if (slot == null) {
            this.linkTo("pingTrigger", (BComponent)this.getNiagaraStation(), (Slot)BNiagaraStation.ping, (Slot)ping);
        }
        this.checkFatalFault();
        this.updateStatus();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == port || property == credentials) {
            this.reset();
            if (property == credentials) {
                this.clearFault();
                this.updateStatus();
            }
        } else if (property == status) {
            BNiagaraStation bNiagaraStation = this.getNiagaraStation();
            BDeviceExt[] bDeviceExtArray = bNiagaraStation.getDeviceExts();
            for (int i = 0; i < bDeviceExtArray.length; ++i) {
                if (!(bDeviceExtArray[i] instanceof BProvisioningStationExt)) continue;
                try {
                    bDeviceExtArray[i].updateStatus();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == ping) {
            Object object = this.sessionMonitor;
            synchronized (object) {
                if (!this.pingActive) {
                    this.pingActive = true;
                    return this.getWorker().postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
                }
            }
            return null;
        }
        return super.post(action, bValue, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPing() {
        try {
            if (this.isUnoperational()) {
                return;
            }
            try {
                this.getDaemonSession();
                this.daemonSession.connect();
                this.daemonSession.sendMessages(new XmlResponseMessage[0], BDaemonSession.DEFAULT_TIMEOUT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            Object object = this.sessionMonitor;
            synchronized (object) {
                this.pingActive = false;
            }
        }
    }

    public BPingMonitor getMonitor() {
        return this.getNetwork().getMonitor();
    }

    public void pingOk() {
        this.getHealth().pingOk();
        this.clearFault();
    }

    public void pingFail(String string) {
        this.getHealth().pingFail(string);
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        return this.getHealth().doAckAlarm(bAlarmRecord);
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo bAlarmSourceInfo = new BAlarmSourceInfo();
        bAlarmSourceInfo.setSourceName(BFormat.make((String)"%parent.parent.parent.displayName% %parent.parent.displayName% %parent.displayName%"));
        bAlarmSourceInfo.setToOffnormalText(BFormat.make((String)"%lexicon(driver:pingFail)%"));
        bAlarmSourceInfo.setToNormalText(BFormat.make((String)"%lexicon(driver:pingSuccess)%"));
        return bAlarmSourceInfo;
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    protected void setFault(String string) {
        if (!this.getStatus().isFault()) {
            int n = this.getStatus().getBits();
            this.setFaultCause(string);
            this.setStatus(BStatus.make((int)(n |= 2)));
        }
    }

    protected void clearFault() {
        if (!this.fatalFault() && this.getStatus().isFault() && !this.getNiagaraStation().isFault()) {
            int n = this.getStatus().getBits();
            this.setFaultCause("");
            this.setStatus(BStatus.make((int)(n &= 0xFFFFFFFD)));
        }
    }

    public final boolean isUnoperational() {
        return this.isDown() || this.isFatalFault() || this.isDisabled();
    }

    public final boolean isFatalFault() {
        return this.fatalFault();
    }

    private void checkFatalFault() {
        if (this.fatalFault()) {
            return;
        }
        try {
            BProvisioningService bProvisioningService = (BProvisioningService)Sys.getService((Type)BProvisioningService.TYPE);
            if (bProvisioningService.isFatalFault()) {
                this.fatalFault(true);
                this.setFaultCause("Provisioning service fault: " + bProvisioningService.getFaultCause());
                return;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        if (this.getNiagaraStation() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
            return;
        }
        if (this.getNiagaraStation().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
            return;
        }
        if (this.getNiagaraNetwork() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraNetwork");
            return;
        }
        if (this.getNiagaraNetwork().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Network fault: " + this.getNiagaraNetwork().getFaultCause());
            return;
        }
    }

    public BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getDevice();
    }

    public BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getNetwork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BDaemonSession getDaemonSession() throws Exception {
        if (!this.isRunning()) {
            return null;
        }
        Object object = this.sessionMonitor;
        synchronized (object) {
            if (this.daemonSession != null && !this.getNiagaraStation().getRemoteHost().equals((Object)this.daemonSession.getHost())) {
                this.reset();
            }
            if (this.daemonSession == null) {
                try {
                    this.daemonSession = BDaemonSession.make((BHost)this.getNiagaraStation().getRemoteHost(), (int)this.getPort());
                    this.daemonSession.addListener((DaemonSessionListener)this);
                    this.daemonSession.setCredentials((BICredentials)this.getCredentials(), true);
                    this.daemonSession.connect();
                }
                catch (AuthenticationException authenticationException) {
                    this.daemonSession = null;
                }
            }
            return this.daemonSession;
        }
    }

    public PlatformDaemon getPlatformDaemon() throws Exception {
        return NiagaraPlatformDaemon.make((BDaemonSession)this.getDaemonSession(), null);
    }

    public void reset() {
        if (this.daemonSession != null) {
            try {
                this.daemonSession.removeListener((DaemonSessionListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.daemonSession = null;
    }

    public void sessionConnected(BDaemonSession bDaemonSession) {
        this.pingOk();
    }

    public void sessionDisconnected(BDaemonSession bDaemonSession) {
        this.getHealth().setDown(true);
        this.updateStatus();
    }

    public void sessionConnectionError(BDaemonSession bDaemonSession, Throwable throwable) {
        if (throwable instanceof AuthenticationException) {
            this.pingFail("Authentication Failed");
            this.setFault("Authentication Failed");
        } else {
            this.clearFault();
            this.pingFail(throwable.toString());
        }
    }

    public void updateStatus() {
        BStatus bStatus;
        int n = this.getStatus().getBits();
        BNiagaraStation bNiagaraStation = this.getNiagaraStation();
        if (bNiagaraStation == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
        }
        if (this.getCredentials().getUsername().trim().length() == 0) {
            n |= 2;
            this.setFaultCause("Missing user name");
        }
        BStatus bStatus2 = bNiagaraStation == null ? BStatus.ok : bNiagaraStation.getStatus();
        BProvisioningService bProvisioningService = null;
        try {
            bProvisioningService = (BProvisioningService)Sys.getService((Type)BProvisioningService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        BStatus bStatus3 = bStatus = bProvisioningService == null ? BStatus.ok : bProvisioningService.getStatus();
        n = bStatus2.isDisabled() || bStatus.isDisabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        if (this.fatalFault()) {
            n |= 2;
        } else if (bProvisioningService == null) {
            n |= 2;
            this.setFaultCause("No provisioning service");
        } else if (bStatus2.isFault()) {
            n |= 2;
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
        }
        if (this.oldStatus == n) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 502) {
            return this.getNiagaraStation().fw(n, object, object2, object3, object4);
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public BIcon getIcon() {
        return icon;
    }

    private boolean fatalFault() {
        return (this.flags & 1) != 0;
    }

    private void fatalFault(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

