/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui.batch;

import com.tridium.program.BCode;
import com.tridium.program.BRobotCode;
import com.tridium.program.BRobotResult;
import com.tridium.program.ui.Compiler;
import com.tridium.program.ui.batch.BBatchEditor;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.sys.BComponent;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;

class BatchCompiler
extends Compiler {
    private BBatchEditor editor;
    private String method;
    private BRobotCode code = new BRobotCode();
    String source;

    BatchCompiler(BBatchEditor bBatchEditor, String string) {
        super((BWidget)bBatchEditor);
        this.editor = bBatchEditor;
        this.method = string;
    }

    public void generateCode(String string) throws Exception {
        String string2 = "import java.util.*;\nimport javax.baja.data.*;\nimport javax.baja.io.*;\nimport javax.baja.naming.*;\nimport javax.baja.sys.*;\nimport javax.baja.util.*;\nimport com.tridium.program.*;\nimport com.tridium.program.ui.batch.*;\n\npublic class " + string + "\n" + "  extends BatchRobot\n" + "{\n" + "\n" + "  public void run()\n" + "    throws Exception\n" + "  {\n" + "    for (int i=0; i<ords.length; i++)\n" + "    {\n" + "      BOrd ord = BOrd.make(ords[i]);\n";
        string2 = string2 + this.method + "\n";
        string2 = string2 + "    }\n  }\n\n  String[] ords = {\n";
        int n = this.editor.table.model.getRowCount();
        for (int i = 0; i < n; ++i) {
            BComponent bComponent = (BComponent)this.editor.table.model.kids.get(i);
            string2 = string2 + "    \"station:|slot:" + bComponent.getSlotPath().getBody() + "\"";
            if (i < n - 1) {
                string2 = string2 + ",";
            }
            string2 = string2 + "\n";
        }
        this.source = string2 = string2 + "  };\n}\n";
    }

    public void compile() throws Exception {
        String string = BCode.generateClassName();
        this.generateCode(string);
        this.code.setDependencies("baja;program");
        this.compile(string, this.code, this.source);
    }

    public BConsole openConsole() {
        return ((BNiagaraWbShell)this.editor.getShell()).getConsole();
    }

    public void compileSuccess(BConsole bConsole) throws Exception {
        super.compileSuccess(bConsole);
        this.run();
    }

    public void run() {
        BRobotResult bRobotResult = this.editor.service.runRobot(this.code);
        this.editor.table.refresh();
        BTextEditor bTextEditor = new BTextEditor(bRobotResult.getLog(), false);
        BTextEditorPane bTextEditorPane = new BTextEditorPane(bTextEditor, 20, 100);
        BDialog.open((BWidget)this.editor, (String)"BatchEditor Results", (Object)bTextEditorPane, (int)1);
    }
}

