/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui.batch;

import com.tridium.program.ui.batch.BBatchEditor;
import com.tridium.program.ui.batch.BatchCommands;
import com.tridium.script.PropertyField;
import com.tridium.script.ScriptField;
import com.tridium.script.ScriptUtil;
import com.tridium.workbench.user.BPermissionsMapFE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BBatchTable
extends BTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$program$ui$batch$BBatchTable == null ? (class$com$tridium$program$ui$batch$BBatchTable = BBatchTable.class$("com.tridium.program.ui.batch.BBatchTable")) : class$com$tridium$program$ui$batch$BBatchTable));
    private Lexicon lex = Lexicon.make((String)"program");
    BBatchEditor editor;
    Model model;
    static /* synthetic */ Class class$com$tridium$program$ui$batch$BBatchTable;

    public Type getType() {
        return TYPE;
    }

    public BBatchTable(BBatchEditor bBatchEditor) {
        this.editor = bBatchEditor;
        this.model = new Model();
        this.setModel(this.model);
        this.setSelection(new Selection());
        this.setController(new Controller());
        this.setPasteEnabled(true);
    }

    public void refresh() {
        BatchCommands.lease(this.model.kids.toArray(new BComponent[this.model.kids.size()]));
        this.relayout();
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        if (tableModel instanceof Model) {
            this.model = (Model)tableModel;
        }
    }

    public int dragOver(TransferContext transferContext) {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        BObject[] bObjectArray = mark.getValues();
        for (int i = 0; i < bObjectArray.length; ++i) {
            if (!(bObjectArray[i] instanceof BComponent)) continue;
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        BObject[] bObjectArray = mark.getValues();
        ArrayList<BObject> arrayList = new ArrayList<BObject>();
        for (int i = 0; i < bObjectArray.length; ++i) {
            if (!(bObjectArray[i] instanceof BComponent) || this.model.kids.contains(bObjectArray[i])) continue;
            arrayList.add(bObjectArray[i]);
            this.model.kids.add(bObjectArray[i]);
        }
        BatchCommands.lease(arrayList.toArray(new BComponent[arrayList.size()]));
        this.sizeColumnsToFit();
        this.relayout();
        this.editor.commands.updateCommands();
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        return this.drop(transferContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
            if (bKeyEvent.getKeyCode() == 127) {
                bKeyEvent.consume();
                BBatchTable.this.editor.commands.clear.invoke();
            } else {
                super.keyPressed(bKeyEvent);
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = BBatchTable.this.editor.commands.buildMenu();
            bMenu.open((BWidget)this.getTable(), bMouseEvent.getX(), bMouseEvent.getY());
        }

        protected void backgroundPopup(BMouseEvent bMouseEvent) {
            BMenu bMenu = BBatchTable.this.editor.commands.buildMenu();
            bMenu.open((BWidget)this.getTable(), bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BBatchTable.this.editor.commands.updateCommands();
        }
    }

    class Model
    extends TableModel {
        ArrayList cols = new ArrayList();
        ArrayList kids = new ArrayList();
        HashMap hash = new HashMap();

        private Model() {
            this.cols.add(BBatchTable.this.lex.getText("batchEditor.object"));
        }

        public int getColumnCount() {
            return this.cols.size();
        }

        public String getColumnName(int n) {
            return (String)this.cols.get(n);
        }

        public int getRowCount() {
            return this.kids.size();
        }

        public Object getValueAt(int n, int n2) {
            BComponent bComponent = (BComponent)this.kids.get(n);
            if (n2 == 0) {
                return SlotPath.unescape((String)bComponent.getSlotPath().getBody());
            }
            BValue bValue = bComponent.get((String)this.cols.get(n2));
            return bValue == null ? "n/a" : String.valueOf(bValue);
        }

        public BImage getRowIcon(int n) {
            BImage bImage = (BImage)this.hash.get(this.kids.get(n));
            if (bImage == null) {
                Object e = this.kids.get(n);
                bImage = BImage.make((BIcon)((BObject)e).getIcon());
                this.hash.put(e, bImage);
            }
            return bImage;
        }

        public String[] getAllColumns() {
            return this.getAllColumns(true);
        }

        public String[] getAllColumns(boolean bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.kids.size(); ++i) {
                ScriptField[] scriptFieldArray = ScriptUtil.scriptFields(this.kids.get(i));
                for (int j = 0; j < scriptFieldArray.length; ++j) {
                    boolean bl2;
                    if (!scriptFieldArray[j].isProperty() || arrayList.contains(scriptFieldArray[j].scriptName()) || (scriptFieldArray[j].scriptFlags(this.kids.get(i)) & 1) != 0 || (scriptFieldArray[j].scriptType().getModifiers() & 0x400) != 0) continue;
                    boolean bl3 = bl2 = scriptFieldArray[j].isProperty() && ((PropertyField)scriptFieldArray[j]).getProperty().isFrozen();
                    if (!bl && (bl || bl2)) continue;
                    arrayList.add(scriptFieldArray[j].scriptName());
                }
            }
            Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
            Arrays.sort(objectArray);
            return objectArray;
        }

        public Class getColumnType(String string) {
            for (int i = 0; i < this.kids.size(); ++i) {
                ScriptField[] scriptFieldArray = ScriptUtil.scriptFields(this.kids.get(i));
                for (int j = 0; j < scriptFieldArray.length; ++j) {
                    if (!string.equals(scriptFieldArray[j].scriptName())) continue;
                    return scriptFieldArray[j].scriptType();
                }
            }
            return null;
        }

        public BWbFieldEditor getColumnEditor(String string) {
            for (int i = 0; i < this.kids.size(); ++i) {
                ScriptField[] scriptFieldArray = ScriptUtil.scriptFields(this.kids.get(i));
                for (int j = 0; j < scriptFieldArray.length; ++j) {
                    BWbFieldEditor bWbFieldEditor;
                    if (!string.equals(scriptFieldArray[j].scriptName())) continue;
                    Context context = null;
                    BObject bObject = null;
                    if (this.kids.get(i) instanceof BComponent && (bWbFieldEditor = ((BComponent)this.kids.get(i)).getSlot(scriptFieldArray[j].scriptName())) != null && bWbFieldEditor.isProperty()) {
                        context = bWbFieldEditor.asProperty().getFacets();
                        bObject = bWbFieldEditor.asProperty().getDefaultValue();
                    }
                    if (bObject == null) {
                        bObject = Sys.getType((Class)scriptFieldArray[j].scriptType()).getInstance();
                    }
                    if ((bWbFieldEditor = BWbFieldEditor.makeFor(bObject, context)) instanceof BPermissionsMapFE && (context == null || context.getFacets().isNull())) {
                        context = BBatchTable.this.editor.getCurrentContext();
                    }
                    bWbFieldEditor.loadValue(bObject, context);
                    return bWbFieldEditor;
                }
            }
            return null;
        }

        public Model makeCopy() {
            int n;
            ArrayList<BComponent> arrayList = new ArrayList<BComponent>();
            Model model = new Model();
            for (n = 1; n < this.cols.size(); ++n) {
                model.cols.add(this.cols.get(n));
            }
            for (n = 0; n < this.kids.size(); ++n) {
                BComponent bComponent = (BComponent)this.kids.get(n);
                if (!bComponent.isMounted()) continue;
                arrayList.add(bComponent);
                model.kids.add(bComponent);
            }
            BatchCommands.lease(arrayList.toArray(new BComponent[arrayList.size()]));
            return model;
        }
    }
}

