/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.BProgram;
import com.tridium.program.BProgramCode;
import com.tridium.program.ui.BProgramEditor;
import com.tridium.program.ui.Imports;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.util.BWsAnnotation;

public class SourceWriter
extends PrintWriter {
    public BProgramEditor editor;
    public BProgram program;
    public BProgramCode code;
    public Imports.Import[] imports;
    private Property[] accessProps;
    private int line;
    public int sourceLine;

    public static char[] generateToCharArray(BProgramEditor bProgramEditor, String string) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        new SourceWriter((Writer)charArrayWriter, bProgramEditor).generate(string);
        return charArrayWriter.toCharArray();
    }

    public SourceWriter(Writer writer, BProgramEditor bProgramEditor) {
        super(writer);
        this.init(bProgramEditor);
    }

    public SourceWriter(OutputStream outputStream, BProgramEditor bProgramEditor) {
        super(outputStream);
        this.init(bProgramEditor);
    }

    private void init(BProgramEditor bProgramEditor) {
        this.editor = bProgramEditor;
        this.program = bProgramEditor.program;
        this.code = bProgramEditor.code;
        this.sourceLine = 0;
        this.imports = bProgramEditor.imports.getAll();
        this.accessProps = this.getAccessProperties();
    }

    private Property[] getAccessProperties() {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        SlotCursor slotCursor = this.program.getProperties();
        while (slotCursor.next()) {
            BObject bObject;
            Property property = slotCursor.property();
            if (property.isFrozen() || (bObject = slotCursor.get()) instanceof BWsAnnotation || bObject instanceof BLink || bObject instanceof BAction || bObject instanceof BTopic) continue;
            arrayList.add(property);
        }
        return arrayList.toArray(new Property[arrayList.size()]);
    }

    public void generate(String string) {
        this.generateHeader(string);
        this.generateGetters();
        this.generateSetters();
        this.generateSource();
        this.generateFooter();
        this.editor.sourceLine = this.sourceLine;
        this.flush();
    }

    private void generateHeader(String string) {
        BModule bModule = Sys.getModuleForClass(this.getClass());
        this.w("/* Auto-generated ProgramImpl Code */");
        this.w("");
        for (int i = 0; i < this.imports.length; ++i) {
            this.x("import ");
            this.x(TextUtil.pad((String)(this.imports[i].packageName + ".*;"), (int)25));
            this.x(" /* ");
            this.x(this.imports[i].moduleName);
            this.x(" ");
            this.x(this.imports[i].definitionToString());
            this.w("*/");
        }
        this.w("");
        this.w("public class " + string);
        this.w("  extends com.tridium.program.ProgramBase");
        this.w("{");
    }

    private void generateGetters() {
        if (this.accessProps.length == 0) {
            return;
        }
        this.header("Getters");
        for (int i = 0; i < this.accessProps.length; ++i) {
            Property property = this.accessProps[i];
            String string = property.getName();
            BValue bValue = this.program.get(property);
            if (bValue.getType() == BBoolean.TYPE) {
                this.x("  public boolean get");
                this.x(SourceWriter.capitalize(string));
                this.x("() { return getBoolean(\"");
                this.x(string);
                this.x("\"); }");
            } else if (bValue.getType() == BInteger.TYPE) {
                this.x("  public int get");
                this.x(SourceWriter.capitalize(string));
                this.x("() { return getInt(\"");
                this.x(string);
                this.x("\"); }");
            } else if (bValue.getType() == BFloat.TYPE) {
                this.x("  public float get");
                this.x(SourceWriter.capitalize(string));
                this.x("() { return getFloat(\"");
                this.x(string);
                this.x("\"); }");
            } else if (bValue.getType() == BString.TYPE) {
                this.x("  public String get");
                this.x(SourceWriter.capitalize(string));
                this.x("() { return getString(\"");
                this.x(string);
                this.x("\"); }");
            } else if (bValue.getType() == BDouble.TYPE) {
                this.x("  public double get");
                this.x(SourceWriter.capitalize(string));
                this.x("() { return getDouble(\"");
                this.x(string);
                this.x("\"); }");
            } else if (bValue.getType() == BLong.TYPE) {
                this.x("  public long get");
                this.x(SourceWriter.capitalize(string));
                this.x("() { return getLong(\"");
                this.x(string);
                this.x("\"); }");
            } else {
                String string2 = TextUtil.getClassName(bValue.getClass());
                this.x("  public ");
                this.x(string2);
                this.x(" get");
                this.x(SourceWriter.capitalize(string));
                this.x("() { return (");
                this.x(string2);
                this.x(")get(\"");
                this.x(string);
                this.x("\"); }");
            }
            this.w("");
        }
    }

    private void generateSetters() {
        if (this.accessProps.length == 0) {
            return;
        }
        this.header("Setters");
        for (int i = 0; i < this.accessProps.length; ++i) {
            Property property = this.accessProps[i];
            String string = property.getName();
            BValue bValue = this.program.get(property);
            if (bValue.getType() == BBoolean.TYPE) {
                this.x("  public void set");
                this.x(SourceWriter.capitalize(string));
                this.x("(boolean v) { setBoolean(\"");
                this.x(string);
                this.x("\", v); }");
            } else if (bValue.getType() == BInteger.TYPE) {
                this.x("  public void set");
                this.x(SourceWriter.capitalize(string));
                this.x("(int v) { setInt(\"");
                this.x(string);
                this.x("\", v); }");
            } else if (bValue.getType() == BFloat.TYPE) {
                this.x("  public void set");
                this.x(SourceWriter.capitalize(string));
                this.x("(float v) { setFloat(\"");
                this.x(string);
                this.x("\", v); }");
            } else if (bValue.getType() == BString.TYPE) {
                this.x("  public void set");
                this.x(SourceWriter.capitalize(string));
                this.x("(String v) { setString(\"");
                this.x(string);
                this.x("\", v); }");
            } else if (bValue.getType() == BDouble.TYPE) {
                this.x("  public void set");
                this.x(SourceWriter.capitalize(string));
                this.x("(double v) { setDouble(\"");
                this.x(string);
                this.x("\", v); }");
            } else if (bValue.getType() == BLong.TYPE) {
                this.x("  public void set");
                this.x(SourceWriter.capitalize(string));
                this.x("(long v) { setLong(\"");
                this.x(string);
                this.x("\", v); }");
            } else {
                this.x("  public void set");
                this.x(SourceWriter.capitalize(string));
                this.x("(");
                this.x(bValue.getClass().getName());
                this.x(" v) { set(\"");
                this.x(string);
                this.x("\", v); }");
            }
            this.w("");
        }
    }

    private void generateSource() {
        this.header("Program Source");
        this.sourceLine = this.line;
        this.writeCode(this.code.getSource(), 2);
    }

    private void generateFooter() {
        this.w("}");
    }

    static String capitalize(String string) {
        return TextUtil.capitalize((String)string);
    }

    static String decapitalize(String string) {
        return TextUtil.decapitalize((String)string);
    }

    private void header(String string) {
        this.w("");
        this.w("////////////////////////////////////////////////////////////////");
        this.w("// " + string);
        this.w("////////////////////////////////////////////////////////////////");
        this.w("");
    }

    private void writeCode(String string, int n) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.x(TextUtil.getSpaces((int)n));
                this.w(string2);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    private void x(String string) {
        this.print(string);
    }

    private void w(String string) {
        this.print(string);
        this.print('\n');
        ++this.line;
    }
}

