/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.ui.BRobotEditor;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class RobotEditorCommands {
    static UiLexicon lex = UiLexicon.bajaui;
    public final BRobotEditor editor;
    public final Command compile;
    public final Command compileAndRun;

    public RobotEditorCommands(BRobotEditor bRobotEditor) {
        this.editor = bRobotEditor;
        this.compileAndRun = new CompileAndRunCommand();
        this.compile = new CompileCommand();
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = UiLexicon.bajaui.buildMenu("robotEditor.menu.label");
        bMenu.add("compile", this.compile);
        bMenu.add("run", this.compileAndRun);
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.editor.getShell();
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("find", bNiagaraWbShell.commands.find);
        bToolBar.add("replace", bNiagaraWbShell.commands.replace);
        bToolBar.add("sep1", (BValue)new BSeparator());
        bToolBar.add("compile", this.compile);
        bToolBar.add("run", this.compileAndRun);
        bToolBar.add("sep2", (BValue)new BSeparator());
        bToolBar.add("consolePrev", bNiagaraWbShell.commands.consolePrev);
        bToolBar.add("consoleNext", bNiagaraWbShell.commands.consoleNext);
        return bToolBar;
    }

    public class CompileAndRunCommand
    extends RobotEditorCommand {
        public CompileAndRunCommand() {
            super("robotEditor.compileAndRun");
        }

        public CommandArtifact doInvoke() throws Exception {
            RobotEditorCommands.this.editor.compiler.compile(true);
            return null;
        }
    }

    public class CompileCommand
    extends RobotEditorCommand {
        public CompileCommand() {
            super("robotEditor.compile");
        }

        public CommandArtifact doInvoke() throws Exception {
            RobotEditorCommands.this.editor.compiler.compile(false);
            return null;
        }
    }

    public class RobotEditorCommand
    extends Command {
        public RobotEditorCommand(String string) {
            super((BWidget)RobotEditorCommands.this.editor, UiLexicon.bajaui.module, string);
        }

        public CommandArtifact doInvoke() throws Exception {
            BDialog.message((BWidget)RobotEditorCommands.this.editor, (Object)("Incomplete: " + this.getLabel()));
            return null;
        }
    }
}

