/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.BCode;
import com.tridium.program.ui.BProgramEditor;
import com.tridium.program.ui.Compiler;
import com.tridium.program.ui.Imports;
import com.tridium.workbench.fieldeditors.BTypeSpecFE;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.File;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class ProgramEditorCommands {
    static UiLexicon lex = UiLexicon.bajaui;
    public final BProgramEditor editor;
    public Command importType;
    public Command importPackage;
    public Command removeImport;
    public Command saveAndCompile;
    public Command compile;
    public Command build;
    static /* synthetic */ Class class$com$tridium$program$ui$BProgramEditor;

    public ProgramEditorCommands(BProgramEditor bProgramEditor) {
        this.editor = bProgramEditor;
        this.importType = new ImportTypeCommand();
        this.importPackage = new ImportPackageCommand();
        this.removeImport = new RemoveImportCommand();
        this.saveAndCompile = new SaveAndCompileCommand();
        this.compile = new CompileCommand();
        this.build = new BuildCommand();
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = UiLexicon.bajaui.buildMenu("programEditor.menu.label");
        bMenu.add("importType", this.importType);
        bMenu.add("importPackage", this.importPackage);
        bMenu.add("importRemove", this.removeImport);
        bMenu.add("sep0", (BValue)new BSeparator());
        bMenu.add("addSlot", (Command)this.editor.slotSheet.commands.add);
        bMenu.add("deleteSlot", (Command)this.editor.slotSheet.commands.delete);
        bMenu.add("renameSlot", (Command)this.editor.slotSheet.commands.rename);
        bMenu.add("reorderSlots", (Command)this.editor.slotSheet.commands.reorder);
        bMenu.add("sep1", (BValue)new BSeparator());
        bMenu.add("saveAndCompile", this.saveAndCompile);
        bMenu.add("compile", this.compile);
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.editor.getShell();
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("find", bNiagaraWbShell.commands.find);
        bToolBar.add("replace", bNiagaraWbShell.commands.replace);
        bToolBar.add("sep2", (BValue)new BSeparator());
        if (this.editor.program.getProgramModule() != null) {
            bToolBar.add("build", this.build);
        }
        bToolBar.add("saveAndCompile", this.saveAndCompile);
        bToolBar.add("compile", this.compile);
        bToolBar.add("consolePrev", bNiagaraWbShell.commands.consolePrev);
        bToolBar.add("consoleNext", bNiagaraWbShell.commands.consoleNext);
        return bToolBar;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class BuildCommand
    extends Command {
        public BuildCommand() {
            super((BWidget)ProgramEditorCommands.this.editor, Lexicon.make((Class)(class$com$tridium$program$ui$BProgramEditor == null ? (class$com$tridium$program$ui$BProgramEditor = ProgramEditorCommands.class$("com.tridium.program.ui.BProgramEditor")) : class$com$tridium$program$ui$BProgramEditor)), "programEditor.build");
        }

        public CommandArtifact doInvoke() throws Exception {
            ProgramEditorCommands.this.editor.compiler.compile(BCode.generateClassName(), true, true);
            return null;
        }
    }

    public class SaveAndCompileCommand
    extends ProgramEditorCommand {
        public SaveAndCompileCommand() {
            super("programEditor.saveAndCompile");
        }

        public CommandArtifact doInvoke() throws Exception {
            ProgramEditorCommands.this.editor.compiler.compile(BCode.generateClassName(), true);
            return null;
        }
    }

    public class CompileCommand
    extends ProgramEditorCommand {
        public CompileCommand() {
            super("programEditor.compile");
        }

        public CommandArtifact doInvoke() throws Exception {
            ProgramEditorCommands.this.editor.compiler.compile(BCode.generateClassName(), false);
            return null;
        }
    }

    public class RemoveImportCommand
    extends ProgramEditorCommand {
        public RemoveImportCommand() {
            super("programEditor.removeImport");
        }

        public CommandArtifact doInvoke() throws Exception {
            ProgramEditorCommands.this.editor.imports.removeSelection();
            return null;
        }
    }

    public class ImportPackageCommand
    extends ProgramEditorCommand {
        public ImportPackageCommand() {
            super("programEditor.importPackage");
        }

        public CommandArtifact doInvoke() throws Exception {
            int n;
            BListDropDown bListDropDown = new BListDropDown();
            ModuleInfo[] moduleInfoArray = Sys.getRegistry().getModules();
            File file = new File(Sys.getBajaHome(), "bin");
            String[] stringArray = file.list(new Compiler.JarFilenameFilter());
            Object[] objectArray = new String[moduleInfoArray.length + stringArray.length];
            for (n = 0; n < moduleInfoArray.length; ++n) {
                objectArray[n] = moduleInfoArray[n].getModuleName();
            }
            for (n = 0; n < stringArray.length; ++n) {
                objectArray[moduleInfoArray.length + n] = stringArray[n].substring(0, stringArray[n].length() - 4);
            }
            SortUtil.sort((Object[])objectArray);
            bListDropDown.getList().addItem((Object)"java");
            for (n = 0; n < objectArray.length; ++n) {
                bListDropDown.getList().addItem(objectArray[n]);
            }
            bListDropDown.setSelectedItem((Object)"baja");
            BTextField bTextField = new BTextField("", 25);
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setColumnAlign(BHalign.fill);
            bGridPane.add(null, (BValue)new BLabel(lex.getText("programEditor.module")));
            bGridPane.add(null, (BValue)bListDropDown);
            bGridPane.add(null, (BValue)new BLabel(lex.getText("programEditor.package")));
            bGridPane.add(null, (BValue)bTextField);
            int n2 = BDialog.open((BWidget)ProgramEditorCommands.this.editor, (String)this.getLabel(), (Object)bGridPane, (int)3, (BImage)BDialog.QUESTION_ICON);
            if (n2 == 2) {
                return null;
            }
            String string = (String)bListDropDown.getSelectedItem();
            String string2 = bTextField.getText();
            if (string2.equals("")) {
                return null;
            }
            ProgramEditorCommands.this.editor.imports.add(new Imports.Import(string, string2, 1));
            return null;
        }
    }

    public class ImportTypeCommand
    extends ProgramEditorCommand {
        public ImportTypeCommand() {
            super("programEditor.importType");
        }

        public CommandArtifact doInvoke() throws Exception {
            BTypeSpecFE bTypeSpecFE = new BTypeSpecFE();
            bTypeSpecFE.loadValue((BObject)BTypeSpec.make((String)"baja", (String)"String"), (Context)BFacets.make((String)"allowNull", (BIDataValue)BBoolean.FALSE));
            int n = BDialog.open((BWidget)ProgramEditorCommands.this.editor, (String)this.getLabel(), (Object)bTypeSpecFE, (int)3, (BImage)BDialog.QUESTION_ICON);
            if (n == 2) {
                return null;
            }
            BTypeSpec bTypeSpec = (BTypeSpec)bTypeSpecFE.saveValue();
            if (bTypeSpec.getTypeName().equals("")) {
                return null;
            }
            String string = bTypeSpec.getResolvedType().getTypeClass().getName();
            String string2 = TextUtil.getPackageName((String)string);
            ProgramEditorCommands.this.editor.imports.add(new Imports.Import(bTypeSpec.getModuleName(), string2, 1));
            return null;
        }
    }

    public class ProgramEditorCommand
    extends Command {
        public ProgramEditorCommand(String string) {
            super((BWidget)ProgramEditorCommands.this.editor, UiLexicon.bajaui.module, string);
        }

        public CommandArtifact doInvoke() throws Exception {
            BDialog.message((BWidget)ProgramEditorCommands.this.editor, (Object)("Incomplete: " + this.getLabel()));
            return null;
        }
    }
}

