/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.BProgramCode;
import com.tridium.program.module.BProgramModule;
import com.tridium.program.module.BuildException;
import com.tridium.program.module.IBuildListener;
import com.tridium.program.ui.BProgramEditor;
import com.tridium.program.ui.Compiler;
import com.tridium.program.ui.SourceWriter;
import com.tridium.workbench.console.BConsole;
import java.io.FileWriter;
import java.io.Writer;
import javax.baja.ui.BWidget;

public class ProgramCompiler
extends Compiler {
    BProgramEditor editor;
    boolean saveOnSuccess;
    boolean buildOnSuccess;

    public ProgramCompiler(BProgramEditor bProgramEditor) {
        super((BWidget)bProgramEditor);
        this.editor = bProgramEditor;
    }

    public void compile(String string, boolean bl) throws Exception {
        this.compile(string, bl, false);
    }

    public void compile(String string, boolean bl, boolean bl2) throws Exception {
        this.saveOnSuccess = bl;
        this.buildOnSuccess = bl2;
        this.editor.saveCode();
        this.editor.imports.updateImports();
        this.editor.imports.save(this.editor.code);
        this.editor.updateSource();
        this.compile(string, this.editor.code, null);
    }

    public void writeSource(FileWriter fileWriter, String string) throws Exception {
        SourceWriter sourceWriter = new SourceWriter((Writer)fileWriter, this.editor);
        sourceWriter.generate(this.className);
    }

    public void compileSuccess(BConsole bConsole) throws Exception {
        super.compileSuccess(bConsole);
        BProgramCode bProgramCode = this.editor.code;
        bProgramCode.setChecksum(this.editor.computeChecksum(bProgramCode.getSource()));
        this.editor.updateProgramCode();
        this.editor.updateStatus();
        if (this.saveOnSuccess) {
            this.editor.getWbShell().getSaveCommand().invoke();
        }
        if (this.buildOnSuccess) {
            this.buildProgramModule(bConsole);
        }
    }

    public void compileFailed(BConsole bConsole) throws Exception {
        this.editor.setModified();
        this.editor.code.setChecksum(0);
        this.editor.updateStatusToError();
        super.compileFailed(bConsole);
    }

    private void buildProgramModule(BConsole bConsole) {
        BProgramModule bProgramModule = this.editor.program.getProgramModule();
        if (bProgramModule == null) {
            return;
        }
        try {
            bConsole.appendBreak();
            bProgramModule.buildModule(new BuildConsoleListener(bConsole));
        }
        catch (BuildException buildException) {
            bConsole.appendLine(buildException.getMessage());
        }
    }

    private class BuildConsoleListener
    implements IBuildListener {
        private BConsole console;

        public BuildConsoleListener(BConsole bConsole) {
            this.console = bConsole;
        }

        public BWidget getOwner() {
            return this.console;
        }

        public void nextStep(String string) {
            this.console.appendLine(string);
        }

        public void setNumBuildSteps(int n) {
        }

        public void updateDesc(String string) {
            this.console.appendLine(string);
        }
    }
}

