/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.BCode;
import com.tridium.program.BProgram;
import com.tridium.program.BProgramService;
import com.tridium.program.BRobotCode;
import com.tridium.program.BRobotResult;
import com.tridium.program.ui.Compiler;
import com.tridium.program.ui.RobotEditorCommands;
import com.tridium.workbench.console.BConsole;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.DependencyInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.parsers.JavaParser;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

public class BRobotEditor
extends BWbComponentView
implements BConsole.HyperlinkInterceptor {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$program$ui$BRobotEditor == null ? (class$com$tridium$program$ui$BRobotEditor = BRobotEditor.class$("com.tridium.program.ui.BRobotEditor")) : class$com$tridium$program$ui$BRobotEditor));
    static String defaultDepends = "baja; program";
    static String defaultCode = "// depends: " + defaultDepends + "\n" + "\n" + "import javax.baja.sys.*;\n" + "import com.tridium.program.*;\n" + "\n" + "public class RobotImpl\n" + "  extends Robot\n" + "{\n" + "\n" + "  public void run()\n" + "    throws Exception\n" + "  {\n" + "    process(Sys.getStation());\n" + "  }\n" + "\n" + "  public void process(BComponent c)\n" + "    throws Exception\n" + "  {\n" + "    // do something here\n" + "    log.println(c.toPathString() + \" [\" + c.getType() + \"]\");\n" + "    \n" + "    // recurse\n" + "    BComponent[] kids = c.getChildComponents();\n" + "    for(int i=0; i<kids.length; ++i)\n" + "      process(kids[i]);\n" + "  }\n" + "\n" + "}\n";
    static UiLexicon lex = UiLexicon.bajaui;
    RobotEditorCommands commands = new RobotEditorCommands(this);
    BProgramService service;
    BTextEditor editor;
    RobotCompiler compiler = new RobotCompiler(this);
    BRobotCode robotCode = new BRobotCode();
    static /* synthetic */ Class class$com$tridium$program$ui$BRobotEditor;

    public Type getType() {
        return TYPE;
    }

    public BRobotEditor() {
        this.editor = new BTextEditor();
        this.editor.setParser((TextParser)new JavaParser());
        this.editor.setText(defaultCode);
        this.setTransferWidget((BTransferWidget)this.editor);
        this.setCommandEnabled(6, true);
        this.setCommandEnabled(8, true);
        this.setCommandEnabled(7, true);
        this.setCommandEnabled(9, true);
        this.setCommandEnabled(10, true);
        BTextEditorPane bTextEditorPane = new BTextEditorPane(this.editor);
        this.setContent((BWidget)bTextEditorPane);
    }

    public BMenu[] getViewMenus() {
        return this.commands.getViewMenus();
    }

    public BToolBar getViewToolBar() {
        return this.commands.getViewToolBar();
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.service = (BProgramService)bObject;
    }

    public void deactivated() {
        super.deactivated();
        defaultCode = this.editor.getText();
    }

    public CommandArtifact invokeCommand(int n) throws Exception {
        switch (n) {
            case 6: {
                return this.editor.doFind();
            }
            case 8: {
                return this.editor.doFindNext();
            }
            case 7: {
                return this.editor.doFindPrev();
            }
            case 9: {
                return this.editor.doReplace();
            }
            case 10: {
                return this.editor.doGoto();
            }
        }
        return super.invokeCommand(n);
    }

    public boolean consoleHyperlink(File file, int n, int n2, int n3, int n4) {
        if (!file.equals(this.compiler.java)) {
            return false;
        }
        this.highlight(n, n2, n3, n4);
        return true;
    }

    public void highlight(int n, int n2, int n3, int n4) {
        this.highlight(this.editor, n, n2, n3, n4);
    }

    void highlight(BTextEditor bTextEditor, int n, int n2, int n3, int n4) {
        Position position = bTextEditor.getModel().getEndPosition();
        Position position2 = new Position(n - 1, n2 - 1);
        Position position3 = new Position(n3 - 1, n4);
        if (position2.compareTo((Object)position) > 0) {
            position2 = position;
        }
        if (position3.compareTo((Object)position) > 0) {
            position3 = position;
        }
        bTextEditor.getSelection().select(position2, position3);
        bTextEditor.moveCaretPosition(position3);
        bTextEditor.requestFocus();
    }

    public void run() {
        BRobotResult bRobotResult = this.service.runRobot(this.robotCode);
        BTextEditor bTextEditor = new BTextEditor(bRobotResult.getLog(), false);
        BTextEditorPane bTextEditorPane = new BTextEditorPane(bTextEditor, 20, 80);
        BDialog.open((BWidget)this, (String)"Log Output", (Object)bTextEditorPane, (int)1);
    }

    public String parseDepends(String string) throws Exception {
        if (string.startsWith("// depends:")) {
            int n = string.indexOf(58);
            int n2 = string.indexOf(10);
            if (n >= 0 && n2 >= 0) {
                CharSequence charSequence;
                HashSet hashSet = new HashSet();
                StringTokenizer stringTokenizer = new StringTokenizer(string.trim().substring(n + 1, n2), ";");
                while (stringTokenizer.hasMoreTokens()) {
                    charSequence = stringTokenizer.nextToken().trim();
                    if (((String)charSequence).length() <= 0 || BProgram.isSpecialModule((String)charSequence)) continue;
                    this.accumDepends(hashSet, (String)charSequence);
                }
                charSequence = new StringBuffer();
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    if (((StringBuffer)charSequence).length() > 0) {
                        ((StringBuffer)charSequence).append("; ");
                    }
                    ((StringBuffer)charSequence).append(iterator.next().toString());
                }
                return ((StringBuffer)charSequence).toString();
            }
        }
        return defaultDepends;
    }

    protected void accumDepends(Set set, String string) throws Exception {
        if (set.contains(string)) {
            return;
        }
        set.add(string);
        DependencyInfo[] dependencyInfoArray = Sys.getRegistry().getModule(string).getDependencies();
        for (int i = 0; i < dependencyInfoArray.length; ++i) {
            this.accumDepends(set, dependencyInfoArray[i].getModuleName());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RobotCompiler
    extends Compiler {
        boolean runOnSuccess;

        RobotCompiler(BRobotEditor bRobotEditor2) {
            super((BWidget)bRobotEditor2);
        }

        public void compile(boolean bl) throws Exception {
            this.runOnSuccess = bl;
            String string = BRobotEditor.this.editor.getText();
            String string2 = BCode.generateClassName();
            int n = string.indexOf("RobotImpl");
            if (n < 0) {
                throw new Exception("Class name must be RobotImpl");
            }
            string = TextUtil.replace((String)string, (String)"RobotImpl", (String)string2);
            BRobotEditor.this.robotCode.setDependencies(BRobotEditor.this.parseDepends(string));
            this.compile(string2, BRobotEditor.this.robotCode, string);
        }

        public void compileSuccess(BConsole bConsole) throws Exception {
            super.compileSuccess(bConsole);
            if (this.runOnSuccess) {
                BRobotEditor.this.run();
            }
        }
    }
}

