/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.BCode;
import com.tridium.program.BProgram;
import com.tridium.program.module.BProgramModule;
import com.tridium.program.module.IBuildListener;
import com.tridium.program.module.ValidateModel;
import com.tridium.program.ui.BBuilderTable;
import com.tridium.program.ui.BFieldSheet;
import com.tridium.program.ui.BProgramEditor;
import com.tridium.program.ui.Compiler;
import com.tridium.program.ui.SourceWriter;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.transfer.TransferUtil;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.util.BFolder;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;

public class BProgramModuleBuilder
extends BFolderManager {
    public static final Action handleSelection = BProgramModuleBuilder.newAction((int)4, null);
    public static final Action handleModified = BProgramModuleBuilder.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$program$ui$BProgramModuleBuilder == null ? (class$com$tridium$program$ui$BProgramModuleBuilder = BProgramModuleBuilder.class$("com.tridium.program.ui.BProgramModuleBuilder")) : class$com$tridium$program$ui$BProgramModuleBuilder));
    Lexicon lex = Lexicon.make((Class)(class$com$tridium$program$ui$BProgramModuleBuilder == null ? (class$com$tridium$program$ui$BProgramModuleBuilder = BProgramModuleBuilder.class$("com.tridium.program.ui.BProgramModuleBuilder")) : class$com$tridium$program$ui$BProgramModuleBuilder));
    static final BImage CHECK = BImage.make((BIcon)BIcon.std((String)"check.png"));
    static final BImage BLANK = BImage.make((BIcon)BIcon.std((String)"blank.png"));
    BProgramModule module;
    BSplitPane split;
    BFieldSheet sheet = new BFieldSheet();
    HashMap verify;
    static /* synthetic */ Class class$com$tridium$program$ui$BProgramModuleBuilder;

    public void handleSelection() {
        this.invoke(handleSelection, null, null);
    }

    public void handleModified() {
        this.invoke(handleModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.module = (BProgramModule)bObject;
        this.verify = new HashMap();
        this.verify.put(this.module, ValidateModel.make(this.module));
        super.doLoadValue(bObject, context);
    }

    protected void init() {
        super.init();
        ViewQuery viewQuery = this.getWbShell().getActiveOrdTarget().getViewQuery();
        if (viewQuery != null) {
            try {
                String string = viewQuery.getParameter("program");
                int n = ((BBuilderTable)this.getModel().getTable()).getRowOfProgram(string);
                this.getModel().getTable().getSelection().select(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        super.handleComponentEvent(bComponentEvent);
        BComponent bComponent = bComponentEvent.getSourceComponent();
        BValue bValue = bComponentEvent.getValue();
        if (bComponent == this.module) {
            this.verify.put(this.module, ValidateModel.make(this.module));
        } else if (bComponentEvent.getId() == 3) {
            this.verify.put(this.getSelectedProgram(), ValidateModel.make(this.getSelectedProgram()));
            this.handleSelection();
        } else if (bValue instanceof BProgram) {
            switch (bComponentEvent.getId()) {
                case 0: 
                case 1: {
                    this.verify.put(bValue, ValidateModel.make((BProgram)bValue));
                    this.handleSelection();
                    break;
                }
                case 2: {
                    if (bValue == this.getSelectedProgram()) {
                        this.getModel().getTable().getSelection().deselectAll();
                    }
                    this.verify.remove(bValue);
                }
            }
            this.verify.put(this.module, ValidateModel.make(this.module));
        }
        super.handleComponentEvent(bComponentEvent);
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        try {
            this.sheet.saveValue((BObject)this.module, context);
            this.verify.put(this.module, ValidateModel.make(this.module));
        }
        catch (Exception exception) {
            ((ValidateModel)((Object)this.verify.get((Object)this.module))).err(exception.getMessage());
            throw exception;
        }
        finally {
            this.getModel().getTable().getSelection().select(-1);
        }
        return this.module;
    }

    public void doHandleModified() {
        if (this.sheet.isModified()) {
            this.getController().updateCommands();
        }
    }

    protected MgrModel makeModel() {
        return new BuilderModel(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public void doHandleSelection() {
        ValidateModel validateModel = (ValidateModel)((Object)this.verify.get((Object)this.module));
        BProgram bProgram = this.getSelectedProgram();
        if (bProgram != null) {
            validateModel = (ValidateModel)((Object)this.verify.get((Object)bProgram));
        }
        if (validateModel.getTable() != null) {
            validateModel.setTable(null);
        }
        this.split.setWidget2((BWidget)new BTable((TableModel)validateModel));
        if (this.split.getDividerPosition() > 75.0) {
            this.split.setDividerPosition(75.0);
            this.split.relayout();
        }
    }

    private BProgram getSelectedProgram() {
        return (BProgram)this.getModel().getTable().getSelectedComponent();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BuilderModel
    extends FolderModel {
        MgrColumn colProgramName = new ProgName(1);
        MgrColumn colComp = new CompName();
        MgrColumn[] columns = new MgrColumn[]{this.colProgramName, this.colComp};

        public BuilderModel(BFolderManager bFolderManager) {
            super(bFolderManager);
        }

        protected BMgrTable makeTable() {
            BBuilderTable bBuilderTable = new BBuilderTable((MgrModel)this);
            BProgramModuleBuilder.this.linkTo((BComponent)bBuilderTable, (Slot)BTable.selectionModified, (Slot)handleSelection);
            return bBuilderTable;
        }

        public Type getFolderType() {
            return BFolder.TYPE;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BProgram.TYPE};
        }

        public boolean accept(BComponent bComponent) {
            if (bComponent.getParent().equals((Object)BProgramModuleBuilder.this.module.getPrograms())) {
                BProgramModuleBuilder.this.verify.put(bComponent, ValidateModel.make((BProgram)bComponent));
                return true;
            }
            return false;
        }

        public int getSubscribeDepth() {
            return 2;
        }

        protected String makeTableTitle() {
            return BProgramModuleBuilder.this.lex.getText("modBuilder.title");
        }

        public BWidget makePane() {
            BProgramModuleBuilder.this.sheet = new BFieldSheet();
            BProgramModuleBuilder.this.sheet.loadValue((BObject)BProgramModuleBuilder.this.module, BProgramModuleBuilder.this.getCurrentContext());
            BProgramModuleBuilder.this.linkTo((BComponent)BProgramModuleBuilder.this.sheet, (Slot)BFieldSheet.pluginModified, (Slot)BAbstractManager.setModified);
            BProgramModuleBuilder.this.linkTo((BComponent)BProgramModuleBuilder.this.sheet, (Slot)BFieldSheet.pluginModified, (Slot)handleModified);
            BExpandablePane bExpandablePane = new BExpandablePane();
            BEdgePane bEdgePane = new BEdgePane();
            bEdgePane.setCenter((BWidget)BProgramModuleBuilder.this.sheet);
            bExpandablePane.setSummary((BWidget)new BLabel(BProgramModuleBuilder.this.lex.getText("modBuilder.settings")));
            bExpandablePane.setExpansion((BWidget)new BBorderPane((BWidget)bEdgePane, 0.0, 0.0, 5.0, 0.0));
            bExpandablePane.setExpanded(true);
            BWidget bWidget = super.makePane();
            BProgramModuleBuilder.this.split = new BSplitPane(BOrientation.vertical, 75.0);
            BProgramModuleBuilder.this.split.setWidget1(bWidget);
            BProgramModuleBuilder.this.split.setWidget2((BWidget)new BNullWidget());
            BEdgePane bEdgePane2 = new BEdgePane();
            bEdgePane2.setTop((BWidget)bExpandablePane);
            bEdgePane2.setCenter((BWidget)BProgramModuleBuilder.this.split);
            return bEdgePane2;
        }

        protected MgrColumn[] makeColumns() {
            return this.columns;
        }

        protected class CompName
        extends MgrColumn {
            public CompName() {
                super("BComponent Name", 6);
            }

            public Object get(Object object) {
                return BProgramModule.toComponentName((BProgram)((Object)object));
            }
        }

        protected class ProgName
        extends MgrColumn.Name {
            private CellRenderer rend = new CellRenderer();

            public ProgName(int n) {
                super(n);
            }

            public TableCellRenderer getCellRenderer() {
                return this.rend;
            }

            private class CellRenderer
            extends ComponentTableCellRenderer {
                private CellRenderer() {
                }

                public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
                    return 20.0 + this.getFont(cell).width("VeryLongBProgramNameExample");
                }

                public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
                    this.paintCellBackground(graphics, cell);
                    double d = 2.0;
                    double d2 = (cell.height - 16.0) / 2.0;
                    ValidateModel validateModel = (ValidateModel)((Object)((BuilderModel)((ProgName)ProgName.this).BuilderModel.this).BProgramModuleBuilder.this.verify.get(this.getComponentTable().getComponentAt(cell.row)));
                    graphics.drawImage(validateModel.getProgramStatusIcon(), d, d2);
                    String string = (String)cell.value;
                    BFont bFont = this.getFont(cell);
                    graphics.setFont(bFont);
                    graphics.drawString(string, d += 20.0, (cell.height + bFont.getAscent() - bFont.getDescent()) / 2.0);
                }

                protected BComponentTable getComponentTable() {
                    return ProgName.this.getManager().getModel().getTable();
                }
            }
        }
    }

    class Controller
    extends FolderController {
        CompileCommand compileCmd;
        BuildCommand buildCmd;
        EditDepends dependsCmd;

        public Controller(BFolderManager bFolderManager) {
            super(bFolderManager);
            this.compileCmd = new CompileCommand((BWidget)bFolderManager);
            this.buildCmd = new BuildCommand((BWidget)bFolderManager);
            this.dependsCmd = new EditDepends((BWidget)bFolderManager);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            this.allDescendants.setSelected(true);
            return new MgrController.IMgrCommand[]{this.edit, this.compileCmd, this.buildCmd, this.dependsCmd};
        }

        public void cellDoubleClicked(BMgrTable bMgrTable, BMouseEvent bMouseEvent, int n, int n2) {
            BProgram bProgram = (BProgram)bMgrTable.getComponentAt(n);
            BWbShell bWbShell = bMgrTable.getManager().getWbShell();
            bWbShell.hyperlink(BOrd.make((BOrd)bProgram.getNavOrd(), (String)"view:program:ProgramEditor"));
        }

        public BToolBar makeToolBar() {
            return super.makeToolBar();
        }

        public void updateCommands() {
            super.updateCommands();
            boolean bl = true;
            Iterator iterator = BProgramModuleBuilder.this.verify.values().iterator();
            while (iterator.hasNext()) {
                if (((ValidateModel)((Object)iterator.next())).getErrCount() <= 0) continue;
                bl = false;
                break;
            }
            if (BProgramModuleBuilder.this.sheet != null && BProgramModuleBuilder.this.sheet.isModified()) {
                bl = false;
            }
            this.buildCmd.setEnabled(bl);
            this.dependsCmd.setEnabled(bl);
            this.compileCmd.setEnabled(!bl && !BProgramModuleBuilder.this.sheet.isModified());
        }

        public CommandArtifact drop(BMgrTable bMgrTable, TransferContext transferContext) throws Exception {
            return TransferUtil.insert((BWidget)BProgramModuleBuilder.this, (TransferContext)transferContext, (BObject)BProgramModuleBuilder.this.module.getPrograms(), null);
        }

        protected class EditDepends
        extends MgrController.MgrCommand {
            public EditDepends(BWidget bWidget) {
                super(bWidget, ((Controller)Controller.this).BProgramModuleBuilder.this.lex, "modBuilder.cmd.editDepends");
                this.setFlags(3);
            }

            public CommandArtifact doInvoke() throws Exception {
                BVector bVector = new BVector();
                BFieldSheet bFieldSheet = this.makeDependsSheet(bVector);
                BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bFieldSheet, BInsets.make((double)10.0)));
                bScrollPane.setVpolicy(BScrollBarPolicy.always);
                bScrollPane.setViewportBackground(Theme.widget().getControlBackground());
                while (true) {
                    if (2 == BDialog.open((BWidget)BProgramModuleBuilder.this, (String)((Controller)Controller.this).BProgramModuleBuilder.this.lex.getText("modBuilder.cmd.editDepends.title"), (Object)bScrollPane, (int)3)) {
                        return null;
                    }
                    try {
                        bFieldSheet.saveValue((BObject)bVector, null);
                    }
                    catch (Exception exception) {
                        BDialog.error((BWidget)BProgramModuleBuilder.this, (String)"Error", (Object)exception.getMessage(), (Throwable)exception);
                        continue;
                    }
                    break;
                }
                BNameMap bNameMap = BNameMap.DEFAULT;
                Property[] propertyArray = bVector.getPropertiesArray();
                for (int i = 0; i < propertyArray.length; ++i) {
                    String string = propertyArray[i].getName();
                    String string2 = bVector.getString(propertyArray[i]);
                    bNameMap = BNameMap.make((BNameMap)bNameMap, (String)string, (String)string2);
                }
                ((Controller)Controller.this).BProgramModuleBuilder.this.module.setDependencies(bNameMap);
                return null;
            }

            private BFieldSheet makeDependsSheet(BVector bVector) {
                BFieldSheet bFieldSheet = new BFieldSheet(true);
                BFacets bFacets = BFacets.make((String)"validator", (String)"baja:VersionValidator");
                bFacets = BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"fieldSheetShow", (boolean)true));
                bFacets = BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"iconOverride", (String)"module://icons/x16/module.png"));
                BNameMap bNameMap = BProgramModule.rationalizeDependecies(((Controller)Controller.this).BProgramModuleBuilder.this.module);
                Object[] objectArray = bNameMap.list();
                SortUtil.sort((Object[])objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    bVector.add((String)objectArray[i], (BValue)BString.make((String)bNameMap.get((String)objectArray[i]).getFormat()));
                    bVector.setFacets(bVector.getSlot((String)objectArray[i]), bFacets);
                }
                bFieldSheet.loadValue((BObject)bVector);
                return bFieldSheet;
            }
        }

        protected class BuildCommand
        extends MgrController.MgrCommand {
            public BuildCommand(BWidget bWidget) {
                super(bWidget, ((Controller)Controller.this).BProgramModuleBuilder.this.lex, "modBuilder.cmd.build");
                this.setFlags(7);
            }

            public CommandArtifact doInvoke() throws Exception {
                BProgramModuleBuilder.this.saveValue();
                BProgressDialog.open((BWidget)this.getOwner(), (String)((Controller)Controller.this).BProgramModuleBuilder.this.lex.getText("modBuilder.cmd.build.title"), (BProgressDialog.Worker)new BuildWorker());
                return null;
            }

            class BuildWorker
            extends BProgressDialog.Worker
            implements IBuildListener {
                int curStep = 0;

                BuildWorker() {
                }

                public void setNumBuildSteps(int n) {
                    this.getDialog().getProgressBar().setMax((double)n);
                }

                public void nextStep(String string) {
                    this.getDialog().getProgressBar().setValue((double)(++this.curStep));
                    this.updateDesc(string);
                }

                public void updateDesc(String string) {
                    this.getDialog().getMessageLabel().setText(string);
                }

                public BWidget getOwner() {
                    return BProgramModuleBuilder.this;
                }

                public void doCancel() throws Exception {
                }

                public void doRun() throws Exception {
                    try {
                        ((Controller)((BuildCommand)BuildCommand.this).Controller.this).BProgramModuleBuilder.this.module.buildModule(this);
                    }
                    catch (Exception exception) {
                        BDialog.error((BWidget)this.getDialog(), (String)((Controller)((BuildCommand)BuildCommand.this).Controller.this).BProgramModuleBuilder.this.lex.getText("programModule.nbuild.fail"), (Object)exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        }

        protected class CompileCommand
        extends MgrController.MgrCommand {
            public CompileCommand(BWidget bWidget) {
                super(bWidget, ((Controller)Controller.this).BProgramModuleBuilder.this.lex, "modBuilder.cmd.compile");
                this.setFlags(7);
            }

            public CommandArtifact doInvoke() throws Exception {
                BProgram[] bProgramArray = ((Controller)Controller.this).BProgramModuleBuilder.this.module.listPrograms();
                for (int i = 0; i < bProgramArray.length; ++i) {
                    if (((ValidateModel)((Object)((Controller)Controller.this).BProgramModuleBuilder.this.verify.get((Object)bProgramArray[i]))).getErrCount() == 0) continue;
                    try {
                        PCompiler pCompiler = new PCompiler(this.getOwner(), bProgramArray[i]);
                        pCompiler.compile(BCode.generateClassName(), bProgramArray[i].getCode(), null);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return null;
            }

            private class PCompiler
            extends Compiler {
                BProgram program;
                BProgramEditor pe;

                public PCompiler(BWidget bWidget, BProgram bProgram) {
                    super(bWidget);
                    this.program = bProgram;
                    this.pe = new BProgramEditor();
                    this.pe.loadValue((BObject)bProgram);
                }

                public void writeSource(FileWriter fileWriter, String string) throws Exception {
                    SourceWriter sourceWriter = new SourceWriter((Writer)fileWriter, this.pe);
                    sourceWriter.generate(this.className);
                }

                public synchronized void compile(String string, BCode bCode, String string2) throws Exception {
                    super.compile(string, bCode, string2);
                    this.wait();
                }

                public synchronized void consoleExecDone(BConsole bConsole, int n) {
                    try {
                        super.consoleExecDone(bConsole, n);
                    }
                    finally {
                        this.notifyAll();
                    }
                }

                public void compileFailed(BConsole bConsole) throws Exception {
                    bConsole.cls();
                    ((ValidateModel)((Object)((Controller)((CompileCommand)CompileCommand.this).Controller.this).BProgramModuleBuilder.this.verify.get((Object)this.program))).err(((Controller)((CompileCommand)CompileCommand.this).Controller.this).BProgramModuleBuilder.this.lex.getText("vprogram.err.compile"));
                }

                public void compileSuccess(BConsole bConsole) throws Exception {
                    super.compileSuccess(bConsole);
                    int n = this.program.getCode().getChecksum();
                    int n2 = this.pe.computeChecksum(this.program.getCode().getSource());
                    if (n != n2) {
                        this.program.getCode().setChecksum(n2);
                        BProgramModuleBuilder.this.handleComponentEvent(new BComponentEvent(0, (BComponent)((Controller)((CompileCommand)CompileCommand.this).Controller.this).BProgramModuleBuilder.this.module.getPrograms(), null, (BValue)this.program));
                    }
                }
            }
        }
    }
}

