/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.BProgram;
import com.tridium.program.BProgramCode;
import com.tridium.program.module.BProgramModule;
import com.tridium.program.ui.Imports;
import com.tridium.program.ui.ProgramCompiler;
import com.tridium.program.ui.ProgramEditorCommands;
import com.tridium.program.ui.SourceWriter;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.slotsheet.BSlotSheet;
import java.io.File;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.parsers.JavaParser;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

public class BProgramEditor
extends BWbComponentView
implements BConsole.HyperlinkInterceptor {
    public static final Action codeTextModified = BProgramEditor.newAction((int)0, null);
    public static final Action tabSelectionModified = BProgramEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$program$ui$BProgramEditor == null ? (class$com$tridium$program$ui$BProgramEditor = BProgramEditor.class$("com.tridium.program.ui.BProgramEditor")) : class$com$tridium$program$ui$BProgramEditor));
    static UiLexicon lex = UiLexicon.bajaui;
    static String statusOk = lex.getText("programEditor.status.ok");
    static String statusNeedsCompile = lex.getText("programEditor.status.needsCompile");
    static String statusError = lex.getText("programEditor.status.error");
    static BImage statusOkIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    static BImage statusNeedsCompileIcon = BImage.make((String)"module://icons/x16/shapes/circleGold.png");
    static BImage statusErrorIcon = BImage.make((String)"module://icons/x16/shapes/circleRed.png");
    static BImage editIcon = BImage.make((String)"module://icons/x16/edit.png");
    static BImage slotsIcon = BImage.make((String)"module://icons/x16/page.png");
    static BImage importsIcon = BImage.make((String)"module://icons/x16/module.png");
    static BImage sourceIcon = BImage.make((String)"module://icons/x16/script.png");
    static BImage addIcon = BImage.make((String)"module://icons/x16/add.png");
    static BImage removeIcon = BImage.make((String)"module://icons/x16/delete.png");
    static final String boilerPlate = "public void onStart() throws Exception\n{\n  // start up code here\n}\n\npublic void onExecute() throws Exception\n{\n  // execute code (set executeOnChange flag on inputs)\n}\n\npublic void onStop() throws Exception\n{\n  // shutdown code here\n}\n\n";
    ProgramEditorCommands commands = new ProgramEditorCommands(this);
    ProgramCompiler compiler = new ProgramCompiler(this);
    int sourceLine;
    BProgram program;
    BProgramCode code;
    BTabbedPane tabs;
    boolean modified = false;
    BWidget statusPane;
    BLabel status;
    BWidget editTab;
    BTextEditor editText;
    BWidget slotTab;
    BSlotSheet slotSheet;
    Imports imports = new Imports(this);
    BWidget importsTab;
    BWidget sourceTab;
    BTextEditor sourceText;
    static /* synthetic */ Class class$com$tridium$program$ui$BProgramEditor;

    public void codeTextModified() {
        this.invoke(codeTextModified, null, null);
    }

    public void tabSelectionModified() {
        this.invoke(tabSelectionModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BProgramEditor() {
        this.autoRegisterForComponentEvents = false;
        this.setContent((BWidget)new BLabel("ProgramEditor"));
        this.initStatusPane();
        this.initEditPane();
        this.initSlotPane();
        this.initImportsPane();
        this.initSourcePane();
        this.tabs = new BTabbedPane();
        this.tabs.addPane(lex.getText("programEditor.edit"), editIcon, this.editTab);
        this.tabs.addPane(lex.getText("programEditor.slots"), slotsIcon, this.slotTab);
        this.tabs.addPane(lex.getText("programEditor.imports"), importsIcon, this.importsTab);
        this.tabs.addPane(lex.getText("programEditor.source"), sourceIcon, this.sourceTab);
        this.linkTo(null, (BComponent)this.editText, (Slot)BTextEditor.textModified, (Slot)codeTextModified);
        this.linkTo(null, (BComponent)this.tabs, (Slot)BTabbedPane.selectionModified, (Slot)tabSelectionModified);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop(this.statusPane);
        bEdgePane.setCenter((BWidget)this.tabs);
        this.setContent((BWidget)bEdgePane);
    }

    private void initStatusPane() {
        this.status = new BLabel("status not initialized");
        this.status.setHalign(BHalign.left);
        this.statusPane = new BBorderPane((BWidget)this.status, 5.0, 0.0, 10.0, 0.0);
    }

    private void initEditPane() {
        this.editText = new BTextEditor();
        this.editText.setParser((TextParser)new JavaParser());
        BTextEditorPane bTextEditorPane = new BTextEditorPane(this.editText);
        this.editTab = bTextEditorPane;
    }

    private void initSlotPane() {
        this.slotSheet = new BSlotSheet();
        this.slotTab = this.slotSheet;
    }

    private void initImportsPane() {
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.add(null, (BValue)new BButton(this.commands.importType));
        bGridPane.add(null, (BValue)new BButton(this.commands.importPackage));
        bGridPane.add(null, (BValue)new BButton(this.commands.removeImport));
        bGridPane.setUniformColumnWidth(true);
        bGridPane.setColumnAlign(BHalign.fill);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)this.imports.table);
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane));
        this.importsTab = bEdgePane;
    }

    private void initSourcePane() {
        this.sourceText = new BTextEditor();
        this.sourceText.setEditable(false);
        this.sourceText.setParser((TextParser)new JavaParser());
        BTextEditorPane bTextEditorPane = new BTextEditorPane(this.sourceText);
        this.sourceTab = bTextEditorPane;
    }

    public BMenu[] getViewMenus() {
        return this.commands.getViewMenus();
    }

    public BToolBar getViewToolBar() {
        return this.commands.getViewToolBar();
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.program = (BProgram)bObject;
        this.registerForComponentEvents(this.program, 1);
        this.code = (BProgramCode)this.program.getCode().newCopy();
        this.loadCode();
        this.imports.load(this.code);
        this.slotSheet.doLoadValue((BObject)this.program, context);
        this.updateStatus();
        this.tabs.selectPane(this.editTab);
    }

    public BObject doSaveValue(BObject bObject, Context context) throws Exception {
        this.saveCode();
        this.imports.save(this.code);
        this.program.setCode(this.code);
        this.program.updateActionParameters();
        this.modified = false;
        this.updateStatus();
        return this.program;
    }

    public CommandArtifact invokeCommand(int n) throws Exception {
        BTextEditor bTextEditor = this.getActiveTextEditor();
        if (bTextEditor == null) {
            return null;
        }
        switch (n) {
            case 6: {
                return bTextEditor.doFind();
            }
            case 8: {
                return bTextEditor.doFindNext();
            }
            case 7: {
                return bTextEditor.doFindPrev();
            }
            case 9: {
                return bTextEditor.doReplace();
            }
            case 10: {
                return bTextEditor.doGoto();
            }
        }
        return super.invokeCommand(n);
    }

    public BTextEditor getActiveTextEditor() {
        BWidget bWidget = this.tabs.getSelectedPane();
        if (bWidget == this.editTab) {
            return this.editText;
        }
        if (bWidget == this.sourceTab) {
            return this.sourceText;
        }
        return null;
    }

    public void updateEditorCommands() {
        BTextEditor bTextEditor = this.getActiveTextEditor();
        if (bTextEditor != null) {
            bTextEditor.updateEnableStates();
        }
        this.setTransferWidget((BTransferWidget)bTextEditor);
        boolean bl = bTextEditor != null;
        this.setCommandEnabled(6, bl);
        this.setCommandEnabled(8, bl);
        this.setCommandEnabled(7, bl);
        this.setCommandEnabled(9, bl && bTextEditor.isEditable());
        this.setCommandEnabled(10, bl);
    }

    public boolean consoleHyperlink(File file, int n, int n2, int n3, int n4) {
        if (!file.equals(this.compiler.java)) {
            BOrd bOrd = BOrd.make((String)SlotPath.unescape((String)file.getName()));
            BObject bObject = bOrd.get();
            if (bObject instanceof BProgramModule || bObject instanceof BProgram) {
                ((BNiagaraWbShell)this.getWbShell()).hyperlink(bOrd);
                return true;
            }
            return false;
        }
        this.highlight(n, n2, n3, n4);
        return true;
    }

    public void highlight(int n, int n2, int n3, int n4) {
        this.tabs.selectPane(this.editTab);
        this.highlight(this.editText, n -= this.sourceLine, n2 -= 2, n3 -= this.sourceLine, n4 -= 2);
    }

    void highlight(BTextEditor bTextEditor, int n, int n2, int n3, int n4) {
        Position position = bTextEditor.getModel().getEndPosition();
        Position position2 = new Position(n - 1, n2 - 1);
        Position position3 = new Position(n3 - 1, n4);
        if (position2.compareTo((Object)position) > 0) {
            position2 = position;
        }
        if (position3.compareTo((Object)position) > 0) {
            position3 = position;
        }
        bTextEditor.getSelection().select(position2, position3);
        bTextEditor.moveCaretPosition(position3);
        bTextEditor.requestFocus();
    }

    public void updateStatus() {
        if (this.modified || this.computeChecksum(this.editText.getText()) != this.program.getCode().getChecksum()) {
            this.status.setText(statusNeedsCompile);
            this.status.setImage(statusNeedsCompileIcon);
        } else {
            this.status.setText(statusOk);
            this.status.setImage(statusOkIcon);
        }
    }

    public void updateProgramCode() {
        this.program.setCode(this.code);
    }

    public void updateStatusToError() {
        this.status.setText(statusError);
        this.status.setImage(statusErrorIcon);
    }

    public void updateSource() {
        char[] cArray = SourceWriter.generateToCharArray(this, "ProgramImpl");
        this.sourceText.getModel().read(cArray);
    }

    public void saveCode() {
        String string = this.editText.getText();
        this.code.setSource(string);
        this.imports.updateImports();
    }

    public void loadCode() {
        String string = this.code.getSource();
        if (string.length() == 0) {
            string = boilerPlate;
        }
        this.editText.setText(string);
    }

    public int computeChecksum(String string) {
        int n = string.hashCode();
        Property[] propertyArray = this.program.getPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            Property property = propertyArray[i];
            if (property.isFrozen()) continue;
            n ^= property.getName().hashCode();
            n ^= property.getType().getTypeName().hashCode();
        }
        return n;
    }

    public void doCodeTextModified() {
        if (!this.isModifiedStateLocked()) {
            this.setModified();
            this.modified = true;
            this.updateStatus();
        }
    }

    public void doTabSelectionModified() {
        this.updateEditorCommands();
        this.saveCode();
        this.updateSource();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        this.slotSheet.handleComponentEvent(bComponentEvent);
        this.imports.updateImports();
        switch (bComponentEvent.getId()) {
            case 1: 
            case 2: 
            case 3: {
                this.updateStatus();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

