/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFieldSheet
extends BWbEditor {
    public static final Property labelMargin = BFieldSheet.newProperty((int)0, (double)10.0, null);
    public static final Property rowGap = BFieldSheet.newProperty((int)0, (double)8.0, null);
    public static final Property indent = BFieldSheet.newProperty((int)0, (double)0.0, null);
    public static final Action handleEditorModified = BFieldSheet.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$program$ui$BFieldSheet == null ? (class$com$tridium$program$ui$BFieldSheet = BFieldSheet.class$("com.tridium.program.ui.BFieldSheet")) : class$com$tridium$program$ui$BFieldSheet));
    public static final String FORCE_SHOW = "fieldSheetShow";
    static final BColor dividerColor = BColor.make((int)0xBBBBBB);
    static BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    boolean showModified;
    private Array fields;
    private double[] divs;
    static /* synthetic */ Class class$com$tridium$program$ui$BFieldSheet;
    static /* synthetic */ Class class$com$tridium$program$ui$BFieldSheet$Field;

    public double getLabelMargin() {
        return this.getDouble(labelMargin);
    }

    public void setLabelMargin(double d) {
        this.setDouble(labelMargin, d, null);
    }

    public double getRowGap() {
        return this.getDouble(rowGap);
    }

    public void setRowGap(double d) {
        this.setDouble(rowGap, d, null);
    }

    public double getIndent() {
        return this.getDouble(indent);
    }

    public void setIndent(double d) {
        this.setDouble(indent, d, null);
    }

    public void handleEditorModified(BWidgetEvent bWidgetEvent) {
        this.invoke(handleEditorModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFieldSheet() {
        this(true);
    }

    public BFieldSheet(boolean bl) {
        this.showModified = bl;
    }

    public void doLoadValue(BObject bObject, Context context) {
        BComponent bComponent = (BComponent)bObject;
        Property[] propertyArray = bComponent.getPropertiesArray();
        this.fields = new Array(class$com$tridium$program$ui$BFieldSheet$Field == null ? (class$com$tridium$program$ui$BFieldSheet$Field = BFieldSheet.class$("com.tridium.program.ui.BFieldSheet$Field")) : class$com$tridium$program$ui$BFieldSheet$Field, propertyArray.length);
        for (int i = 0; i < propertyArray.length; ++i) {
            Property property = propertyArray[i];
            if (Flags.isHidden((BComplex)bComponent, (Slot)property) || property.isDynamic() && !property.getFacets().getb(FORCE_SHOW, false)) continue;
            BValue bValue = bComponent.get(property);
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bValue, (Context)property.getFacets());
            bWbFieldEditor.setReadonly((property.getDefaultFlags() & 1) != 0);
            bWbFieldEditor.loadValue((BObject)bValue, (Context)new BasicContext(context, property.getFacets()));
            String string = null;
            BImage bImage = null;
            string = property.getFacets().gets("iconOverride", null);
            bImage = string != null ? BImage.make((BIcon)BIcon.make((String)string)) : BImage.make((BIcon)bValue.getIcon());
            if (bImage == null) {
                bImage = defaultIcon;
            }
            Field field = new Field(property, new BLabel(bImage, TextUtil.toFriendly((String)property.getName())), bWbFieldEditor);
            field.icon = bImage;
            this.add("label" + i, (BValue)field.label);
            this.add("editor" + i, (BValue)field.editor);
            this.linkTo((BComponent)field.editor, (Slot)BWbFieldEditor.setModified, (Slot)setModified);
            this.linkTo((BComponent)field.editor, (Slot)BWbFieldEditor.setModified, (Slot)handleEditorModified);
            this.fields.add((Object)field);
        }
        this.divs = new double[this.fields.size()];
    }

    public BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        int n;
        BComponent bComponent = (BComponent)bObject;
        int n2 = this.fields.size();
        for (n = 0; n < n2; ++n) {
            Field field = (Field)this.fields.get(n);
            if (!field.editor.isModified()) continue;
            bComponent.set(field.prop, (BValue)field.editor.saveValue((BObject)bComponent.get(field.prop), context));
        }
        for (n = 0; n < n2; ++n) {
            ((Field)this.fields.get((int)n)).editor.clearModified();
        }
        this.handleEditorModified(null);
        this.clearModified();
        return bComponent;
    }

    public void computePreferredSize() {
        if (this.fields == null) {
            this.setPreferredSize(0.0, 0.0);
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.fields.size();
        for (int i = 0; i < n; ++i) {
            Field field = (Field)this.fields.get(i);
            field.label.computePreferredSize();
            field.editor.computePreferredSize();
            if (i == 0) {
                d = field.label.getPreferredWidth();
                d2 = field.editor.getPreferredWidth();
            } else {
                d = Math.max(d, field.label.getPreferredWidth());
                d2 = Math.max(d2, field.editor.getPreferredWidth());
            }
            if (i != 0) {
                d3 += this.getRowGap();
            }
            d3 += Math.max(field.label.getPreferredHeight(), field.editor.getPreferredHeight());
        }
        this.setPreferredSize(this.getIndent() + d + d2 + this.getLabelMargin(), d3);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        if (this.fields == null) {
            return;
        }
        double d = 0.0;
        int n = this.fields.size();
        for (int i = 0; i < n; ++i) {
            Field field = (Field)this.fields.get(i);
            field.label.computePreferredSize();
            field.editor.computePreferredSize();
            d = i == 0 ? field.label.getPreferredWidth() : Math.max(d, field.label.getPreferredWidth());
        }
        double d2 = 0.0;
        double d3 = this.getIndent();
        for (int i = 0; i < n; ++i) {
            Field field = (Field)this.fields.get(i);
            double d4 = Math.max(field.label.getPreferredHeight(), field.editor.getPreferredHeight());
            field.label.setBounds(d3, d2 + (d4 - field.label.getPreferredHeight()) / 2.0, field.label.getPreferredWidth(), d4);
            field.editor.setBounds(d3 + d + this.getLabelMargin(), d2 + (d4 - field.editor.getPreferredHeight()) / 2.0, field.editor.getPreferredWidth(), d4);
            this.divs[i] = d2 += d4 + this.getRowGap();
        }
    }

    public void paint(Graphics graphics) {
        this.paintChildren(graphics);
        for (int i = 0; i < this.divs.length; ++i) {
            double d = this.divs[i] - this.getRowGap() / 2.0;
            graphics.setBrush(dividerColor);
            graphics.strokeLine(0.0, d, this.getWidth(), d);
        }
    }

    public void doHandleEditorModified(BWidgetEvent bWidgetEvent) {
        if (!this.showModified) {
            return;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = (Field)this.fields.get(i);
            if (field.editor.isModified()) {
                field.label.setImage(field.icon.getHighlightedImage());
                continue;
            }
            field.label.setImage(field.icon);
        }
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Field {
        public Property prop;
        public BLabel label;
        public BWbFieldEditor editor;
        public BImage icon;

        public Field(Property property, BLabel bLabel, BWbFieldEditor bWbFieldEditor) {
            this.prop = property;
            this.label = bLabel;
            this.editor = bWbFieldEditor;
        }
    }
}

