/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.module;

import com.tridium.program.BProgram;
import com.tridium.program.ProgramBase;
import com.tridium.program.module.BProgramModule;
import com.tridium.program.module.ComponentWriter;
import com.tridium.program.module.ReflectUtil;
import com.tridium.program.ui.BProgramEditor;
import java.lang.reflect.Method;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BDouble;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ValidateModel
extends TableModel {
    protected static final Lexicon lex;
    public static final BImage okProgramIcon;
    public static final BImage errProgramIcon;
    public static final BImage warnProgramIcon;
    protected static final BImage errIcon;
    protected static final BImage warnIcon;
    protected Array errs = new Array();
    protected Array warns = new Array();
    static /* synthetic */ Class class$com$tridium$program$module$BProgramModule;

    public static ValidateModel make(BProgram bProgram) {
        ValidateProgram validateProgram = new ValidateProgram(bProgram);
        ((ValidateModel)validateProgram).validate();
        return validateProgram;
    }

    public static ValidateModel make(BProgramModule bProgramModule) {
        ValidateModule validateModule = new ValidateModule(bProgramModule);
        ((ValidateModel)validateModule).validate();
        return validateModule;
    }

    public BImage getProgramStatusIcon() {
        if (this.getErrCount() > 0) {
            return errProgramIcon;
        }
        if (this.getWarnCount() > 0) {
            return warnProgramIcon;
        }
        return okProgramIcon;
    }

    public final int getErrCount() {
        return this.errs.size();
    }

    public final int getWarnCount() {
        return this.warns.size();
    }

    protected abstract void validate();

    public void err(String string) {
        if (!this.errs.contains((Object)string)) {
            this.errs.add((Object)string);
        }
    }

    public void warn(String string) {
        if (!this.warns.contains((Object)string)) {
            this.warns.add((Object)string);
        }
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return this.errs.size() + this.warns.size();
    }

    public Object getValueAt(int n, int n2) {
        int n3 = this.getErrCount();
        if (n < n3) {
            return this.errs.get(n);
        }
        return this.warns.get(n - n3);
    }

    public BImage getRowIcon(int n) {
        return n < this.getErrCount() ? errIcon : warnIcon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$program$module$BProgramModule;
        if (clazz == null) {
            clazz = class$com$tridium$program$module$BProgramModule = ValidateModel.class("[Lcom.tridium.program.module.BProgramModule;", false);
        }
        lex = Lexicon.make((Class)clazz);
        okProgramIcon = BImage.make((BIcon)new BProgram().getIcon());
        errProgramIcon = BImage.make((BIcon)BIcon.make((BIcon)new BProgram().getIcon(), (BIcon)BIcon.std((String)"badges/error.png")));
        warnProgramIcon = BImage.make((BIcon)BIcon.make((BIcon)new BProgram().getIcon(), (BIcon)BIcon.std((String)"badges/warning.png")));
        errIcon = BImage.make((BIcon)BIcon.std((String)"stop.png"));
        warnIcon = BImage.make((BIcon)BIcon.std((String)"warning.png"));
    }

    private static class ValidateProgram
    extends ValidateModel {
        private static final BProgramEditor pe = new BProgramEditor();
        BProgram program;

        public String getColumnName(int n) {
            return lex.getText("vprogram.col");
        }

        protected void validate() {
            this.checkCompileStatus();
            this.checkName();
            this.checkLongAndDoubleSlots();
            this.checkPropertySlots();
            this.checkActionDelegates();
            this.checkReflection();
        }

        public void err(String string) {
            super.err("[" + BProgramModule.toTypeName(this.program) + "] " + string);
        }

        public void warn(String string) {
            super.warn("[" + BProgramModule.toTypeName(this.program) + "] " + string);
        }

        private final void checkCompileStatus() {
            pe.loadValue((BObject)this.program);
            int n = this.program.getCode().getChecksum();
            if (n == 0 || n != pe.computeChecksum(this.program.getCode().getSource())) {
                this.err(lex.getText("vprogram.err.outofdate"));
            }
        }

        private final void checkName() {
            if (BProgramModule.toComponentName(this.program) == null) {
                this.err(lex.getText("vprogram.err.name"));
            }
        }

        private final void checkLongAndDoubleSlots() {
            Property[] propertyArray = this.program.getPropertiesArray();
            int n = 0;
            while (n < propertyArray.length) {
                BValue bValue = propertyArray[n].getDefaultValue();
                if (bValue instanceof BDouble) {
                    this.err(lex.getText("vprogram.err.double", new Object[]{propertyArray[n].getName()}));
                } else if (bValue instanceof BLong) {
                    this.err(lex.getText("vprogram.err.long", new Object[]{propertyArray[n].getName()}));
                }
                ++n;
            }
        }

        private final void checkPropertySlots() {
            Property[] propertyArray = this.program.getPropertiesArray();
            int n = 0;
            while (n < propertyArray.length) {
                if (ReflectUtil.getInstance().getPropertyStatus(propertyArray[n]) != 0) {
                    this.err(lex.getText("vprogram.err.getset", new Object[]{propertyArray[n].getName()}));
                }
                ++n;
            }
        }

        private final void checkActionDelegates() {
            Class<?> clazz = null;
            try {
                clazz = this.program.getCode().newInstance().getClass();
            }
            catch (Exception exception) {
                return;
            }
            Action[] actionArray = this.program.getActionsArray();
            int n = 0;
            while (n < actionArray.length) {
                ComponentWriter.CompAction compAction = new ComponentWriter.CompAction(actionArray[n]);
                if (!"onExecute".equals(compAction.getOn())) {
                    String string = compAction.paramType() == null ? "" : compAction.paramType();
                    String string2 = compAction.getOn() + '(' + string + ')';
                    Object[] objectArray = new Object[]{compAction.name(), string2};
                    try {
                        Method method = clazz.getDeclaredMethod(compAction.getOn(), compAction.paramTypeArray());
                        if ((method.getModifiers() & 1) == 0) {
                            this.err(lex.getText("vprogram.err.delegate.public", objectArray));
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        this.err(lex.getText("vprogram.err.delegate", objectArray));
                    }
                }
                ++n;
            }
        }

        private final void checkReflection() {
            ProgramBase programBase = this.program.getCode().newProgramInstance();
            Method[] methodArray = programBase.getClass().getDeclaredMethods();
            ReflectUtil reflectUtil = ReflectUtil.getInstance();
            int n = 0;
            while (n < methodArray.length) {
                switch (reflectUtil.getOverrideStatus(methodArray[n])) {
                    case 2: {
                        this.err(lex.getText("vprogram.err.override", new Object[]{this.toMethodDef(methodArray[n])}));
                        break;
                    }
                    case 1: {
                        if ("toString".equals(methodArray[n].getName())) break;
                        this.warn(lex.getText("vprogram.warn.override", new Object[]{this.toMethodDef(methodArray[n])}));
                        break;
                    }
                }
                ++n;
            }
        }

        private final String toMethodDef(Method method) {
            StringBuffer stringBuffer = new StringBuffer().append(ReflectUtil.getInstance().getDeclaringClass(method).getName()).append(".").append(method.getName()).append("(");
            Class<?>[] classArray = method.getParameterTypes();
            int n = 0;
            while (n < classArray.length) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(classArray[n].getName());
                ++n;
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public ValidateProgram(BProgram bProgram) {
            this.program = bProgram;
        }
    }

    private static class ValidateModule
    extends ValidateModel {
        BProgramModule module;

        public String getColumnName(int n) {
            return lex.getText("vmodule.col");
        }

        protected void validate() {
            this.checkName();
            this.checkVendor();
            this.checkVersion();
            if (this.module.listPrograms().length == 0) {
                this.warn(lex.getText("vmodule.warn.noPrograms"));
            }
        }

        private final void checkName() {
            if (!SlotPath.isValidName((String)this.module.getModuleName())) {
                this.err(lex.getText("vmodule.err.name", new Object[]{this.module.getModuleName()}));
            }
        }

        private final void checkVendor() {
            if (this.module.getVendor().length() == 0) {
                this.err(lex.getText("vmodule.err.vendor"));
            }
        }

        private final void checkVersion() {
            try {
                Version version = new Version(this.module.getVendorVersion());
                if (version.toString().length() == 0) {
                    this.err(lex.getText("vmodule.err.verRequired"));
                }
            }
            catch (Exception exception) {
                this.err(lex.getText("vmodule.err.version", new Object[]{this.module.getVendorVersion()}));
            }
        }

        public ValidateModule(BProgramModule bProgramModule) {
            this.module = bProgramModule;
        }
    }
}

