/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program;

import com.tridium.program.BCode;
import com.tridium.program.BProgram;
import com.tridium.program.BProgramCode;
import com.tridium.program.ui.BProgramEditor;
import com.tridium.program.ui.Compiler;
import com.tridium.program.ui.SourceWriter;
import java.io.File;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;

public class RecompileTool {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println("usage: RecompileTool <dir|bogfile>");
            return;
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            System.out.println("File not found: " + file);
            return;
        }
        RecompileTool.process(file);
        System.exit(0);
    }

    public static void process(File file) throws Exception {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (fileArray != null && n < fileArray.length) {
                RecompileTool.process(fileArray[n]);
                ++n;
            }
            return;
        }
        if (file.getName().endsWith(".bog")) {
            RecompileTool.processBog(file);
        }
    }

    public static void processBog(File file) throws Exception {
        System.out.println("--- Processing " + file + "...");
        try {
            ValueDocDecoder valueDocDecoder = new ValueDocDecoder(file);
            BComponent bComponent = (BComponent)valueDocDecoder.decodeDocument();
            boolean bl = valueDocDecoder.isZipped();
            valueDocDecoder.close();
            RecompileTool.process(bComponent);
            ValueDocEncoder valueDocEncoder = new ValueDocEncoder(file);
            valueDocEncoder.setZipped(bl);
            valueDocEncoder.encodeDocument((BValue)bComponent);
            valueDocEncoder.close();
            System.out.println("--- Processed " + file + '!');
        }
        catch (Exception exception) {
            System.out.println("ERROR: Cannot process " + file);
            exception.printStackTrace();
        }
    }

    public static void process(BComponent bComponent) throws Exception {
        if (bComponent instanceof BProgram) {
            System.out.println("  Recompiling " + RecompileTool.toString(bComponent));
            try {
                RecompileTool.recompile((BProgram)bComponent);
            }
            catch (Exception exception) {
                System.out.println("ERROR Recompiling " + RecompileTool.toString(bComponent));
                exception.printStackTrace();
            }
        }
        BComponent[] bComponentArray = bComponent.getChildComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            RecompileTool.process(bComponentArray[n]);
            ++n;
        }
    }

    public static void recompile(BProgram bProgram) throws Exception {
        String string = BCode.generateClassName();
        BProgramEditor bProgramEditor = new BProgramEditor();
        bProgramEditor.loadValue((BObject)bProgram);
        char[] cArray = SourceWriter.generateToCharArray(bProgramEditor, string);
        BProgramCode bProgramCode = bProgram.getCode();
        Compiler compiler = new Compiler(null);
        compiler.compile(string, bProgramCode, new String(cArray));
    }

    static String toString(BComponent bComponent) {
        Object object;
        Array array = new Array();
        while ((object = bComponent.getPropertyInParent()) != null) {
            array.add(0, (Object)object.getName());
            bComponent = (BComponent)bComponent.getParent();
        }
        object = new StringBuffer();
        int n = 0;
        while (n < array.size()) {
            ((StringBuffer)object).append("/").append(array.get(n));
            ++n;
        }
        return ((StringBuffer)object).toString();
    }
}

