/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.svg.gx;

import java.io.PrintWriter;
import java.util.Stack;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XWriter;

public class SvgGraphics
implements Graphics {
    private PrintWriter writer;
    private Writer out;
    private Stack stack = new Stack();
    private int clipCount = 0;
    private double tx = 0.0;
    private double ty = 0.0;
    private int width;
    private int height;
    private BBrush brush;
    private BPen pen;
    private BFont font;
    private IGeom clip;

    public SvgGraphics(PrintWriter printWriter, int n, int n2) {
        this.writer = printWriter;
        this.out = new Writer();
        this.brush = BBrush.DEFAULT;
        this.font = BFont.DEFAULT;
        this.pen = BPen.DEFAULT;
        this.width = n;
        this.height = n2;
        this.out.w("<?xml version='1.0' standalone='no'?>").nl();
        this.out.w("<!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.1//EN'");
        this.out.w(" 'http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd'>").nl();
        this.out.w("<svg width='100%' height='100%'");
        this.out.w(" viewBox='0 0 ").w(n).w(" ").w(n2).w("'");
        this.out.w(" version='1.1' xmlns='http://www.w3.org/2000/svg'>").nl();
        this.clip(0.0, 0.0, n, n2);
    }

    public void useAntiAliasing(boolean bl) {
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush bBrush) {
        BBrush.Paint paint = bBrush.getPaint();
        if (paint instanceof BBrush.Solid) {
            this.brush = bBrush;
        } else if (paint instanceof BBrush.Gradient) {
            BBrush.Stop stop = ((BBrush.Gradient)paint).getStops()[0];
            this.brush = stop.getColor().toBrush();
        } else {
            this.brush = BColor.white.toBrush();
        }
    }

    public void setBrush(BColor bColor) {
        this.setBrush(bColor.toBrush());
    }

    public BPen getPen() {
        return this.pen;
    }

    public void setPen(BPen bPen) {
        this.pen = bPen;
    }

    public BFont getFont() {
        return this.font;
    }

    public void setFont(BFont bFont) {
        this.font = bFont;
    }

    public void transform(BTransform bTransform) {
    }

    public void translate(double d, double d2) {
        this.tx += d;
        this.ty += d2;
    }

    public IGeom getClip() {
        return this.clip;
    }

    public IRectGeom getClipBounds() {
        return this.clip.bounds();
    }

    public void clip(IGeom iGeom) {
        this.clip = iGeom;
        ++this.clipCount;
        IRectGeom iRectGeom = iGeom.bounds();
        double d = iRectGeom.x();
        double d2 = iRectGeom.y();
        double d3 = iRectGeom.width();
        double d4 = iRectGeom.height();
        this.out.w("<clipPath id='clip" + this.clipCount + "'>");
        this.out.w("<path d='M").w(d).w(",").w(d2).w(" ");
        this.out.w(" h ").w(d3);
        this.out.w(" v ").w(d4);
        this.out.w(" h ").w(-d3);
        this.out.w(" z' />");
        this.out.w("</clipPath>").nl();
    }

    public void clip(double d, double d2, double d3, double d4) {
        this.clip((IGeom)new RectGeom(d, d2, d3, d4));
    }

    public void stroke(IGeom iGeom) {
        switch (iGeom.getGeomCase()) {
            case 1: {
                ILineGeom iLineGeom = (ILineGeom)iGeom;
                this.strokeLine(iLineGeom.x1(), iLineGeom.y1(), iLineGeom.x2(), iLineGeom.y2());
                break;
            }
            case 2: {
                IRectGeom iRectGeom = (IRectGeom)iGeom;
                this.strokeRect(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
                break;
            }
            case 3: {
                this.strokeEllipse((IEllipseGeom)iGeom);
                break;
            }
            case 4: {
                this.strokePolygon((IPolygonGeom)iGeom);
                break;
            }
            case 5: {
                this.strokePath((IPathGeom)iGeom);
            }
        }
    }

    public void fill(IGeom iGeom) {
        switch (iGeom.getGeomCase()) {
            case 2: {
                IRectGeom iRectGeom = (IRectGeom)iGeom;
                this.fillRect(iRectGeom.x(), iRectGeom.y(), iRectGeom.width(), iRectGeom.height());
                break;
            }
            case 3: {
                this.fillEllipse((IEllipseGeom)iGeom);
                break;
            }
            case 4: {
                this.fillPolygon((IPolygonGeom)iGeom);
                break;
            }
            case 5: {
                this.fillPath((IPathGeom)iGeom);
            }
        }
    }

    public void strokeLine(double d, double d2, double d3, double d4) {
        this.out.w("<line clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" stroke='").w(this.brush).w("'");
        this.out.w(" x1='").w(this.tx + d).w("' y1='").w(this.ty + d2).w("'");
        this.out.w(" x2='").w(this.tx + d3).w("' y2='").w(this.ty + d4).w("'");
        this.out.w("/>").nl();
    }

    public void strokeRect(double d, double d2, double d3, double d4) {
        this.out.w("<rect clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" fill='none' stroke='").w(this.brush).w("'");
        this.out.w(" x='").w(this.tx + d).w("' y='").w(this.ty + d2).w("'");
        this.out.w(" width='").w(d3).w("' height='").w(d4).w("'");
        this.out.w("/>").nl();
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        this.out.w("<rect clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" stroke='none' fill='").w(this.brush).w("'");
        this.out.w(" x='").w(this.tx + d).w("' y='").w(this.ty + d2).w("'");
        this.out.w(" width='").w(d3).w("' height='").w(d4).w("'");
        this.out.w("/>").nl();
    }

    public void drawString(String string, double d, double d2) {
        this.drawString(string.toCharArray(), 0, string.length(), d, d2);
    }

    public void drawString(char[] cArray, int n, int n2, double d, double d2) {
        try {
            this.out.w("<text clip-path='url(#clip" + this.clipCount + ")'");
            this.out.w(" x='").w(this.tx + d).w("' y='").w(this.ty + d2).w("'");
            this.out.w(" fill='").w(this.brush).w("'");
            this.out.w(" font-family='").w(this.font.getName()).w("'");
            this.out.w(" font-size='").w(this.font.getSize()).w("'");
            if (this.font.isBold()) {
                this.out.w(" font-weight='bold'");
            }
            this.out.w(">");
            for (int i = n; i < n2; ++i) {
                XWriter.safe((java.io.Writer)this.writer, (int)cArray[i], (boolean)false);
            }
            this.out.w("</text>").nl();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void drawImage(BImage bImage, double d, double d2) {
    }

    private void strokeEllipse(IEllipseGeom iEllipseGeom) {
        double d = iEllipseGeom.width() / 2.0;
        double d2 = iEllipseGeom.height() / 2.0;
        double d3 = iEllipseGeom.x() + d;
        double d4 = iEllipseGeom.y() + d2;
        this.out.w("<ellipse clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" fill='none' stroke='").w(this.brush).w("'");
        this.out.w(" cx='").w(this.tx + d3).w("' cy='").w(this.ty + d4).w("'");
        this.out.w(" rx='").w(d).w("' ry='").w(d2).w("' />");
    }

    private void fillEllipse(IEllipseGeom iEllipseGeom) {
        double d = iEllipseGeom.width() / 2.0;
        double d2 = iEllipseGeom.height() / 2.0;
        double d3 = iEllipseGeom.x() + d;
        double d4 = iEllipseGeom.y() + d2;
        this.out.w("<ellipse clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" stroke='none' fill='").w(this.brush).w("'");
        this.out.w(" cx='").w(this.tx + d3).w("' cy='").w(this.ty + d4).w("'");
        this.out.w(" rx='").w(d).w("' ry='").w(d2).w("' />");
    }

    private void strokePolygon(IPolygonGeom iPolygonGeom) {
        this.out.w("<polygon clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" fill='none' stroke='").w(this.brush).w("' points='");
        for (int i = 0; i < iPolygonGeom.size(); ++i) {
            if (i > 0) {
                this.out.w(" ");
            }
            this.out.w(this.tx + iPolygonGeom.x(i)).w(",").w(this.ty + iPolygonGeom.y(i));
        }
        this.out.w("' />");
    }

    private void fillPolygon(IPolygonGeom iPolygonGeom) {
        this.out.w("<polygon clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" stroke='none' fill='").w(this.brush).w("' points='");
        for (int i = 0; i < iPolygonGeom.size(); ++i) {
            if (i > 0) {
                this.out.w(" ");
            }
            this.out.w(this.tx + iPolygonGeom.x(i)).w(",").w(this.ty + iPolygonGeom.y(i));
        }
        this.out.w("' />");
    }

    private void strokePath(IPathGeom iPathGeom) {
        this.out.w("<path clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" fill='none' stroke='").w(this.brush).w("'");
        this.out.w(" transform='translate(").w(this.tx).w(",").w(this.ty).w(")'");
        this.out.w(" d='");
        for (int i = 0; i < iPathGeom.size(); ++i) {
            if (i > 0) {
                this.out.w(" ");
            }
            this.out.w(iPathGeom.segment(i).toString());
        }
        this.out.w("' />");
    }

    private void fillPath(IPathGeom iPathGeom) {
        this.out.w("<path clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" stroke='none' fill='").w(this.brush).w("'");
        this.out.w(" transform='translate(").w(this.tx).w(",").w(this.ty).w(")'");
        this.out.w(" d='");
        for (int i = 0; i < iPathGeom.size(); ++i) {
            if (i > 0) {
                this.out.w(" ");
            }
            this.out.w(iPathGeom.segment(i).toString());
        }
        this.out.w("' />");
    }

    public void push() {
        GxState gxState = new GxState();
        gxState.tx = this.tx;
        gxState.ty = this.ty;
        gxState.brush = this.brush;
        gxState.pen = this.pen;
        gxState.font = this.font;
        this.stack.push(gxState);
    }

    public void pop() {
        GxState gxState = (GxState)this.stack.pop();
        this.tx = gxState.tx;
        this.ty = gxState.ty;
        this.brush = gxState.brush;
        this.pen = gxState.pen;
        this.font = gxState.font;
        this.clip(0.0, 0.0, this.width, this.height);
    }

    public void dispose() {
        this.out.w("</svg>");
    }

    class Writer {
        Writer() {
        }

        public Writer w(double d) {
            return this.w(Double.toString(d));
        }

        public Writer w(Object object) {
            return this.w(String.valueOf(object));
        }

        public Writer w(String string) {
            try {
                SvgGraphics.this.writer.print(string);
                return this;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public Writer w(char c) {
            try {
                SvgGraphics.this.writer.print(c);
                return this;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public Writer nl() {
            return this.w("\n");
        }
    }

    class GxState {
        public double tx;
        public double ty;
        public BBrush brush;
        public BPen pen;
        public BFont font;

        GxState() {
        }
    }
}

