/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.points;

import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.nrio.BIWritable;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioInputOutputModule;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioWriteAsyncRequest;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.point.conv.BReversePolarityConversion;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNrioProxyExt
extends BProxyExt
implements BIBasicPollable,
BIWritable,
NrioMessageConst {
    public static final Property conversion = BNrioProxyExt.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"nrio:NrioProxyConversionFE"));
    public static final Property pollFrequency = BNrioProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property instance = BNrioProxyExt.newProperty((int)0, (int)0, null);
    public static final Property isStrike = BNrioProxyExt.newProperty((int)5, (boolean)false, null);
    public static final Property isSdi = BNrioProxyExt.newProperty((int)5, (boolean)false, null);
    public static final Action postChangeTimeout = BNrioProxyExt.newAction((int)4, null);
    public static final Type TYPE;
    public static final byte[] ACTIVE_DATA;
    public static final byte[] INACTIVE_DATA;
    Clock.Ticket postChangeTicket;
    private int undoInstance;
    static /* synthetic */ Class class$com$tridium$nrio$points$BNrioProxyExt;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public int getInstance() {
        return this.getInt(instance);
    }

    public void setInstance(int n) {
        this.setInt(instance, n, null);
    }

    public boolean getIsStrike() {
        return this.getBoolean(isStrike);
    }

    public void setIsStrike(boolean bl) {
        this.setBoolean(isStrike, bl, null);
    }

    public boolean getIsSdi() {
        return this.getBoolean(isSdi);
    }

    public void setIsSdi(boolean bl) {
        this.setBoolean(isSdi, bl, null);
    }

    public void postChangeTimeout() {
        this.invoke(postChangeTimeout, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BControlPoint bControlPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
            if (bControlPoint != null) {
                this.setEnabled(false);
                this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + ' ' + bControlPoint.getName());
            }
            BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
            this.undoInstance = this.getInstance();
            if (this.getEnabled()) {
                bNrioNetwork.getPollScheduler().subscribe((BIPollable)this);
            }
        }
    }

    public void stopped() throws Exception {
        if (this.isRunning()) {
            BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
            bNrioNetwork.getPollScheduler().unsubscribe((BIPollable)this);
        }
        super.stopped();
    }

    public boolean requiresPointSubscription() {
        return false;
    }

    public Type getDeviceExtType() {
        return BNrioPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.writeonly : BReadWriteMode.readonly;
    }

    public void doReadPoint() {
        this.read();
    }

    public void readSubscribed(Context context) throws Exception {
    }

    public void readUnsubscribed(Context context) throws Exception {
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && context != Context.decoding) {
            BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
            if (property.equals((Object)instance)) {
                BControlPoint bControlPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
                if (bControlPoint != null) {
                    this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + ' ' + bControlPoint.getName());
                    this.setEnabled(false);
                } else {
                    if (this.getParentPoint().isWritablePoint()) {
                        this.device().setDoValue(false, this.undoInstance);
                        try {
                            this.write(null);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    this.undoInstance = this.getInstance();
                }
                this.device().updateProxyValues();
            } else if (property.equals((Object)enabled)) {
                if (this.getEnabled()) {
                    BControlPoint bControlPoint = this.device().checkForProxyExtConflicts(this.getParentPoint());
                    if (bControlPoint != null) {
                        this.readFail(this.getLexicon().getText("readFail.pointInstanceConflict") + ' ' + bControlPoint.getName());
                        this.setEnabled(false);
                        this.device().updateProxyValues();
                    } else {
                        this.device().updateProxyValues();
                        this.setPostChangeTicket();
                        if (this.getParentPoint().isWritablePoint()) {
                            try {
                                this.write(null);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
            } else if (property.equals((Object)conversion)) {
                this.device().updateProxyValues();
                this.setPostChangeTicket();
            }
        }
    }

    protected void convertDeviceToProxy(BStatusValue bStatusValue, BStatusValue bStatusValue2) {
        if (bStatusValue.getStatus().isFault() && this.getIsSdi() && this.getConversion().getType().is(BReversePolarityConversion.TYPE) && bStatusValue.getStatus().isFault()) {
            ((BStatusBoolean)bStatusValue).setValue(true);
        }
        super.convertDeviceToProxy(bStatusValue, bStatusValue2);
    }

    public void poll() {
        BNrioNetwork bNrioNetwork = this.network();
        if (bNrioNetwork.getLog().isTraceOn()) {
            bNrioNetwork.getLog().trace(this + ".poll()");
        }
        this.read();
        if (!this.getStatus().isStale()) {
            bNrioNetwork.getPollScheduler().unsubscribe((BIPollable)this);
        }
    }

    private final void read() {
        if (this.getParentPoint() instanceof BBooleanWritable) {
            this.readOk(this.getWriteValue());
        } else {
            this.device().updateProxyValues();
        }
    }

    public boolean write(Context context) throws Exception {
        BStatusValue bStatusValue = this.getWriteValue();
        if (bStatusValue.getStatus().isNull()) {
            return false;
        }
        BNrioNetwork bNrioNetwork = this.network();
        this.readOk(bStatusValue);
        if (bNrioNetwork.isDownLoadInProcess()) {
            return false;
        }
        bNrioNetwork.postWrite(new NrioWriteAsyncRequest(this, bStatusValue));
        return true;
    }

    public void writeData(BStatusValue bStatusValue) {
        BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
        if (bNrioNetwork == null) {
            return;
        }
        if (this.device() instanceof BNrioInputOutputModule) {
            int n = ((BNrioInputOutputModule)this.device()).setDoValue(((BStatusBoolean)bStatusValue).getValue(), this.getInstance());
            if (n == 0) {
                this.writeOk(bStatusValue);
            } else {
                this.writeFail("writeError: " + n);
            }
        } else if (this.device() instanceof BNrio16Module) {
            int n = ((BNrio16Module)this.device()).setDoValue(((BStatusBoolean)bStatusValue).getValue(), this.getInstance());
            if (n == 0) {
                this.writeOk(bStatusValue);
            } else {
                this.writeFail("writeError: " + n);
            }
        }
    }

    public String toString(Context context) {
        return super.toString(context);
    }

    private final BNrioDevice device() {
        return (BNrioDevice)this.getDevice();
    }

    private final BNrioNetwork network() {
        return (BNrioNetwork)this.getDevice().getNetwork();
    }

    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    public boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    public void doPostChangeTimeout() {
        BControlPoint bControlPoint = this.getParentPoint();
        if (bControlPoint != null) {
            bControlPoint.execute();
        }
    }

    private final void setPostChangeTicket() {
        if (this.postChangeTicket != null) {
            this.postChangeTicket.cancel();
        }
        this.postChangeTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)500L), (Action)postChangeTimeout, null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.postChangeTicket = null;
        this.undoInstance = -1;
    }

    public BNrioProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nrio$points$BNrioProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$points$BNrioProxyExt = BNrioProxyExt.class("[Lcom.tridium.nrio.points.BNrioProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ACTIVE_DATA = new byte[]{1};
        INACTIVE_DATA = new byte[1];
    }
}

