/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.points;

import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.components.BNrio16Status;
import com.tridium.nrio.enums.BNrio16CounterSelectEnum;
import com.tridium.nrio.enums.BUniversalInputTypeEnum;
import com.tridium.nrio.points.BUiProxyExt;
import com.tridium.nrio.types.BAbstractRateType;
import com.tridium.nrio.types.BFixedWindowRateType;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNrioCounterInputProxyExt
extends BUiProxyExt {
    public static final Property uiType = BNrioCounterInputProxyExt.newProperty((int)1, (BValue)BUniversalInputTypeEnum.di_HighSpeed, null);
    public static final Property outputSelect = BNrioCounterInputProxyExt.newProperty((int)0, (BValue)BNrio16CounterSelectEnum.count, null);
    public static final Property total = BNrioCounterInputProxyExt.newProperty((int)1, (int)-1, null);
    public static final Property rate = BNrioCounterInputProxyExt.newProperty((int)3, (int)0, null);
    public static final Property rateCalcType = BNrioCounterInputProxyExt.newProperty((int)0, (BValue)BTypeSpec.make((String)"nrio:FixedWindowRateType"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"nrio:AbstractRateType")));
    public static final Property rateCalc = BNrioCounterInputProxyExt.newProperty((int)1, (BValue)new BFixedWindowRateType(), null);
    public static final Property rateCalcTime = BNrioCounterInputProxyExt.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Action reset = BNrioCounterInputProxyExt.newAction((int)0, null);
    public static final Action set = BNrioCounterInputProxyExt.newAction((int)0, (BValue)BLong.make((long)0L), null);
    public static final Action recalculateRate = BNrioCounterInputProxyExt.newAction((int)4, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$nrio$points$BNrioCounterInputProxyExt;

    public BNrio16CounterSelectEnum getOutputSelect() {
        return (BNrio16CounterSelectEnum)this.get(outputSelect);
    }

    public void setOutputSelect(BNrio16CounterSelectEnum bNrio16CounterSelectEnum) {
        this.set(outputSelect, (BValue)bNrio16CounterSelectEnum, null);
    }

    public long getTotal() {
        return this.getLong(total);
    }

    public void setTotal(long l) {
        this.setLong(total, l, null);
    }

    public double getRate() {
        return this.getDouble(rate);
    }

    public void setRate(double d) {
        this.setDouble(rate, d, null);
    }

    public BTypeSpec getRateCalcType() {
        return (BTypeSpec)this.get(rateCalcType);
    }

    public void setRateCalcType(BTypeSpec bTypeSpec) {
        this.set(rateCalcType, (BValue)bTypeSpec, null);
    }

    public BAbstractRateType getRateCalc() {
        return (BAbstractRateType)this.get(rateCalc);
    }

    public void setRateCalc(BAbstractRateType bAbstractRateType) {
        this.set(rateCalc, (BValue)bAbstractRateType, null);
    }

    public BAbsTime getRateCalcTime() {
        return (BAbsTime)this.get(rateCalcTime);
    }

    public void setRateCalcTime(BAbsTime bAbsTime) {
        this.set(rateCalcTime, (BValue)bAbsTime, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void set(BLong bLong) {
        this.invoke(set, (BValue)bLong, null);
    }

    public void recalculateRate() {
        this.invoke(recalculateRate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            if (this.getTotal() < 0L) {
                return;
            }
            BNrio16Module bNrio16Module = (BNrio16Module)this.getDevice();
            ((BNrio16Status)bNrio16Module.getIoStatus()).setTotalCounts(this.getInstance(), this.getTotal());
        }
    }

    public boolean isParentLegal(BComponent bComponent) {
        return super.isParentLegal(bComponent) && bComponent instanceof BNumericPoint;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning()) {
            if (property.equals((Object)rateCalcType)) {
                BAbstractRateType bAbstractRateType = (BAbstractRateType)this.getRateCalcType().getInstance();
                this.getRateCalc().cleanupType();
                this.setRateCalc(bAbstractRateType);
                this.getRateCalc().initType();
                this.setStale(true, null);
            } else if (property.equals((Object)outputSelect)) {
                this.setStale(true, null);
            } else if (property.equals((Object)total)) {
                this.doRecalculateRate();
            }
        }
    }

    public void ioValueChanged() {
        BNrio16Status bNrio16Status = (BNrio16Status)((BNrio16Module)this.getDevice()).getIoStatus();
        if (this.getUiType().getOrdinal() != 2 || this.getInstance() < 1 || this.getInstance() > 8) {
            this.readFail("readFail.invalidInstanceOrData");
        } else {
            try {
                long l = bNrio16Status.getTotalCounts(this.getInstance());
                if (l == this.getTotal()) {
                    this.recalculateRate();
                } else {
                    this.setTotal(l);
                }
            }
            catch (Exception exception) {
                this.readFail(exception.getMessage());
            }
        }
    }

    public void doReset() {
        this.doSet(BLong.make((long)0L));
    }

    public synchronized void doSet(BLong bLong) {
        long l = bLong.getLong();
        BNrio16Status bNrio16Status = (BNrio16Status)((BNrio16Module)this.getDevice()).getIoStatus();
        bNrio16Status.setTotalCounts(this.getInstance(), l);
        this.getRateCalc().resetRate();
        this.setTotal(l);
    }

    public void doRecalculateRate() {
        try {
            BStatusNumeric bStatusNumeric = this.getRateCalc().calculateRate(this.getTotal());
            if (bStatusNumeric != null) {
                this.setRate(bStatusNumeric.getValue());
                if (this.getOutputSelect() == BNrio16CounterSelectEnum.rate) {
                    this.readOk((BStatusValue)bStatusNumeric);
                } else {
                    this.readOk((BStatusValue)new BStatusNumeric((double)this.getTotal()));
                }
            } else if (this.getOutputSelect() == BNrio16CounterSelectEnum.rate) {
                this.setStale(true, null);
            }
        }
        catch (Exception exception) {
            this.readFail(exception.getMessage());
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$nrio$points$BNrioCounterInputProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$points$BNrioCounterInputProxyExt = BNrioCounterInputProxyExt.class("[Lcom.tridium.nrio.points.BNrioCounterInputProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

