/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.job;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.WriteDownLoadData;
import com.tridium.nrio.messages.WriteDownLoadStart;
import com.tridium.nrio.messages.WriteDownLoadStop;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.baja.driver.BDevice;
import javax.baja.file.BIFile;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BUpgradeFirmwareJob
extends BSimpleJob
implements NrioMessageConst {
    public static final Type TYPE;
    private static boolean isRunning;
    final BNrioNetwork accessNet;
    static /* synthetic */ Class class$com$tridium$nrio$job$BUpgradeFirmwareJob;

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        if (isRunning) {
            throw new IllegalStateException("FirmwareUpgrade already running could not start!!!");
        }
        isRunning = true;
        this.logMessage("starting...");
        boolean bl = false;
        BDevice[] bDeviceArray = this.accessNet.getDevices();
        try {
            this.accessNet.setDownLoadInProcess(true);
            this.logMessage("Wait 15 seconds to allow all devices to go 0ffline");
            int n = 1;
            while (n <= 15) {
                this.progress(n);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                ++n;
            }
            n = 0;
            while (n < bDeviceArray.length) {
                if (bDeviceArray[n] instanceof BNrioDevice && !bDeviceArray[n].isDown()) {
                    BNrioDevice bNrioDevice = (BNrioDevice)bDeviceArray[n];
                    if (!this.upgradeFirmware(bNrioDevice)) {
                        bl = true;
                    }
                    this.progress(15 + (n + 1) * 85 / bDeviceArray.length);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.accessNet.setDownLoadInProcess(false);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        int n = 0;
        while (n < bDeviceArray.length) {
            ((BNrioDevice)bDeviceArray[n]).doPing();
            ++n;
        }
        isRunning = false;
        if (bl) {
            throw new IllegalStateException("complete with errors");
        }
    }

    private final boolean upgradeFirmware(BNrioDevice bNrioDevice) {
        boolean bl = false;
        if (!bl && bNrioDevice.getInstalledVersion().equals(bNrioDevice.getAvailableVersion())) {
            this.logMessage(" device " + bNrioDevice.getDisplayName(null) + " is up to date");
            return true;
        }
        BIFile bIFile = this.accessNet.getFirmwareFile(bNrioDevice.getDeviceType());
        if (bIFile == null) {
            this.logMessage("downloadFile is null!!");
            return false;
        }
        this.logMessage(" upgrading device: " + bNrioDevice.getDisplayName(null) + " with file " + bIFile.getFileName());
        IntelHexFile intelHexFile = new IntelHexFile(bIFile);
        if (intelHexFile == null) {
            this.logMessage("hexFile is null!!!!!!!!!!!!!!!!!");
            return false;
        }
        Vector vector = intelHexFile.readMemoryBlocks();
        if (vector == null) {
            this.logMessage("vector is null!!!!!!!!!!!!!!!!!");
            return false;
        }
        long l = Clock.ticks();
        bNrioDevice.setInstalledVersion("upgrading firmware");
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {}
        WriteDownLoadStart writeDownLoadStart = new WriteDownLoadStart(bNrioDevice.getAddress());
        NrioMessage nrioMessage = this.accessNet.sendDownLoadMessage(writeDownLoadStart, 0);
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {}
        if (nrioMessage == null || nrioMessage.getStatus() != 0) {
            this.logMessage("Aborting - start down load returned error!");
            bNrioDevice.setInstalledVersion("upgrade failed");
            return false;
        }
        boolean bl2 = false;
        int n = 0;
        while (n < vector.size()) {
            MemoryBlock memoryBlock = (MemoryBlock)vector.elementAt(n);
            if (memoryBlock.baseAddress >= 49152 && memoryBlock.baseAddress < 53248) {
                bl2 = true;
                if (!this.writeMemoryBlock(bNrioDevice.getAddress(), memoryBlock)) {
                    this.logMessage(" WriteDownLoad message returned error!!!");
                    bNrioDevice.setInstalledVersion("upgrade failed");
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        WriteDownLoadStop writeDownLoadStop = new WriteDownLoadStop(bNrioDevice.getAddress());
        nrioMessage = this.accessNet.sendDownLoadMessage(writeDownLoadStop, 0);
        if (!bl2) {
            this.logMessage(" Oxc000 block does not exist!!!");
            bNrioDevice.setInstalledVersion("upgrade failed");
            return false;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            MemoryBlock memoryBlock = (MemoryBlock)vector.elementAt(n2);
            if (memoryBlock.baseAddress < 49152 || memoryBlock.baseAddress >= 53248) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
                this.writeMemoryBlock(bNrioDevice.getAddress(), memoryBlock);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        writeDownLoadStop = new WriteDownLoadStop(bNrioDevice.getAddress());
        nrioMessage = this.accessNet.sendDownLoadMessage(writeDownLoadStop, 0);
        long l2 = Clock.ticks() - l;
        this.logMessage(bNrioDevice.getDisplayName(null) + " - Download completed in " + l2 + " milliseconds");
        bNrioDevice.setInstalledVersion("upgraded");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        return true;
    }

    private final boolean writeMemoryBlock(int n, MemoryBlock memoryBlock) {
        byte[] byArray = memoryBlock.out.toByteArray();
        int n2 = 0;
        WriteDownLoadData writeDownLoadData = new WriteDownLoadData(n, byArray, memoryBlock.baseAddress, n2);
        while (n2 < byArray.length) {
            writeDownLoadData.setOffset(n2);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
            NrioMessage nrioMessage = this.accessNet.sendDownLoadMessage(writeDownLoadData, 2);
            if (nrioMessage == null || nrioMessage.getStatus() != 0) {
                System.out.println("null response or status != 0");
                if (nrioMessage != null) {
                    System.out.println("response = \n" + nrioMessage.toDebugString());
                }
                return false;
            }
            n2 += 64;
        }
        return true;
    }

    private final void logMessage(String string) {
        this.log().message(string);
        if (this.accessNet != null) {
            int n = this.accessNet.getLog().getSeverity();
            this.accessNet.getLog().setSeverity(1);
            this.accessNet.getLog().message("Upgrade Firmware Job:" + string);
            this.accessNet.getLog().setSeverity(n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BUpgradeFirmwareJob() {
        this.accessNet = null;
    }

    public BUpgradeFirmwareJob(BNrioNetwork bNrioNetwork) {
        this.accessNet = bNrioNetwork;
    }

    static {
        Class clazz = class$com$tridium$nrio$job$BUpgradeFirmwareJob;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$job$BUpgradeFirmwareJob = BUpgradeFirmwareJob.class("[Lcom.tridium.nrio.job.BUpgradeFirmwareJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        isRunning = false;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IntelHexFile {
        private BIFile file;
        private InputStream inStream;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Vector readMemoryBlocks() {
            try {
                Vector<MemoryBlock> vector = new Vector<MemoryBlock>();
                int n = -1;
                IntelHexLine intelHexLine = this.readHexLine();
                if (intelHexLine == null) {
                    return null;
                }
                MemoryBlock memoryBlock = new MemoryBlock(intelHexLine.getBaseAddress());
                memoryBlock.write(intelHexLine.getData());
                n = intelHexLine.getBaseAddress() + intelHexLine.getData().length;
                boolean bl = false;
                block2: while (true) {
                    if (bl) {
                        return vector;
                    }
                    intelHexLine = this.readHexLine();
                    if (intelHexLine == null || intelHexLine.isEndOfFile()) {
                        vector.addElement(memoryBlock);
                        return vector;
                    }
                    while (true) {
                        if (intelHexLine.getBaseAddress() != n) {
                            vector.addElement(memoryBlock);
                            memoryBlock = new MemoryBlock(intelHexLine.getBaseAddress());
                            memoryBlock.write(intelHexLine.getData());
                            n = intelHexLine.getBaseAddress() + intelHexLine.getData().length;
                            continue block2;
                        }
                        memoryBlock.write(intelHexLine.getData());
                        n = intelHexLine.getBaseAddress() + intelHexLine.getData().length;
                        intelHexLine = this.readHexLine();
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        IntelHexLine readHexLine() {
            IntelHexLine intelHexLine = new IntelHexLine();
            int n = 0;
            while (true) {
                while (n != 58) {
                    n = this.inStream.read();
                }
                int n2 = this.readByte();
                int n3 = this.readWord();
                intelHexLine.setBaseAddress(n3);
                boolean bl = false;
                if (this.readByte() == 1) {
                    bl = true;
                }
                boolean bl2 = bl;
                intelHexLine.setEndOfFile(bl2);
                intelHexLine.setDataSize(n2);
                if (bl2) {
                    return intelHexLine;
                }
                if (n2 != 0) {
                    byte[] byArray = intelHexLine.getData();
                    int n4 = 0;
                    while (n4 < n2) {
                        byArray[n4] = (byte)this.readByte();
                        ++n4;
                    }
                    return intelHexLine;
                }
                try {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
        }

        int readByte() throws Exception {
            int n = this.inStream.read();
            int n2 = TextUtil.hexCharToInt((char)((char)n));
            n = this.inStream.read();
            n2 = n2 << 4 | TextUtil.hexCharToInt((char)((char)n));
            return n2;
        }

        int readWord() throws Exception {
            int n = this.readByte();
            n = n << 8 | this.readByte();
            return n;
        }

        private IntelHexFile(BIFile bIFile) {
            this.file = bIFile;
            try {
                this.inStream = bIFile.getInputStream();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MemoryBlock {
        ByteArrayOutputStream out;
        int baseAddress;

        private final void writeByte(int n) {
            this.out.write(n);
        }

        private final void write(byte[] byArray) {
            this.out.write(byArray, 0, byArray.length);
        }

        public String toString() {
            return "baseAddress = " + Integer.toHexString(this.baseAddress) + " size = " + Integer.toHexString(this.out.size());
        }

        private final /* synthetic */ void this() {
            this.out = new ByteArrayOutputStream();
        }

        private MemoryBlock(int n) {
            this.this();
            this.baseAddress = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class IntelHexLine {
        boolean endOfFile;
        int address;
        byte[] data;

        void setDataSize(int n) {
            this.data = new byte[n];
        }

        void setBaseAddress(int n) {
            this.address = n;
        }

        void setData(byte[] byArray) {
            this.data = byArray;
        }

        void setEndOfFile(boolean bl) {
            this.endOfFile = bl;
        }

        int getBaseAddress() {
            return this.address;
        }

        byte[] getData() {
            return this.data;
        }

        boolean isEndOfFile() {
            return this.endOfFile;
        }

        private final /* synthetic */ void this() {
            this.endOfFile = false;
            this.address = 0;
        }

        IntelHexLine() {
            this.this();
        }
    }
}

