/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.job;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.NrioInputStream;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.PingMessage;
import com.tridium.nrio.messages.PingResponse;
import com.tridium.nrio.messages.SetLogicalAddressMessage;
import com.tridium.nrio.messages.UnconfiguredModuleReply;
import java.util.Vector;
import javax.baja.driver.BDevice;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNrioLearnDevicesJob
extends BSimpleJob {
    public static final Property learnedDevices = BNrioLearnDevicesJob.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Type TYPE;
    protected static final String LEARN_NAME_PREFIX = "Device";
    final BNrioNetwork nrioNet;
    protected int learnCount;
    static /* synthetic */ Class class$com$tridium$nrio$job$BNrioLearnDevicesJob;
    static /* synthetic */ Class class$com$tridium$nrio$components$BNrioLearnDeviceEntry;

    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    public void setLearnedDevices(BFolder bFolder) {
        this.set(learnedDevices, (BValue)bFolder, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void addLearnedDevice(int n, BNrioDeviceTypeEnum bNrioDeviceTypeEnum, byte[] byArray, String string, String string2) {
        String string3 = "device_" + ByteArrayUtil.toHexString((byte[])byArray);
        if (this.getLearnedDevices().get(string3) == null) {
            this.getLearnedDevices().add(string3, (BValue)new BNrioLearnDeviceEntry(n, bNrioDeviceTypeEnum, byArray, string, string2));
            this.logMessage("found device " + string3 + " usedBy: " + string2);
            ++this.learnCount;
        } else {
            this.getDiscoveryLog().trace(string3 + " already learned ???");
        }
        this.progress(this.learnCount * 100 / 16);
    }

    protected void removeLearnedDevice(byte[] byArray) {
        String string = "device" + ByteArrayUtil.toHexString((byte[])byArray);
        if (this.getLearnedDevices().get(string) != null) {
            this.getLearnedDevices().remove(string);
            --this.learnCount;
        }
    }

    public void run(Context context) throws Exception {
        BNrioLearnDeviceEntry[] bNrioLearnDeviceEntryArray;
        this.logMessage("starting");
        if (this.nrioNet.isDisabled() || this.nrioNet.isFault()) {
            this.logMessage("Network is disabled or configured incorrectly");
            throw new RuntimeException("Network is disabled or configured incorrectly");
        }
        try {
            bNrioLearnDeviceEntryArray = new NrioMessage();
            UnconfiguredModuleReply unconfiguredModuleReply = new UnconfiguredModuleReply();
            Vector vector = new Vector();
            this.nrioNet.initLogicalAddressMap();
            Vector vector2 = new Vector();
            boolean bl = false;
            boolean bl2 = true;
            int n = 0;
            while (bl2 || vector2.size() > 0 && !bl && this.isAlive()) {
                bl2 = false;
                try {
                    this.getDiscoveryLog().trace("*** nrioNet.discover() called *****");
                    vector2 = this.nrioNet.discover();
                    n = 0;
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {}
                    this.getDiscoveryLog().trace("*** unconfigDevices.size() = " + vector2.size());
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        byte[] byArray = (byte[])vector2.elementAt(n2);
                        this.getDiscoveryLog().trace("NrioDiscovery byte[] = " + ByteArrayUtil.toHexString((byte[])byArray));
                        NrioReceivedMessage nrioReceivedMessage = new NrioReceivedMessage(byArray, byArray.length, null);
                        NrioInputStream nrioInputStream = bNrioLearnDeviceEntryArray.readResponse(nrioReceivedMessage);
                        unconfiguredModuleReply.readData(nrioInputStream);
                        BNrioDevice bNrioDevice = this.nrioNet.getDevice(unconfiguredModuleReply.getUid());
                        int n3 = -1;
                        if (bNrioDevice == null) {
                            n3 = this.nrioNet.getFreeAddress(unconfiguredModuleReply.isReader());
                            if (n3 < 0) {
                                this.getDiscoveryLog().trace("************** no free addresses availiable ****************");
                                this.logMessage("no free address is availiable for this module!");
                                this.addLearnedDevice(n3, BNrioDeviceTypeEnum.makeFromRaw(unconfiguredModuleReply.getModuleType()), unconfiguredModuleReply.getUid(), "", "");
                                bl = true;
                            } else if (this.setAddressAndPing(n3, unconfiguredModuleReply.getUid(), unconfiguredModuleReply.getModuleType()) != 0) {
                                this.nrioNet.clearAddressUsed(n3);
                            } else {
                                String string = this.nrioNet.readBuildInfo(n3);
                                this.addLearnedDevice(n3, BNrioDeviceTypeEnum.makeFromRaw(unconfiguredModuleReply.getModuleType()), unconfiguredModuleReply.getUid(), string, "");
                            }
                        } else {
                            this.getDiscoveryLog().trace(" ******  discovered device allready in station ******");
                            n3 = bNrioDevice.getAddress();
                            if (this.setAddressAndPing(n3, unconfiguredModuleReply.getUid(), unconfiguredModuleReply.getModuleType()) == 0) {
                                if (bNrioDevice.sendWriteConfig() == 0) {
                                    this.nrioNet.enablePolling(n3);
                                } else {
                                    this.getDiscoveryLog().trace("write config was not Ok");
                                }
                                bNrioDevice.readBuildInfo();
                            } else {
                                this.getDiscoveryLog().trace("Set logical address and Ping was not Ok");
                                this.addLearnedDevice(n3, BNrioDeviceTypeEnum.makeFromRaw(unconfiguredModuleReply.getModuleType()), unconfiguredModuleReply.getUid(), bNrioDevice.getInstalledVersion(), bNrioDevice.getDisplayName(null));
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    this.getDiscoveryLog().trace("*** caught Exception: " + exception + " count = " + ++n);
                    if (n > 10) {
                        bl = true;
                    } else {
                        bl2 = true;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception2) {}
                }
            }
            this.addExistingDevices();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BFolder bFolder = this.getLearnedDevices();
        Class clazz = class$com$tridium$nrio$components$BNrioLearnDeviceEntry;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$components$BNrioLearnDeviceEntry = BNrioLearnDevicesJob.class("[Lcom.tridium.nrio.components.BNrioLearnDeviceEntry;", false);
        }
        bNrioLearnDeviceEntryArray = (BNrioLearnDeviceEntry[])bFolder.getChildren(clazz);
        int n = 0;
        while (n < bNrioLearnDeviceEntryArray.length) {
            if (bNrioLearnDeviceEntryArray[n].getUsedBy().equals("")) {
                this.nrioNet.sendReset(bNrioLearnDeviceEntryArray[n].getAddress());
            }
            ++n;
        }
        this.progress(100);
    }

    protected void addExistingDevices() {
        BDevice[] bDeviceArray = this.nrioNet.getDevices();
        int n = 0;
        while (n < bDeviceArray.length) {
            if (bDeviceArray[n] instanceof BNrioDevice && !bDeviceArray[n].isDown() && !bDeviceArray[n].isFault()) {
                BNrioDevice bNrioDevice = (BNrioDevice)bDeviceArray[n];
                this.addLearnedDevice(bNrioDevice.getAddress(), bNrioDevice.getDeviceType(), bNrioDevice.getUid().copyBytes(), bNrioDevice.getInstalledVersion(), bNrioDevice.getDisplayName(null));
            }
            ++n;
        }
    }

    protected int setAddressAndPing(int n, byte[] byArray, int n2) {
        SetLogicalAddressMessage setLogicalAddressMessage = new SetLogicalAddressMessage(n, byArray);
        NrioMessage nrioMessage = this.nrioNet.sendNrioMessage(setLogicalAddressMessage);
        if (nrioMessage.getStatus() != 0) {
            return nrioMessage.getStatus();
        }
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {}
        PingMessage pingMessage = new PingMessage(n, byArray, n2);
        PingResponse pingResponse = (PingResponse)this.nrioNet.sendNrioMessage(pingMessage);
        return pingResponse.getStatus();
    }

    public Log getDiscoveryLog() {
        return Log.getLog((String)(this.nrioNet.getName() + ".discovery"));
    }

    protected void logMessage(String string) {
        this.log().message(string);
        if (this.nrioNet != null) {
            Log log = this.getDiscoveryLog();
            int n = log.getSeverity();
            log.setSeverity(1);
            log.message("Learn Niagara Remote IO Devices Job:" + string);
            log.setSeverity(n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.learnCount = 0;
    }

    public BNrioLearnDevicesJob() {
        this.this();
        this.nrioNet = null;
    }

    public BNrioLearnDevicesJob(BNrioNetwork bNrioNetwork) {
        this.this();
        this.nrioNet = bNrioNetwork;
    }

    static {
        Class clazz = class$com$tridium$nrio$job$BNrioLearnDevicesJob;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$job$BNrioLearnDevicesJob = BNrioLearnDevicesJob.class("[Lcom.tridium.nrio.job.BNrioLearnDevicesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

