/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.conv;

import com.tridium.util.EscUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BNrioTabularThermistorConversion
extends BProxyConversion {
    private static final String DEFAULT_ENCODING = "Thermistor Type 3|0.0,165.0;610.0,110.0;1060.0,90.0;1690.0,75.0;2320.0,65.0;3250.0,55.0;4620.0,45.0;6240.0,37.0;8197.0,30.0;10000.0,25.0;12268.0,20.0;15136.0,15.0;18787.0,10.0;23462.0,5.0;29490.0,0.0;37316.0,-5.0;47549.0,-10.0;61030.0,-15.0;78930.0,-20.0;100000.0,-25.0;";
    public static final BNrioTabularThermistorConversion NULL = BNrioTabularThermistorConversion.make();
    public static final BNrioTabularThermistorConversion DEFAULT = BNrioTabularThermistorConversion.make("Thermistor Type 3|0.0,165.0;610.0,110.0;1060.0,90.0;1690.0,75.0;2320.0,65.0;3250.0,55.0;4620.0,45.0;6240.0,37.0;8197.0,30.0;10000.0,25.0;12268.0,20.0;15136.0,15.0;18787.0,10.0;23462.0,5.0;29490.0,0.0;37316.0,-5.0;47549.0,-10.0;61030.0,-15.0;78930.0,-20.0;100000.0,-25.0;");
    public static final Type TYPE;
    private static BUnit OHMS_UNIT;
    private static BUnit CELSIUS_UNIT;
    private Array points;
    private double[] ohmsArray;
    private double[] celsiusArray;
    private String description;
    static /* synthetic */ Class class$com$tridium$nrio$conv$BNrioTabularThermistorConversion;
    static /* synthetic */ Class class$com$tridium$nrio$conv$BNrioTabularThermistorConversion$XYPoint;

    public static final BNrioTabularThermistorConversion make() {
        return new BNrioTabularThermistorConversion();
    }

    public static final BNrioTabularThermistorConversion make(String string) {
        try {
            return (BNrioTabularThermistorConversion)NULL.decodeFromString(string);
        }
        catch (Exception exception) {
            return new BNrioTabularThermistorConversion();
        }
    }

    public final Array getPoints() {
        return this.points;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final void add(double d, double d2) {
        XYPoint xYPoint = new XYPoint(d, d2);
        this.points.add((Object)xYPoint);
        this.refreshArrays();
    }

    public final void convertDeviceToProxy(BProxyExt bProxyExt, BStatusValue bStatusValue, BStatusValue bStatusValue2) throws Exception {
        if (bStatusValue instanceof BStatusNumeric) {
            BUnit bUnit = (BUnit)bProxyExt.getPointFacets().get("units", (BObject)BUnit.NULL);
            BUnit bUnit2 = (BUnit)bProxyExt.getDeviceFacets().get("units", (BObject)BUnit.NULL);
            boolean bl = false;
            if (bUnit2.isConvertible(OHMS_UNIT) || bUnit2.isNull()) {
                bl = true;
            }
            boolean bl2 = bl;
            boolean bl3 = bUnit.isConvertible(CELSIUS_UNIT);
            if (this.ohmsArray == null) {
                bStatusValue.copyFrom((BComplex)bStatusValue2);
                throw new UnitException("Not convertible: invalid points table");
            }
            if (bl2 && bl3) {
                double d = bUnit2.convertTo(OHMS_UNIT, ((BStatusNumeric)bStatusValue).getValue());
                double d2 = this.convertTo(d, this.ohmsArray, this.celsiusArray);
                bStatusValue2.setStatus(bStatusValue.getStatus());
                ((BStatusNumeric)bStatusValue2).setValue(CELSIUS_UNIT.convertTo(bUnit, d2));
                return;
            }
            bStatusValue2.copyFrom((BComplex)bStatusValue);
            throw new UnitException("Not convertible: " + bUnit2 + " -> " + bUnit);
        }
        bStatusValue2.copyFrom((BComplex)bStatusValue);
        throw new UnitException("Not convertible: invalid point type");
    }

    public final void convertProxyToDevice(BProxyExt bProxyExt, BStatusValue bStatusValue, BStatusValue bStatusValue2) throws Exception {
        if (bStatusValue instanceof BStatusNumeric) {
            BUnit bUnit = (BUnit)bProxyExt.getPointFacets().get("units", (BObject)BUnit.NULL);
            BUnit bUnit2 = (BUnit)bProxyExt.getDeviceFacets().get("units", (BObject)BUnit.NULL);
            boolean bl = false;
            if (bUnit2.isConvertible(OHMS_UNIT) || bUnit2.isNull()) {
                bl = true;
            }
            boolean bl2 = bl;
            boolean bl3 = bUnit.isConvertible(CELSIUS_UNIT);
            if (this.ohmsArray == null) {
                bStatusValue2.copyFrom((BComplex)bStatusValue);
                throw new UnitException("Not convertible: invalid points table");
            }
            if (bl2 && bl3) {
                double d = bUnit.convertTo(CELSIUS_UNIT, ((BStatusNumeric)bStatusValue).getValue());
                double d2 = this.convertTo(d, this.celsiusArray, this.ohmsArray);
                bStatusValue2.setStatus(bStatusValue.getStatus());
                ((BStatusNumeric)bStatusValue2).setValue(OHMS_UNIT.convertTo(bUnit2, d2));
                return;
            }
            bStatusValue2.copyFrom((BComplex)bStatusValue);
            throw new UnitException("Not convertible: " + bUnit + " -> " + bUnit2);
        }
        bStatusValue2.copyFrom((BComplex)bStatusValue);
        throw new UnitException("Not convertible: invalid point type");
    }

    private final double convertTo(double d, double[] dArray, double[] dArray2) {
        int n = 0;
        int n2 = dArray.length;
        if (d < dArray[0]) {
            return dArray2[0];
        }
        if (d > dArray[n2 - 1]) {
            return dArray2[n2 - 1];
        }
        if (d == dArray[n2 - 1]) {
            return dArray2[n2 - 1];
        }
        int n3 = 0;
        while (n3 < n2 - 1) {
            if (d >= dArray[n3] && d < dArray[n3 + 1]) {
                n = n3;
                break;
            }
            ++n3;
        }
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        double d4 = dArray2[n];
        double d5 = dArray2[n + 1];
        return d4 - (d2 - d) * (d4 - d5) / (d2 - d3);
    }

    public final boolean equals(Object object) {
        return false;
    }

    public final String toString(Context context) {
        return this.encodeToString();
    }

    public final void regen() {
        this.points = this.points.sort();
        this.refreshArrays();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = EscUtil.slot.escape(this.description);
        stringBuffer.append(string).append("|");
        int n = 0;
        while (n < this.points.size()) {
            XYPoint xYPoint = (XYPoint)this.points.get(n);
            stringBuffer.append(xYPoint.x()).append(',').append(xYPoint.y()).append(';');
            ++n;
        }
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        BNrioTabularThermistorConversion bNrioTabularThermistorConversion = new BNrioTabularThermistorConversion();
        int n = -1;
        int n2 = string.indexOf(124);
        String string2 = string.substring(0, n2);
        bNrioTabularThermistorConversion.setDescription(EscUtil.slot.unescape(string2));
        n = n2;
        n2 = string.indexOf(59);
        while (true) {
            if (n2 == -1) break;
            this.decodePoint(bNrioTabularThermistorConversion, string.substring(n + 1, n2));
            n = n2;
            n2 = string.indexOf(59, n + 1);
        }
        this.decodePoint(bNrioTabularThermistorConversion, string.substring(n + 1));
        bNrioTabularThermistorConversion.regen();
        return bNrioTabularThermistorConversion;
    }

    private final void decodePoint(BNrioTabularThermistorConversion bNrioTabularThermistorConversion, String string) {
        int n = string.indexOf(44);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        if (string2.length() > 0 && string3.length() > 0) {
            try {
                double d = Double.parseDouble(string2);
                double d2 = Double.parseDouble(string3);
                bNrioTabularThermistorConversion.add(d, d2);
            }
            catch (Exception exception) {}
        }
    }

    private final void refreshArrays() {
        if (this.points.size() >= 2) {
            this.ohmsArray = new double[this.points.size()];
            this.celsiusArray = new double[this.points.size()];
            int n = 0;
            while (n < this.points.size()) {
                XYPoint xYPoint = (XYPoint)this.points.get(n);
                this.ohmsArray[n] = xYPoint.x();
                this.celsiusArray[n] = xYPoint.y();
                ++n;
            }
        } else {
            this.celsiusArray = null;
            this.ohmsArray = null;
        }
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$nrio$conv$BNrioTabularThermistorConversion$XYPoint;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$conv$BNrioTabularThermistorConversion$XYPoint = BNrioTabularThermistorConversion.class("[Lcom.tridium.nrio.conv.BNrioTabularThermistorConversion$XYPoint;", false);
        }
        this.points = new Array(clazz);
        this.ohmsArray = null;
        this.celsiusArray = null;
        this.description = "";
    }

    private BNrioTabularThermistorConversion() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nrio$conv$BNrioTabularThermistorConversion;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$conv$BNrioTabularThermistorConversion = BNrioTabularThermistorConversion.class("[Lcom.tridium.nrio.conv.BNrioTabularThermistorConversion;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        OHMS_UNIT = BUnit.getUnit((String)"ohm");
        CELSIUS_UNIT = BUnit.getUnit((String)"celsius");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class XYPoint
    implements Comparable {
        private double x;
        private double y;

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public int compareTo(Object object) {
            if (object instanceof XYPoint) {
                XYPoint xYPoint = (XYPoint)object;
                if (xYPoint.x > this.x) {
                    return -1;
                }
                if (xYPoint.x < this.x) {
                    return 1;
                }
                return 0;
            }
            throw new ClassCastException("object not of type XYPoint.class");
        }

        public boolean equals(Object object) {
            if (object instanceof XYPoint) {
                XYPoint xYPoint = (XYPoint)object;
                boolean bl = false;
                if (this.x == xYPoint.x && this.y == xYPoint.y) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public XYPoint(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }
}

