/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.comm;

import com.tridium.basicdriver.UnsolicitedMessageListener;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioInputOutputModule;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.comm.MessageElement;
import com.tridium.nrio.comm.NrioComm;
import com.tridium.nrio.comm.TLinkedListManager;
import com.tridium.nrio.components.BIoStatus;
import com.tridium.nrio.components.BNrio16Status;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.points.BNrioIOPoints;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NrioUnsolicitedReceive
implements Runnable,
UnsolicitedMessageListener,
NrioMessageConst {
    private static Integer DEFAULT_TAG = new Integer(-1);
    private TLinkedListManager unsolicitedMessageManager;
    private BNrioNetwork host;
    private boolean timeToDie;
    private Thread myThread;
    private long msgCount;
    private long rateTicks;
    private long rateCount;
    private long droppedByteCount;

    public final void init() {
    }

    public final void cleanup() {
    }

    public final void start() {
        if (this.host != null && this.host.isFatalFault()) {
            return;
        }
        this.timeToDie = false;
        this.myThread = new Thread((Runnable)this, "NrioUnsolicitedReceive" + this.host.getTrunk());
        this.myThread.setPriority(this.host.getReadThreadPriority());
        this.myThread.start();
    }

    public final void stop() {
        this.timeToDie = true;
        this.myThread.stop();
    }

    public boolean isDying() {
        return this.timeToDie;
    }

    public void setThreadPriority(int n) {
        if (n != this.myThread.getPriority()) {
            this.getUnsolicitedLog().trace("thread priority changed from " + this.myThread.getPriority() + " to " + n);
            this.myThread.setPriority(n);
        }
    }

    public void receiveMessage(ReceivedMessage receivedMessage) {
        MessageElement messageElement = new MessageElement((NrioReceivedMessage)receivedMessage);
        if (this.unsolicitedMessageManager != null) {
            this.unsolicitedMessageManager.addToTail(messageElement);
        }
    }

    public Object getUnsolicitedListenerCode() {
        return DEFAULT_TAG;
    }

    public void run() {
        long l;
        NrioMessage nrioMessage = new NrioMessage();
        NrioComm nrioComm = (NrioComm)this.host.getComm();
        byte[] byArray = new byte[128];
        this.rateTicks = l = Clock.ticks();
        this.rateCount = this.msgCount;
        while (!this.timeToDie) {
            nrioComm = (NrioComm)this.host.getComm();
            try {
                if (this.host.isDownLoadInProcess()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                long l2 = Clock.ticks();
                long l3 = l2 - l;
                if (l2 - this.rateTicks > 5000L) {
                    this.host.setUnsolicitedMessageRate((float)(this.msgCount - this.rateCount) * 1000.0f / (float)(l2 - this.rateTicks));
                    this.rateTicks = l2;
                    this.rateCount = this.msgCount;
                }
                this.host.setUnsolicitedProcessTime((int)l3);
                this.getUnsolicitedLog().trace("NrioUnsolicitedReceive processing time = " + l3);
                nrioComm.waitForStatusChange(nrioComm.getHandle(), byArray);
                this.host.setUnsolicitedMsgCount(++this.msgCount);
                l = Clock.ticks();
                if (this.host.isDownLoadInProcess()) {
                    this.getUnsolicitedLog().trace("NrioUnsolicitedReceive: wakeup with downLoadInProcess");
                    continue;
                }
                int n = (byArray[1] & 0xFF) + 2;
                nrioMessage.decodeFromBytes(byArray, n);
                this.getUnsolicitedLog().trace("ioStatusMessage: " + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)n));
                if (nrioMessage.getType() != 8) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    this.getUnsolicitedLog().error("received invalid message: " + ByteArrayUtil.toHexString((byte[])byArray));
                    continue;
                }
                BNrioDevice bNrioDevice = this.host.getDevice(nrioMessage.getAddress());
                if (bNrioDevice != null) {
                    if (nrioMessage.getStatus() != 0) {
                        this.getUnsolicitedLog().message("nrioService reports device is down: " + nrioMessage.getAddress());
                        bNrioDevice.pingFail("nrioService reports device is down");
                        continue;
                    }
                    if (!bNrioDevice.getFirstPing()) {
                        bNrioDevice.pingOk();
                    }
                    if (bNrioDevice instanceof BNrio16Module) {
                        BNrio16Module bNrio16Module = (BNrio16Module)bNrioDevice;
                        this.getUnsolicitedLog().trace("Io16 module ioStatusMessage: " + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)n));
                        if (((BNrio16Status)bNrio16Module.getIoStatus()).readIoStatus(byArray, 0, nrioMessage.getLength() + 2)) continue;
                        ++this.droppedByteCount;
                        continue;
                    }
                    if (bNrioDevice instanceof BNrioInputOutputModule) {
                        this.getUnsolicitedLog().trace("GpIo module ioStatusMessage: " + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)n));
                        ((BNrioInputOutputModule)bNrioDevice).setIoStatus(new BIoStatus(byArray, 0, nrioMessage.getLength() + 2));
                        ((BNrioIOPoints)bNrioDevice.getPoints()).setDynamicPoints();
                        continue;
                    }
                    this.getUnsolicitedLog().trace("Other module ioStatusMessage: " + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)n));
                    bNrioDevice.setIoStatus(new BIoStatus(byArray, 0, nrioMessage.getLength() + 2));
                    bNrioDevice.getPoints().setDynamicPoints();
                    bNrioDevice.processIoStatusMessage(nrioMessage);
                    continue;
                }
                this.getUnsolicitedLog().message("nrioService reports unknown device is down: " + nrioMessage.getAddress());
            }
            catch (Exception exception) {
                if (this.host.isDownLoadInProcess()) {
                    this.getUnsolicitedLog().trace("NrioUnsolicitedReceive: wakeup with downLoadInProcess");
                } else {
                    if (this.host == null || this.host.getName() == null) {
                        this.timeToDie = true;
                    }
                    this.getUnsolicitedLog().error("Exception with " + this.host.getName() + "-NrioUnsolicitedReceive : " + exception);
                    if (exception.getMessage().equals("wait for status change failed")) {
                        this.host.configFatal("FatalFault! actrld is not running at " + BAbsTime.now());
                        this.timeToDie = true;
                    }
                    exception.printStackTrace();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception2) {}
            }
        }
        System.out.println("!!!!!!!!!!!!! " + this.host.getName() + ":: NrioUnsolicetedReceive thread exited !!!!!!!!!");
    }

    public BNrioDevice getDevice(NrioReceivedMessage nrioReceivedMessage) {
        int n = nrioReceivedMessage.getLength();
        if (n <= 0) {
            return null;
        }
        int n2 = nrioReceivedMessage.getBytes()[0] & 0xFF;
        return this.host.getDevice(n2);
    }

    public Log getUnsolicitedLog() {
        return Log.getLog((String)(this.host.getName() + ".unsolicited"));
    }

    public long getDroppedByteCount() {
        return this.droppedByteCount;
    }

    private final /* synthetic */ void this() {
        this.unsolicitedMessageManager = null;
        this.timeToDie = true;
        this.msgCount = 0L;
        this.rateTicks = 0L;
        this.rateCount = 0L;
        this.droppedByteCount = 0L;
    }

    public NrioUnsolicitedReceive(BNrioNetwork bNrioNetwork) {
        this.this();
        this.host = bNrioNetwork;
    }
}

