/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.comm.NrioCommReceiver;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.platNrio.BNrioPlatformService;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NrioComm
extends Comm
implements NrioMessageConst {
    private static final long MIN_SLEEP_TIME = 10L;
    private boolean localCommStarted;
    private String commInitError;
    private long lastRecvMessageTicks;
    private int handle;
    protected BISerialPort port;
    BNrioPlatformService nrioService;
    private long replyTicks;

    public boolean isCommStarted() {
        return this.localCommStarted;
    }

    protected boolean started() throws Exception {
        Object object;
        this.localCommStarted = false;
        BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
        this.commInitError = null;
        try {
            object = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            object.checkPropertiesLoaded();
            this.port = object.openPort(bNrioNetwork.getPortName(), bNrioNetwork.getName());
        }
        catch (Exception exception) {
            this.commInitError = "Check for duplicate or invalid Port Name";
            this.getNetwork().getLog().error(this.commInitError, (Throwable)exception);
            try {
                if (this.port != null) {
                    this.port.close();
                }
            }
            catch (Exception exception2) {}
            this.port = null;
            throw exception;
        }
        try {
            object = this.port.getOsPortName();
            this.nrioService = (BNrioPlatformService)Sys.getService((Type)BNrioPlatformService.TYPE);
            if (this.nrioService != null) {
                this.handle = this.nrioService.open(bNrioNetwork.getTrunk());
                this.nrioService.setPortParams(this.handle, (String)object, bNrioNetwork.getBaudRate().getOrdinal());
            }
            bNrioNetwork.getLog().message("Opened " + bNrioNetwork.getPortName());
        }
        catch (Exception exception) {
            this.commInitError = "Check for duplicate or invalid Trunk assignment.";
            this.getNetwork().getLog().error(this.commInitError, (Throwable)exception);
            try {
                if (this.port != null) {
                    this.port.close();
                }
            }
            catch (Exception exception3) {}
            try {
                if (this.nrioService != null) {
                    this.nrioService.close(this.handle);
                }
            }
            catch (Exception exception4) {}
            this.port = null;
            this.nrioService = null;
            throw exception;
        }
        this.localCommStarted = true;
        return true;
    }

    protected void stopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        try {
            if (this.nrioService != null) {
                this.nrioService.close(this.handle);
            }
        }
        catch (Exception exception) {}
        try {
            if (this.port != null) {
                this.port.close();
            }
        }
        catch (Exception exception) {}
        this.nrioService = null;
        this.port = null;
        this.localCommStarted = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetCommPort() {
        String string;
        block6: {
            try {
                try {
                    ((BNrioNetwork)this.getNetwork()).stopUnsolicitedReceive();
                    this.stopped();
                    this.started();
                    ((BNrioNetwork)this.getNetwork()).startUnsolicitedReceive();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                String string2 = this.getCommInitError();
                if (string2 == null) {
                    this.getNetwork().configOk();
                    throw throwable;
                }
                this.getNetwork().configFail(string2);
                throw throwable;
            }
            {
                Object var2_4 = null;
                string = this.getCommInitError();
                if (string != null) break block6;
            }
            this.getNetwork().configOk();
            return;
        }
        this.getNetwork().configFail(string);
    }

    public Vector discover() {
        if (this.nrioService != null) {
            return this.nrioService.discover(this.getHandle());
        }
        return null;
    }

    public void enablePolling(int n) {
        if (this.nrioService != null) {
            this.nrioService.enablePolling(this.getHandle(), n);
        }
    }

    public void disablePolling(int n) {
        if (this.nrioService != null) {
            this.nrioService.disablePolling(this.getHandle(), n);
        }
    }

    public void waitForStatusChange(int n, byte[] byArray) {
        if (this.nrioService != null) {
            this.nrioService.waitForStatusChange(this.getHandle(), byArray);
        }
    }

    public byte[] sendRequest(byte[] byArray) {
        try {
            Object object;
            if (this.nrioService == null) {
                return NrioMessageConst.NULL_BA;
            }
            if (this.getLog().isTraceOn()) {
                object = Thread.currentThread().getName();
                this.getLog().trace("<" + (String)object + "> request: " + (Clock.ticks() - this.replyTicks) + " ms " + ByteArrayUtil.toHexString((byte[])byArray));
            }
            object = new byte[128];
            long l = Clock.ticks();
            this.getNetwork().incrementSent();
            this.getNetwork().incrementReceived();
            this.nrioService.sendRequest(this.getHandle(), byArray, (byte[])object);
            this.replyTicks = Clock.ticks();
            int n = (object[1] & 0xFF) + 2;
            if (n > 128) {
                n = 128;
            }
            this.getLog().trace("response: " + (this.replyTicks - l) + " ms " + ByteArrayUtil.toHexString((byte[])object, (int)0, (int)n));
            if (object[3] != false) {
                this.getLog().trace("***> request: " + ByteArrayUtil.toHexString((byte[])byArray));
                this.getLog().trace("***> response: " + ByteArrayUtil.toHexString((byte[])object, (int)0, (int)n));
                this.getNetwork().incrementTimeouts();
            }
            return object;
        }
        catch (Exception exception) {
            this.getLog().error("sendRequest caught Exception: " + exception);
            return NrioMessageConst.NULL_BA;
        }
    }

    public Message transmit(Message message, BRelTime bRelTime, int n) throws BasicException {
        if (message == null) {
            return null;
        }
        if (!message.getResponseExpected()) {
            this.transmitNoResponse(message);
            return null;
        }
        return super.transmit(message, bRelTime, n);
    }

    public void transmitNoResponse(Message message) throws BasicException {
        if (message == null) {
            return;
        }
        if (!this.isCommStarted()) {
            throw new BasicException("Communication handler service not started.");
        }
        super.transmitNoResponse(message);
    }

    public void receive(ReceivedMessage receivedMessage) {
        if (receivedMessage == null) {
            return;
        }
        this.setReceivedMessageTicks(Clock.ticks());
        super.receive(receivedMessage);
    }

    protected void setReceivedMessageTicks(long l) {
        this.lastRecvMessageTicks = l;
    }

    public String getCommInitError() {
        return this.commInitError;
    }

    public int getHandle() {
        return this.handle;
    }

    public Log getLog() {
        return this.getNetwork().getLog();
    }

    private final /* synthetic */ void this() {
        this.localCommStarted = false;
        this.commInitError = null;
        this.lastRecvMessageTicks = 0L;
        this.replyTicks = 0L;
    }

    public NrioComm(BNrioNetwork bNrioNetwork) {
        super((BBasicNetwork)bNrioNetwork, (CommReceiver)new NrioCommReceiver());
        this.this();
    }
}

