/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BIoStatus;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.IoModuleIOStatus;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.WriteConfigMessage;
import com.tridium.nrio.messages.WriteDOMessage;
import com.tridium.nrio.points.BNrioIOPoints;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNrioInputOutputModule
extends BNrioDevice {
    public static final Property deviceType = BNrioInputOutputModule.newProperty((int)1, (BValue)BNrioDeviceTypeEnum.remoteInputOutput, null);
    public static final Property points = BNrioInputOutputModule.newProperty((int)0, (BValue)new BNrioIOPoints(), null);
    public static final Action writeConfig = BNrioInputOutputModule.newAction((int)4, null);
    public static final Type TYPE;
    private static byte[] NO_DATA;
    private int wrDoValue;
    private int lastWriteValue;
    static /* synthetic */ Class class$com$tridium$nrio$BNrioInputOutputModule;

    public BNrioPointDeviceExt getPoints() {
        return (BNrioPointDeviceExt)this.get(points);
    }

    public void setPoints(BNrioPointDeviceExt bNrioPointDeviceExt) {
        this.set(points, (BValue)bNrioPointDeviceExt, null);
    }

    public void writeConfig() {
        this.invoke(writeConfig, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doWriteConfig() {
        this.sendWriteConfig();
    }

    public int sendWriteConfig() {
        BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
        WriteConfigMessage writeConfigMessage = new WriteConfigMessage(this.getAddress(), 0);
        NrioMessage nrioMessage = bNrioNetwork.sendNrioMessage(writeConfigMessage);
        return nrioMessage.getStatus();
    }

    public int setDoValue(boolean bl, int n) {
        int n2 = 128 << n;
        this.setWrDoValue(bl, n2);
        return 0;
    }

    public synchronized void setWrDoValue(boolean bl, int n) {
        this.wrDoValue = bl ? (this.wrDoValue |= n) : (this.wrDoValue &= ~n);
        ((BNrioNetwork)this.getNetwork()).interruptWriteThread();
    }

    public int doWriteDoValues() {
        BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
        int n = this.wrDoValue;
        if (n != this.lastWriteValue) {
            WriteDOMessage writeDOMessage = new WriteDOMessage(this.getAddress(), n);
            NrioMessage nrioMessage = bNrioNetwork.sendNrioMessage(writeDOMessage);
            if (nrioMessage != null && nrioMessage.getStatus() == 0) {
                if (!this.getFirstPing()) {
                    this.pingOk();
                }
                this.lastWriteValue = n;
            }
            return nrioMessage.getStatus();
        }
        return 0;
    }

    public void doDumpIoMap() {
        BOrd[] bOrdArray = this.getUsedDiArray();
        System.out.println("Digital input use map:");
        int n = 0;
        while (n < bOrdArray.length) {
            System.out.println("   di" + (n + 1) + " used = " + bOrdArray[n]);
            ++n;
        }
        bOrdArray = this.getUsedRelayArray();
        System.out.println("Relay output use map:");
        n = 0;
        while (n < bOrdArray.length) {
            System.out.println("   ro" + (n + 1) + " used = " + bOrdArray[n]);
            ++n;
        }
        bOrdArray = this.getUsedSdiArray();
        System.out.println("Sdi use map:");
        n = 0;
        while (n < bOrdArray.length) {
            System.out.println("   sdi" + (n + 1) + " used = " + bOrdArray[n]);
            ++n;
        }
    }

    public BOrd[] getUsedRelayArray() {
        return this.getUsedRelayArray(8);
    }

    public BOrd[] getUsedDiArray() {
        return this.getUsedDiArray(2);
    }

    public BOrd[] getUsedSdiArray() {
        return this.getUsedSdiArray(8);
    }

    public void updateProxyValues() {
        byte[] byArray = ((BIoStatus)this.getIoStatus()).copyBytes();
        if (byArray.length < 12) {
            return;
        }
        NrioMessage nrioMessage = new NrioMessage();
        nrioMessage.decodeFromBytes(byArray, byArray.length);
        ((BNrioIOPoints)this.getPoints()).setIoStatus(new IoModuleIOStatus(nrioMessage.getData()));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.wrDoValue = 0;
        this.lastWriteValue = 0;
    }

    public BNrioInputOutputModule() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nrio$BNrioInputOutputModule;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$BNrioInputOutputModule = BNrioInputOutputModule.class("[Lcom.tridium.nrio.BNrioInputOutputModule;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        NO_DATA = new byte[0];
    }
}

