/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio;

import com.tridium.nrio.BM2mIoNetwork;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BNrio16Status;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.NrIo16WriteConfigMessage;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.WriteIoMessage;
import com.tridium.nrio.points.BNrio16Points;
import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridium.nrio.points.BNrioRelayOutputProxyExt;
import com.tridium.nrio.points.BNrioVoltageOutputProxyExt;
import com.tridium.nrio.points.BUiProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNrio16Module
extends BNrioDevice {
    public static final Property deviceType = BNrio16Module.newProperty((int)1, (BValue)BNrioDeviceTypeEnum.io16, null);
    public static final Property points = BNrio16Module.newProperty((int)0, (BValue)new BNrio16Points(), null);
    public static final Property ioStatus = BNrio16Module.newProperty((int)0, (BValue)new BNrio16Status(), null);
    public static final Action writeConfig = BNrio16Module.newAction((int)20, null);
    public static final Action writeIo = BNrio16Module.newAction((int)4, null);
    public static final Action clearTotals = BNrio16Module.newAction((int)0, null);
    public static final Type TYPE;
    private static byte[] NO_DATA;
    private static final int NUM_AOS = 4;
    private static final int NUM_UIS = 8;
    private static final int NUM_DOS = 4;
    private int wrDoValue;
    private int[] wrAoValue;
    private byte[] lastWriteData;
    private byte[] uiConfig;
    static /* synthetic */ Class class$com$tridium$nrio$BNrio16Module;

    public BNrioPointDeviceExt getPoints() {
        return (BNrioPointDeviceExt)this.get(points);
    }

    public void setPoints(BNrioPointDeviceExt bNrioPointDeviceExt) {
        this.set(points, (BValue)bNrioPointDeviceExt, null);
    }

    public BStruct getIoStatus() {
        return (BStruct)this.get(ioStatus);
    }

    public void setIoStatus(BStruct bStruct) {
        this.set(ioStatus, (BValue)bStruct, null);
    }

    public void writeConfig() {
        this.invoke(writeConfig, null, null);
    }

    public void writeIo() {
        this.invoke(writeIo, null, null);
    }

    public void clearTotals() {
        this.invoke(clearTotals, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)writeConfig)) {
            return this.postWriteConfig(bValue, context);
        }
        return super.post(action, bValue, context);
    }

    protected IFuture postWriteConfig(BValue bValue, Context context) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, writeConfig, bValue, context));
    }

    public void started() throws Exception {
        super.started();
        if (this.getAddress() != 0) {
            return;
        }
        BDeviceNetwork bDeviceNetwork = this.getNetwork();
        if (bDeviceNetwork != null && bDeviceNetwork instanceof BM2mIoNetwork) {
            ((BM2mIoNetwork)bDeviceNetwork).doSubmitDeviceDiscoveryJob();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        property.equals((Object)ioStatus);
        if (property.equals((Object)status) && this.isDown()) {
            int n = 0;
            while (n < this.lastWriteData.length) {
                this.lastWriteData[n] = 0;
                ++n;
            }
        }
    }

    public void doClearTotals() {
        ((BNrio16Status)this.getIoStatus()).doClearTotals();
    }

    public void doWriteConfig() {
        this.sendWriteConfig();
    }

    public int sendWriteConfig() {
        BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
        NrIo16WriteConfigMessage nrIo16WriteConfigMessage = new NrIo16WriteConfigMessage(this.getAddress(), this.getUiConfigBytes());
        NrioMessage nrioMessage = bNrioNetwork.sendNrioMessage(nrIo16WriteConfigMessage);
        if (this.getConfigLog().isTraceOn()) {
            byte[] byArray = nrIo16WriteConfigMessage.getByteArray();
            this.getConfigLog().trace(this.getName() + " request: " + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)byArray.length));
            byArray = nrioMessage.getByteArray();
            this.getConfigLog().trace(this.getName() + " response: " + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)byArray.length));
        }
        return nrioMessage.getStatus();
    }

    public BControlPoint checkForProxyExtConflicts(BControlPoint bControlPoint) {
        BNrio16ProxyExt bNrio16ProxyExt = (BNrio16ProxyExt)bControlPoint.getProxyExt();
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            BNrio16ProxyExt bNrio16ProxyExt2;
            if (!bControlPointArray[n].equals((Object)bControlPoint) && (bNrio16ProxyExt2 = (BNrio16ProxyExt)bControlPointArray[n].getProxyExt()).getEnabled()) {
                boolean bl;
                boolean bl2 = false;
                if (bNrio16ProxyExt2.getInstance() == bNrio16ProxyExt.getInstance()) {
                    bl2 = bl = true;
                }
                if (bNrio16ProxyExt2 instanceof BUiProxyExt && bNrio16ProxyExt instanceof BUiProxyExt && bl) {
                    return bControlPointArray[n];
                }
                if (bNrio16ProxyExt2 instanceof BNrioVoltageOutputProxyExt && bNrio16ProxyExt instanceof BNrioVoltageOutputProxyExt && bl) {
                    return bControlPointArray[n];
                }
                if (bNrio16ProxyExt2 instanceof BNrioRelayOutputProxyExt && bNrio16ProxyExt instanceof BNrioRelayOutputProxyExt && bl) {
                    return bControlPointArray[n];
                }
            }
            ++n;
        }
        return null;
    }

    public int setAoValue(int n, int n2) {
        if (n2 <= 0 || n2 > 4) {
            return 1;
        }
        this.wrAoValue[n2 - 1] = n;
        return 0;
    }

    public int setDoValue(boolean bl, int n) {
        if (n <= 0) {
            return 1;
        }
        int n2 = 1 << n - 1;
        this.setWrDoValue(bl, n2);
        return 0;
    }

    public synchronized void setWrDoValue(boolean bl, int n) {
        this.wrDoValue = bl ? (this.wrDoValue |= n) : (this.wrDoValue &= ~n);
    }

    public int doWriteDoValues() {
        return this.doWriteIoValues();
    }

    public void doWriteIo() {
        this.lastWriteData[0] = (byte)(~this.wrDoValue);
        this.doWriteIoValues();
    }

    public int doWriteIoValues() {
        if (this.isDown() || this.isFault()) {
            return 0;
        }
        BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
        byte[] byArray = this.getIoData();
        if (this.hasWrDataChanged(byArray)) {
            WriteIoMessage writeIoMessage = new WriteIoMessage(this.getAddress(), this.getIoData());
            NrioMessage nrioMessage = bNrioNetwork.sendNrioMessage(writeIoMessage);
            if (nrioMessage != null && nrioMessage.getStatus() == 0) {
                if (!this.getFirstPing()) {
                    this.pingOk();
                }
                int n = 0;
                while (n < this.lastWriteData.length) {
                    this.lastWriteData[n] = byArray[n];
                    ++n;
                }
            }
            return nrioMessage.getStatus();
        }
        return 0;
    }

    public void doDumpIoMap() {
    }

    public BOrd[] getUsedRelayArray() {
        return this.getUsedRelayArray(8);
    }

    public BOrd[] getUsedDiArray() {
        return this.getUsedDiArray(2);
    }

    public BOrd[] getUsedSdiArray() {
        return this.getUsedSdiArray(8);
    }

    public void updateProxyValues() {
        byte[] byArray = ((BNrio16Status)this.getIoStatus()).copyBytes();
        if (byArray.length < 12) {
            return;
        }
        NrioMessage nrioMessage = new NrioMessage();
        nrioMessage.decodeFromBytes(byArray, byArray.length);
        ((BNrio16Points)this.getPoints()).setDynamicPoints();
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public void setUiConfig(int n, int n2) {
        switch (n - 1) {
            case 0: {
                this.uiConfig[0] = (byte)(this.uiConfig[0] & 0xF | (n2 & 0xF) << 4);
                break;
            }
            case 1: {
                this.uiConfig[0] = (byte)(this.uiConfig[0] & 0xF0 | n2 & 0xF);
                break;
            }
            case 2: {
                this.uiConfig[1] = (byte)(this.uiConfig[1] & 0xF | (n2 & 0xF) << 4);
                break;
            }
            case 3: {
                this.uiConfig[1] = (byte)(this.uiConfig[1] & 0xF0 | n2 & 0xF);
                break;
            }
            case 4: {
                this.uiConfig[2] = (byte)(this.uiConfig[2] & 0xF | (n2 & 0xF) << 4);
                break;
            }
            case 5: {
                this.uiConfig[2] = (byte)(this.uiConfig[2] & 0xF0 | n2 & 0xF);
                break;
            }
            case 6: {
                this.uiConfig[3] = (byte)(this.uiConfig[3] & 0xF | (n2 & 0xF) << 4);
                break;
            }
            case 7: {
                this.uiConfig[3] = (byte)(this.uiConfig[3] & 0xF0 | n2 & 0xF);
                break;
            }
        }
        this.writeConfig();
    }

    public byte[] getUiConfigBytes() {
        return this.uiConfig;
    }

    public byte[] getIoData() {
        byte[] byArray = new byte[7];
        byArray[0] = (byte)this.wrDoValue;
        int n = 0;
        while (n < 4) {
            int n2 = this.getAoRawValue(n);
            switch (n) {
                case 0: {
                    byArray[1] = (byte)(n2 >> 4 & 0xFF);
                    byArray[2] = (byte)((n2 & 0xF) << 4);
                    break;
                }
                case 1: {
                    byArray[2] = (byte)(byArray[2] | n2 >> 8 & 0xF);
                    byArray[3] = (byte)(n2 & 0xFF);
                    break;
                }
                case 2: {
                    byArray[4] = (byte)(n2 >> 4 & 0xFF);
                    byArray[5] = (byte)((n2 & 0xF) << 4);
                    break;
                }
                case 3: {
                    byArray[5] = (byte)(byArray[5] | n2 >> 8 & 0xF);
                    byArray[6] = (byte)(n2 & 0xFF);
                    break;
                }
            }
            ++n;
        }
        return byArray;
    }

    private final int getAoRawValue(int n) {
        int n2 = this.wrAoValue[n];
        if (n2 > 4095) {
            n2 = 4095;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    private final boolean hasWrDataChanged(byte[] byArray) {
        if (byArray.length != this.lastWriteData.length) {
            return true;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != this.lastWriteData[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Log getConfigLog() {
        return Log.getLog((String)(this.getNetwork().getName() + ".config"));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.wrDoValue = 0;
        this.wrAoValue = new int[4];
        this.lastWriteData = new byte[7];
        this.uiConfig = new byte[]{17, 17, 17, 17};
    }

    public BNrio16Module() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nrio$BNrio16Module;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$BNrio16Module = BNrio16Module.class("[Lcom.tridium.nrio.BNrio16Module;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        NO_DATA = new byte[0];
    }
}

