/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BPriAlmHisHistoryRecord;
import com.tridium.tls.datatypes.BPriorityAlarmHistoryEntry;
import com.tridium.tls.datatypes.BPriorityAlarmHistoryTable;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.TlsConsolePriorityAlarmHistoryReport;
import com.tridium.tls.messages.TlsConsolePriorityAlarmHistoryReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350ConsoleDevicePointDeviceExt;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350PahDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTls350PriAlmHisProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    public static final Property minimumPollInterval = BTls350PriAlmHisProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), null);
    public static final Property priorityAlarmHistoryTable = BTls350PriAlmHisProxyExt.newProperty((int)257, (BValue)new BPriorityAlarmHistoryTable(), null);
    public static final Property maxOldEntriesSaved = BTls350PriAlmHisProxyExt.newProperty((int)0, (int)16, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Action purgeHashtable = BTls350PriAlmHisProxyExt.newAction((int)4, null);
    public static final Type TYPE;
    private Vector pAHEntriesVector;
    private Hashtable pAHHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;
    static /* synthetic */ Class class$com$tridium$tls$point$BTls350PriAlmHisProxyExt;
    static /* synthetic */ Class class$com$tridium$tls$datatypes$BPriorityAlarmHistoryEntry;

    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    public void setMinimumPollInterval(BRelTime bRelTime) {
        this.set(minimumPollInterval, (BValue)bRelTime, null);
    }

    public BPriorityAlarmHistoryTable getPriorityAlarmHistoryTable() {
        return (BPriorityAlarmHistoryTable)this.get(priorityAlarmHistoryTable);
    }

    public void setPriorityAlarmHistoryTable(BPriorityAlarmHistoryTable bPriorityAlarmHistoryTable) {
        this.set(priorityAlarmHistoryTable, (BValue)bPriorityAlarmHistoryTable, null);
    }

    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    public void setMaxOldEntriesSaved(int n) {
        this.setInt(maxOldEntriesSaved, n, null);
    }

    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BTls350ConsoleDevicePointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BPriorityAlarmHistoryEntry[] bPriorityAlarmHistoryEntryArray = this.getPriorityAlarmHistoryTable().getEntries();
            this.pAHHashtable = new Hashtable(bPriorityAlarmHistoryEntryArray.length * 2);
            int n = 0;
            while (n < bPriorityAlarmHistoryEntryArray.length) {
                Long l = new Long(bPriorityAlarmHistoryEntryArray[n].getValueHashCode());
                this.pAHHashtable.put(l, bPriorityAlarmHistoryEntryArray[n]);
                ++n;
            }
            TlsHistoryHelper.initHistory(BPriAlmHisHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.pAHHashtable = null;
        super.stopped();
    }

    public void poll() {
        if (!this.pollIntervalCheck(this.getMinimumPollInterval().getMillis())) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        boolean bl = false;
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            bl = true;
        }
        boolean bl2 = bl;
        TlsConsolePriorityAlarmHistoryReport tlsConsolePriorityAlarmHistoryReport = new TlsConsolePriorityAlarmHistoryReport(this);
        TlsConsolePriorityAlarmHistoryReportResponse tlsConsolePriorityAlarmHistoryReportResponse = (TlsConsolePriorityAlarmHistoryReportResponse)this.network().sendSync(tlsConsolePriorityAlarmHistoryReport);
        if (tlsConsolePriorityAlarmHistoryReportResponse != null) {
            if (tlsConsolePriorityAlarmHistoryReportResponse.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                TlsConsolePriorityAlarmHistoryReportResponse.PriorityAlarmHistory[] priorityAlarmHistoryArray = tlsConsolePriorityAlarmHistoryReportResponse.getPriorityAlarmHistoryEntries();
                if (priorityAlarmHistoryArray == null || priorityAlarmHistoryArray.length <= 0) {
                    if (bl2) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit... response has no entries");
                    }
                    return;
                }
                if (bl2) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow continue... process " + priorityAlarmHistoryArray.length + " entries");
                }
                this.pAHEntriesVector = new Vector();
                int n = 0;
                while (n < priorityAlarmHistoryArray.length) {
                    String string = Sys.getStation().getStationName();
                    BAbsTime bAbsTime = priorityAlarmHistoryArray[n].getDateTimeRetrieved();
                    int n2 = priorityAlarmHistoryArray[n].getAlarmWarningCategory();
                    int n3 = priorityAlarmHistoryArray[n].getSensorCategory();
                    int n4 = priorityAlarmHistoryArray[n].getAlarmTypeNumber();
                    int n5 = priorityAlarmHistoryArray[n].getTankSensorNumber();
                    int n6 = priorityAlarmHistoryArray[n].getAlarmState();
                    BAbsTime bAbsTime2 = priorityAlarmHistoryArray[n].getDateTimeOccurred();
                    BPriorityAlarmHistoryEntry bPriorityAlarmHistoryEntry = new BPriorityAlarmHistoryEntry(string, bAbsTime, n2, n3, n4, n5, n6, bAbsTime2);
                    BAbsTime bAbsTime3 = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (bPriorityAlarmHistoryEntry.getDateTimeOccurred().isBefore(bAbsTime3)) {
                        if (bl2) {
                            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + bPriorityAlarmHistoryEntry.toDebugString() + " for " + this.getName());
                        }
                    } else {
                        Long l = new Long(bPriorityAlarmHistoryEntry.getValueHashCode());
                        if (this.pAHHashtable == null || this.pAHHashtable.get(l) == null) {
                            this.pAHHashtable.put(l, bPriorityAlarmHistoryEntry);
                            this.pAHEntriesVector.addElement(bPriorityAlarmHistoryEntry);
                            if (bl2) {
                                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + bPriorityAlarmHistoryEntry.toDebugString());
                            }
                        } else if (bl2) {
                            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + bPriorityAlarmHistoryEntry.toDebugString());
                        }
                    }
                    ++n;
                }
                if (this.pAHEntriesVector.size() > 0) {
                    this.setValue(this.pAHEntriesVector);
                    return;
                }
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)bStatusString);
                this.updateDemuxedProxyPoints();
            } else {
                if (bl2) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (bl2) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector vector) {
        Object object;
        BPriorityAlarmHistoryEntry[] bPriorityAlarmHistoryEntryArray = new BPriorityAlarmHistoryEntry[vector.size()];
        vector.copyInto((Object[])bPriorityAlarmHistoryEntryArray);
        BPriorityAlarmHistoryTable bPriorityAlarmHistoryTable = new BPriorityAlarmHistoryTable();
        int n = 0;
        while (n < bPriorityAlarmHistoryEntryArray.length) {
            try {
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                object = bPriorityAlarmHistoryEntryArray[n].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + (String)object);
                }
                bStatusString.setValue((String)object);
                this.readOk((BStatusValue)bStatusString);
                this.getPriorityAlarmHistoryTable().add("priorityAlarmHistoryEntry?", (BValue)bPriorityAlarmHistoryEntryArray[n]);
                bPriorityAlarmHistoryTable.add("priorityAlarmHistoryEntry?", (BValue)((BPriorityAlarmHistoryEntry)bPriorityAlarmHistoryEntryArray[n].newCopy()));
                BPriAlmHisHistoryRecord bPriAlmHisHistoryRecord = new BPriAlmHisHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), bPriorityAlarmHistoryEntryArray[n]);
                TlsHistoryHelper.appendTlsHistory((BStruct)bPriAlmHisHistoryRecord);
            }
            catch (Exception exception) {
                this.readFail(exception.toString());
            }
            ++n;
        }
        this.updateDemuxedProxyPoints();
        BPriorityAlarmHistoryEntry[] bPriorityAlarmHistoryEntryArray2 = this.getPriorityAlarmHistoryTable().getSortedCopy();
        if (bPriorityAlarmHistoryEntryArray2 == null || bPriorityAlarmHistoryEntryArray2.length == 0) {
            return;
        }
        int n2 = bPriorityAlarmHistoryEntryArray2.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350PriAlmHisProxyExt setValue sortedValues.length=" + bPriorityAlarmHistoryEntryArray2.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (n2 > 0) {
            object = new Vector();
            int n3 = 0;
            while (n3 < n2) {
                ((Vector)object).addElement(bPriorityAlarmHistoryEntryArray2[n3]);
                ++n3;
            }
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                BPriorityAlarmHistoryEntry bPriorityAlarmHistoryEntry = (BPriorityAlarmHistoryEntry)((Object)enumeration.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350PriAlmHisProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + bPriorityAlarmHistoryEntry.createCommaDelimitedString());
                }
                this.getPriorityAlarmHistoryTable().remove((BComplex)bPriorityAlarmHistoryEntry);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, bPriorityAlarmHistoryTable));
    }

    private final void updateDemuxedProxyPoints() {
        BPriorityAlarmHistoryEntry[] bPriorityAlarmHistoryEntryArray = this.getPriorityAlarmHistoryTable().getSortedCopy();
        if (bPriorityAlarmHistoryEntryArray == null || bPriorityAlarmHistoryEntryArray.length == 0) {
            return;
        }
        BPriorityAlarmHistoryEntry bPriorityAlarmHistoryEntry = bPriorityAlarmHistoryEntryArray[bPriorityAlarmHistoryEntryArray.length - 1];
        String[] stringArray = CsMgrBaseUtil.createStringArrayOfAllNames((String)bPriorityAlarmHistoryEntry.createCommaDelimitedString());
        if (stringArray != null && stringArray.length > 0) {
            BControlPoint[] bControlPointArray;
            BTls350PahDemuxedPointDeviceExt bTls350PahDemuxedPointDeviceExt = null;
            BDeviceExt[] bDeviceExtArray = this.getDevice().getDeviceExts();
            int n = 0;
            while (n < bDeviceExtArray.length) {
                if (bDeviceExtArray[n] instanceof BTls350PahDemuxedPointDeviceExt) {
                    bTls350PahDemuxedPointDeviceExt = (BTls350PahDemuxedPointDeviceExt)bDeviceExtArray[n];
                    break;
                }
                ++n;
            }
            if (bTls350PahDemuxedPointDeviceExt != null && (bControlPointArray = bTls350PahDemuxedPointDeviceExt.getPoints()) != null && bControlPointArray.length > 0) {
                int n2 = 0;
                while (n2 < bControlPointArray.length) {
                    if (bControlPointArray[n2].getProxyExt().getType() == BTls350DemuxedProxyExt.TYPE) {
                        ((BTls350DemuxedProxyExt)bControlPointArray[n2].getProxyExt()).updateValueFrom(stringArray);
                    }
                    ++n2;
                }
            }
        }
    }

    public void readDataNow() {
        this.pollForDataNow();
    }

    public void clearDataNow() {
        BPriorityAlarmHistoryEntry[] bPriorityAlarmHistoryEntryArray;
        this.getPriorityAlarmHistoryTable().lease(2);
        BPriorityAlarmHistoryTable bPriorityAlarmHistoryTable = this.getPriorityAlarmHistoryTable();
        Class clazz = class$com$tridium$tls$datatypes$BPriorityAlarmHistoryEntry;
        if (clazz == null) {
            clazz = class$com$tridium$tls$datatypes$BPriorityAlarmHistoryEntry = BTls350PriAlmHisProxyExt.class("[Lcom.tridium.tls.datatypes.BPriorityAlarmHistoryEntry;", false);
        }
        if ((bPriorityAlarmHistoryEntryArray = (BPriorityAlarmHistoryEntry[])bPriorityAlarmHistoryTable.getChildren(clazz)) != null && bPriorityAlarmHistoryEntryArray.length > 0) {
            int n = 0;
            while (n < bPriorityAlarmHistoryEntryArray.length) {
                this.getPriorityAlarmHistoryTable().remove((BComplex)bPriorityAlarmHistoryEntryArray[n]);
                ++n;
            }
        }
        this.pAHHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context context) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration enumeration = this.pAHHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            BPriorityAlarmHistoryEntry bPriorityAlarmHistoryEntry = (BPriorityAlarmHistoryEntry)((Object)this.pAHHashtable.get(l));
            BAbsTime bAbsTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!bPriorityAlarmHistoryEntry.getDateTimeOccurred().isBefore(bAbsTime)) continue;
            this.pAHHashtable.remove(l);
        }
        this.reschedPurgeHashtable();
    }

    private final void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime bAbsTime = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime, (Action)purgeHashtable, null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$tls$point$BTls350PriAlmHisProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$tls$point$BTls350PriAlmHisProxyExt = BTls350PriAlmHisProxyExt.class("[Lcom.tridium.tls.point.BTls350PriAlmHisProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

