/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BInTankStaHistoryRecord;
import com.tridium.tls.datatypes.BInTankStatusEntry;
import com.tridium.tls.datatypes.BInTankStatusTable;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350StatusReport;
import com.tridium.tls.messages.Tls350StatusReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import com.tridium.tls.point.BTls350ItsDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTls350InTankStaProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    public static final Property minimumPollInterval = BTls350InTankStaProxyExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), null);
    public static final Property inTankStatusTable = BTls350InTankStaProxyExt.newProperty((int)0, (BValue)new BInTankStatusTable(), null);
    public static final Property maxOldEntriesSaved = BTls350InTankStaProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Action purgeHashtable = BTls350InTankStaProxyExt.newAction((int)4, null);
    public static final Type TYPE;
    private Vector iTSEntriesVector;
    private Hashtable iTSHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;
    static /* synthetic */ Class class$com$tridium$tls$point$BTls350InTankStaProxyExt;
    static /* synthetic */ Class class$com$tridium$tls$datatypes$BInTankStatusEntry;

    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    public void setMinimumPollInterval(BRelTime bRelTime) {
        this.set(minimumPollInterval, (BValue)bRelTime, null);
    }

    public BInTankStatusTable getInTankStatusTable() {
        return (BInTankStatusTable)this.get(inTankStatusTable);
    }

    public void setInTankStatusTable(BInTankStatusTable bInTankStatusTable) {
        this.set(inTankStatusTable, (BValue)bInTankStatusTable, null);
    }

    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    public void setMaxOldEntriesSaved(int n) {
        this.setInt(maxOldEntriesSaved, n, null);
    }

    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BTls350FuelTankPointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BInTankStatusEntry[] bInTankStatusEntryArray = this.getInTankStatusTable().getEntries();
            this.iTSHashtable = new Hashtable(bInTankStatusEntryArray.length * 2);
            int n = 0;
            while (n < bInTankStatusEntryArray.length) {
                Long l = new Long(bInTankStatusEntryArray[n].getValueHashCode());
                this.iTSHashtable.put(l, bInTankStatusEntryArray[n]);
                ++n;
            }
            TlsHistoryHelper.initHistory(BInTankStaHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.iTSHashtable = null;
        super.stopped();
    }

    public void poll() {
        if (!this.pollIntervalCheck(this.getMinimumPollInterval().getMillis())) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        int n;
        boolean bl;
        boolean bl2 = false;
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            bl2 = bl = true;
        }
        if ((n = ((BTls350FuelTankDevice)this.device()).getTankNumber()) <= 0) {
            if (bl) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit ... tank number not initialized");
            }
            return;
        }
        Tls350StatusReport tls350StatusReport = new Tls350StatusReport(n, this);
        Tls350StatusReportResponse tls350StatusReportResponse = (Tls350StatusReportResponse)this.network().sendSync(tls350StatusReport);
        if (tls350StatusReportResponse != null) {
            if (tls350StatusReportResponse.getSuccessfulResponse()) {
                int[] nArray;
                this.device().setPollSinceLastPingFlag();
                if (n != tls350StatusReportResponse.getMessageTank()) {
                    if (bl) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong tank number... entry for tankNumber=" + tls350StatusReportResponse.getMessageTank() + " may be lost\n\n");
                    }
                    return;
                }
                BAbsTime bAbsTime = tls350StatusReportResponse.getReadTime();
                if (bAbsTime == null) {
                    bAbsTime = BAbsTime.make();
                }
                if ((nArray = tls350StatusReportResponse.getAlarmTypes()).length == 0) {
                    if (bl) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... poll response contains no alarm entries... nothing to record tankNumber=" + tls350StatusReportResponse.getMessageTank() + " alarmTypes.length=" + nArray.length);
                    }
                    return;
                }
                this.iTSEntriesVector = new Vector();
                String string = Sys.getStation().getStationName();
                int n2 = 0;
                while (n2 < nArray.length) {
                    BInTankStatusEntry bInTankStatusEntry = new BInTankStatusEntry(string, n, bAbsTime, nArray[n2]);
                    BAbsTime bAbsTime2 = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (bInTankStatusEntry.getReadTime().isBefore(bAbsTime2)) {
                        if (bl) {
                            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + bInTankStatusEntry.toDebugString() + " for " + this.getName());
                        }
                    } else {
                        Long l = new Long(bInTankStatusEntry.getValueHashCode());
                        if (this.iTSHashtable == null || this.iTSHashtable.get(l) == null) {
                            this.iTSHashtable.put(l, bInTankStatusEntry);
                            this.iTSEntriesVector.addElement(bInTankStatusEntry);
                            if (bl) {
                                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + bInTankStatusEntry.toDebugString());
                            }
                        } else if (bl) {
                            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + bInTankStatusEntry.toDebugString());
                        }
                    }
                    ++n2;
                }
                if (this.iTSEntriesVector.size() > 0) {
                    this.setValue(this.iTSEntriesVector);
                    return;
                }
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)bStatusString);
                this.updateDemuxedProxyPoints();
            } else {
                if (bl) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (bl) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector vector) {
        Object object;
        BInTankStatusEntry[] bInTankStatusEntryArray = new BInTankStatusEntry[vector.size()];
        vector.copyInto((Object[])bInTankStatusEntryArray);
        BInTankStatusTable bInTankStatusTable = new BInTankStatusTable();
        int n = 0;
        while (n < bInTankStatusEntryArray.length) {
            try {
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                object = bInTankStatusEntryArray[n].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + (String)object);
                }
                bStatusString.setValue((String)object);
                this.readOk((BStatusValue)bStatusString);
                this.getInTankStatusTable().add("inTankStatusEntry?", (BValue)bInTankStatusEntryArray[n]);
                bInTankStatusTable.add("inTankStatusEntry?", (BValue)((BInTankStatusEntry)bInTankStatusEntryArray[n].newCopy()));
                BInTankStaHistoryRecord bInTankStaHistoryRecord = new BInTankStaHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), bInTankStatusEntryArray[n]);
                TlsHistoryHelper.appendTlsHistory((BStruct)bInTankStaHistoryRecord);
            }
            catch (Exception exception) {
                this.readFail(exception.toString());
            }
            ++n;
        }
        this.updateDemuxedProxyPoints();
        BInTankStatusEntry[] bInTankStatusEntryArray2 = this.getInTankStatusTable().getSortedCopy();
        if (bInTankStatusEntryArray2 == null || bInTankStatusEntryArray2.length == 0) {
            return;
        }
        int n2 = bInTankStatusEntryArray2.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350InTankStaProxyExt setValue sortedValues.length=" + bInTankStatusEntryArray2.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (n2 > 0) {
            object = new Vector();
            int n3 = 0;
            while (n3 < n2) {
                ((Vector)object).addElement(bInTankStatusEntryArray2[n3]);
                ++n3;
            }
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                BInTankStatusEntry bInTankStatusEntry = (BInTankStatusEntry)((Object)enumeration.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350InTankStaProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + bInTankStatusEntry.createCommaDelimitedString());
                }
                this.getInTankStatusTable().remove((BComplex)bInTankStatusEntry);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, bInTankStatusTable));
    }

    private final void updateDemuxedProxyPoints() {
        BInTankStatusEntry[] bInTankStatusEntryArray = this.getInTankStatusTable().getSortedCopy();
        if (bInTankStatusEntryArray == null || bInTankStatusEntryArray.length == 0) {
            return;
        }
        BInTankStatusEntry bInTankStatusEntry = bInTankStatusEntryArray[bInTankStatusEntryArray.length - 1];
        String[] stringArray = CsMgrBaseUtil.createStringArrayOfAllNames((String)bInTankStatusEntry.createCommaDelimitedString());
        if (stringArray != null && stringArray.length > 0) {
            BControlPoint[] bControlPointArray;
            BTls350ItsDemuxedPointDeviceExt bTls350ItsDemuxedPointDeviceExt = null;
            BDeviceExt[] bDeviceExtArray = this.getDevice().getDeviceExts();
            int n = 0;
            while (n < bDeviceExtArray.length) {
                if (bDeviceExtArray[n] instanceof BTls350ItsDemuxedPointDeviceExt) {
                    bTls350ItsDemuxedPointDeviceExt = (BTls350ItsDemuxedPointDeviceExt)bDeviceExtArray[n];
                    break;
                }
                ++n;
            }
            if (bTls350ItsDemuxedPointDeviceExt != null && (bControlPointArray = bTls350ItsDemuxedPointDeviceExt.getPoints()) != null && bControlPointArray.length > 0) {
                int n2 = 0;
                while (n2 < bControlPointArray.length) {
                    if (bControlPointArray[n2].getProxyExt().getType() == BTls350DemuxedProxyExt.TYPE) {
                        ((BTls350DemuxedProxyExt)bControlPointArray[n2].getProxyExt()).updateValueFrom(stringArray);
                    }
                    ++n2;
                }
            }
        }
    }

    public void readDataNow() {
        this.pollForDataNow();
    }

    public void clearDataNow() {
        BInTankStatusEntry[] bInTankStatusEntryArray;
        this.getInTankStatusTable().lease(2);
        BInTankStatusTable bInTankStatusTable = this.getInTankStatusTable();
        Class clazz = class$com$tridium$tls$datatypes$BInTankStatusEntry;
        if (clazz == null) {
            clazz = class$com$tridium$tls$datatypes$BInTankStatusEntry = BTls350InTankStaProxyExt.class("[Lcom.tridium.tls.datatypes.BInTankStatusEntry;", false);
        }
        if ((bInTankStatusEntryArray = (BInTankStatusEntry[])bInTankStatusTable.getChildren(clazz)) != null && bInTankStatusEntryArray.length > 0) {
            int n = 0;
            while (n < bInTankStatusEntryArray.length) {
                this.getInTankStatusTable().remove((BComplex)bInTankStatusEntryArray[n]);
                ++n;
            }
        }
        this.iTSHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context context) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration enumeration = this.iTSHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            BInTankStatusEntry bInTankStatusEntry = (BInTankStatusEntry)((Object)this.iTSHashtable.get(l));
            BAbsTime bAbsTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!bInTankStatusEntry.getReadTime().isBefore(bAbsTime)) continue;
            this.iTSHashtable.remove(l);
        }
        this.reschedPurgeHashtable();
    }

    private final void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime bAbsTime = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime, (Action)purgeHashtable, null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$tls$point$BTls350InTankStaProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$tls$point$BTls350InTankStaProxyExt = BTls350InTankStaProxyExt.class("[Lcom.tridium.tls.point.BTls350InTankStaProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

