/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BFuelManagementEntry;
import com.tridium.tls.datatypes.BFuelManagementTable;
import com.tridium.tls.datatypes.BFuelMgmtHistoryRecord;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350FuelManagementReport;
import com.tridium.tls.messages.Tls350FuelManagementReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350FmDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTls350FuelMgmtProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    public static final Property minimumPollInterval = BTls350FuelMgmtProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)30), null);
    public static final Property fuelManagementTable = BTls350FuelMgmtProxyExt.newProperty((int)0, (BValue)new BFuelManagementTable(), null);
    public static final Property maxOldEntriesSaved = BTls350FuelMgmtProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Action purgeHashtable = BTls350FuelMgmtProxyExt.newAction((int)4, null);
    public static final Type TYPE;
    private Vector fMEntriesVector;
    private Hashtable fMHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;
    static /* synthetic */ Class class$com$tridium$tls$point$BTls350FuelMgmtProxyExt;
    static /* synthetic */ Class class$com$tridium$tls$datatypes$BFuelManagementEntry;

    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    public void setMinimumPollInterval(BRelTime bRelTime) {
        this.set(minimumPollInterval, (BValue)bRelTime, null);
    }

    public BFuelManagementTable getFuelManagementTable() {
        return (BFuelManagementTable)this.get(fuelManagementTable);
    }

    public void setFuelManagementTable(BFuelManagementTable bFuelManagementTable) {
        this.set(fuelManagementTable, (BValue)bFuelManagementTable, null);
    }

    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    public void setMaxOldEntriesSaved(int n) {
        this.setInt(maxOldEntriesSaved, n, null);
    }

    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BTls350FuelTankPointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BFuelManagementEntry[] bFuelManagementEntryArray = this.getFuelManagementTable().getEntries();
            this.fMHashtable = new Hashtable(bFuelManagementEntryArray.length * 2);
            int n = 0;
            while (n < bFuelManagementEntryArray.length) {
                Long l = bFuelManagementEntryArray[n].getHTKey();
                this.fMHashtable.put(l, bFuelManagementEntryArray[n]);
                ++n;
            }
            TlsHistoryHelper.initHistory(BFuelMgmtHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.fMHashtable = null;
        super.stopped();
    }

    public void poll() {
        if (!this.pollIntervalCheck(this.getMinimumPollInterval().getMillis())) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        int n;
        boolean bl;
        boolean bl2 = false;
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            bl2 = bl = true;
        }
        if ((n = ((BTls350FuelTankDevice)this.device()).getTankNumber()) <= 0) {
            if (bl) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit ... tank number not initialized");
            }
            return;
        }
        Tls350FuelManagementReport tls350FuelManagementReport = new Tls350FuelManagementReport(n, this);
        Tls350FuelManagementReportResponse tls350FuelManagementReportResponse = (Tls350FuelManagementReportResponse)this.network().sendSync(tls350FuelManagementReport);
        if (tls350FuelManagementReportResponse != null) {
            if (tls350FuelManagementReportResponse.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                Tls350FuelManagementReportResponse.FuelManagement[] fuelManagementArray = tls350FuelManagementReportResponse.getFuelManagementEntries();
                if (fuelManagementArray == null || fuelManagementArray.length <= 0) {
                    if (bl) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit... response has no entries");
                    }
                    return;
                }
                if (bl) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow continue... process " + fuelManagementArray.length + " entries");
                }
                if (n != fuelManagementArray[0].getTankNumber()) {
                    if (bl) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong tank number... entry for tankNumber=" + fuelManagementArray[0].getTankNumber() + " may be lost\n\n");
                    }
                    return;
                }
                this.fMEntriesVector = new Vector();
                int n2 = 0;
                while (n2 < fuelManagementArray.length) {
                    BFuelManagementEntry bFuelManagementEntry = new BFuelManagementEntry();
                    bFuelManagementEntry.setStore(Sys.getStation().getStationName());
                    bFuelManagementEntry.setTank(n);
                    bFuelManagementEntry.setCurrentDateTime(fuelManagementArray[n2].getCurrentDateTime());
                    bFuelManagementEntry.setProductCode(fuelManagementArray[n2].getProductCode());
                    bFuelManagementEntry.setDaysRemaining(fuelManagementArray[n2].getDaysRemaining());
                    bFuelManagementEntry.setPresentInventory(fuelManagementArray[n2].getPresentInventory());
                    bFuelManagementEntry.setPresentUllage(fuelManagementArray[n2].getPresentUllage());
                    bFuelManagementEntry.setSundaySales(fuelManagementArray[n2].getSundaySales());
                    bFuelManagementEntry.setMondaySales(fuelManagementArray[n2].getMondaySales());
                    bFuelManagementEntry.setTuesdaySales(fuelManagementArray[n2].getTuesdaySales());
                    bFuelManagementEntry.setWednesdaySales(fuelManagementArray[n2].getWednesdaySales());
                    bFuelManagementEntry.setThursdaySales(fuelManagementArray[n2].getThursdaySales());
                    bFuelManagementEntry.setFridaySales(fuelManagementArray[n2].getFridaySales());
                    bFuelManagementEntry.setSaturdaySales(fuelManagementArray[n2].getSaturdaySales());
                    BAbsTime bAbsTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (bFuelManagementEntry.getCurrentDateTime().isBefore(bAbsTime)) {
                        if (bl) {
                            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + bFuelManagementEntry.toDebugString() + " for " + this.getName());
                        }
                    } else {
                        Long l = bFuelManagementEntry.getHTKey();
                        if (this.fMHashtable == null || this.fMHashtable.get(l) == null) {
                            this.fMHashtable.put(l, bFuelManagementEntry);
                            this.fMEntriesVector.addElement(bFuelManagementEntry);
                            if (bl) {
                                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + bFuelManagementEntry.toDebugString() + " for " + this.getName());
                            }
                        } else if (bl) {
                            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + bFuelManagementEntry.toDebugString() + " for " + this.getName());
                        }
                    }
                    ++n2;
                }
                if (this.fMEntriesVector.size() > 0) {
                    this.setValue(this.fMEntriesVector);
                    return;
                }
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)bStatusString);
                this.updateDemuxedProxyPoints();
            } else {
                if (bl) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (bl) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector vector) {
        Object object;
        BFuelManagementEntry[] bFuelManagementEntryArray = new BFuelManagementEntry[vector.size()];
        vector.copyInto((Object[])bFuelManagementEntryArray);
        BFuelManagementTable bFuelManagementTable = new BFuelManagementTable();
        int n = 0;
        while (n < bFuelManagementEntryArray.length) {
            try {
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                object = bFuelManagementEntryArray[n].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + (String)object);
                }
                bStatusString.setValue((String)object);
                this.readOk((BStatusValue)bStatusString);
                this.getFuelManagementTable().add("fuelManagementEntry?", (BValue)bFuelManagementEntryArray[n]);
                bFuelManagementTable.add("fuelManagementEntry?", (BValue)((BFuelManagementEntry)bFuelManagementEntryArray[n].newCopy()));
                BFuelMgmtHistoryRecord bFuelMgmtHistoryRecord = new BFuelMgmtHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), bFuelManagementEntryArray[n]);
                TlsHistoryHelper.appendTlsHistory((BStruct)bFuelMgmtHistoryRecord);
            }
            catch (Exception exception) {
                this.readFail(exception.toString());
            }
            ++n;
        }
        this.updateDemuxedProxyPoints();
        BFuelManagementEntry[] bFuelManagementEntryArray2 = this.getFuelManagementTable().getSortedCopy();
        if (bFuelManagementEntryArray2 == null || bFuelManagementEntryArray2.length == 0) {
            return;
        }
        int n2 = bFuelManagementEntryArray2.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350FuelMgmtProxyExt setValue sortedValues.length=" + bFuelManagementEntryArray2.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (n2 > 0) {
            object = new Vector();
            int n3 = 0;
            while (n3 < n2) {
                ((Vector)object).addElement(bFuelManagementEntryArray2[n3]);
                ++n3;
            }
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                BFuelManagementEntry bFuelManagementEntry = (BFuelManagementEntry)((Object)enumeration.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350FuelMgmtProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + bFuelManagementEntry.createCommaDelimitedString());
                }
                this.getFuelManagementTable().remove((BComplex)bFuelManagementEntry);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, bFuelManagementTable));
    }

    private final void updateDemuxedProxyPoints() {
        BFuelManagementEntry[] bFuelManagementEntryArray = this.getFuelManagementTable().getSortedCopy();
        if (bFuelManagementEntryArray == null || bFuelManagementEntryArray.length == 0) {
            return;
        }
        BFuelManagementEntry bFuelManagementEntry = bFuelManagementEntryArray[bFuelManagementEntryArray.length - 1];
        String[] stringArray = CsMgrBaseUtil.createStringArrayOfAllNames((String)bFuelManagementEntry.createCommaDelimitedString());
        if (stringArray != null && stringArray.length > 0) {
            BControlPoint[] bControlPointArray;
            BTls350FmDemuxedPointDeviceExt bTls350FmDemuxedPointDeviceExt = null;
            BDeviceExt[] bDeviceExtArray = this.getDevice().getDeviceExts();
            int n = 0;
            while (n < bDeviceExtArray.length) {
                if (bDeviceExtArray[n] instanceof BTls350FmDemuxedPointDeviceExt) {
                    bTls350FmDemuxedPointDeviceExt = (BTls350FmDemuxedPointDeviceExt)bDeviceExtArray[n];
                    break;
                }
                ++n;
            }
            if (bTls350FmDemuxedPointDeviceExt != null && (bControlPointArray = bTls350FmDemuxedPointDeviceExt.getPoints()) != null && bControlPointArray.length > 0) {
                int n2 = 0;
                while (n2 < bControlPointArray.length) {
                    if (bControlPointArray[n2].getProxyExt().getType() == BTls350DemuxedProxyExt.TYPE) {
                        ((BTls350DemuxedProxyExt)bControlPointArray[n2].getProxyExt()).updateValueFrom(stringArray);
                    }
                    ++n2;
                }
            }
        }
    }

    public void readDataNow() {
        this.pollForDataNow();
    }

    public void clearDataNow() {
        BFuelManagementEntry[] bFuelManagementEntryArray;
        this.getFuelManagementTable().lease(2);
        BFuelManagementTable bFuelManagementTable = this.getFuelManagementTable();
        Class clazz = class$com$tridium$tls$datatypes$BFuelManagementEntry;
        if (clazz == null) {
            clazz = class$com$tridium$tls$datatypes$BFuelManagementEntry = BTls350FuelMgmtProxyExt.class("[Lcom.tridium.tls.datatypes.BFuelManagementEntry;", false);
        }
        if ((bFuelManagementEntryArray = (BFuelManagementEntry[])bFuelManagementTable.getChildren(clazz)) != null && bFuelManagementEntryArray.length > 0) {
            int n = 0;
            while (n < bFuelManagementEntryArray.length) {
                this.getFuelManagementTable().remove((BComplex)bFuelManagementEntryArray[n]);
                ++n;
            }
        }
        this.fMHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context context) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration enumeration = this.fMHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            BFuelManagementEntry bFuelManagementEntry = (BFuelManagementEntry)((Object)this.fMHashtable.get(l));
            BAbsTime bAbsTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!bFuelManagementEntry.getCurrentDateTime().isBefore(bAbsTime)) continue;
            this.fMHashtable.remove(l);
        }
        this.reschedPurgeHashtable();
    }

    private final void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime bAbsTime = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime, (Action)purgeHashtable, null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$tls$point$BTls350FuelMgmtProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$tls$point$BTls350FuelMgmtProxyExt = BTls350FuelMgmtProxyExt.class("[Lcom.tridium.tls.point.BTls350FuelMgmtProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

