/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BDelVarHistoryRecord;
import com.tridium.tls.datatypes.BDeliveryVarianceEntry;
import com.tridium.tls.datatypes.BDeliveryVarianceTable;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350DeliveryVarianceReport;
import com.tridium.tls.messages.Tls350DeliveryVarianceReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350DvDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTls350DelVarProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    public static final Property minimumPollInterval = BTls350DelVarProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), null);
    public static final Property deliveryVarianceTable = BTls350DelVarProxyExt.newProperty((int)0, (BValue)new BDeliveryVarianceTable(), null);
    public static final Property maxOldEntriesSaved = BTls350DelVarProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Action purgeHashtable = BTls350DelVarProxyExt.newAction((int)4, null);
    public static final Type TYPE;
    private Vector dVEntriesVector;
    private Hashtable dVHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;
    static /* synthetic */ Class class$com$tridium$tls$point$BTls350DelVarProxyExt;
    static /* synthetic */ Class class$com$tridium$tls$datatypes$BDeliveryVarianceEntry;

    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    public void setMinimumPollInterval(BRelTime bRelTime) {
        this.set(minimumPollInterval, (BValue)bRelTime, null);
    }

    public BDeliveryVarianceTable getDeliveryVarianceTable() {
        return (BDeliveryVarianceTable)this.get(deliveryVarianceTable);
    }

    public void setDeliveryVarianceTable(BDeliveryVarianceTable bDeliveryVarianceTable) {
        this.set(deliveryVarianceTable, (BValue)bDeliveryVarianceTable, null);
    }

    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    public void setMaxOldEntriesSaved(int n) {
        this.setInt(maxOldEntriesSaved, n, null);
    }

    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BTls350FuelTankPointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BDeliveryVarianceEntry[] bDeliveryVarianceEntryArray = this.getDeliveryVarianceTable().getEntries();
            this.dVHashtable = new Hashtable(bDeliveryVarianceEntryArray.length * 2);
            int n = 0;
            while (n < bDeliveryVarianceEntryArray.length) {
                Long l = bDeliveryVarianceEntryArray[n].getHTKey();
                this.dVHashtable.put(l, bDeliveryVarianceEntryArray[n]);
                ++n;
            }
            TlsHistoryHelper.initHistory(BDelVarHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.dVHashtable = null;
        super.stopped();
    }

    public void poll() {
        if (!this.pollIntervalCheck(this.getMinimumPollInterval().getMillis())) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        int n;
        boolean bl;
        boolean bl2 = false;
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            bl2 = bl = true;
        }
        if ((n = ((BTls350FuelTankDevice)this.device()).getTankNumber()) <= 0) {
            if (bl) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit ... tank number not initialized");
            }
            return;
        }
        Tls350DeliveryVarianceReport tls350DeliveryVarianceReport = new Tls350DeliveryVarianceReport(n, this);
        Tls350DeliveryVarianceReportResponse tls350DeliveryVarianceReportResponse = (Tls350DeliveryVarianceReportResponse)this.network().sendSync(tls350DeliveryVarianceReport);
        if (tls350DeliveryVarianceReportResponse != null) {
            if (tls350DeliveryVarianceReportResponse.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                Tls350DeliveryVarianceReportResponse.DeliveryVariance[] deliveryVarianceArray = tls350DeliveryVarianceReportResponse.getDeliveryVariances();
                if (deliveryVarianceArray == null || deliveryVarianceArray.length <= 0) {
                    if (bl) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit... response has no entries");
                    }
                    return;
                }
                if (bl) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow continue... process " + deliveryVarianceArray.length + " entries");
                }
                if (n != deliveryVarianceArray[0].getTankNumber()) {
                    if (bl) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong tank number... entry for tankNumber=" + deliveryVarianceArray[0].getTankNumber() + " may be lost\n\n");
                    }
                    return;
                }
                this.dVEntriesVector = new Vector();
                int n2 = 0;
                while (n2 < deliveryVarianceArray.length) {
                    BDeliveryVarianceEntry bDeliveryVarianceEntry = new BDeliveryVarianceEntry();
                    bDeliveryVarianceEntry.setStore(Sys.getStation().getStationName());
                    bDeliveryVarianceEntry.setTank(n);
                    bDeliveryVarianceEntry.setProduct(deliveryVarianceArray[n2].getProduct());
                    bDeliveryVarianceEntry.setProbe(deliveryVarianceArray[n2].getProbe());
                    bDeliveryVarianceEntry.setDeliveryTime(deliveryVarianceArray[n2].getDeliveryTime());
                    bDeliveryVarianceEntry.setTicketVolume(deliveryVarianceArray[n2].getTicketVolume());
                    bDeliveryVarianceEntry.setGuagedVolume(deliveryVarianceArray[n2].getGuagedVolume());
                    bDeliveryVarianceEntry.setDeliveryVariance(deliveryVarianceArray[n2].getDeliveryVarance());
                    BAbsTime bAbsTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (bDeliveryVarianceEntry.getDeliveryTime().isBefore(bAbsTime)) {
                        if (bl) {
                            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + bDeliveryVarianceEntry.toDebugString() + " for " + this.getName());
                        }
                    } else {
                        Long l = bDeliveryVarianceEntry.getHTKey();
                        if (this.dVHashtable == null || this.dVHashtable.get(l) == null) {
                            this.dVHashtable.put(l, bDeliveryVarianceEntry);
                            this.dVEntriesVector.addElement(bDeliveryVarianceEntry);
                            if (bl) {
                                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + bDeliveryVarianceEntry.toDebugString() + " for " + this.getName());
                            }
                        } else if (bl) {
                            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + bDeliveryVarianceEntry.toDebugString() + " for " + this.getName());
                        }
                    }
                    ++n2;
                }
                if (this.dVEntriesVector.size() > 0) {
                    this.setValue(this.dVEntriesVector);
                    return;
                }
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)bStatusString);
                this.updateDemuxedProxyPoints();
            } else {
                if (bl) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (bl) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector vector) {
        Object object;
        BDeliveryVarianceEntry[] bDeliveryVarianceEntryArray = new BDeliveryVarianceEntry[vector.size()];
        vector.copyInto((Object[])bDeliveryVarianceEntryArray);
        BDeliveryVarianceTable bDeliveryVarianceTable = new BDeliveryVarianceTable();
        int n = 0;
        while (n < bDeliveryVarianceEntryArray.length) {
            try {
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                object = bDeliveryVarianceEntryArray[n].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + (String)object);
                }
                bStatusString.setValue((String)object);
                this.readOk((BStatusValue)bStatusString);
                this.getDeliveryVarianceTable().add("deliveryVarianceEntry?", (BValue)bDeliveryVarianceEntryArray[n]);
                bDeliveryVarianceTable.add("deliveryVarianceEntry?", (BValue)((BDeliveryVarianceEntry)bDeliveryVarianceEntryArray[n].newCopy()));
                BDelVarHistoryRecord bDelVarHistoryRecord = new BDelVarHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), bDeliveryVarianceEntryArray[n]);
                TlsHistoryHelper.appendTlsHistory((BStruct)bDelVarHistoryRecord);
            }
            catch (Exception exception) {
                this.readFail(exception.toString());
            }
            ++n;
        }
        this.updateDemuxedProxyPoints();
        BDeliveryVarianceEntry[] bDeliveryVarianceEntryArray2 = this.getDeliveryVarianceTable().getSortedCopy();
        if (bDeliveryVarianceEntryArray2 == null || bDeliveryVarianceEntryArray2.length == 0) {
            return;
        }
        int n2 = bDeliveryVarianceEntryArray2.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350DelVarProxyExt setValue sortedValues.length=" + bDeliveryVarianceEntryArray2.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (n2 > 0) {
            object = new Vector();
            int n3 = 0;
            while (n3 < n2) {
                ((Vector)object).addElement(bDeliveryVarianceEntryArray2[n3]);
                ++n3;
            }
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                BDeliveryVarianceEntry bDeliveryVarianceEntry = (BDeliveryVarianceEntry)((Object)enumeration.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350DelVarProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + bDeliveryVarianceEntry.createCommaDelimitedString());
                }
                this.getDeliveryVarianceTable().remove((BComplex)bDeliveryVarianceEntry);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, bDeliveryVarianceTable));
    }

    private final void updateDemuxedProxyPoints() {
        BDeliveryVarianceEntry[] bDeliveryVarianceEntryArray = this.getDeliveryVarianceTable().getSortedCopy();
        if (bDeliveryVarianceEntryArray == null || bDeliveryVarianceEntryArray.length == 0) {
            return;
        }
        BDeliveryVarianceEntry bDeliveryVarianceEntry = bDeliveryVarianceEntryArray[bDeliveryVarianceEntryArray.length - 1];
        String[] stringArray = CsMgrBaseUtil.createStringArrayOfAllNames((String)bDeliveryVarianceEntry.createCommaDelimitedString());
        if (stringArray != null && stringArray.length > 0) {
            BControlPoint[] bControlPointArray;
            BTls350DvDemuxedPointDeviceExt bTls350DvDemuxedPointDeviceExt = null;
            BDeviceExt[] bDeviceExtArray = this.getDevice().getDeviceExts();
            int n = 0;
            while (n < bDeviceExtArray.length) {
                if (bDeviceExtArray[n] instanceof BTls350DvDemuxedPointDeviceExt) {
                    bTls350DvDemuxedPointDeviceExt = (BTls350DvDemuxedPointDeviceExt)bDeviceExtArray[n];
                    break;
                }
                ++n;
            }
            if (bTls350DvDemuxedPointDeviceExt != null && (bControlPointArray = bTls350DvDemuxedPointDeviceExt.getPoints()) != null && bControlPointArray.length > 0) {
                int n2 = 0;
                while (n2 < bControlPointArray.length) {
                    if (bControlPointArray[n2].getProxyExt().getType() == BTls350DemuxedProxyExt.TYPE) {
                        ((BTls350DemuxedProxyExt)bControlPointArray[n2].getProxyExt()).updateValueFrom(stringArray);
                    }
                    ++n2;
                }
            }
        }
    }

    public void readDataNow() {
        this.pollForDataNow();
    }

    public void clearDataNow() {
        BDeliveryVarianceEntry[] bDeliveryVarianceEntryArray;
        this.getDeliveryVarianceTable().lease(2);
        BDeliveryVarianceTable bDeliveryVarianceTable = this.getDeliveryVarianceTable();
        Class clazz = class$com$tridium$tls$datatypes$BDeliveryVarianceEntry;
        if (clazz == null) {
            clazz = class$com$tridium$tls$datatypes$BDeliveryVarianceEntry = BTls350DelVarProxyExt.class("[Lcom.tridium.tls.datatypes.BDeliveryVarianceEntry;", false);
        }
        if ((bDeliveryVarianceEntryArray = (BDeliveryVarianceEntry[])bDeliveryVarianceTable.getChildren(clazz)) != null && bDeliveryVarianceEntryArray.length > 0) {
            int n = 0;
            while (n < bDeliveryVarianceEntryArray.length) {
                this.getDeliveryVarianceTable().remove((BComplex)bDeliveryVarianceEntryArray[n]);
                ++n;
            }
        }
        this.dVHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context context) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration enumeration = this.dVHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            BDeliveryVarianceEntry bDeliveryVarianceEntry = (BDeliveryVarianceEntry)((Object)this.dVHashtable.get(l));
            BAbsTime bAbsTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!bDeliveryVarianceEntry.getDeliveryTime().isBefore(bAbsTime)) continue;
            this.dVHashtable.remove(l);
        }
        this.reschedPurgeHashtable();
    }

    private final void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime bAbsTime = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime, (Action)purgeHashtable, null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$tls$point$BTls350DelVarProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$tls$point$BTls350DelVarProxyExt = BTls350DelVarProxyExt.class("[Lcom.tridium.tls.point.BTls350DelVarProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

