/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350BirAdjDelProxyExt;
import javax.baja.sys.BAbsTime;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tls350BirAdjustedDeliveryReportResponse
extends Tls350Response {
    public BAbsTime readTime;
    private int tankNumber;
    private int numberDeliveryEntries;
    private int numberFieldsToFollowInt;
    public BirAdjustedDelivery[] adjustedDeliveryEntries;
    private BTls350BirAdjDelProxyExt ext;
    private boolean debug;
    private boolean debug_negative;

    public BirAdjustedDelivery[] getBirAdjustedDeliveryEntries() {
        if (this.debug) {
            this.ext.getLog().trace("TlsBADResponse :readResponse adjustedDeliveryEntries.length=" + this.adjustedDeliveryEntries.length);
        }
        return this.adjustedDeliveryEntries;
    }

    public TlsInputStream readResponse(byte[] byArray) {
        TlsInputStream tlsInputStream = super.readResponse(byArray);
        if (this.debug) {
            this.ext.getLog().trace("TlsBADResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (tlsInputStream.available() < 16 || !this.functionCode.equalsIgnoreCase("20B")) {
            this.tankNumber = this.tank;
            return tlsInputStream;
        }
        this.readTime = tlsInputStream.readDateTime(true);
        boolean bl = false;
        while (!bl) {
            tlsInputStream.mark(0);
            String string = tlsInputStream.readString(2);
            if (string.equals("&&")) {
                this.adjustedDeliveryEntries = new BirAdjustedDelivery[0];
                this.tankNumber = this.tank;
                return tlsInputStream;
            }
            tlsInputStream.reset();
            if (tlsInputStream.available() < 8) {
                this.adjustedDeliveryEntries = new BirAdjustedDelivery[0];
                this.tankNumber = this.tank;
                return tlsInputStream;
            }
            this.tankNumber = tlsInputStream.readAsciiInt(2);
            if (this.tankNumber == -1) {
                this.adjustedDeliveryEntries = new BirAdjustedDelivery[0];
                return tlsInputStream;
            }
            this.numberDeliveryEntries = tlsInputStream.readAsciiInt(2);
            if (this.numberDeliveryEntries != 0) {
                this.adjustedDeliveryEntries = new BirAdjustedDelivery[this.numberDeliveryEntries];
                int n = 0;
                while (n < this.numberDeliveryEntries) {
                    this.adjustedDeliveryEntries[n] = new BirAdjustedDelivery();
                    this.adjustedDeliveryEntries[n].setTankNumber(this.tankNumber);
                    this.adjustedDeliveryEntries[n].setDeliveryStartDateTime(tlsInputStream.readDateTime(true));
                    this.adjustedDeliveryEntries[n].setDeliveryEndDateTime(tlsInputStream.readDateTime(true));
                    String string2 = tlsInputStream.readString(2);
                    try {
                        this.numberFieldsToFollowInt = Integer.parseInt(string2, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("AdjustedDeliveryReportResponse could not convert numberFieldsToFollowIntStr from str-hex-int... numberFieldsToFollowIntStr=" + string2);
                        return tlsInputStream;
                    }
                    int n2 = 0;
                    while (n2 < 21) {
                        float f = tlsInputStream.readAsciiFloat();
                        if (f < 0.0f && this.debug_negative) {
                            System.out.println("ADRR (-) value=" + f + " j=" + n2);
                            System.out.println("ADRR - ba=" + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)byArray.length));
                        }
                        switch (n2) {
                            case 0: {
                                this.adjustedDeliveryEntries[n].setStartVolume(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 1: {
                                this.adjustedDeliveryEntries[n].setEndVolume(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 2: {
                                this.adjustedDeliveryEntries[n].setAdjustedDelivery(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 3: {
                                this.adjustedDeliveryEntries[n].setAdjustedTcDelivery(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 4: {
                                this.adjustedDeliveryEntries[n].setStartFuelHeight(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 5: {
                                this.adjustedDeliveryEntries[n].setStartFuelTemp1(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 6: {
                                this.adjustedDeliveryEntries[n].setStartFuelTemp2(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 7: {
                                this.adjustedDeliveryEntries[n].setStartFuelTemp3(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 8: {
                                this.adjustedDeliveryEntries[n].setStartFuelTemp4(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 9: {
                                this.adjustedDeliveryEntries[n].setStartFuelTemp5(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 10: {
                                this.adjustedDeliveryEntries[n].setStartFuelTemp6(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 11: {
                                this.adjustedDeliveryEntries[n].setEndFuelHeight(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 12: {
                                this.adjustedDeliveryEntries[n].setEndFuelTemp1(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 13: {
                                this.adjustedDeliveryEntries[n].setEndFuelTemp2(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 14: {
                                this.adjustedDeliveryEntries[n].setEndFuelTemp3(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 15: {
                                this.adjustedDeliveryEntries[n].setEndFuelTemp4(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 16: {
                                this.adjustedDeliveryEntries[n].setEndFuelTemp5(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 17: {
                                this.adjustedDeliveryEntries[n].setEndFuelTemp6(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 18: {
                                this.adjustedDeliveryEntries[n].setTotDispensedDurDel(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 19: {
                                this.adjustedDeliveryEntries[n].setStartFuelTempAvg(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                            case 20: {
                                this.adjustedDeliveryEntries[n].setEndFuelTempAvg(n2 < this.numberFieldsToFollowInt ? f : Float.NaN);
                                break;
                            }
                        }
                        ++n2;
                    }
                    if (this.debug) {
                        this.ext.getLog().trace("TlsBADResponse :readResponse adjustedDeliveryEntries[" + n + "]=" + this.adjustedDeliveryEntries[n].getBADLogString());
                    }
                    ++n;
                }
            }
            bl = true;
        }
        return tlsInputStream;
    }

    private final /* synthetic */ void this() {
        this.adjustedDeliveryEntries = null;
    }

    public Tls350BirAdjustedDeliveryReportResponse() {
        this.this();
    }

    public Tls350BirAdjustedDeliveryReportResponse(BTls350BirAdjDelProxyExt bTls350BirAdjDelProxyExt) {
        this.this();
        this.ext = bTls350BirAdjDelProxyExt;
        boolean bl = false;
        if (bTls350BirAdjDelProxyExt != null && bTls350BirAdjDelProxyExt.getLog().isTraceOn() && bTls350BirAdjDelProxyExt.device().getUserData().indexOf("msg") != -1) {
            bl = true;
        }
        this.debug = bl;
        boolean bl2 = false;
        if (bTls350BirAdjDelProxyExt != null && bTls350BirAdjDelProxyExt.getLog().isTraceOn() && bTls350BirAdjDelProxyExt.device().getUserData().indexOf("negv") != -1) {
            bl2 = true;
        }
        this.debug_negative = bl2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class BirAdjustedDelivery {
        int tankNumber;
        BAbsTime deliveryStartDateTime;
        BAbsTime deliveryEndDateTime;
        float startVolume;
        float endVolume;
        float adjustedDelVolume;
        float adjustedTcDelVolume;
        float startFuelHeight;
        float startFuelTemp1;
        float startFuelTemp2;
        float startFuelTemp3;
        float startFuelTemp4;
        float startFuelTemp5;
        float startFuelTemp6;
        float endFuelHeight;
        float endFuelTemp1;
        float endFuelTemp2;
        float endFuelTemp3;
        float endFuelTemp4;
        float endFuelTemp5;
        float endFuelTemp6;
        float totDispensedDuringDel;
        float startFuelTempAvg;
        float endFuelTempAvg;

        public void setTankNumber(int n) {
            this.tankNumber = n;
        }

        public void setDeliveryStartDateTime(BAbsTime bAbsTime) {
            this.deliveryStartDateTime = bAbsTime;
        }

        public void setDeliveryEndDateTime(BAbsTime bAbsTime) {
            this.deliveryEndDateTime = bAbsTime;
        }

        public void setStartVolume(float f) {
            this.startVolume = f;
        }

        public void setEndVolume(float f) {
            this.endVolume = f;
        }

        public void setAdjustedDelivery(float f) {
            this.adjustedDelVolume = f;
        }

        public void setAdjustedTcDelivery(float f) {
            this.adjustedTcDelVolume = f;
        }

        public void setStartFuelHeight(float f) {
            this.startFuelHeight = f;
        }

        public void setStartFuelTemp1(float f) {
            this.startFuelTemp1 = f;
        }

        public void setStartFuelTemp2(float f) {
            this.startFuelTemp2 = f;
        }

        public void setStartFuelTemp3(float f) {
            this.startFuelTemp3 = f;
        }

        public void setStartFuelTemp4(float f) {
            this.startFuelTemp4 = f;
        }

        public void setStartFuelTemp5(float f) {
            this.startFuelTemp5 = f;
        }

        public void setStartFuelTemp6(float f) {
            this.startFuelTemp6 = f;
        }

        public void setEndFuelHeight(float f) {
            this.endFuelHeight = f;
        }

        public void setEndFuelTemp1(float f) {
            this.endFuelTemp1 = f;
        }

        public void setEndFuelTemp2(float f) {
            this.endFuelTemp2 = f;
        }

        public void setEndFuelTemp3(float f) {
            this.endFuelTemp3 = f;
        }

        public void setEndFuelTemp4(float f) {
            this.endFuelTemp4 = f;
        }

        public void setEndFuelTemp5(float f) {
            this.endFuelTemp5 = f;
        }

        public void setEndFuelTemp6(float f) {
            this.endFuelTemp6 = f;
        }

        public void setTotDispensedDurDel(float f) {
            this.totDispensedDuringDel = f;
        }

        public void setStartFuelTempAvg(float f) {
            this.startFuelTempAvg = f;
        }

        public void setEndFuelTempAvg(float f) {
            this.endFuelTempAvg = f;
        }

        public int getTankNumber() {
            return this.tankNumber;
        }

        public BAbsTime getDeliveryStartDateTime() {
            return this.deliveryStartDateTime;
        }

        public BAbsTime getDeliveryEndDateTime() {
            return this.deliveryEndDateTime;
        }

        public float getStartVolume() {
            return this.startVolume;
        }

        public float getEndVolume() {
            return this.endVolume;
        }

        public float getAdjustedDelivery() {
            return this.adjustedDelVolume;
        }

        public float getAdjustedTcDelivery() {
            return this.adjustedTcDelVolume;
        }

        public float getStartFuelHeight() {
            return this.startFuelHeight;
        }

        public float getStartFuelTemp1() {
            return this.startFuelTemp1;
        }

        public float getStartFuelTemp2() {
            return this.startFuelTemp2;
        }

        public float getStartFuelTemp3() {
            return this.startFuelTemp3;
        }

        public float getStartFuelTemp4() {
            return this.startFuelTemp4;
        }

        public float getStartFuelTemp5() {
            return this.startFuelTemp5;
        }

        public float getStartFuelTemp6() {
            return this.startFuelTemp6;
        }

        public float getEndFuelHeight() {
            return this.endFuelHeight;
        }

        public float getEndFuelTemp1() {
            return this.endFuelTemp1;
        }

        public float getEndFuelTemp2() {
            return this.endFuelTemp2;
        }

        public float getEndFuelTemp3() {
            return this.endFuelTemp3;
        }

        public float getEndFuelTemp4() {
            return this.endFuelTemp4;
        }

        public float getEndFuelTemp5() {
            return this.endFuelTemp5;
        }

        public float getEndFuelTemp6() {
            return this.endFuelTemp6;
        }

        public float getTotDispensedDurDel() {
            return this.totDispensedDuringDel;
        }

        public float getStartFuelTempAvg() {
            return this.startFuelTempAvg;
        }

        public float getEndFuelTempAvg() {
            return this.endFuelTempAvg;
        }

        public String getBADLogString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.tankNumber);
            stringBuffer.append(", ");
            stringBuffer.append(this.deliveryStartDateTime.encodeToString());
            stringBuffer.append(", ");
            stringBuffer.append(this.deliveryEndDateTime.encodeToString());
            stringBuffer.append(", ");
            stringBuffer.append(this.startVolume);
            stringBuffer.append(", ");
            stringBuffer.append(this.endVolume);
            stringBuffer.append(", ");
            stringBuffer.append(this.adjustedDelVolume);
            stringBuffer.append(", ");
            stringBuffer.append(this.adjustedTcDelVolume);
            stringBuffer.append(", ");
            stringBuffer.append(this.startFuelHeight);
            stringBuffer.append(", ");
            stringBuffer.append(this.startFuelTemp1);
            stringBuffer.append(", ");
            stringBuffer.append(this.startFuelTemp2);
            stringBuffer.append(", ");
            stringBuffer.append(this.startFuelTemp3);
            stringBuffer.append(", ");
            stringBuffer.append(this.startFuelTemp4);
            stringBuffer.append(", ");
            stringBuffer.append(this.startFuelTemp5);
            stringBuffer.append(", ");
            stringBuffer.append(this.startFuelTemp6);
            stringBuffer.append(", ");
            stringBuffer.append(this.endFuelHeight);
            stringBuffer.append(", ");
            stringBuffer.append(this.endFuelTemp1);
            stringBuffer.append(", ");
            stringBuffer.append(this.endFuelTemp2);
            stringBuffer.append(", ");
            stringBuffer.append(this.endFuelTemp3);
            stringBuffer.append(", ");
            stringBuffer.append(this.endFuelTemp4);
            stringBuffer.append(", ");
            stringBuffer.append(this.endFuelTemp5);
            stringBuffer.append(", ");
            stringBuffer.append(this.endFuelTemp6);
            stringBuffer.append(", ");
            stringBuffer.append(this.totDispensedDuringDel);
            stringBuffer.append(", ");
            stringBuffer.append(this.startFuelTempAvg);
            stringBuffer.append(", ");
            stringBuffer.append(this.endFuelTempAvg);
            return stringBuffer.toString();
        }
    }
}

