/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.messages.TlsReceivedMessage;
import javax.baja.util.ByteArrayUtil;

public class Tls250Response
extends ReceivedMessage {
    protected byte[] messageData;
    protected String functionCode;
    protected int tank;

    public Message toResponse(ReceivedMessage receivedMessage) {
        TlsReceivedMessage tlsReceivedMessage = (TlsReceivedMessage)receivedMessage;
        byte[] byArray = tlsReceivedMessage.getBytes();
        Tls250Response tls250Response = new Tls250Response();
        tls250Response.readResponse(byArray);
        return tls250Response;
    }

    public TlsInputStream readResponse(byte[] byArray) {
        TlsInputStream tlsInputStream = new TlsInputStream(byArray);
        tlsInputStream.read();
        this.functionCode = tlsInputStream.readString(2);
        this.tank = tlsInputStream.readAsciiInt(1);
        this.messageData = new byte[tlsInputStream.available() - 1];
        int n = 0;
        while (n < this.messageData.length) {
            this.messageData[n] = (byte)(tlsInputStream.read() & 0xFF);
            ++n;
        }
        tlsInputStream = new TlsInputStream(this.messageData);
        return tlsInputStream;
    }

    public String toDebugString() {
        return ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length);
    }
}

